/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.graphical_view;

import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.controls.AbstractZoomControl;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class ZoomBoxControl
extends AbstractZoomControl {
    public static final String BOX_ITEM_LABEL = "$ZOOMBOX";
    private ZoomBoxRenderer zoomBoxRenderer = new ZoomBoxRenderer();
    private VisualItem boxItem;
    private Point2D down = null;
    private Point2D current = null;
    private int button = 4;

    @Override
    public void mousePressed(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.button)) {
            Display display = (Display)e.getComponent();
            if (display.isTranformInProgress()) {
                return;
            }
            this.down = new Point2D.Float();
            this.current = null;
            display.getAbsoluteCoordinate(e.getPoint(), this.down);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!UILib.isButtonPressed(e, this.button)) {
            this.hideZoomBox();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.button)) {
            Display display = (Display)e.getComponent();
            if (display.isTranformInProgress() || this.down == null) {
                this.hideZoomBox();
                return;
            }
            this.current = new Point2D.Float();
            display.getAbsoluteCoordinate(e.getPoint(), this.current);
            if (this.boxItem != null) {
                this.boxItem.setVisible(true);
                this.boxItem.setValidated(false);
                this.boxItem.getVisualization().repaint();
            }
        }
    }

    private void hideZoomBox() {
        if (this.down != null || this.current != null) {
            this.down = null;
            this.current = null;
            if (this.boxItem != null) {
                this.boxItem.setValidated(false);
                this.boxItem.getVisualization().repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.button)) {
            if (this.down != null && this.current != null) {
                Display display = (Display)e.getComponent();
                DisplayLib.fitViewToBounds(display, this.getZoomBoxBounds(200.0), 500L);
            }
            this.hideZoomBox();
        }
    }

    @Override
    public void itemPressed(VisualItem item, MouseEvent e) {
        if (this.m_zoomOverItem) {
            this.mousePressed(e);
        }
    }

    @Override
    public void itemDragged(VisualItem item, MouseEvent e) {
        if (this.m_zoomOverItem) {
            this.mouseDragged(e);
        }
    }

    @Override
    public void itemReleased(VisualItem item, MouseEvent e) {
        if (this.m_zoomOverItem) {
            this.mouseReleased(e);
        }
    }

    private Rectangle2D getZoomBoxBounds(double minWidth) {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        if (this.down == null || this.current == null) {
            ((Rectangle2D)bounds).setRect(0.0, 0.0, 0.0, 0.0);
        } else {
            ((Rectangle2D)bounds).setRect(Math.min(this.down.getX(), this.current.getX()), Math.min(this.down.getY(), this.current.getY()), Math.max(minWidth, Math.abs(this.down.getX() - this.current.getX())), Math.max(minWidth, Math.abs(this.down.getY() - this.current.getY())));
        }
        return bounds;
    }

    public ZoomBoxRenderer getRenderer() {
        return this.zoomBoxRenderer;
    }

    public class ZoomBoxRenderer
    extends ShapeRenderer {
        @Override
        public boolean locatePoint(Point2D p, VisualItem item) {
            return false;
        }

        @Override
        protected Shape getRawShape(VisualItem item) {
            Rectangle2D bounds = ZoomBoxControl.this.getZoomBoxBounds(1.0);
            return this.rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }

        @Override
        public void setBounds(VisualItem item) {
            Rectangle2D bounds = ZoomBoxControl.this.getZoomBoxBounds(1.0);
            item.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }

        public boolean isBoxItem(VisualItem item) {
            if (ZoomBoxControl.BOX_ITEM_LABEL.equals(item.getString("label"))) {
                ZoomBoxControl.this.boxItem = item;
                item.setFillColor(ColorLib.rgba(150, 150, 255, 100));
                return true;
            }
            return false;
        }
    }
}

