/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.graphical_view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.ui.graphical_view.GraphicalDataModelView;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.ImageFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphicsLib;
import prefuse.util.StringLib;
import prefuse.visual.VisualItem;

public class TableRenderer
extends AbstractShapeRenderer {
    protected ImageFactory m_images = null;
    protected String m_delim = "\n";
    protected String m_labelName = "label";
    protected String m_imageName = null;
    protected int m_xAlign = 2;
    protected int m_yAlign = 2;
    protected int m_hTextAlign = 0;
    protected int m_vTextAlign = 4;
    protected int m_hImageAlign = 2;
    protected int m_vImageAlign = 4;
    protected int m_imagePos = 0;
    protected int m_horizBorder = 2;
    protected int m_vertBorder = 0;
    protected int m_imageMargin = 2;
    protected int m_arcWidth = 0;
    protected int m_arcHeight = 0;
    protected int m_maxTextWidth = -1;
    AffineTransform m_transform = new AffineTransform();
    protected RectangularShape m_bbox = new Rectangle2D.Double();
    protected Point2D m_pt = new Point2D.Double();
    protected Font m_font;
    protected Font m_font_nic;
    protected Font m_font2;
    protected String m_text;
    protected Dimension m_textDim = new Dimension();
    protected Dimension m_headerDim = new Dimension();
    private int m_color;
    private int NOT_IN_CLOSURE_COLOR = ColorLib.rgb(170, 50, 50);
    private int IN_CLOSURE_COLOR = ColorLib.rgb(0, 0, 0);
    private Map<String, String> textCache = new HashMap<String, String>();
    private long textCacheVersion = -1L;
    private final DataModel model;
    private final GraphicalDataModelView graphicalDataModelView;
    private List<String> excludeFromDeletion = new ArrayList<String>();
    private List<String> initialDataTables = new ArrayList<String>();
    private Set<Table> filteredTables = new HashSet<Table>();
    private long dmVersionOfFilteredTables = -1L;
    private Image excludeFromDeletionImage = null;
    private Image allRowsImage = null;
    private Image collapsedImage = null;
    private Image upsertImage = null;
    private Image subjectImage = null;
    private Image filterImage = null;

    public void setRoundedCorner(int arcWidth, int arcHeight) {
        if (!(arcWidth != 0 && arcHeight != 0 || this.m_bbox instanceof Rectangle2D)) {
            this.m_bbox = new Rectangle2D.Double();
        } else {
            if (!(this.m_bbox instanceof RoundRectangle2D)) {
                this.m_bbox = new RoundRectangle2D.Double();
            }
            ((RoundRectangle2D)this.m_bbox).setRoundRect(0.0, 0.0, 10.0, 10.0, arcWidth, arcHeight);
            this.m_arcWidth = arcWidth;
            this.m_arcHeight = arcHeight;
        }
    }

    public String getTextField() {
        return this.m_labelName;
    }

    public void setTextField(String textField) {
        this.m_labelName = textField;
    }

    public void setMaxTextWidth(int maxWidth) {
        this.m_maxTextWidth = maxWidth;
    }

    protected String getText(VisualItem item) {
        if (this.textCacheVersion != this.model.version) {
            this.textCacheVersion = this.model.version;
            this.textCache.clear();
        }
        this.m_color = this.IN_CLOSURE_COLOR;
        if (item.canGetString(this.m_labelName)) {
            String tableName = item.getString(this.m_labelName);
            Table table = this.model.getTable(tableName);
            if (table != null) {
                tableName = this.model.getDisplayName(table);
            }
            if (table != null && !this.graphicalDataModelView.modelEditor.getCurrentSubjectClosure().contains(table)) {
                this.m_color = this.NOT_IN_CLOSURE_COLOR;
            }
            if (table != null && this.graphicalDataModelView.showDetails(table)) {
                if (this.textCache.containsKey(table.getName())) {
                    return this.textCache.get(table.getName());
                }
                StringBuilder sb = new StringBuilder(tableName + " \n-\n");
                for (Column c : table.getColumns()) {
                    if (c.getFilterExpression() != null) {
                        sb.append("!");
                    }
                    for (Column pk : table.primaryKey.getColumns()) {
                        if (!pk.name.equals(c.name)) continue;
                        sb.append("+");
                        break;
                    }
                    String sql = c.toSQL(null);
                    sb.append(c.name).append("  \t").append(sql.substring(c.name.length()).trim()).append(" \n");
                }
                this.textCache.put(table.getName(), sb.toString());
                return sb.toString();
            }
            return tableName + " ";
        }
        return " ";
    }

    public String getImageField() {
        return this.m_imageName;
    }

    public void setImageField(String imageField) {
        if (imageField != null) {
            this.m_images = new ImageFactory();
        }
        this.m_imageName = imageField;
    }

    public void setMaxImageDimensions(int width, int height) {
        if (this.m_images == null) {
            this.m_images = new ImageFactory();
        }
        this.m_images.setMaxImageDimensions(width, height);
    }

    protected String getImageLocation(VisualItem item) {
        return item.canGetString(this.m_imageName) ? item.getString(this.m_imageName) : null;
    }

    private String computeTextDimensions(VisualItem item, String text, double size) {
        String line;
        this.m_font = item.getFont();
        if (size != 1.0) {
            this.m_font = FontLib.getFont(this.m_font.getName(), this.m_font.getStyle(), size * (double)this.m_font.getSize());
        }
        this.m_font2 = FontLib.getFont(this.m_font.getName(), this.m_font.getStyle(), size * (double)this.m_font.getSize() * 0.8);
        this.m_font_nic = FontLib.getFont(this.m_font.getName(), this.m_font.getStyle() | 2, size * (double)this.m_font.getSize());
        FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
        FontMetrics fm2 = DEFAULT_GRAPHICS.getFontMetrics(this.m_font2);
        StringBuffer str = null;
        int nlines = 1;
        int w = 0;
        int start = 0;
        int end = text.indexOf(this.m_delim);
        if (text.endsWith("\n")) {
            --nlines;
        }
        this.m_textDim.width = 0;
        this.m_headerDim.width = 0;
        boolean f = true;
        while (end >= 0) {
            line = text.substring(start, end);
            w = (f ? fm : fm2).stringWidth(line);
            f = false;
            if (this.m_maxTextWidth > -1 && w > this.m_maxTextWidth) {
                if (str == null) {
                    str = new StringBuffer(text.substring(0, start));
                }
                str.append(StringLib.abbreviate(line, fm, this.m_maxTextWidth));
                str.append(this.m_delim);
                w = this.m_maxTextWidth;
            } else if (str != null) {
                str.append(line).append(this.m_delim);
            }
            this.m_textDim.width = Math.max(this.m_textDim.width, w);
            start = end + 1;
            end = text.indexOf(this.m_delim, start);
            ++nlines;
        }
        line = text.substring(start);
        w = (f ? fm : fm2).stringWidth(line);
        if (this.m_maxTextWidth > -1 && w > this.m_maxTextWidth) {
            if (str == null) {
                str = new StringBuffer(text.substring(0, start));
            }
            str.append(StringLib.abbreviate(line, fm, this.m_maxTextWidth));
            w = this.m_maxTextWidth;
        } else if (str != null) {
            str.append(line);
        }
        this.m_textDim.width = Math.max(this.m_textDim.width, w);
        this.m_textDim.height = fm.getHeight() + fm2.getHeight() * (nlines - 1);
        this.m_headerDim.width = this.m_textDim.width;
        this.m_headerDim.height = fm.getHeight();
        return str == null ? text : str.toString();
    }

    @Override
    protected Shape getRawShape(VisualItem item) {
        this.m_text = this.getText(item);
        Image[] img = this.getImage(item);
        double size = item.getSize();
        int tw = 0;
        int th = 0;
        if (this.m_text != null) {
            this.m_text = this.computeTextDimensions(item, this.m_text, size);
            th = this.m_textDim.height;
            tw = this.m_textDim.width;
        }
        double iw = 0.0;
        double ih = 0.0;
        for (Image i : img) {
            if (i == null) continue;
            ih = (double)i.getHeight(null) * this.imgScale(i);
            iw += (double)i.getWidth(null) * this.imgScale(i) + 2.0;
        }
        double w = 0.0;
        double h = 0.0;
        switch (this.m_imagePos) {
            case 0: 
            case 1: {
                w = (double)tw + size * (iw + (double)(2 * this.m_horizBorder) + (double)(tw > 0 && iw > 0.0 ? this.m_imageMargin : 0));
                h = Math.max((double)th, size * ih) + size * 2.0 * (double)this.m_vertBorder;
                break;
            }
            case 3: 
            case 4: {
                w = Math.max((double)tw, size * iw) + size * 2.0 * (double)this.m_horizBorder;
                h = (double)th + size * (ih + (double)(2 * this.m_vertBorder) + (double)(th > 0 && ih > 0.0 ? this.m_imageMargin : 0));
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized image alignment setting.");
            }
        }
        TableRenderer.getAlignedPoint(this.m_pt, item, w, h, this.m_xAlign, this.m_yAlign);
        if (this.m_bbox instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)this.m_bbox;
            rr.setRoundRect(this.m_pt.getX(), this.m_pt.getY(), w, h, size * (double)this.m_arcWidth, size * (double)this.m_arcHeight);
        } else {
            this.m_bbox.setFrame(this.m_pt.getX(), this.m_pt.getY(), w, h);
        }
        return this.m_bbox;
    }

    protected static void getAlignedPoint(Point2D p, VisualItem item, double w, double h, int xAlign, int yAlign) {
        double x = item.getX();
        double y = item.getY();
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y) || Double.isInfinite(y)) {
            y = 0.0;
        }
        if (xAlign == 2) {
            x -= w / 2.0;
        } else if (xAlign == 1) {
            x -= w;
        }
        if (yAlign == 2) {
            y -= h / 2.0;
        } else if (yAlign == 3) {
            y -= h;
        }
        p.setLocation(x, y);
    }

    @Override
    public void render(Graphics2D g, VisualItem item) {
        item.setTextColor(this.IN_CLOSURE_COLOR);
        RectangularShape shape = (RectangularShape)this.getShape(item);
        if (shape == null) {
            return;
        }
        int type = this.getRenderType(item);
        if (type == 2 || type == 3) {
            boolean isSelected = false;
            String tableName = item.getString("label");
            Table table = this.model.getTable(tableName);
            if (!this.graphicalDataModelView.inImageExport) {
                if (this.graphicalDataModelView.selectedAssociation != null) {
                    isSelected = this.graphicalDataModelView.selectedAssociation.destination.equals(table);
                } else {
                    boolean bl = isSelected = this.graphicalDataModelView.root != null && this.graphicalDataModelView.root.equals(table);
                }
            }
            if (isSelected) {
                item.setStrokeColor(ColorLib.rgb(0, 0, 0));
            } else {
                item.setStrokeColor(ColorLib.rgba(0, 0, 0, 0));
            }
            int fillColor = item.getFillColor();
            if (this.graphicalDataModelView.tablesOnPath.contains(tableName)) {
                fillColor = ColorLib.rgba(0.3f, 0.9f, 1.0f, 0.3f);
            }
            TableRenderer.paint(g, item, fillColor, shape, new BasicStroke(isSelected ? 1.0f : 0.0f), isSelected ? 3 : 2);
        }
        String text = this.m_text;
        Image[] img = this.getImage(item);
        if (text == null && img == null) {
            return;
        }
        double size = item.getSize();
        boolean useInt = 1.5 > Math.max(g.getTransform().getScaleX(), g.getTransform().getScaleY());
        double x = shape.getMinX() + size * (double)this.m_horizBorder;
        double y = shape.getMinY() + size * (double)this.m_vertBorder;
        for (Image i : img) {
            if (i == null) continue;
            double w = size * (double)i.getWidth(null) * this.imgScale(i);
            double h = size * (double)i.getHeight(null) * this.imgScale(i);
            double ix = x;
            double iy = y;
            switch (this.m_imagePos) {
                case 0: {
                    x += w + size * (double)this.m_imageMargin;
                    break;
                }
                case 1: {
                    ix = shape.getMaxX() - size * (double)this.m_horizBorder - w;
                    break;
                }
                case 4: {
                    y += h + size * (double)this.m_imageMargin;
                    break;
                }
                case 3: {
                    iy = shape.getMaxY() - size * (double)this.m_vertBorder - h;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized image alignment setting.");
                }
            }
            block6 : switch (this.m_imagePos) {
                case 0: 
                case 1: {
                    switch (this.m_vImageAlign) {
                        case 4: {
                            break;
                        }
                        case 3: {
                            iy = shape.getMaxY() - size * (double)this.m_vertBorder - h;
                            break;
                        }
                        case 2: {
                            iy = shape.getCenterY() - h / 2.0;
                        }
                    }
                    break;
                }
                case 3: 
                case 4: {
                    switch (this.m_hImageAlign) {
                        case 0: {
                            break block6;
                        }
                        case 1: {
                            ix = shape.getMaxX() - size * (double)this.m_horizBorder - w;
                            break block6;
                        }
                        case 2: {
                            ix = shape.getCenterX() - w / 2.0;
                        }
                    }
                }
            }
            this.m_transform.setTransform(size * this.imgScale(i), 0.0, 0.0, size * this.imgScale(i), ix, iy);
            g.drawImage(i, this.m_transform, null);
        }
        int textColor = this.m_color;
        if (text != null && ColorLib.alpha(textColor) > 0) {
            double th;
            double tw;
            g.setPaint(ColorLib.getColor(textColor));
            if (this.m_color == this.NOT_IN_CLOSURE_COLOR) {
                g.setFont(this.m_font_nic);
            } else {
                g.setFont(this.m_font);
            }
            FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
            switch (this.m_imagePos) {
                case 3: 
                case 4: {
                    tw = shape.getWidth() - 2.0 * size * (double)this.m_horizBorder;
                    break;
                }
                default: {
                    tw = this.m_textDim.width;
                }
            }
            switch (this.m_imagePos) {
                case 0: 
                case 1: {
                    th = shape.getHeight() - 2.0 * size * (double)this.m_vertBorder;
                    break;
                }
                default: {
                    th = this.m_textDim.height;
                }
            }
            y += (double)fm.getAscent();
            switch (this.m_vTextAlign) {
                case 4: {
                    break;
                }
                case 3: {
                    y += th - (double)this.m_textDim.height;
                    break;
                }
                case 2: {
                    y += (th - (double)this.m_textDim.height) / 2.0;
                }
            }
            int lh = fm.getHeight();
            boolean f = true;
            int start = 0;
            int end = text.indexOf(this.m_delim);
            while (end >= 0) {
                String b;
                String a;
                g.setPaint(ColorLib.getColor(textColor));
                String line = text.substring(start, end);
                int tab = line.indexOf(9);
                if (tab < 0) {
                    a = line;
                    b = null;
                } else {
                    a = line.substring(0, tab);
                    b = line.substring(tab + 1);
                    if (a.startsWith("!")) {
                        if (this.filterImage != null) {
                            this.m_transform.setTransform(size * this.imgScale(this.filterImage) * 0.6, 0.0, 0.0, size * this.imgScale(this.filterImage) * 0.6, x - (double)this.filterImage.getWidth(null) * this.imgScale(this.filterImage) * 0.9, y - (double)lh * 0.75);
                            g.drawImage(this.filterImage, this.m_transform, null);
                        }
                        a = a.substring(1);
                    }
                    if (a.startsWith("+")) {
                        g.setPaint(Color.RED);
                        a = a.substring(1);
                    }
                }
                if ("-".equals(line)) {
                    g.drawLine((int)x, (int)y - lh / 2 + 1, (int)x + (int)tw, (int)y - lh / 2 + 1);
                } else {
                    this.drawString(g, fm, a, useInt, x, y, tw, 0);
                    if (b != null) {
                        g.setPaint(Color.GRAY);
                        this.drawString(g, fm, b, useInt, x, y, tw, 1);
                    }
                }
                start = end + 1;
                end = text.indexOf(this.m_delim, start);
                if (f) {
                    g.setFont(this.m_font2);
                    fm = DEFAULT_GRAPHICS.getFontMetrics(this.m_font2);
                    lh = fm.getHeight();
                }
                textColor = this.IN_CLOSURE_COLOR;
                f = false;
                y += (double)lh;
            }
            this.drawString(g, fm, text.substring(start), useInt, x, y, tw, 0);
        }
        if (type == 1 || type == 3) {
            GraphicsLib.paint(g, item, shape, this.getStroke(item), 1);
        }
    }

    private double imgScale(Image image) {
        if (image == null) {
            return 1.0;
        }
        return (double)this.m_headerDim.height / (double)image.getHeight(null) * (image == this.collapsedImage ? 1.0 : 1.2);
    }

    private final void drawString(Graphics2D g, FontMetrics fm, String text, boolean useInt, double x, double y, double w, int hTextAlign) {
        double tx;
        if (text.length() == 0) {
            return;
        }
        switch (hTextAlign) {
            case 0: {
                tx = x;
                break;
            }
            case 1: {
                tx = x + w - (double)fm.stringWidth(text);
                break;
            }
            case 2: {
                tx = x + (w - (double)fm.stringWidth(text)) / 2.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized text alignment setting.");
            }
        }
        if (useInt) {
            g.drawString(text, (int)tx, (int)y);
        } else {
            g.drawString(text, (float)tx, (float)y);
        }
    }

    public ImageFactory getImageFactory() {
        if (this.m_images == null) {
            this.m_images = new ImageFactory();
        }
        return this.m_images;
    }

    public void setImageFactory(ImageFactory ifact) {
        this.m_images = ifact;
    }

    public int getHorizontalTextAlignment() {
        return this.m_hTextAlign;
    }

    public void setHorizontalTextAlignment(int halign) {
        if (halign != 0 && halign != 1 && halign != 2) {
            throw new IllegalArgumentException("Illegal horizontal text alignment value.");
        }
        this.m_hTextAlign = halign;
    }

    public int getVerticalTextAlignment() {
        return this.m_vTextAlign;
    }

    public void setVerticalTextAlignment(int valign) {
        if (valign != 4 && valign != 3 && valign != 2) {
            throw new IllegalArgumentException("Illegal vertical text alignment value.");
        }
        this.m_vTextAlign = valign;
    }

    public int getHorizontalImageAlignment() {
        return this.m_hImageAlign;
    }

    public void setHorizontalImageAlignment(int halign) {
        if (halign != 0 && halign != 1 && halign != 2) {
            throw new IllegalArgumentException("Illegal horizontal text alignment value.");
        }
        this.m_hImageAlign = halign;
    }

    public int getVerticalImageAlignment() {
        return this.m_vImageAlign;
    }

    public void setVerticalImageAlignment(int valign) {
        if (valign != 4 && valign != 3 && valign != 2) {
            throw new IllegalArgumentException("Illegal vertical text alignment value.");
        }
        this.m_vImageAlign = valign;
    }

    public int getImagePosition() {
        return this.m_imagePos;
    }

    public void setImagePosition(int pos) {
        if (pos != 4 && pos != 3 && pos != 0 && pos != 1 && pos != 2) {
            throw new IllegalArgumentException("Illegal image position value.");
        }
        this.m_imagePos = pos;
    }

    public int getHorizontalAlignment() {
        return this.m_xAlign;
    }

    public int getVerticalAlignment() {
        return this.m_yAlign;
    }

    public void setHorizontalAlignment(int align) {
        this.m_xAlign = align;
    }

    public void setVerticalAlignment(int align) {
        this.m_yAlign = align;
    }

    public int getHorizontalPadding() {
        return this.m_horizBorder;
    }

    public void setHorizontalPadding(int xpad) {
        this.m_horizBorder = xpad;
    }

    public int getVerticalPadding() {
        return this.m_vertBorder;
    }

    public void setVerticalPadding(int ypad) {
        this.m_vertBorder = ypad;
    }

    public int getImageTextPadding() {
        return this.m_imageMargin;
    }

    public void setImageTextPadding(int pad) {
        this.m_imageMargin = pad;
    }

    public TableRenderer(DataModel model, GraphicalDataModelView graphicalDataModelView) {
        String dir = "/net/sf/jailer/resource";
        try {
            this.excludeFromDeletionImage = new ImageIcon(this.getClass().getResource(dir + "/database-lock.png")).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.allRowsImage = new ImageIcon(this.getClass().getResource(dir + "/all-rows.png")).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.collapsedImage = new ImageIcon(this.getClass().getResource(dir + "/collapsed.png")).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.upsertImage = new ImageIcon(this.getClass().getResource(dir + "/upsert.png")).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.subjectImage = new ImageIcon(this.getClass().getResource(dir + "/subject.png")).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.filterImage = new ImageIcon(this.getClass().getResource(dir + "/filter.png")).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.model = model;
        this.graphicalDataModelView = graphicalDataModelView;
        try {
            UIUtil.loadTableList(this.excludeFromDeletion, DataModel.getExcludeFromDeletionFile());
            UIUtil.loadTableList(this.initialDataTables, DataModel.getInitialDataTablesFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Image[] getImage(VisualItem item) {
        Image[] img = new Image[6];
        int i = 0;
        Table table = this.model.getTable(item.getString("label"));
        if (table != null) {
            if (!this.graphicalDataModelView.expandedTables.contains(table)) {
                img[i++] = this.collapsedImage;
            }
            if (table.equals(this.graphicalDataModelView.modelEditor.getSubject())) {
                img[i++] = this.subjectImage;
            }
            if (this.excludeFromDeletion.contains(table.getName())) {
                img[i++] = this.excludeFromDeletionImage;
            }
            if (this.initialDataTables.contains(table.getName())) {
                img[i++] = this.allRowsImage;
            }
            if (table.getUpsert().booleanValue()) {
                img[i++] = this.upsertImage;
            }
            if (this.model.version != this.dmVersionOfFilteredTables) {
                block0: for (Table t : this.model.getTables()) {
                    for (Column column : t.getColumns()) {
                        if (column.getFilterExpression() == null) continue;
                        this.filteredTables.add(t);
                        continue block0;
                    }
                }
                this.dmVersionOfFilteredTables = this.model.version;
            }
            if (this.filteredTables.contains(table)) {
                img[i++] = this.filterImage;
            }
        }
        return img;
    }

    public String getToolTip(Table table) {
        String tt = "";
        if (this.excludeFromDeletion.contains(table.getName())) {
            tt = tt + "Excluded from Deletion. ";
        }
        if (this.initialDataTables.contains(table.getName())) {
            tt = tt + "Export all Rows. ";
        }
        if (table.getUpsert().booleanValue()) {
            tt = tt + "Upsert Rows/Merge. ";
        }
        return tt + table.getName() + " (" + table.primaryKey.toSQL(null, false) + ")";
    }

    private static void paint(Graphics2D g, VisualItem item, int fillColorI, Shape shape, BasicStroke stroke, int type) {
        AffineTransform at;
        double scale;
        boolean fdraw;
        if (type == 0) {
            return;
        }
        Color fillColor = ColorLib.getColor(fillColorI);
        Color strokeColor = ColorLib.getColor(item.getStrokeColor());
        boolean sdraw = (type == 1 || type == 3) && strokeColor.getAlpha() != 0;
        boolean bl = fdraw = (type == 2 || type == 3) && fillColor.getAlpha() != 0;
        if (!sdraw && !fdraw) {
            return;
        }
        Stroke origStroke = null;
        if (sdraw) {
            origStroke = g.getStroke();
            g.setStroke(stroke);
        }
        if ((scale = Math.max((at = g.getTransform()).getScaleX(), at.getScaleY())) > 1.5) {
            if (fdraw) {
                g.setPaint(fillColor);
                g.fill(shape);
            }
            if (sdraw) {
                g.setPaint(strokeColor);
                g.draw(shape);
            }
        } else if (shape instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)shape;
            double xx = r.getX();
            double ww = r.getWidth();
            double yy = r.getY();
            double hh = r.getHeight();
            int x = (int)xx;
            int y = (int)yy;
            int w = (int)(ww + xx - (double)x);
            int h = (int)(hh + yy - (double)y);
            if (shape instanceof Rectangle2D) {
                if (fdraw) {
                    g.setPaint(fillColor);
                    g.fillRect(x, y, w, h);
                }
                if (sdraw) {
                    g.setPaint(strokeColor);
                    g.drawRect(x, y, w, h);
                }
            } else if (shape instanceof RoundRectangle2D) {
                RoundRectangle2D rr = (RoundRectangle2D)shape;
                int aw = (int)rr.getArcWidth();
                int ah = (int)rr.getArcHeight();
                if (fdraw) {
                    g.setPaint(fillColor);
                    g.fillRoundRect(x, y, w, h, aw, ah);
                }
                if (sdraw) {
                    g.setPaint(strokeColor);
                    g.drawRoundRect(x, y, w, h, aw, ah);
                }
            } else if (shape instanceof Ellipse2D) {
                if (fdraw) {
                    g.setPaint(fillColor);
                    g.fillOval(x, y, w, h);
                }
                if (sdraw) {
                    g.setPaint(strokeColor);
                    g.drawOval(x, y, w, h);
                }
            } else {
                if (fdraw) {
                    g.setPaint(fillColor);
                    g.fill(shape);
                }
                if (sdraw) {
                    g.setPaint(strokeColor);
                    g.draw(shape);
                }
            }
        } else if (shape instanceof Line2D) {
            if (sdraw) {
                Line2D l = (Line2D)shape;
                int x = (int)(l.getX1() + 0.5);
                int y = (int)(l.getY1() + 0.5);
                int w = (int)(l.getX2() + 0.5);
                int h = (int)(l.getY2() + 0.5);
                g.setPaint(strokeColor);
                g.drawLine(x, y, w, h);
            }
        } else {
            if (fdraw) {
                g.setPaint(fillColor);
                g.fill(shape);
            }
            if (sdraw) {
                g.setPaint(strokeColor);
                g.draw(shape);
            }
        }
        if (sdraw) {
            g.setStroke(origStroke);
        }
    }
}

