/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.graphical_view;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jailer.util.CsvFile;

public class LayoutStorage {
    private static final String GLOBAL_STORAGE = ".layout";
    public static volatile boolean enabled = true;
    private static Map<String, Map<String, double[]>> tablePositions = Collections.synchronizedMap(new HashMap());
    private static Map<String, Map<String, double[]>> globalTablePositions = Collections.synchronizedMap(new HashMap());

    public static void setPosition(String rootTable, String table, double[] position) {
        if (rootTable == null) {
            throw new RuntimeException("rootTable is null");
        }
        if (table == null) {
            throw new RuntimeException("table is null");
        }
        Map<String, double[]> posMap = tablePositions.get(rootTable);
        if (posMap == null) {
            posMap = new HashMap<String, double[]>();
            tablePositions.put(rootTable, posMap);
        }
        posMap.put(table, position);
    }

    public static void checkSignificance(String rootTable) {
        Map<String, double[]> layout = tablePositions.get(rootTable);
        if (!LayoutStorage.isSignificant(rootTable, layout)) {
            tablePositions.remove(rootTable);
        } else {
            globalTablePositions.put(rootTable, new HashMap<String, double[]>(layout));
        }
    }

    private static boolean isSignificant(String rootTable, Map<String, double[]> layout) {
        if (layout != null) {
            for (String t : layout.keySet()) {
                if (t.equals(rootTable) || "$ZOOMBOX".equals(t) || layout.get(t)[2] != 1.0) continue;
                return true;
            }
        }
        return false;
    }

    private static File getGlobalStorageFile(String rootTable) {
        try {
            File dir = new File(GLOBAL_STORAGE);
            if (!dir.exists() && !dir.mkdir()) {
                return null;
            }
            String fn = "";
            for (int i = 0; i < rootTable.length(); ++i) {
                char c = rootTable.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '.') continue;
                fn = fn + c;
            }
            if (fn.length() > 0) {
                return new File(dir, fn);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static double[] getPosition(String rootTable, String table) {
        if (enabled) {
            LayoutStorage.readGlobalLayout(rootTable);
            Map<String, double[]> posMap = tablePositions.get(rootTable);
            if (posMap != null) {
                return posMap.get(table);
            }
        }
        return null;
    }

    public static Map<String, double[]> getPositions(String root) {
        if (enabled) {
            LayoutStorage.readGlobalLayout(root);
            return tablePositions.get(root);
        }
        return null;
    }

    public static void removeAll(String root) {
        tablePositions.remove(root);
    }

    public static void removeAll() {
        tablePositions.clear();
        globalTablePositions.clear();
    }

    public static void store(PrintWriter out) {
        LayoutStorage.store(out, tablePositions);
        try {
            for (String rootTable : tablePositions.keySet()) {
                Map<String, double[]> layout = globalTablePositions.get(rootTable);
                if (layout == null) continue;
                globalTablePositions.put(rootTable, new HashMap<String, double[]>(layout));
                HashMap<String, Map<String, double[]>> tmp = new HashMap<String, Map<String, double[]>>();
                tmp.put(rootTable, layout);
                File file = LayoutStorage.getGlobalStorageFile(rootTable);
                if (file == null) continue;
                PrintWriter tout = new PrintWriter(file);
                LayoutStorage.store(tout, tmp);
                tout.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readGlobalLayout(String rootTable) {
        if (!tablePositions.containsKey(rootTable)) {
            Map<String, double[]> layout;
            if (!globalTablePositions.containsKey(rootTable)) {
                File file = LayoutStorage.getGlobalStorageFile(rootTable);
                HashMap<String, double[]> layout2 = null;
                if (file != null) {
                    try {
                        LayoutStorage.restore(file.getAbsolutePath(), false);
                        if (tablePositions.get(rootTable) != null) {
                            layout2 = new HashMap<String, double[]>(tablePositions.get(rootTable));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                globalTablePositions.put(rootTable, layout2);
            }
            if ((layout = globalTablePositions.get(rootTable)) != null) {
                tablePositions.put(rootTable, new HashMap<String, double[]>(globalTablePositions.get(rootTable)));
            }
        }
    }

    public static void store(PrintWriter out, Map<String, Map<String, double[]>> positions) {
        out.println(CsvFile.BLOCK_INDICATOR + "layout");
        for (String root : positions.keySet()) {
            Map<String, double[]> pos = positions.get(root);
            for (String table : pos.keySet()) {
                double[] xyf = pos.get(table);
                out.println(CsvFile.encodeCell(root) + "; " + CsvFile.encodeCell(table) + "; " + xyf[0] + "; " + xyf[1] + "; " + xyf[2]);
            }
        }
    }

    public static void restore(String file) {
        LayoutStorage.restore(file, true);
    }

    private static void restore(String file, boolean resetLayout) {
        if (resetLayout) {
            tablePositions.clear();
            globalTablePositions.clear();
        }
        try {
            File csvFile = new File(file);
            if (csvFile.exists()) {
                CsvFile csv = new CsvFile(csvFile, "layout");
                for (CsvFile.Line line : csv.getLines()) {
                    if (line.cells.get(0).length() <= 0) continue;
                    double x = 0.0;
                    double y = 0.0;
                    double f = 0.0;
                    try {
                        x = Double.parseDouble(line.cells.get(2));
                        y = Double.parseDouble(line.cells.get(3));
                        f = Double.parseDouble(line.cells.get(4));
                        LayoutStorage.setPosition(line.cells.get(0), line.cells.get(1), new double[]{x, y, f});
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

