/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.graphical_view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.sf.jailer.ScriptFormat;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.ExtractionModelEditor;
import net.sf.jailer.ui.QueryBuilderDialog;
import net.sf.jailer.ui.graphical_view.AssociationRenderer;
import net.sf.jailer.ui.graphical_view.DisplayExporter;
import net.sf.jailer.ui.graphical_view.LayoutStorage;
import net.sf.jailer.ui.graphical_view.TableRenderer;
import net.sf.jailer.ui.graphical_view.ZoomBoxControl;
import net.sf.jailer.ui.scrollmenu.JScrollMenu;
import net.sf.jailer.ui.scrollmenu.JScrollPopupMenu;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.filter.GraphDistanceFilter;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.PanControl;
import prefuse.controls.ToolTipControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.tuple.TupleSet;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.Integrator;
import prefuse.util.force.NBodyForce;
import prefuse.util.ui.UILib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

public class GraphicalDataModelView
extends JPanel {
    private final int EXPAND_LIMIT = 50;
    public Association selectedAssociation;
    Set<String> tablesOnPath = new HashSet<String>();
    private List<Association> associationsOnPath = new ArrayList<Association>();
    private static final String graph = "graph";
    private static final String nodes = "graph.nodes";
    private static final String edges = "graph.edges";
    private Visualization visualization;
    private VisualGraph visualGraph;
    public Display display;
    private boolean inInitialization = false;
    final Table root;
    private TableRenderer tableRenderer;
    private CompositeAssociationRenderer associationRenderer;
    public final ExtractionModelEditor modelEditor;
    private ForceDirectedLayout layout;
    private ZoomToFitControlExtension zoomToFitControl;
    private boolean showTableDetails;
    private NBodyForce force;
    private volatile boolean layoutHasBeenSet = false;
    private Graph theGraph;
    private Map<Table, Node> tableNodes = new HashMap<Table, Node>();
    Set<Table> expandedTables = new HashSet<Table>();
    private Map<Association, Edge> renderedAssociations = new HashMap<Association, Edge>();
    private Map<Association, Node> renderedAssociationsAsNode = new HashMap<Association, Node>();
    private DataModel model = null;
    private Set<Table> reversedShowDetailsTables = new HashSet<Table>();
    private static DisplayExporter displayExporter = new DisplayExporter();
    public boolean inImageExport = false;
    private static final long serialVersionUID = -5938101712807557555L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicalDataModelView(final DataModel model, ExtractionModelEditor modelEditor, Table subject, boolean expandSubject, int width, int height) {
        super(new BorderLayout());
        Map<String, double[]> positions;
        this.model = model;
        this.modelEditor = modelEditor;
        this.root = subject;
        this.tableRenderer = new TableRenderer(model, this);
        final HashSet<Table> initiallyVisibleTables = new HashSet<Table>();
        if (subject != null && (positions = LayoutStorage.getPositions(subject.getName())) != null) {
            for (String tn : positions.keySet()) {
                Table table = model.getTable(tn);
                if (table == null || table.equals(subject)) continue;
                initiallyVisibleTables.add(table);
            }
        }
        this.theGraph = this.getModelGraph(model, initiallyVisibleTables, expandSubject);
        this.visualization = new Visualization();
        final ZoomBoxControl zoomBoxControl = new ZoomBoxControl();
        final ShapeRenderer sr = new ShapeRenderer(){

            @Override
            protected Shape getRawShape(VisualItem item) {
                double width;
                double y;
                item.setFillColor(ColorLib.rgb(220, 210, 0));
                double x = item.getX();
                if (Double.isNaN(x) || Double.isInfinite(x)) {
                    x = 0.0;
                }
                if (Double.isNaN(y = item.getY()) || Double.isInfinite(y)) {
                    y = 0.0;
                }
                if ((width = 10.0 * item.getSize()) > 1.0) {
                    x -= width / 2.0;
                    y -= width / 2.0;
                }
                return this.ellipse((float)x, (float)y, (float)width, (float)width);
            }
        };
        this.associationRenderer = new CompositeAssociationRenderer();
        this.tableRenderer.setRoundedCorner(3, 3);
        this.tableRenderer.setVerticalPadding(3);
        this.tableRenderer.setHorizontalPadding(3);
        this.visualization.setRendererFactory(new RendererFactory(){

            @Override
            public Renderer getRenderer(VisualItem item) {
                if (zoomBoxControl.getRenderer().isBoxItem(item)) {
                    return zoomBoxControl.getRenderer();
                }
                if (item instanceof EdgeItem) {
                    return GraphicalDataModelView.this.associationRenderer;
                }
                if (item.get("association") != null) {
                    return sr;
                }
                return GraphicalDataModelView.this.tableRenderer;
            }
        });
        this.setGraph(this.theGraph);
        TupleSet focusGroup = this.visualization.getGroup(Visualization.FOCUS_ITEMS);
        focusGroup.addTupleSetListener(new TupleSetListener(){

            @Override
            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                boolean draw = false;
                if (GraphicalDataModelView.this.inInitialization) {
                    return;
                }
                for (int i = 0; i < add.length; ++i) {
                    if (!(add[i] instanceof NodeItem)) continue;
                    draw = true;
                    ((VisualItem)add[i]).setFixed(false);
                    ((VisualItem)add[i]).setFixed(true);
                }
                if (draw) {
                    // empty if block
                }
            }
        });
        int hops = 30;
        GraphDistanceFilter filter = new GraphDistanceFilter(graph, hops);
        ColorAction fill = new ColorAction(nodes, VisualItem.FILLCOLOR, ColorLib.rgba(255, 235, 20, 100));
        fill.add(VisualItem.FIXED, ColorLib.rgba(255, 235, 20, 100));
        fill.add(VisualItem.HIGHLIGHT, ColorLib.rgba(160, 160, 0, 120));
        ActionList draw = new ActionList();
        draw.add(filter);
        draw.add(fill);
        draw.add(new ColorAction(nodes, VisualItem.STROKECOLOR, 0));
        draw.add(new ColorAction(nodes, VisualItem.TEXTCOLOR, ColorLib.rgb(0, 0, 0)));
        draw.add(new ColorAction(edges, VisualItem.FILLCOLOR, ColorLib.gray(200)));
        draw.add(new ColorAction(edges, VisualItem.STROKECOLOR, ColorLib.gray(200)));
        ActionList animate = new ActionList(-1L);
        animate.add(fill);
        animate.add(new RepaintAction());
        if (modelEditor.extractionModelFrame.animationStepTime > 0) {
            animate.setStepTime(modelEditor.extractionModelFrame.animationStepTime);
        }
        this.visualization.putAction("draw", draw);
        this.visualization.putAction("layout", animate);
        this.visualization.runAfter("draw", "layout");
        this.display = new Display(this.visualization);
        this.display.setSize(width, height);
        this.display.pan(width / 2, height / 2);
        this.display.setForeground(Color.GRAY);
        this.display.setBackground(Color.WHITE);
        this.display.addControlListener(new FocusControl(1));
        this.display.addControlListener(new DragControl(){

            @Override
            public void itemClicked(VisualItem item, MouseEvent e) {
                Table table = model.getTable(item.getString("label"));
                if (SwingUtilities.isLeftMouseButton(e) && table != null && e.getClickCount() == 1) {
                    GraphicalDataModelView.this.selectTable(table);
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu popup;
                    Association association = (Association)item.get("association");
                    if (association != null) {
                        if (Boolean.TRUE.equals(item.get("full"))) {
                            ((GraphicalDataModelView)GraphicalDataModelView.this).associationRenderer.useAssociationRendererForLocation = true;
                            VisualItem findItem = GraphicalDataModelView.this.display.findItem(e.getPoint());
                            if (findItem == null || !findItem.equals(item)) {
                                association = association.reversalAssociation;
                            }
                            ((GraphicalDataModelView)GraphicalDataModelView.this).associationRenderer.useAssociationRendererForLocation = false;
                        }
                        popup = GraphicalDataModelView.this.createPopupMenu(association);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                    if (table != null) {
                        popup = GraphicalDataModelView.this.createPopupMenu(table, true);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
                super.itemClicked(item, e);
            }

            @Override
            public void itemPressed(VisualItem item, MouseEvent e) {
                if (UILib.isButtonPressed(e, 16)) {
                    Table table;
                    Association association = (Association)item.get("association");
                    if (association != null) {
                        if (Boolean.TRUE.equals(item.get("full"))) {
                            ((GraphicalDataModelView)GraphicalDataModelView.this).associationRenderer.useAssociationRendererForLocation = true;
                            VisualItem findItem = GraphicalDataModelView.this.display.findItem(e.getPoint());
                            if (findItem == null || !findItem.equals(item)) {
                                association = association.reversalAssociation;
                            }
                            ((GraphicalDataModelView)GraphicalDataModelView.this).associationRenderer.useAssociationRendererForLocation = false;
                        }
                        GraphicalDataModelView.this.setSelection(association);
                    }
                    if ((table = model.getTable(item.getString("label"))) != null && e.getClickCount() > 1) {
                        if (GraphicalDataModelView.this.expandedTables.contains(table)) {
                            GraphicalDataModelView.this.collapseTable(GraphicalDataModelView.this.theGraph, table, false);
                            GraphicalDataModelView.this.display.pan(1.0, 0.0);
                            GraphicalDataModelView.this.display.pan(0.0, 1.0);
                            Association sa = GraphicalDataModelView.this.selectedAssociation;
                            GraphicalDataModelView.this.setSelection(null);
                            GraphicalDataModelView.this.setSelection(sa);
                            GraphicalDataModelView.this.visualization.invalidateAll();
                            GraphicalDataModelView.this.display.invalidate();
                        } else {
                            GraphicalDataModelView.this.expandTable(GraphicalDataModelView.this.theGraph, table);
                            GraphicalDataModelView.this.visualization.invalidateAll();
                            GraphicalDataModelView.this.display.invalidate();
                        }
                    }
                }
                super.itemPressed(item, e);
            }

            @Override
            public void itemReleased(VisualItem item, MouseEvent e) {
                super.itemReleased(item, e);
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (item instanceof NodeItem) {
                    item.setFixed(true);
                }
            }
        });
        this.display.addControlListener(new PanControl());
        this.display.addControlListener(zoomBoxControl);
        this.display.addControlListener(new WheelZoomControl(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Display display = (Display)e.getComponent();
                Point p = e.getPoint();
                this.zoom(display, p, 1.0f + 0.1f * (float)e.getWheelRotation(), false);
            }
        });
        this.zoomToFitControl = new ZoomToFitControlExtension(Visualization.ALL_ITEMS, 50, 800L, 4, model);
        this.display.addControlListener(this.zoomToFitControl);
        this.display.addControlListener(new ToolTipControl("tooltip"));
        this.display.setForeground(Color.GRAY);
        this.display.setBackground(Color.WHITE);
        this.visualization.run("draw");
        this.resetExpandedState();
        this.display.setHighQuality(true);
        this.add(this.display);
        RectangularShape bounds = null;
        if (this.root != null) {
            Visualization visualization = this.visualization;
            synchronized (visualization) {
                Iterator items = this.visualization.items(BooleanLiteral.TRUE);
                int m_visibleCount = 0;
                while (items.hasNext()) {
                    VisualItem item = (VisualItem)items.next();
                    if (item.canGetString("label")) {
                        String tableName = item.getString("label");
                        double[] pos = LayoutStorage.getPosition(this.root.getName(), tableName);
                        if (pos != null) {
                            if (bounds == null) {
                                bounds = new Rectangle2D.Double(pos[0], pos[1], 1.0, 1.0);
                            } else {
                                ((Rectangle2D)bounds).add(new Point2D.Double(pos[0], pos[1]));
                            }
                        }
                    }
                    ++m_visibleCount;
                }
            }
        }
        if (bounds != null) {
            this.display.panToAbs(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
        }
        this.layout = new ForceDirectedLayout(graph){

            @Override
            protected float getMassValue(VisualItem n) {
                return zoomBoxControl.getRenderer().isBoxItem(n) ? 0.01f : (GraphicalDataModelView.this.showTableDetails ? 2.0f : 1.0f);
            }
        };
        for (Force force : this.layout.getForceSimulator().getForces()) {
            if (!(force instanceof NBodyForce)) continue;
            this.force = (NBodyForce)force;
        }
        if (this.force != null) {
            this.force.setParameter(0, -100.0f);
        }
        this.updateTableDetailsMode();
        this.layout.getForceSimulator().setIntegrator(new Integrator(){

            @Override
            public void integrate(ForceSimulator sim, long timestep) {
                float v;
                float vy;
                float vx;
                float[][] l;
                float[][] k;
                float coeff;
                ForceItem item;
                float speedLimit = sim.getSpeedLimit();
                Iterator iter = sim.getItems();
                while (iter.hasNext()) {
                    item = (ForceItem)iter.next();
                    coeff = (float)timestep / item.mass;
                    k = item.k;
                    l = item.l;
                    item.plocation[0] = item.location[0];
                    item.plocation[1] = item.location[1];
                    k[0][0] = (float)timestep * item.velocity[0];
                    k[0][1] = (float)timestep * item.velocity[1];
                    l[0][0] = coeff * item.force[0];
                    l[0][1] = coeff * item.force[1];
                    item.location[0] = item.location[0] + 0.5f * k[0][0];
                    item.location[1] = item.location[1] + 0.5f * k[0][1];
                }
                sim.accumulate();
                iter = sim.getItems();
                while (iter.hasNext()) {
                    item = (ForceItem)iter.next();
                    coeff = (float)timestep / item.mass;
                    k = item.k;
                    l = item.l;
                    vx = item.velocity[0] + 0.5f * l[0][0];
                    vy = item.velocity[1] + 0.5f * l[0][1];
                    v = (float)Math.sqrt(vx * vx + vy * vy);
                    if (v > speedLimit) {
                        vx = speedLimit * vx / v;
                        vy = speedLimit * vy / v;
                    }
                    k[1][0] = (float)timestep * vx;
                    k[1][1] = (float)timestep * vy;
                    l[1][0] = coeff * item.force[0];
                    l[1][1] = coeff * item.force[1];
                    item.location[0] = item.plocation[0] + 0.5f * k[1][0];
                    item.location[1] = item.plocation[1] + 0.5f * k[1][1];
                }
                sim.accumulate();
                iter = sim.getItems();
                while (iter.hasNext()) {
                    item = (ForceItem)iter.next();
                    coeff = (float)timestep / item.mass;
                    k = item.k;
                    l = item.l;
                    vx = item.velocity[0] + 0.5f * l[1][0];
                    vy = item.velocity[1] + 0.5f * l[1][1];
                    v = (float)Math.sqrt(vx * vx + vy * vy);
                    if (v > speedLimit) {
                        vx = speedLimit * vx / v;
                        vy = speedLimit * vy / v;
                    }
                    k[2][0] = (float)timestep * vx;
                    k[2][1] = (float)timestep * vy;
                    l[2][0] = coeff * item.force[0];
                    l[2][1] = coeff * item.force[1];
                    item.location[0] = item.plocation[0] + 0.5f * k[2][0];
                    item.location[1] = item.plocation[1] + 0.5f * k[2][1];
                }
                sim.accumulate();
                iter = sim.getItems();
                while (iter.hasNext()) {
                    item = (ForceItem)iter.next();
                    coeff = (float)timestep / item.mass;
                    k = item.k;
                    l = item.l;
                    float[] p = item.plocation;
                    vx = item.velocity[0] + l[2][0];
                    vy = item.velocity[1] + l[2][1];
                    v = (float)Math.sqrt(vx * vx + vy * vy);
                    if (v > speedLimit) {
                        vx = speedLimit * vx / v;
                        vy = speedLimit * vy / v;
                    }
                    k[3][0] = (float)timestep * vx;
                    k[3][1] = (float)timestep * vy;
                    l[3][0] = coeff * item.force[0];
                    l[3][1] = coeff * item.force[1];
                    float dx = (k[0][0] + k[3][0]) / 6.0f + (k[1][0] + k[2][0]) / 3.0f;
                    float dy = (k[0][1] + k[3][1]) / 6.0f + (k[1][1] + k[2][1]) / 3.0f;
                    if (dx * dx + dy * dy < 3.0f) {
                        dy = 0.0f;
                        dx = 0.0f;
                    }
                    item.location[0] = p[0] + dx;
                    item.location[1] = p[1] + dy;
                    vx = (l[0][0] + l[3][0]) / 6.0f + (l[1][0] + l[2][0]) / 3.0f;
                    vy = (l[0][1] + l[3][1]) / 6.0f + (l[1][1] + l[2][1]) / 3.0f;
                    v = (float)Math.sqrt(vx * vx + vy * vy);
                    if (v > speedLimit) {
                        vx = speedLimit * vx / v;
                        vy = speedLimit * vy / v;
                    }
                    item.velocity[0] = item.velocity[0] + vx;
                    item.velocity[1] = item.velocity[1] + vy;
                }
            }
        });
        this.layout.setVisualization(this.visualization);
        animate.add(this.layout);
        this.layout.run();
        Action a = new Action(){
            boolean done = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(double frac) {
                if (!this.done) {
                    Visualization visualization = GraphicalDataModelView.this.visualization;
                    synchronized (visualization) {
                        if (GraphicalDataModelView.this.root != null && !initiallyVisibleTables.isEmpty()) {
                            Iterator items = GraphicalDataModelView.this.visualization.items(BooleanLiteral.TRUE);
                            int m_visibleCount = 0;
                            while (items.hasNext()) {
                                VisualItem item = (VisualItem)items.next();
                                if (item.canGetString("label")) {
                                    String tableName = item.getString("label");
                                    double[] pos = LayoutStorage.getPosition(GraphicalDataModelView.this.root.getName(), tableName);
                                    if (pos != null) {
                                        item.setX(pos[0]);
                                        item.setY(pos[1]);
                                        item.setEndX(pos[0]);
                                        item.setEndY(pos[1]);
                                        item.setFixed(pos[2] == 1.0);
                                    }
                                }
                                ++m_visibleCount;
                            }
                        }
                    }
                    GraphicalDataModelView.this.layout.reset();
                    GraphicalDataModelView.this.visualization.invalidateAll();
                    this.done = true;
                    GraphicalDataModelView.this.layoutHasBeenSet = true;
                }
            }
        };
        a.alwaysRunAfter(this.layout);
        animate.add(a);
        animate.add(new Action(){
            long startTime = System.currentTimeMillis();
            boolean done = false;

            @Override
            public void run(double frac) {
                if (!this.done && System.currentTimeMillis() > this.startTime + 30L) {
                    GraphicalDataModelView.this.display.pan(1.0, 1.0);
                    GraphicalDataModelView.this.display.pan(-1.0, -1.0);
                    this.done = true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLayout() {
        if (this.root != null && this.layoutHasBeenSet) {
            Visualization visualization = this.visualization;
            synchronized (visualization) {
                LayoutStorage.removeAll(this.root.getName());
                Iterator items = this.visualization.items(BooleanLiteral.TRUE);
                int m_visibleCount = 0;
                while (items.hasNext()) {
                    String tableName;
                    VisualItem item = (VisualItem)items.next();
                    if (item.canGetString("label") && (tableName = item.getString("label")) != null) {
                        LayoutStorage.setPosition(this.root.getName(), tableName, new double[]{item.getX(), item.getY(), item.isFixed() ? 1.0 : 0.0});
                    }
                    ++m_visibleCount;
                }
                LayoutStorage.checkSignificance(this.root.getName());
            }
        }
    }

    public JPopupMenu createPopupMenu(final Table table, boolean withNavigation) {
        JScrollPopupMenu popup = new JScrollPopupMenu();
        JScrollMenu navigateTo = null;
        if (withNavigation) {
            navigateTo = new JScrollMenu("Show Associated Table");
            ArrayList<Association> aList = new ArrayList<Association>();
            HashSet<Table> includedTables = new HashSet<Table>();
            for (Association a : table.associations) {
                if (!this.isVisualizable(a) || includedTables.contains(a.destination)) continue;
                aList.add(a);
                includedTables.add(a.destination);
            }
            Collections.sort(aList, new Comparator<Association>(){

                @Override
                public int compare(Association o1, Association o2) {
                    return o1.getDataModel().getDisplayName(o1.destination).compareTo(o2.getDataModel().getDisplayName(o2.destination));
                }
            });
            navigateTo.setEnabled(false);
            JScrollMenu currentMenu = navigateTo;
            for (final Association a : aList) {
                String miText = a.getDataModel().getDisplayName(a.destination);
                JMenuItem mi = new JMenuItem();
                int MAX_LENGTH = 50;
                if (miText.length() < 50) {
                    mi.setText(miText);
                } else {
                    mi.setText(miText.substring(0, 50) + "...");
                    mi.setToolTipText(miText);
                }
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GraphicalDataModelView.this.modelEditor.select(a);
                    }
                });
                if (this.renderedAssociations.containsKey(a) || this.renderedAssociations.containsKey(a.reversalAssociation)) {
                    mi.setEnabled(false);
                } else {
                    navigateTo.setEnabled(true);
                }
                ((JMenu)currentMenu).add(mi);
            }
        }
        JMenuItem selectAsRoot = new JMenuItem("Focus " + table.getName());
        selectAsRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.modelEditor.setRootSelection(table);
            }
        });
        JMenuItem dataBrowser = new JMenuItem("Browse Data");
        dataBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.modelEditor.extractionModelFrame.openDataBrowser(table, "");
            }
        });
        JMenuItem showReachability = new JMenuItem("Show Reachability");
        showReachability.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.modelEditor.showReachability(table);
            }
        });
        JMenuItem zoomToFit = new JMenuItem("Zoom To Fit");
        zoomToFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.zoomToFit();
            }
        });
        JMenuItem hide = new JMenuItem("Hide " + table.getName());
        hide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.hideTable(table);
                GraphicalDataModelView.this.display.invalidate();
            }
        });
        if (table.equals(this.root)) {
            hide.setEnabled(false);
        }
        JMenuItem toggleDetails = new JMenuItem(this.showDetails(table) ? "Hide Details" : "Show Details");
        toggleDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphicalDataModelView.this.reversedShowDetailsTables.contains(table)) {
                    GraphicalDataModelView.this.reversedShowDetailsTables.remove(table);
                } else {
                    GraphicalDataModelView.this.reversedShowDetailsTables.add(table);
                }
                GraphicalDataModelView.this.visualization.invalidateAll();
                GraphicalDataModelView.this.display.invalidate();
            }
        });
        JMenuItem mapColumns = new JMenuItem("XML Column Mapping");
        mapColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.modelEditor.openColumnMapper(table);
            }
        });
        mapColumns.setEnabled(ScriptFormat.XML.equals((Object)this.modelEditor.scriptFormat));
        JMenuItem restrictAll = new JMenuItem("Disable Associations");
        restrictAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 == JOptionPane.showConfirmDialog(GraphicalDataModelView.this.modelEditor.extractionModelFrame, "Disable each association with '" + GraphicalDataModelView.this.model.getDisplayName(table) + "'?\n(except dependencies)?", "Add restrictions", 0, 3)) {
                    GraphicalDataModelView.this.modelEditor.ignoreAll(table);
                }
            }
        });
        restrictAll.setEnabled(this.modelEditor.isIgnoreAllApplicable(table));
        JMenuItem removeRestrictions = new JMenuItem("Remove Restrictions");
        removeRestrictions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0 == JOptionPane.showConfirmDialog(GraphicalDataModelView.this.modelEditor.extractionModelFrame, "Remove all restrictions from associations with '" + GraphicalDataModelView.this.model.getDisplayName(table) + "'?", "Remove restrictions", 0, 3)) {
                    GraphicalDataModelView.this.modelEditor.removeAllRestrictions(table);
                }
            }
        });
        JMenuItem htmlRender = new JMenuItem("Open HTML Render");
        htmlRender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.modelEditor.extractionModelFrame.openHTMLRender(table);
            }
        });
        JMenuItem queryBuilder = new JMenuItem("Query Builder");
        queryBuilder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.openQueryBuilder(table, false);
            }
        });
        removeRestrictions.setEnabled(this.modelEditor.isRemovalOfAllRestrictionsApplicable(table));
        JMenuItem findTable = new JMenuItem("Browse Closure");
        findTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.modelEditor.extractionModelFrame.openClosureView(table);
            }
        });
        JMenuItem filterEditor = new JMenuItem("Edit Filters...");
        filterEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.modelEditor.extractionModelFrame.openFilterEditor(table);
            }
        });
        popup.add(toggleDetails);
        popup.add(new JSeparator());
        popup.add(hide);
        popup.add(selectAsRoot);
        if (navigateTo != null) {
            popup.add(navigateTo);
        }
        popup.add(dataBrowser);
        popup.add(findTable);
        popup.add(showReachability);
        popup.add(new JSeparator());
        popup.add(restrictAll);
        popup.add(removeRestrictions);
        popup.add(filterEditor);
        popup.add(mapColumns);
        popup.add(new JSeparator());
        popup.add(zoomToFit);
        popup.add(new JSeparator());
        popup.add(queryBuilder);
        popup.add(htmlRender);
        popup.add(new JSeparator());
        JMenu insertModeMenu = new JMenu("Export Mode");
        popup.add(insertModeMenu);
        JRadioButtonMenuItem insert = new JRadioButtonMenuItem("Insert");
        insert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Boolean.FALSE.equals(table.upsert)) {
                    table.upsert = false;
                    GraphicalDataModelView.this.visualization.invalidateAll();
                    GraphicalDataModelView.this.display.invalidate();
                    GraphicalDataModelView.this.modelEditor.markDirty();
                }
            }
        });
        insertModeMenu.add(insert);
        JRadioButtonMenuItem upsert = new JRadioButtonMenuItem("Upsert/Merge");
        insertModeMenu.add(upsert);
        upsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Boolean.TRUE.equals(table.upsert)) {
                    table.upsert = true;
                    GraphicalDataModelView.this.visualization.invalidateAll();
                    GraphicalDataModelView.this.display.invalidate();
                    GraphicalDataModelView.this.modelEditor.markDirty();
                }
            }
        });
        JRadioButtonMenuItem deflt = new JRadioButtonMenuItem("Data model default (" + (table.defaultUpsert ? "Upsert" : "Insert") + ")");
        insertModeMenu.add(deflt);
        deflt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (table.upsert != null) {
                    table.upsert = null;
                    GraphicalDataModelView.this.visualization.invalidateAll();
                    GraphicalDataModelView.this.display.invalidate();
                    GraphicalDataModelView.this.modelEditor.markDirty();
                }
            }
        });
        ButtonGroup bt = new ButtonGroup();
        bt.add(insert);
        bt.add(upsert);
        bt.add(deflt);
        if (table.upsert == null) {
            deflt.setSelected(true);
        }
        if (Boolean.TRUE.equals(table.upsert)) {
            upsert.setSelected(true);
        }
        if (Boolean.FALSE.equals(table.upsert)) {
            insert.setSelected(true);
        }
        return popup;
    }

    public JPopupMenu createPopupMenu(final Association association) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem disable = new JMenuItem("Disable Association");
        disable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.setRestriction(association, true);
            }
        });
        JMenuItem enable = new JMenuItem("Remove Restriction");
        enable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.setRestriction(association, false);
            }
        });
        JMenuItem zoomToFit = new JMenuItem("Zoom To Fit");
        zoomToFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalDataModelView.this.zoomToFit();
            }
        });
        disable.setEnabled(!association.isIgnored());
        enable.setEnabled(association.isRestricted());
        popup.add(disable);
        popup.add(enable);
        popup.add(new JSeparator());
        popup.add(zoomToFit);
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideTable(Table table) {
        Visualization visualization = this.visualization;
        synchronized (visualization) {
            this.collapseTable(this.theGraph, table, true);
        }
    }

    public void close(boolean storeLayout, boolean removeLayout) {
        if (storeLayout) {
            this.storeLayout();
        } else if (removeLayout && this.root != null) {
            LayoutStorage.removeAll(this.root.getName());
        }
        this.visualization.reset();
        this.layout.cancel();
    }

    public void zoomToFit() {
        this.zoomToFitControl.zoomToFit();
    }

    private void setGraph(Graph g) {
        this.inInitialization = true;
        this.visualization.removeGroup(graph);
        this.visualGraph = this.visualization.addGraph(graph, g);
        if (this.visualGraph.getNodeCount() > 1) {
            VisualItem f = (VisualItem)((Object)this.visualGraph.getNode(1));
            this.visualization.getGroup(Visualization.FOCUS_ITEMS).setTuple(f);
            f.setFixed(true);
            ((VisualItem)((Object)this.visualGraph.getNode(0))).setFixed(true);
        }
        this.inInitialization = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Association association) {
        Visualization visualization = this.visualization;
        synchronized (visualization) {
            if (!(this.selectedAssociation != null && association != null && this.selectedAssociation.equals(association) || this.selectedAssociation == null && association == null)) {
                Association newlySelectedAssociation = null;
                if (association != null && !this.renderedAssociations.containsKey(association) && !this.renderedAssociations.containsKey(association.reversalAssociation)) {
                    newlySelectedAssociation = association;
                }
                this.selectedAssociation = association;
                this.modelEditor.select(association);
                if (association != null) {
                    this.expandTable(this.theGraph, association.source, association);
                    this.expandTable(this.theGraph, association.destination, association);
                }
                this.tablesOnPath.clear();
                this.associationsOnPath.clear();
                if (this.selectedAssociation != null) {
                    List<Association> path = this.getPathToRoot(this.selectedAssociation.destination, true, newlySelectedAssociation);
                    if (path.isEmpty()) {
                        path = this.getPathToRoot(this.selectedAssociation.destination, false, newlySelectedAssociation);
                    }
                    boolean highlightPath = true;
                    if (path.isEmpty()) {
                        highlightPath = false;
                        path = this.modelEditor.getPathToRoot(this.selectedAssociation);
                    }
                    for (int i = 0; i < path.size(); ++i) {
                        if (highlightPath) {
                            this.associationsOnPath.add(path.get(i));
                            this.tablesOnPath.add(path.get((int)i).source.getName());
                            this.tablesOnPath.add(path.get((int)i).destination.getName());
                        }
                        this.expandTable(this.theGraph, path.get((int)i).source, path.get(i));
                        this.expandTable(this.theGraph, path.get((int)i).destination, path.get(i));
                    }
                }
                this.invalidate();
            }
        }
    }

    private List<Association> getPathToRoot(Table destination, boolean ignoreInvisibleAssociations, Association newlySelectedAssociation) {
        Table table;
        ArrayList<Association> path = new ArrayList<Association>();
        HashMap<Table, Table> successor = new HashMap<Table, Table>();
        HashMap<Table, Association> outgoingAssociation = new HashMap<Table, Association>();
        ArrayList<Table> agenda = new ArrayList<Table>();
        agenda.add(destination);
        block0: while (!agenda.isEmpty()) {
            table = (Table)agenda.remove(0);
            for (Association association : this.incomingAssociations(table, ignoreInvisibleAssociations, newlySelectedAssociation)) {
                if (ignoreInvisibleAssociations && !this.renderedAssociations.containsKey(association) && !this.renderedAssociations.containsKey(association.reversalAssociation) || successor.containsKey(association.source)) continue;
                successor.put(association.source, table);
                outgoingAssociation.put(association.source, association);
                agenda.add(association.source);
                if (!association.source.equals(this.root)) continue;
                agenda.clear();
                continue block0;
            }
        }
        if (successor.containsKey(this.root)) {
            table = this.root;
            while (!table.equals(destination)) {
                Association association = (Association)outgoingAssociation.get(table);
                path.add(association);
                table = (Table)successor.get(table);
            }
        }
        return path;
    }

    private Collection<Association> incomingAssociations(Table table, boolean ignoreInvisibleAssociations, Association newlySelectedAssociation) {
        ArrayList<Association> result = new ArrayList<Association>();
        for (Association association : table.associations) {
            if (association.reversalAssociation.getJoinCondition() == null && (ignoreInvisibleAssociations || association.reversalAssociation == newlySelectedAssociation || !this.renderedAssociations.containsKey(association) && !this.renderedAssociations.containsKey(association.reversalAssociation))) continue;
            result.add(association.reversalAssociation);
        }
        return result;
    }

    private Graph getModelGraph(DataModel model, Set<Table> initiallyVisibleTables, boolean expandSubject) {
        this.tableNodes = new HashMap<Table, Node>();
        this.expandedTables = new HashSet<Table>();
        this.renderedAssociations = new HashMap<Association, Edge>();
        Graph g = new Graph(true);
        Schema s = new Schema();
        s.addColumn("label", String.class);
        s.addColumn("tooltip", String.class);
        s.addColumn("association", Association.class);
        s.addColumn("full", Boolean.class);
        g.addColumns(s);
        Node zoomBox = g.addNode();
        zoomBox.setString("label", "$ZOOMBOX");
        Table table = this.root;
        this.showTable(g, table);
        if (table != null) {
            if (!this.modelEditor.extractionModelFrame.showDisabledAssociations()) {
                initiallyVisibleTables.retainAll(table.closure(true));
            } else {
                initiallyVisibleTables.retainAll(table.unrestrictedClosure(new HashSet<Table>()));
            }
        }
        for (Table t : initiallyVisibleTables) {
            this.showTable(g, t);
        }
        for (Table t : initiallyVisibleTables) {
            this.addEdges(g, t, null, new ArrayList<Table>(), true);
        }
        if (!initiallyVisibleTables.isEmpty()) {
            this.addEdges(g, table, null, new ArrayList<Table>(), true);
        }
        int nAssociatedTables = 0;
        if (table != null) {
            for (Association a : table.associations) {
                if (!this.isVisualizable(a)) continue;
                ++nAssociatedTables;
            }
        }
        if (initiallyVisibleTables.isEmpty() && nAssociatedTables <= 10 && expandSubject) {
            this.expandTable(g, table);
        }
        return g;
    }

    private boolean showTable(Graph graph, Table table) {
        if (table != null && !this.tableNodes.containsKey(table)) {
            Node n = graph.addNode();
            n.setString("label", table.getName());
            String tooltip = this.tableRenderer.getToolTip(table);
            n.setString("tooltip", tooltip);
            this.tableNodes.put(table, n);
            return true;
        }
        return false;
    }

    private void collapseTable(Graph g, Table table, boolean hideTable) {
        if (table == null || this.expandedTables.contains(table) || hideTable) {
            Tuple e;
            HashSet<Association> associationsToKeep = new HashSet<Association>();
            HashSet<Table> tablesToKeep = new HashSet<Table>();
            this.collect(this.root, table, associationsToKeep, tablesToKeep);
            if (hideTable && table != null) {
                for (Association a : table.associations) {
                    associationsToKeep.remove(a);
                    associationsToKeep.remove(a.reversalAssociation);
                }
            }
            for (Table t : this.model.getTables()) {
                for (Association a : t.associations) {
                    if (associationsToKeep.contains(a)) continue;
                    e = this.renderedAssociations.get(a);
                    if (e != null) {
                        g.removeEdge((Edge)e);
                    }
                    this.renderedAssociations.remove(a);
                }
            }
            for (Table t : this.model.getTables()) {
                for (Association a : t.associations) {
                    if (associationsToKeep.contains(a)) continue;
                    e = this.renderedAssociationsAsNode.get(a);
                    if (e != null) {
                        g.removeNode((Node)e);
                    }
                    this.renderedAssociationsAsNode.remove(a);
                }
            }
            for (Table t : this.model.getTables()) {
                if (t == table && !hideTable || tablesToKeep.contains(t)) continue;
                Node n = this.tableNodes.get(t);
                if (n != null) {
                    g.removeNode(n);
                }
                this.tableNodes.remove(t);
                for (Association a : t.associations) {
                    this.expandedTables.remove(a.source);
                    this.expandedTables.remove(a.destination);
                }
            }
            if (table != null) {
                this.expandedTables.remove(table);
                if (!hideTable) {
                    tablesToKeep.add(table);
                }
            }
            this.checkForExpansion(this.theGraph, tablesToKeep);
        }
    }

    private void collect(Table root, Table ignore, Set<Association> associationsToKeep, Set<Table> tablesToKeep) {
        if (root != ignore && !tablesToKeep.contains(root)) {
            tablesToKeep.add(root);
            for (Association a : root.associations) {
                if (!this.isVisualizable(a) || !this.renderedAssociations.containsKey(a) && !this.renderedAssociations.containsKey(a.reversalAssociation)) continue;
                associationsToKeep.add(a);
                associationsToKeep.add(a.reversalAssociation);
                this.collect(a.destination, ignore, associationsToKeep, tablesToKeep);
                this.collect(a.source, ignore, associationsToKeep, tablesToKeep);
            }
        }
    }

    private List<Table> expandTable(Graph g, Table table) {
        return this.expandTable(g, table, null);
    }

    private List<Table> expandTable(Graph g, Table table, Association toRender) {
        List<Table> result = new ArrayList<Table>();
        if (!(table == null || this.expandedTables.contains(table) && toRender == null)) {
            ArrayList<Table> toCheck = new ArrayList<Table>();
            result = this.addEdges(g, table, toRender, toCheck, false);
            this.checkForExpansion(g, toCheck);
        }
        return result;
    }

    private void checkForExpansion(Graph g, Collection<Table> toCheck) {
        for (Table t : toCheck) {
            if (this.expandedTables.contains(t)) continue;
            this.addEdges(g, t, null, new ArrayList<Table>(), true);
            boolean isExpanded = true;
            for (Association a : t.associations) {
                if (!this.isVisualizable(a)) continue;
                if (a.source != t && !this.tableNodes.containsKey(a.source) && !toCheck.contains(a.source)) {
                    isExpanded = false;
                    break;
                }
                if (a.destination == t || this.tableNodes.containsKey(a.destination) || toCheck.contains(a.destination)) continue;
                isExpanded = false;
                break;
            }
            if (!isExpanded) continue;
            this.expandedTables.add(t);
        }
    }

    private void checkForCollapsed(Graph g, Collection<Table> toCheck) {
        for (Table t : toCheck) {
            if (!this.expandedTables.contains(t)) continue;
            boolean isExpanded = true;
            for (Association a : t.associations) {
                if (!this.isVisualizable(a) || this.renderedAssociations.containsKey(a) || this.renderedAssociations.containsKey(a.reversalAssociation)) continue;
                isExpanded = false;
                break;
            }
            if (isExpanded) continue;
            this.expandedTables.remove(t);
        }
    }

    private List<Table> addEdges(Graph g, Table table, Association toRender, List<Table> toCheck, boolean visibleDestinationRequired) {
        ArrayList<Table> result = new ArrayList<Table>();
        toCheck.add(table);
        for (Association a : table.associations) {
            if (toRender != null && toRender != a || !this.isVisualizable(a) && (toRender == null || a != toRender) || visibleDestinationRequired && !this.tableNodes.containsKey(a.destination) || this.renderedAssociations.containsKey(a) || this.renderedAssociations.containsKey(a.reversalAssociation)) continue;
            toCheck.add(a.destination);
            toCheck.add(a.source);
            if (this.showTable(g, a.source)) {
                result.add(a.source);
            }
            if (this.showTable(g, a.destination)) {
                result.add(a.destination);
            }
            String tooltip = a.getJoinCondition();
            if (!this.associationIsUnique(a)) {
                Node an = g.addNode();
                an.set("association", (Object)a);
                an.setString("label", a.getName() + "#");
                an.setString("tooltip", tooltip);
                this.renderedAssociationsAsNode.put(a, an);
                Edge ae = g.addEdge(an, this.tableNodes.get(a.source));
                ae.set("association", (Object)a.reversalAssociation);
                ae.set("full", (Object)Boolean.FALSE);
                ae.setString("tooltip", tooltip);
                this.renderedAssociations.put(a.reversalAssociation, ae);
                Edge be = g.addEdge(an, this.tableNodes.get(a.destination));
                be.set("association", (Object)a);
                be.set("full", (Object)Boolean.FALSE);
                be.setString("tooltip", tooltip);
                this.renderedAssociations.put(a, be);
                continue;
            }
            Edge e = g.addEdge(this.tableNodes.get(a.source), this.tableNodes.get(a.destination));
            e.set("association", (Object)a);
            e.set("full", (Object)Boolean.TRUE);
            e.setString("tooltip", tooltip);
            this.renderedAssociations.put(a, e);
        }
        return result;
    }

    private boolean associationIsUnique(Association a) {
        if (a.source == a.destination) {
            return false;
        }
        ArrayList<Association> all = new ArrayList<Association>();
        all.addAll(a.source.associations);
        all.addAll(a.destination.associations);
        for (Association b : all) {
            if (a == b || a == b.reversalAssociation) continue;
            if (a.destination == b.destination && a.source == b.source) {
                return false;
            }
            if (a.destination != b.source || a.source != b.destination) continue;
            return false;
        }
        return true;
    }

    private boolean isVisualizable(Association association) {
        return this.modelEditor.extractionModelFrame.showDisabledAssociations() || !association.isIgnored();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandAll(boolean expandOnlyVisibleTables, Table reachableTable) {
        HashSet<Table> onPath = new HashSet<Table>();
        if (reachableTable != null) {
            ArrayList<Table> toExpand = new ArrayList<Table>();
            toExpand.addAll(this.tableNodes.keySet());
            onPath.addAll(this.tableNodes.keySet());
            while (!toExpand.isEmpty()) {
                Table table = (Table)toExpand.remove(0);
                for (Association association : table.associations) {
                    if (association.isIgnored() || onPath.contains(association.destination) || !association.destination.closure(true).contains(reachableTable)) continue;
                    onPath.add(association.destination);
                    toExpand.add(association.destination);
                }
            }
            while (true) {
                HashSet<Table> toRemove = new HashSet<Table>();
                HashSet<Table> refTables = new HashSet<Table>();
                HashSet<Table> toIgnore = new HashSet<Table>();
                for (Table initTable : this.tableNodes.keySet()) {
                    toIgnore.addAll(initTable.closure(true));
                }
                toIgnore.removeAll(onPath);
                for (Table table : onPath) {
                    refTables.clear();
                    for (Association association : table.associations) {
                        if (association.destination.equals(table) || !onPath.contains(association.destination)) continue;
                        refTables.add(association.destination);
                    }
                    boolean isIn = toIgnore.contains(table);
                    toIgnore.add(table);
                    for (Table toCheck : refTables) {
                        if (toCheck.equals(reachableTable) || this.tableNodes.containsKey(toCheck)) continue;
                        boolean reach = toCheck.closure(toIgnore, true).contains(reachableTable);
                        if (!reach) {
                            this.model.transpose();
                            for (Table initTable : this.tableNodes.keySet()) {
                                reach = toCheck.closure(toIgnore, true).contains(initTable);
                                if (!reach) continue;
                                break;
                            }
                            this.model.transpose();
                        }
                        if (reach) continue;
                        toRemove.add(toCheck);
                    }
                    if (isIn) continue;
                    toIgnore.remove(table);
                }
                if (toRemove.isEmpty()) break;
                onPath.removeAll(toRemove);
                toIgnore.addAll(toRemove);
                toRemove.clear();
            }
        }
        boolean stop = false;
        ArrayList<Table> toExpand = new ArrayList<Table>();
        toExpand.addAll(this.tableNodes.keySet());
        while (!stop) {
            boolean askNow = false;
            Visualization visualization = this.visualization;
            synchronized (visualization) {
                boolean ask;
                boolean bl = ask = this.tableNodes.size() <= 50;
                while (!toExpand.isEmpty()) {
                    Table table;
                    table = (Table)toExpand.remove(0);
                    if (reachableTable != null) {
                        for (Association association : table.associations) {
                            if (!onPath.contains(association.destination) || this.tableNodes.containsKey(association.destination)) continue;
                            List<Table> tables = this.expandTable(this.theGraph, table, association);
                            if (expandOnlyVisibleTables) continue;
                            toExpand.addAll(tables);
                        }
                    } else {
                        List<Table> tables = this.expandTable(this.theGraph, table);
                        if (!expandOnlyVisibleTables) {
                            toExpand.addAll(tables);
                        }
                    }
                    if (!ask || this.tableNodes.size() <= 50) continue;
                    askNow = true;
                    break;
                }
            }
            if (askNow) {
                if (1 == JOptionPane.showConfirmDialog(this.modelEditor.extractionModelFrame, "More than 50 visible tables!\nStop expansion?", "", 0, 1)) continue;
                stop = true;
                continue;
            }
            stop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetExpandedState() {
        Visualization visualization = this.visualization;
        synchronized (visualization) {
            this.hideTable(null);
            this.checkForCollapsed(this.theGraph, this.tableNodes.keySet());
            this.checkForExpansion(this.theGraph, this.tableNodes.keySet());
            this.visualization.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFix(boolean fix) {
        Visualization visualization = this.visualization;
        synchronized (visualization) {
            for (int i = this.visualGraph.getNodeCount() - 1; i >= 0; --i) {
                VisualItem n = (VisualItem)((Object)this.visualGraph.getNode(i));
                n.setFixed(fix);
            }
        }
    }

    public boolean showDetails(Table table) {
        if (this.reversedShowDetailsTables.contains(table)) {
            return !this.showTableDetails;
        }
        return this.showTableDetails;
    }

    public void updateTableDetailsMode() {
        this.showTableDetails = this.modelEditor.extractionModelFrame.showTableDetails();
        this.reversedShowDetailsTables.clear();
        this.visualization.invalidateAll();
        this.visualization.repaint();
    }

    public Set<Table> getVisibleTables() {
        return this.tableNodes.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDisplayToImage() throws Exception {
        GraphicalDataModelView graphicalDataModelView;
        Association oldAssociation = this.selectedAssociation;
        Set<String> oldTablesOnPath = this.tablesOnPath;
        try {
            graphicalDataModelView = this;
            synchronized (graphicalDataModelView) {
                this.selectedAssociation = null;
                this.tablesOnPath = new HashSet<String>();
                this.inImageExport = true;
            }
            displayExporter.export(this.display);
        }
        finally {
            graphicalDataModelView = this;
            synchronized (graphicalDataModelView) {
                this.inImageExport = false;
                this.selectedAssociation = oldAssociation;
                this.tablesOnPath = oldTablesOnPath;
            }
        }
    }

    public void openQueryBuilder(Table table, boolean usePath) {
        new QueryBuilderDialog(this.modelEditor.extractionModelFrame).buildQuery(table, usePath, true, this.associationsOnPath, null, this.model);
    }

    public boolean isTableVisible(Table table) {
        return this.tableNodes.containsKey(table);
    }

    public void selectTable(Table table) {
        Association toS = null;
        for (Association a : table.associations) {
            if (!this.renderedAssociations.containsKey(a) && !this.renderedAssociations.containsKey(a.reversalAssociation)) continue;
            toS = a.reversalAssociation;
            break;
        }
        if (toS == null) {
            this.modelEditor.select(table);
        } else {
            this.modelEditor.select(toS);
        }
        Association sa = this.selectedAssociation;
        this.setSelection(null);
        this.setSelection(sa);
    }

    public void setRestriction(Association association, boolean ignore) {
        this.setSelection(association);
        this.modelEditor.restrictionEditor.ignore.setSelected(ignore);
        this.modelEditor.onApply(false);
    }

    private final class CompositeAssociationRenderer
    implements Renderer {
        private AssociationRenderer associationRenderer = new AssociationRenderer(false);
        private AssociationRenderer reversedAssociationRenderer = new AssociationRenderer(true);
        private AssociationRenderer associationFullRenderer = new AssociationRenderer();
        public boolean useAssociationRendererForLocation = false;

        private CompositeAssociationRenderer() {
        }

        public boolean locatePointWithAssociationRenderer(Point2D p, VisualItem item) {
            return this.associationRenderer.locatePoint(p, item);
        }

        @Override
        public boolean locatePoint(Point2D p, VisualItem item) {
            if (this.useAssociationRendererForLocation) {
                return this.locatePointWithAssociationRenderer(p, item);
            }
            return this.associationFullRenderer.locatePoint(p, item);
        }

        @Override
        public void render(Graphics2D g, VisualItem item) {
            item.setInteractive(true);
            boolean isSelected = GraphicalDataModelView.this.selectedAssociation != null && GraphicalDataModelView.this.selectedAssociation.equals(item.get("association"));
            boolean isReversedSelected = GraphicalDataModelView.this.selectedAssociation != null && GraphicalDataModelView.this.selectedAssociation.reversalAssociation.equals(item.get("association"));
            this.associationFullRenderer.render(g, item, isSelected);
            this.associationRenderer.render(g, item, isSelected);
            this.reversedAssociationRenderer.render(g, item, isReversedSelected);
        }

        @Override
        public void setBounds(VisualItem item) {
            this.associationFullRenderer.setBounds(item);
        }
    }

    private final class ZoomToFitControlExtension
    extends ZoomToFitControl {
        private final DataModel model;
        private final long duration;

        private ZoomToFitControlExtension(String group, int margin, long duration, int button, DataModel model) {
            super(group, margin, duration, button);
            this.duration = duration;
            this.model = model;
        }

        @Override
        public void itemClicked(VisualItem item, MouseEvent e) {
            if (this.model.getTable(item.getString("label")) != null || item.get("association") != null) {
                return;
            }
            super.itemClicked(item, e);
        }

        public void zoomToFit() {
            Visualization vis = GraphicalDataModelView.this.display.getVisualization();
            Rectangle2D bounds = vis.getBounds(Visualization.ALL_ITEMS);
            GraphicsLib.expand(bounds, 50 + (int)(1.0 / GraphicalDataModelView.this.display.getScale()));
            DisplayLib.fitViewToBounds(GraphicalDataModelView.this.display, bounds, this.duration);
        }
    }
}

