/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.graphical_view;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.util.GraphicsLib;
import prefuse.util.io.IOLib;
import prefuse.util.io.SimpleFileFilter;

public class DisplayExporter {
    protected JFileChooser chooser = null;

    protected void init() {
        this.chooser = new JFileChooser();
        this.chooser.setDialogType(1);
        this.chooser.setDialogTitle("Export graph as image");
        this.chooser.setAcceptAllFileFilterUsed(false);
        HashSet<String> availableFormats = new HashSet<String>();
        String[] fmts = ImageIO.getWriterFormatNames();
        for (int i = 0; i < fmts.length; ++i) {
            String s = fmts[i].toLowerCase();
            if (s.length() != 3 || availableFormats.contains(s)) continue;
            availableFormats.add(s);
            this.chooser.setFileFilter(new SimpleFileFilter(s, s.toUpperCase() + " Image (*." + s + ")"));
        }
        availableFormats.clear();
        availableFormats = null;
    }

    public void export(Display display) throws Exception {
        if (this.chooser == null) {
            this.init();
        }
        File f = null;
        int returnVal = this.chooser.showSaveDialog(display);
        if (returnVal != 0) {
            return;
        }
        f = this.chooser.getSelectedFile();
        String format = ((SimpleFileFilter)this.chooser.getFileFilter()).getExtension();
        String ext = IOLib.getExtension(f);
        if (!format.equals(ext)) {
            f = new File(f.toString() + "." + format);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        this.exportImage(display, out, format);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exportImage(Display display, OutputStream output, String format) throws Exception {
        String m_group = Visualization.ALL_ITEMS;
        try {
            display.setCursor(Cursor.getPredefinedCursor(3));
            Rectangle2D bounds = display.getVisualization().getBounds(m_group);
            GraphicsLib.expand(bounds, 11.0);
            BufferedImage img = this.getNewOffscreenBuffer(display, (int)(bounds.getWidth() * display.getScale()), (int)(bounds.getHeight() * display.getScale()));
            Graphics2D g = (Graphics2D)img.getGraphics();
            Double scale = display.getScale();
            boolean isHighQuality = display.isHighQuality();
            display.setHighQuality(true);
            Point2D.Double currentPoint = new Point2D.Double(display.getDisplayX(), display.getDisplayY());
            display.panToAbs(new Point2D.Double(bounds.getMinX() + (double)display.getWidth() / scale / 2.0, bounds.getMinY() + (double)display.getHeight() / scale / 2.0));
            display.paintDisplay(g, new Dimension((int)(bounds.getWidth() * scale), (int)(bounds.getHeight() * scale)));
            display.panToAbs(new Point2D.Double((((Point2D)currentPoint).getX() + (double)(display.getWidth() / 2)) / scale, (((Point2D)currentPoint).getY() + (double)(display.getHeight() / 2)) / scale));
            display.setHighQuality(isHighQuality);
            ImageIO.write((RenderedImage)img, format, output);
            boolean bl = true;
            return bl;
        }
        finally {
            display.setCursor(Cursor.getDefaultCursor());
        }
    }

    private BufferedImage getNewOffscreenBuffer(Display display, int width, int height) {
        BufferedImage img = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                img = (BufferedImage)display.createImage(width, height);
            }
            catch (Exception e) {
                img = null;
            }
        }
        if (img == null) {
            return new BufferedImage(width, height, 1);
        }
        return img;
    }
}

