/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.graphical_view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import prefuse.render.EdgeRenderer;
import prefuse.util.GraphicsLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class AssociationRenderer
extends EdgeRenderer {
    public static Color COLOR_IGNORED;
    public static Color COLOR_ASSOCIATION;
    public static Color COLOR_DEPENDENCY;
    public static Color COLOR_REVERSE_DEPENDENCY;
    boolean reversed;
    boolean full = false;
    private Point2D[] m_isctPoints2 = new Point2D[2];
    private Point2D starPosition = null;
    private boolean arrowIsPotAggregation = false;
    private AffineTransform transform = new AffineTransform();
    private Rectangle2D starBounds = null;
    private Image starImage = null;
    private double starWidth = 0.0;
    private double starHeight = 0.0;
    private final double STAR_SIZE = 0.22;

    public AssociationRenderer(boolean reversed) {
        super(0, reversed ? 2 : 1);
        try {
            String dir = "/net/sf/jailer/resource";
            this.starImage = new ImageIcon(this.getClass().getResource(dir + "/star.png")).getImage();
            this.starWidth = this.starImage.getWidth(null);
            this.starHeight = this.starImage.getHeight(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reversed = reversed;
    }

    public AssociationRenderer() {
        try {
            String dir = "/net/sf/jailer/resource";
            this.starImage = new ImageIcon(this.getClass().getResource(dir + "/star.png")).getImage();
            this.starWidth = this.starImage.getWidth(null);
            this.starHeight = this.starImage.getHeight(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.full = true;
    }

    @Override
    protected Shape getRawShape(VisualItem item) {
        EdgeItem edge = (EdgeItem)item;
        NodeItem item1 = edge.getSourceItem();
        NodeItem item2 = edge.getTargetItem();
        int type = this.m_edgeType;
        boolean reversedCurve = false;
        Association association = (Association)item.get("association");
        if (association != null && association.source == association.destination) {
            type = 1;
            reversedCurve = association.reversed;
        }
        AssociationRenderer.getAlignedPoint(this.m_tmpPoints[0], item1.getBounds(), this.m_xAlign1, this.m_yAlign1);
        AssociationRenderer.getAlignedPoint(this.m_tmpPoints[1], item2.getBounds(), this.m_xAlign2, this.m_yAlign2);
        this.m_curWidth = (float)(this.m_width * this.getLineWidth(item));
        EdgeItem e = (EdgeItem)item;
        boolean forward = this.m_edgeArrow == 1;
        Point2D start = null;
        Point2D end = null;
        start = this.m_tmpPoints[forward ? 0 : 1];
        end = this.m_tmpPoints[forward ? 1 : 0];
        if (!this.full) {
            NodeItem src;
            Point2D sp = start;
            Point2D ep = end;
            NodeItem dest = forward ? e.getTargetItem() : e.getSourceItem();
            int i = GraphicsLib.intersectLineRectangle(start, end, dest.getBounds(), this.m_isctPoints);
            if (i > 0) {
                ep = this.m_isctPoints[0];
            }
            if ((i = GraphicsLib.intersectLineRectangle(start, end, (src = !forward ? e.getTargetItem() : e.getSourceItem()).getBounds(), this.m_isctPoints2)) > 0) {
                sp = this.m_isctPoints2[0];
            }
            double midX = (sp.getX() + ep.getX()) / 2.0;
            double midY = (sp.getY() + ep.getY()) / 2.0;
            this.m_tmpPoints[this.reversed ? 1 : 0].setLocation(midX, midY);
        }
        if (e.isDirected() && this.m_edgeArrow != 0) {
            NodeItem dest;
            int i;
            if (type == 1) {
                AffineTransform t = new AffineTransform();
                t.setToRotation(0.7853981633974483 * (double)(reversedCurve ? 1 : -1));
                Point2D.Double p = new Point2D.Double();
                Point2D.Double shift = new Point2D.Double();
                double d = start.distance(end) / 5.0;
                ((Point2D)p).setLocation((end.getX() - start.getX()) / d, (end.getY() - start.getY()) / d);
                t.transform(p, shift);
                start.setLocation(start.getX() + ((Point2D)shift).getX(), start.getY() + ((Point2D)shift).getY());
                end.setLocation(end.getX() + ((Point2D)shift).getX(), end.getY() + ((Point2D)shift).getY());
            }
            if ((i = GraphicsLib.intersectLineRectangle(start, end, (dest = forward ? e.getTargetItem() : e.getSourceItem()).getBounds(), this.m_isctPoints)) > 0) {
                end = this.m_isctPoints[0];
            }
            AffineTransform at = this.getArrowTrans(start, end, this.m_curWidth);
            this.m_curArrow = at.createTransformedShape(this.m_arrowHead);
            if (!(type != 1 || "XML".equals(association.getDataModel().getExportModus()) && this.isAggregation(association))) {
                this.m_curArrow = null;
            }
            Point2D lineEnd = this.m_tmpPoints[forward ? 1 : 0];
            lineEnd.setLocation(0.0, type == 1 ? 0.0 : (double)(-this.m_arrowHeight));
            at.transform(lineEnd, lineEnd);
        } else {
            this.m_curArrow = null;
        }
        Line2D shape = null;
        double n1x = this.m_tmpPoints[0].getX();
        double n1y = this.m_tmpPoints[0].getY();
        double n2x = this.m_tmpPoints[1].getX();
        double n2y = this.m_tmpPoints[1].getY();
        this.m_line.setLine(n1x, n1y, n2x, n2y);
        shape = this.m_line;
        this.starBounds = null;
        this.starPosition = null;
        if (!forward && (Cardinality.MANY_TO_MANY.equals((Object)association.getCardinality()) || Cardinality.MANY_TO_ONE.equals((Object)association.getCardinality())) || forward && (Cardinality.MANY_TO_MANY.equals((Object)association.getCardinality()) || Cardinality.ONE_TO_MANY.equals((Object)association.getCardinality()))) {
            start = this.starPosition = this.m_tmpPoints[forward ? 1 : 0];
            end = this.m_tmpPoints[forward ? 0 : 1];
            AffineTransform t = new AffineTransform();
            t.setToRotation(-1.0471975511965976);
            Point2D.Double p = new Point2D.Double();
            Point2D.Double shift = new Point2D.Double();
            double d = this.m_tmpPoints[0].distance(this.m_tmpPoints[1]) / 9.0;
            ((Point2D)p).setLocation((end.getX() - start.getX()) / d, (end.getY() - start.getY()) / d);
            t.transform(p, shift);
            this.starPosition.setLocation(this.starPosition.getX() + ((Point2D)shift).getX(), this.starPosition.getY() + ((Point2D)shift).getY());
            this.starBounds = new Rectangle2D.Double(this.starPosition.getX() - 0.22 * (this.starWidth / 2.0), this.starPosition.getY() - 0.22 * (this.starHeight / 2.0), this.starWidth * 0.22, this.starHeight * 0.22);
        }
        return shape;
    }

    @Override
    protected AffineTransform getArrowTrans(Point2D p1, Point2D p2, double width) {
        this.m_arrowTrans.setToTranslation(p2.getX(), p2.getY());
        this.m_arrowTrans.rotate(-1.5707963267948966 + Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX()));
        if (width > 1.0) {
            double scalar = width / 2.0;
            this.m_arrowTrans.scale(scalar, scalar);
        }
        return this.m_arrowTrans;
    }

    public void render(Graphics2D g, VisualItem item, boolean isSelected) {
        int color;
        Association association = (Association)item.get("association");
        item.setSize(isSelected ? 3.0 : 1.0);
        if (!Boolean.TRUE.equals(item.get("full"))) {
            if (!this.full) {
                return;
            }
            color = this.associationColor(association);
        } else {
            if (this.full) {
                return;
            }
            color = this.reversed ? this.associationColor(association.reversalAssociation) : this.associationColor(association);
        }
        item.setFillColor(color);
        item.setStrokeColor(color);
        BasicStroke stroke = item.getStroke();
        if (stroke != null) {
            if (this.reversed && association != null) {
                association = association.reversalAssociation;
            }
            if (association != null && association.isRestricted() && !association.isIgnored()) {
                item.setStroke(new BasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), new float[]{8.0f, 6.0f}, 1.0f));
            } else {
                item.setStroke(new BasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit()));
            }
        }
        if ("XML".equals(association.getDataModel().getExportModus())) {
            this.m_arrowHead = this.updateArrowHead(this.m_arrowWidth, this.m_arrowHeight, association, isSelected);
            this.arrowIsPotAggregation = true;
        } else {
            if (this.arrowIsPotAggregation) {
                this.m_arrowHead = this.updateArrowHead(this.m_arrowWidth, this.m_arrowHeight);
            }
            this.arrowIsPotAggregation = false;
        }
        this.starPosition = null;
        this.render(g, item);
        if (this.starPosition != null && this.starImage != null) {
            double size = 0.22;
            this.transform.setTransform(size, 0.0, 0.0, size, this.starPosition.getX() - size * (this.starWidth / 2.0), this.starPosition.getY() - size * (this.starHeight / 2.0));
            g.drawImage(this.starImage, this.transform, null);
            this.starPosition = null;
        }
    }

    @Override
    public void setBounds(VisualItem item) {
        super.setBounds(item);
        if (this.starBounds != null) {
            Rectangle2D bbox = (Rectangle2D)item.get(VisualItem.BOUNDS);
            Rectangle2D.union(bbox, this.starBounds, bbox);
        }
    }

    private int associationColor(Association association) {
        if (association.isIgnored()) {
            return COLOR_IGNORED.getRGB();
        }
        if (association.isInsertDestinationBeforeSource()) {
            return COLOR_DEPENDENCY.getRGB();
        }
        if (association.isInsertSourceBeforeDestination()) {
            return COLOR_REVERSE_DEPENDENCY.getRGB();
        }
        return COLOR_ASSOCIATION.getRGB();
    }

    @Override
    public boolean locatePoint(Point2D p, VisualItem item) {
        Shape s = this.getShape(item);
        if (s == null) {
            return false;
        }
        double width = Math.max(14.0, this.getLineWidth(item));
        double halfWidth = width / 2.0;
        return s.intersects(p.getX() - halfWidth, p.getY() - halfWidth, width, width);
    }

    protected Polygon updateArrowHead(int w, int h, Association association, boolean isSelected) {
        if (this.isAggregation(association)) {
            if (this.m_arrowHead == null) {
                this.m_arrowHead = new Polygon();
            } else {
                this.m_arrowHead.reset();
            }
            double ws = 0.9;
            double hs = 0.6666666666666666;
            if (isSelected) {
                ws /= 1.3;
                hs /= 1.3;
            }
            this.m_arrowHead.addPoint(0, 0);
            this.m_arrowHead.addPoint((int)(ws * (double)(-w)), (int)(hs * (double)(-h)));
            this.m_arrowHead.addPoint(0, (int)(hs * (double)(-2 * h)));
            this.m_arrowHead.addPoint((int)(ws * (double)w), (int)(hs * (double)(-h)));
            this.m_arrowHead.addPoint(0, 0);
            return this.m_arrowHead;
        }
        return this.updateArrowHead(w, h);
    }

    private boolean isAggregation(Association association) {
        return association.reversalAssociation.getAggregationSchema() != AggregationSchema.NONE;
    }
}

