/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class TreeLayoutOptimizer<T> {
    private static long MAX_OPTIM_TIME_MS = 1000L;

    public static <T> void optimizeTreeLayout(Node<T> root) {
        int numNodes = root.getNodesCount();
        TreeLayoutOptimizer.optimizeChildrenOrder(root, System.currentTimeMillis(), MAX_OPTIM_TIME_MS, numNodes);
        TreeLayoutOptimizer.layoutTree(root, numNodes);
        TreeLayoutOptimizer.optimizeLeafs(root);
    }

    private static <T> double layoutTree(Node<T> root, int numNodes) {
        double[] maxPositionPerLevel = new double[root.getDepth()];
        for (int i = 0; i < maxPositionPerLevel.length; ++i) {
            maxPositionPerLevel[i] = -1.0;
        }
        root.position = 0.0;
        TreeLayoutOptimizer.layoutNode(root, maxPositionPerLevel);
        double sumMaxPositionSqr = 0.0;
        for (int i = 0; i < maxPositionPerLevel.length; ++i) {
            if (!(maxPositionPerLevel[i] > 0.0)) continue;
            sumMaxPositionSqr += maxPositionPerLevel[i] * maxPositionPerLevel[i];
        }
        return sumMaxPositionSqr / (double)numNodes + root.getCompactness();
    }

    private static <T> void layoutNode(Node<T> node, double[] maxPositionPerLevel) {
        for (Node child : ((Node)node).children) {
            maxPositionPerLevel[child.level] = child.position = Math.max(node.position - (double)(((Node)node).children.size() - 1) / 2.0, maxPositionPerLevel[child.level] + 1.0);
            TreeLayoutOptimizer.adjustParentPosition(node, maxPositionPerLevel);
            TreeLayoutOptimizer.layoutNode(child, maxPositionPerLevel);
        }
    }

    private static <T> void adjustParentPosition(Node<T> node, double[] maxPositionPerLevel) {
        double parentPos;
        while (node != null && node.position < (parentPos = ((Node)((Node)node).children.get((int)0)).position + (maxPositionPerLevel[node.level + 1] - ((Node)((Node)node).children.get((int)0)).position) / 2.0)) {
            node.position = parentPos;
            maxPositionPerLevel[node.level] = parentPos;
            node = node.parent;
        }
    }

    private static <T> void optimizeLeafs(Node<T> node) {
        int i;
        if (((Node)node).children.isEmpty() && node.parent != null && node.position < node.parent.position && (i = node.parent.children.indexOf(node)) >= 0 && i < node.parent.children.size() - 1) {
            Node brother = (Node)node.parent.children.get(i + 1);
            node.position = Math.min(node.parent.position, brother.position - 1.0);
        }
        for (i = ((Node)node).children.size() - 1; i >= 0; --i) {
            TreeLayoutOptimizer.optimizeLeafs((Node)((Node)node).children.get(i));
        }
    }

    private static <T> void optimizeChildrenOrder(Node<T> root, long startTime, long maxTime, int numNodes) {
        Stack<Node> toVisit = new Stack<Node>();
        toVisit.push(root);
        ArrayList<1> modifications = new ArrayList<1>();
        while (!toVisit.isEmpty()) {
            final Node node = (Node)toVisit.pop();
            for (Node child : node.children) {
                toVisit.push(child);
            }
            for (int i = 0; i < node.children.size(); ++i) {
                int j = i + 1;
                while (j < node.children.size()) {
                    final int a = i;
                    final int b = j++;
                    modifications.add(new Modification(){

                        @Override
                        public void doIt() {
                            Node h = (Node)node.children.get(a);
                            node.children.set(a, node.children.get(b));
                            node.children.set(b, h);
                        }

                        @Override
                        public void undoIt() {
                            this.doIt();
                        }
                    });
                }
            }
        }
        ArrayList<2> modificationPairs = new ArrayList<2>();
        int l = modifications.size();
        int countDown = Math.max(100, 10 * l);
        for (int i = 0; i < l; ++i) {
            for (int j = i + 1; j < l; ++j) {
                final Modification a = (Modification)modifications.get(i);
                final Modification b = (Modification)modifications.get(j);
                modificationPairs.add(new Modification(){

                    @Override
                    public void doIt() {
                        a.doIt();
                        b.doIt();
                    }

                    @Override
                    public void undoIt() {
                        b.undoIt();
                        a.undoIt();
                    }
                });
                if (--countDown < 0) break;
            }
            if (countDown < 0) break;
        }
        modifications.addAll(modificationPairs);
        double currentMaxPosition = TreeLayoutOptimizer.layoutTree(root, numNodes);
        while (System.currentTimeMillis() - startTime < maxTime) {
            Modification bestModification = null;
            double bestMaxPosition = 0.0;
            for (Modification modification : modifications) {
                modification.doIt();
                double maxPosition = TreeLayoutOptimizer.layoutTree(root, numNodes);
                if (maxPosition < currentMaxPosition && (bestModification == null || maxPosition < bestMaxPosition)) {
                    bestMaxPosition = maxPosition;
                    bestModification = modification;
                }
                modification.undoIt();
            }
            if (bestModification == null) break;
            bestModification.doIt();
            currentMaxPosition = bestMaxPosition;
        }
    }

    private static abstract class Modification {
        private Modification() {
        }

        public abstract void doIt();

        public abstract void undoIt();
    }

    public static class Node<T> {
        private final T userObject;
        private final List<Node<T>> children = new ArrayList<Node<T>>();
        int level = 0;
        Node<T> parent = null;
        double position = 0.0;

        public T getUserObject() {
            return this.userObject;
        }

        public Node(T userObject) {
            this.userObject = userObject;
        }

        public void addChild(Node<T> child) {
            this.children.add(child);
            child.parent = this;
            child.level = this.level + 1;
        }

        public double getPosition() {
            return this.position;
        }

        public int getLevel() {
            return this.level;
        }

        public List<Node<T>> getChildren() {
            return this.children;
        }

        public int getDepth() {
            int maxChildDepth = 0;
            for (Node<T> child : this.children) {
                maxChildDepth = Math.max(maxChildDepth, child.getDepth());
            }
            return 1 + maxChildDepth;
        }

        public int getNodesCount() {
            int count = 1;
            for (Node<T> child : this.children) {
                count += child.getNodesCount();
            }
            return count;
        }

        public double getCompactness() {
            double compactness = 0.0;
            if (this.children.size() > 1) {
                compactness = this.children.get((int)(this.children.size() - 1)).position - this.children.get((int)0).position;
                compactness *= compactness;
                for (Node<T> child : this.children) {
                    compactness += child.getCompactness();
                }
            }
            return compactness;
        }
    }
}

