/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.DbConnectionDialog;
import net.sf.jailer.ui.JComboBox;

public class SchemaMappingDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT = "<default>";
    private boolean ok = false;
    private Map<String, JComboBox> comboboxes = new TreeMap<String, JComboBox>();
    private static final String MAPPINGS_FILE = ".browserschemamaps.ser";
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JButton okButton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaMappingDialog(Frame parent, DataModel dataModel, DbConnectionDialog connectionDialog, Session session, Map<String, String> mapping) throws Exception {
        super(parent, true);
        this.initComponents();
        Frame windowAncestor = parent;
        try {
            if (windowAncestor != null) {
                windowAncestor.setCursor(Cursor.getPredefinedCursor(3));
            }
            TreeSet<String> modelSchemas = new TreeSet<String>();
            for (Table table : new DataModel().getTables()) {
                modelSchemas.add(table.getSchema(DEFAULT));
            }
            TreeSet<String> dbSchemas = new TreeSet<String>(connectionDialog.getDBSchemas(new String[1]));
            dbSchemas.add(DEFAULT);
            int y = 1;
            for (String schema : modelSchemas) {
                String v;
                JComboBox comboBox = new JComboBox();
                comboBox.setModel(new DefaultComboBoxModel<Object>(dbSchemas.toArray()));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = y;
                this.getContentPane().add((Component)comboBox, gridBagConstraints);
                String string = v = mapping.containsKey(schema) ? mapping.get(schema) : schema;
                if (schema.equals(DEFAULT)) {
                    String string2 = v = mapping.containsKey("") ? mapping.get("") : schema;
                }
                if (dbSchemas.contains(v)) {
                    comboBox.setSelectedItem(v);
                } else if (dbSchemas.contains(v.toUpperCase())) {
                    comboBox.setSelectedItem(v.toUpperCase());
                } else if (dbSchemas.contains(v.toLowerCase())) {
                    comboBox.setSelectedItem(v.toLowerCase());
                } else {
                    comboBox.setSelectedItem(DEFAULT);
                }
                this.comboboxes.put(schema, comboBox);
                JLabel label = new JLabel();
                label.setFont(new Font("DejaVu Sans", 1, 13));
                label.setText(schema);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = y++;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                this.getContentPane().add((Component)label, gridBagConstraints);
            }
        }
        finally {
            if (windowAncestor != null) {
                windowAncestor.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.pack();
        this.setLocation(300, 100);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.jButton2 = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Schema Mapping");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("  Read from  ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("  instead of  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.okButton.setText(" Ok ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaMappingDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanel1.add((Component)this.okButton, gridBagConstraints);
        this.jButton2.setText(" Cancel ");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaMappingDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 200;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel4.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 199;
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel3.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.setVisible(false);
    }

    public Map<String, String> getMapping() {
        if (this.ok) {
            TreeMap<String, String> mapping = new TreeMap<String, String>();
            for (Map.Entry<String, JComboBox> e : this.comboboxes.entrySet()) {
                String selection = (String)e.getValue().getSelectedItem();
                if (selection == DEFAULT) {
                    selection = "";
                }
                mapping.put(e.getKey() == DEFAULT ? "" : e.getKey(), selection);
            }
            return mapping;
        }
        return null;
    }

    private static Map<String, Map<String, String>> restore() {
        try {
            File file = CommandLineParser.getInstance().newFile(MAPPINGS_FILE);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            Map mappings = (Map)in.readObject();
            in.close();
            return mappings;
        }
        catch (Exception e) {
            return new TreeMap<String, Map<String, String>>();
        }
    }

    public static Map<String, String> restore(DbConnectionDialog connectionDialog) {
        if (connectionDialog.currentConnection == null) {
            return new TreeMap<String, String>();
        }
        Map<String, String> mapping = SchemaMappingDialog.restore().get(connectionDialog.currentConnection.user + "@" + connectionDialog.currentConnection.url);
        if (mapping == null) {
            return new TreeMap<String, String>();
        }
        return mapping;
    }

    public static void store(Map<String, String> mapping, DbConnectionDialog connectionDialog) {
        try {
            Map<String, Map<String, String>> mappings = SchemaMappingDialog.restore();
            File file = CommandLineParser.getInstance().newFile(MAPPINGS_FILE);
            file.delete();
            mappings.put(connectionDialog.currentConnection.user + "@" + connectionDialog.currentConnection.url, mapping);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(mappings);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

