/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.database.Session;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.SqlScriptExecutor;

public class SQLDMLPanel
extends JPanel {
    private static final long serialVersionUID = 1747749941444843829L;
    private final Session session;
    private final Runnable afterExecution;
    private String mlm = "";
    private String lastMultiLineSQL = "";
    private JButton clipboardButton;
    private JButton clipboardSingleLineButton;
    private JButton executeButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTextField mlmTextField;
    private JButton saveButton;
    private JCheckBox singleLineCheckBox;
    private JEditorPane sqlTextArea;
    private JLabel statusLabel;

    public SQLDMLPanel(String sql, Session session, Runnable afterExecution) {
        this.session = session;
        this.afterExecution = afterExecution;
        this.initComponents();
        this.statusLabel.setText("");
        this.sqlTextArea.setContentType("text/sql");
        this.sqlTextArea.setText(sql);
        this.sqlTextArea.select(0, 0);
        this.mlmTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SQLDMLPanel.this.appendMLM(SQLDMLPanel.this.mlmTextField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SQLDMLPanel.this.appendMLM(SQLDMLPanel.this.mlmTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SQLDMLPanel.this.appendMLM(SQLDMLPanel.this.mlmTextField.getText());
            }
        });
    }

    private void initComponents() {
        this.clipboardSingleLineButton = new JButton();
        this.jPanel2 = new JPanel();
        this.saveButton = new JButton();
        this.clipboardButton = new JButton();
        this.executeButton = new JButton();
        this.statusLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.mlmTextField = new JTextField();
        this.singleLineCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.sqlTextArea = new JEditorPane();
        this.jPanel3 = new JPanel();
        this.clipboardSingleLineButton.setText(" Copy as Single Line ");
        this.clipboardSingleLineButton.setToolTipText(" Copy the SQL statement as a single line to the clipboard");
        this.clipboardSingleLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLDMLPanel.this.clipboardSingleLineButtonActionPerformed(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.saveButton.setText(" Save ");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLDMLPanel.this.saveButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.saveButton, gridBagConstraints);
        this.clipboardButton.setText(" Copy to Clipboard ");
        this.clipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLDMLPanel.this.clipboardButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.clipboardButton, gridBagConstraints);
        this.executeButton.setText(" Execute ");
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLDMLPanel.this.executeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.executeButton, gridBagConstraints);
        this.statusLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel2.add((Component)this.statusLabel, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel1.setText("multi-line continuation  ");
        this.jLabel1.setToolTipText("multi-line continuation character");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 16;
        this.jPanel4.add((Component)this.mlmTextField, gridBagConstraints);
        this.singleLineCheckBox.setText("single line  ");
        this.singleLineCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SQLDMLPanel.this.singleLineCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.jPanel4.add((Component)this.singleLineCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.sqlTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        String fn = UIUtil.choseFile(null, ".", "Save SQL Query", "", this, false, false);
        if (fn != null) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(fn));
                out.print(this.sqlTextArea.getText());
                out.close();
            }
            catch (Exception e) {
                UIUtil.showException(this, "Error saving query", e);
            }
        }
    }

    private void clipboardButtonActionPerformed(ActionEvent evt) {
        this.sqlTextArea.selectAll();
        this.sqlTextArea.copy();
        this.sqlTextArea.select(0, 0);
    }

    private void clipboardSingleLineButtonActionPerformed(ActionEvent evt) {
        String orig = this.sqlTextArea.getText();
        this.sqlTextArea.setText(orig.replaceAll(" *(\n|\r)+ *", " "));
        this.sqlTextArea.selectAll();
        this.sqlTextArea.copy();
        this.sqlTextArea.setText(orig);
        this.sqlTextArea.select(0, 0);
    }

    private void singleLineCheckBoxItemStateChanged(ItemEvent evt) {
        String mlm = this.mlm;
        if (this.singleLineCheckBox.isSelected()) {
            String lf = System.getProperty("line.separator", "\n");
            this.appendMLM("");
            this.lastMultiLineSQL = this.sqlTextArea.getText();
            String EOL = "EOL498503458430EOL";
            this.sqlTextArea.setText(this.lastMultiLineSQL.replaceAll(";(\n|\r)", EOL).replaceAll(" *(\n|\r)+ *", " ").replaceAll(EOL + " *", ";" + lf));
            this.appendMLM(mlm);
        } else {
            this.sqlTextArea.setText(this.lastMultiLineSQL);
            this.mlm = "";
            this.appendMLM(mlm);
        }
        this.sqlTextArea.setCaretPosition(0);
    }

    private void appendMLM(String mlm) {
        if ((mlm = mlm.trim()).length() > 1) {
            mlm = mlm.substring(0, 1);
        }
        if (this.mlm.equals(mlm)) {
            return;
        }
        if (this.mlm.length() > 0) {
            String omlm = this.mlm;
            if ("\\|[]()^-$".indexOf(omlm) >= 0) {
                omlm = "\\" + omlm;
            }
            this.sqlTextArea.setText(this.sqlTextArea.getText().replaceAll(" " + omlm + "([\n\r])", "$1"));
            this.sqlTextArea.select(0, 0);
        }
        this.mlm = mlm;
        if (mlm.length() > 0) {
            if ("\\".equals(mlm) || "$".equals(mlm)) {
                mlm = "\\" + mlm;
            }
            this.sqlTextArea.setText(this.sqlTextArea.getText().replaceAll("([^\n\r;])([\n\r])", "$1 " + mlm + "$2"));
            this.sqlTextArea.select(0, 0);
        }
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        if (0 == JOptionPane.showConfirmDialog(this, "Execute Statements?", "Execute", 0, 3)) {
            String sqlFile;
            try {
                String sqlFileBase = "temp_" + System.currentTimeMillis();
                int i = 0;
                while (true) {
                    sqlFile = sqlFileBase + i + ".sql";
                    if (!CommandLineParser.getInstance().newFile(sqlFile).exists()) break;
                    ++i;
                }
                PrintWriter out = new PrintWriter(CommandLineParser.getInstance().newFile(sqlFile));
                out.println(this.sqlTextArea.getText());
                out.close();
            }
            catch (Exception e) {
                UIUtil.showException(this, "Error", e);
                return;
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("import");
            args.add(sqlFile);
            args.addAll(this.session.getCliArguments());
            args.add("-transactional");
            if (UIUtil.runJailer(SwingUtilities.getWindowAncestor(this), args, false, true, false, true, null, this.session.getPassword(), null, null, false, false, true)) {
                this.statusLabel.setText("Executed " + SqlScriptExecutor.getLastStatementCount().a + " statements. " + SqlScriptExecutor.getLastStatementCount().b + " rows affected");
                this.statusLabel.setForeground(new Color(0, 100, 0));
                this.afterExecution.run();
                JOptionPane.showMessageDialog(this, "Successfully executed " + SqlScriptExecutor.getLastStatementCount().a + " statements.\n" + SqlScriptExecutor.getLastStatementCount().b + " rows affected.", "SQL/DML", 1);
            } else {
                this.statusLabel.setText("Error, rolled back");
                this.statusLabel.setForeground(new Color(115, 0, 0));
            }
            CommandLineParser.getInstance().newFile(sqlFile).delete();
        }
    }
}

