/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.databrowser.LobValue;
import net.sf.jailer.ui.databrowser.Row;
import net.sf.jailer.util.SqlUtil;

public class SQLDMLBuilder {
    private static final String LF = System.getProperty("line.separator", "\n");

    public static String buildUpdate(Table table, List<Row> rows, Session session) {
        StringBuilder sb = new StringBuilder();
        for (Row row : SQLDMLBuilder.unique(rows)) {
            sb.append(SQLDMLBuilder.buildUpdate(table, row, false, session)).append(";" + LF + LF);
        }
        return sb.toString();
    }

    public static String buildUpdate(Table table, Row row, boolean withComments, Session session) {
        String sql = "Update " + table.getName() + " " + LF + "Set ";
        boolean f = true;
        int i = 0;
        for (Column column : table.getColumns()) {
            String value;
            String name = column.name;
            if ((value = SQLDMLBuilder.getSQLLiteral(row.values[i++], session)) == null) continue;
            sql = sql + (f ? "" : ", " + LF + "    ") + name + " = " + value + SQLDMLBuilder.comment(withComments, column, false);
            f = false;
        }
        sql = sql + " " + LF + "Where " + SqlUtil.replaceAliases(row.rowId, null, null);
        return sql;
    }

    private static String comment(boolean withComments, Column column, boolean withName) {
        if (withComments) {
            return "   /* " + (withName ? column.toSQL(null) : column.toSQL(null).substring(column.name.length()).trim()) + " */";
        }
        return "";
    }

    public static String buildInsert(Table table, List<Row> rows, Session session) {
        StringBuilder sb = new StringBuilder();
        for (Row row : SQLDMLBuilder.unique(rows)) {
            sb.append(SQLDMLBuilder.buildInsert(table, row, false, session)).append(";" + LF + LF);
        }
        return sb.toString();
    }

    public static String buildInsert(Table table, Row row, boolean withComments, Session session) {
        String sql = "Insert into " + table.getName() + " (" + LF + "    ";
        String values = "";
        boolean f = true;
        int i = 0;
        for (Column column : table.getColumns()) {
            String value;
            String name = column.name;
            if ((value = SQLDMLBuilder.getSQLLiteral(row.values[i++], session)) == null) continue;
            sql = sql + (f ? "" : ", " + LF + "    ") + name + SQLDMLBuilder.comment(withComments, column, false);
            values = values + (f ? "" : ", " + LF + "    ") + value + SQLDMLBuilder.comment(withComments, column, true);
            f = false;
        }
        sql = sql + ") " + LF + "Values (" + LF + "    " + values + ")";
        return sql;
    }

    public static String buildDelete(Table table, Row row, boolean withComments, Session session) {
        String sql = "Delete from " + table.getName() + " Where " + SqlUtil.replaceAliases(row.rowId, null, null);
        return sql;
    }

    public static String buildDelete(Table table, List<Row> rows, Session session) {
        StringBuilder sb = new StringBuilder();
        for (Row row : SQLDMLBuilder.unique(rows)) {
            sb.append(SQLDMLBuilder.buildDelete(table, row, false, session)).append(";" + LF + "");
        }
        return sb.toString();
    }

    private static List<Row> unique(List<Row> rows) {
        ArrayList<Row> result = new ArrayList<Row>();
        HashSet<String> ids = new HashSet<String>();
        for (Row row : rows) {
            if (ids.contains(row.rowId)) continue;
            ids.add(row.rowId);
            result.add(row);
        }
        return result;
    }

    private static String getSQLLiteral(Object value, Session session) {
        if (value instanceof LobValue) {
            return null;
        }
        return SqlUtil.toSql(value, session);
    }
}

