/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jailer.Configuration;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.databrowser.Row;
import net.sf.jailer.util.SqlUtil;

public class RowCounter {
    private final Table table;
    private final Association association;
    private final Session session;
    private final List<Row> theRows;
    private final int TIMEOUT = 6;
    private static final String ROWNUMBERALIAS = "RN";

    public RowCounter(Table table, Association association, List<Row> theRows, Session session) {
        this.table = table;
        this.association = association;
        this.theRows = theRows;
        this.session = session;
    }

    public long countRows(String andCond, Object context, int limit, boolean selectDistinct) throws SQLException {
        List<Row> pRows = this.theRows;
        pRows = new ArrayList<Row>(pRows);
        HashMap<String, Row> rowSet = new HashMap<String, Row>();
        long maxTime = System.currentTimeMillis() + 6000L;
        if (this.association != null && this.association.source.primaryKey.getColumns().isEmpty()) {
            try {
                this.loadRowBlocks(andCond, context, limit, selectDistinct, pRows, rowSet, 1, maxTime);
            }
            catch (SQLException e) {
                if (System.currentTimeMillis() >= maxTime) {
                    return -1L;
                }
                throw e;
            }
        } else {
            try {
                return this.loadRowBlocks(andCond, context, limit, selectDistinct, pRows, rowSet, 258, maxTime);
            }
            catch (SQLException e) {
                if (System.currentTimeMillis() >= maxTime) {
                    return -1L;
                }
                Session._log.warn("failed, try another blocking-size");
                try {
                    return this.loadRowBlocks(andCond, context, limit, selectDistinct, pRows, rowSet, 100, maxTime);
                }
                catch (SQLException e2) {
                    if (System.currentTimeMillis() >= maxTime) {
                        return -1L;
                    }
                    Session._log.warn("failed, try another blocking-size");
                    try {
                        return this.loadRowBlocks(andCond, context, limit, selectDistinct, pRows, rowSet, 40, maxTime);
                    }
                    catch (SQLException e3) {
                        if (System.currentTimeMillis() >= maxTime) {
                            return -1L;
                        }
                        Session._log.warn("failed, try another blocking-size");
                    }
                }
            }
        }
        try {
            return this.loadRowBlocks(andCond, context, limit, selectDistinct, pRows, rowSet, 1, maxTime);
        }
        catch (SQLException e) {
            if (System.currentTimeMillis() >= maxTime) {
                return -1L;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadRowBlocks(String andCond, Object context, int limit, boolean selectDistinct, List<Row> pRows, Map<String, Row> rowSet, int NUM_PARENTS, long maxTime) throws SQLException {
        ArrayList parentBlocks = new ArrayList();
        ArrayList<Row> currentBlock = new ArrayList<Row>();
        parentBlocks.add(currentBlock);
        for (Row pRow : pRows) {
            if (currentBlock.size() >= NUM_PARENTS) {
                currentBlock = new ArrayList();
                parentBlocks.add(currentBlock);
            }
            currentBlock.add(pRow);
        }
        long rc = 0L;
        if (!pRows.isEmpty()) {
            for (List list : parentBlocks) {
                if (System.currentTimeMillis() >= maxTime) {
                    return -1L;
                }
                List pRowBlock = list;
                HashMap<String, List<Row>> newBlockRows = new HashMap<String, List<Row>>();
                boolean loaded = false;
                if (pRowBlock.size() == 1 && pRowBlock.get(0) == null) {
                    pRowBlock = null;
                }
                long brc = 0L;
                if (Configuration.forDbms(this.session).getSqlLimitSuffix() != null) {
                    try {
                        this.session.setSilent(true);
                        brc += this.countRows(andCond, pRowBlock, newBlockRows, context, limit, false, Configuration.forDbms(this.session).getSqlLimitSuffix(), selectDistinct, maxTime);
                        loaded = true;
                    }
                    catch (SQLException e) {
                        if (System.currentTimeMillis() >= maxTime) {
                            long l = -1L;
                            return l;
                        }
                        Session._log.warn("failed, try another limit-strategy");
                    }
                    finally {
                        this.session.setSilent(false);
                    }
                }
                if (!loaded) {
                    try {
                        this.session.setSilent(true);
                        brc += this.countRows(andCond, pRowBlock, newBlockRows, context, limit, true, null, selectDistinct, maxTime);
                        loaded = true;
                    }
                    catch (SQLException e) {
                        if (System.currentTimeMillis() >= maxTime) {
                            long l = -1L;
                            return l;
                        }
                        Session._log.warn("failed, try another limit-strategy");
                    }
                    finally {
                        this.session.setSilent(false);
                    }
                    if (!loaded) {
                        brc += this.countRows(andCond, pRowBlock, newBlockRows, context, limit, false, null, selectDistinct, maxTime);
                    }
                }
                rc += brc;
                if ((limit = (int)((long)limit - brc)) > 0) continue;
                break;
            }
        }
        return rc;
    }

    public long countRows(String andCond, List<Row> parentRows, Map<String, List<Row>> rows, Object context, int limit, boolean useOLAPLimitation, String sqlLimitSuffix, boolean selectDistinct, long maxTime) throws SQLException {
        boolean limitSuffixInSelectClause;
        String sql = "Select ";
        String olapPrefix = "Select ";
        String olapSuffix = ") S Where S.RN <= " + limit;
        boolean bl = limitSuffixInSelectClause = sqlLimitSuffix != null && (sqlLimitSuffix.toLowerCase().startsWith("top ") || sqlLimitSuffix.toLowerCase().startsWith("first "));
        if (sqlLimitSuffix != null && limitSuffixInSelectClause) {
            sql = sql + sqlLimitSuffix.replace("%s", Integer.toString(limit)) + " ";
        }
        boolean f = true;
        int i = 0;
        for (Column column : this.association.destination.getColumns()) {
            String name = column.name;
            sql = sql + (!f ? ", " : "") + "A." + name + " AS A" + i;
            olapPrefix = olapPrefix + (!f ? ", " : "") + "S.A" + i;
            ++i;
            f = false;
        }
        f = true;
        f = true;
        String orderBy = "";
        for (Column pk : this.association.destination.primaryKey.getColumns()) {
            orderBy = orderBy + (f ? "" : ", ") + "B." + pk.name;
            f = false;
        }
        if (useOLAPLimitation) {
            sql = sql + ", row_number() over(";
            sql = sql + "order by -1";
            sql = sql + ") as RN";
        }
        sql = sql + " From ";
        if (this.association != null) {
            sql = sql + this.association.destination.getName() + " A join ";
        }
        sql = sql + this.table.getName() + " B";
        if (this.association != null) {
            sql = this.association.reversed ? sql + " on " + this.association.getUnrestrictedJoinCondition() : sql + " on " + SqlUtil.reversRestrictionCondition(this.association.getUnrestrictedJoinCondition());
        }
        boolean whereExists = false;
        if (parentRows != null && !parentRows.isEmpty()) {
            if (parentRows.size() == 1) {
                sql = sql + " Where (" + parentRows.get((int)0).rowId + ")";
            } else {
                StringBuilder sb = new StringBuilder();
                for (Row parentRow : parentRows) {
                    if (sb.length() == 0) {
                        sb.append(" Where ((");
                    } else {
                        sb.append(" or (");
                    }
                    sb.append(parentRow.rowId).append(")");
                }
                sb.append(")");
                sql = sql + sb.toString();
            }
            whereExists = true;
        }
        olapPrefix = olapPrefix + " From (";
        if (useOLAPLimitation) {
            sql = olapPrefix + sql + olapSuffix;
        }
        if (sqlLimitSuffix != null && !limitSuffixInSelectClause) {
            sql = sql + " " + sqlLimitSuffix.replace("%s", Integer.toString(limit));
        }
        final long[] rc = new long[1];
        if (sql.length() > 0) {
            sql = "Select count(*) From (" + sql + ") JLASRCNT";
            int timeout = (int)Math.max(1L, (maxTime - System.currentTimeMillis()) / 1000L);
            this.session.executeQuery(sql, new Session.ResultSetReader(){

                @Override
                public void readCurrentRow(ResultSet resultSet) throws SQLException {
                    rc[0] = resultSet.getLong(1);
                }

                @Override
                public void close() {
                }
            }, null, context, 0, timeout);
        }
        return rc[0];
    }
}

