/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.UIUtil;

public class QueryBuilderPathSelector
extends JDialog {
    private static final long serialVersionUID = 3231933816703766740L;
    private JLabel fromLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton okButton;
    private javax.swing.JComboBox toComboBox;
    private int backCount;
    private boolean ok;

    public QueryBuilderPathSelector(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                QueryBuilderPathSelector.this.okButton.grabFocus();
            }
        });
        this.pack();
        this.setSize(Math.max(400, this.getWidth()), this.getHeight());
        UIUtil.initPeer();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.toComboBox = new JComboBox();
        this.fromLabel = new JLabel();
        this.okButton = new JButton();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Query Builder");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText(" join tables from   ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(" to ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.toComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.toComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                QueryBuilderPathSelector.this.toComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.toComboBox, gridBagConstraints);
        this.fromLabel.setFont(new Font("DejaVu Sans", 1, 13));
        this.fromLabel.setText("TABLE");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.fromLabel, gridBagConstraints);
        this.okButton.setText(" Ok ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPathSelector.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.jLabel3.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.setVisible(false);
    }

    private void toComboBoxItemStateChanged(ItemEvent evt) {
        this.backCount = ((ToElement)this.toComboBox.getSelectedItem()).backCount;
        this.ok = true;
        this.setVisible(false);
    }

    public int selectBackCount(List<Association> associationsOnPath) {
        if (associationsOnPath.isEmpty()) {
            return 0;
        }
        this.fromLabel.setText(associationsOnPath.get((int)0).source.getUnqualifiedName());
        this.backCount = -1;
        this.ok = false;
        DefaultComboBoxModel<ToElement> model = new DefaultComboBoxModel<ToElement>();
        int i = 0;
        ToElement element = new ToElement();
        element.backCount = i++;
        element.name = associationsOnPath.get((int)0).source.getUnqualifiedName();
        model.addElement(element);
        for (Association a : associationsOnPath) {
            element = new ToElement();
            element.backCount = i++;
            element.name = a.destination.getUnqualifiedName();
            model.addElement(element);
        }
        this.toComboBox.setModel(model);
        this.toComboBox.setSelectedIndex(i - 1);
        this.setLocation(this.getParent().getX() + (this.getParent().getWidth() - this.getWidth()) / 2, this.getParent().getY() + (this.getParent().getHeight() - this.getHeight()) / 2);
        this.setVisible(true);
        return this.ok ? this.backCount : -1;
    }

    private static class ToElement {
        public int backCount;
        public String name;

        private ToElement() {
        }

        public String toString() {
            return this.name;
        }
    }
}

