/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.ui.databrowser.DataBrowserContext;

public abstract class NewTableBrowser
extends JDialog {
    private JButton analyzeButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JButton restoreSessionButton;
    private JList tableList;

    public NewTableBrowser(Frame parent, DataModel datamodel, boolean offerAlternatives) {
        super(parent, true);
        this.initComponents();
        UIUtil.wireComponentWithButton(this.tableList, this.okButton);
        this.analyzeButton.setVisible(DataBrowserContext.isSupportsDataModelUpdates());
        if (offerAlternatives) {
            this.setTitle(DataBrowserContext.getAppName(true));
            this.okButton.setText(" Open Table ");
        } else {
            this.analyzeButton.setVisible(false);
            this.restoreSessionButton.setVisible(false);
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        ArrayList<String> tables = new ArrayList<String>();
        for (Table table : datamodel.getTables()) {
            tables.add(datamodel.getDisplayName(table));
        }
        Collections.sort(tables);
        for (String tn : tables) {
            model.addElement(tn);
        }
        this.tableList.setModel(model);
        this.pack();
        this.setSize(Math.max(400, this.getWidth()), 400);
        this.setLocation(300, 100);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableList = new JList();
        this.okButton = new JButton();
        this.analyzeButton = new JButton();
        this.restoreSessionButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Table Browser");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Tables"));
        this.tableList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.tableList.setSelectionMode(0);
        this.tableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                NewTableBrowser.this.tableListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tableList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.okButton.setText(" OK ");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableBrowser.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.okButton, gridBagConstraints);
        this.analyzeButton.setText(" Analyze Database ");
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableBrowser.this.analyzeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.analyzeButton, gridBagConstraints);
        this.restoreSessionButton.setText(" Restore Layout ");
        this.restoreSessionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTableBrowser.this.restoreSessionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 16);
        this.jPanel1.add((Component)this.restoreSessionButton, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void tableListValueChanged(ListSelectionEvent evt) {
        this.okButton.setEnabled(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        Object s = this.tableList.getSelectedValue();
        if (s instanceof String) {
            this.openTableBrowser((String)s);
        }
    }

    private void analyzeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.openDatabaseAnalyzer();
    }

    private void restoreSessionButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.restoreSession();
    }

    abstract void openTableBrowser(String var1);

    abstract void openDatabaseAnalyzer();

    abstract void restoreSession();
}

