/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.databrowser.Row;

public abstract class DetailsView
extends JPanel {
    private final Table table;
    private final List<Row> rows;
    private final RowSorter<? extends TableModel> rowSorter;
    private final Font font = new JLabel().getFont();
    private final Font nonbold = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
    private final Font italic = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE | 2, this.font.getSize());
    private final Color BG1 = new Color(255, 255, 255);
    private final Color BG2 = new Color(230, 255, 255);
    private final Color FG1 = new Color(155, 0, 0);
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JSpinner rowSpinner;

    public DetailsView(List<Row> rows, int size, DataModel dataModel, Table table, int rowIndex, RowSorter<? extends TableModel> rowSorter, boolean showSpinner) {
        this.table = table;
        this.rows = rows;
        this.rowSorter = rowSorter;
        this.initComponents();
        if (rowSorter != null) {
            rowIndex = rowSorter.convertRowIndexToView(rowIndex);
        }
        final SpinnerNumberModel model = new SpinnerNumberModel(rowIndex + 1, 1, size, -1);
        this.rowSpinner.setModel(model);
        this.rowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DetailsView.this.setCurrentRow((Integer)model.getValue() - 1, true);
            }
        });
        if (!showSpinner) {
            this.jLabel1.setVisible(false);
            this.rowSpinner.setVisible(false);
            this.jScrollPane1.setVerticalScrollBarPolicy(21);
            this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        }
        this.setCurrentRow(rowIndex, showSpinner);
    }

    public void setBorderColor(Color color) {
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder(color, Color.GRAY));
    }

    private void setCurrentRow(int row, boolean selectableFields) {
        GridBagConstraints gridBagConstraints;
        int i;
        this.jPanel1.removeAll();
        for (i = 0; i < this.table.getColumns().size(); ++i) {
            JComponent f;
            Column c = this.table.getColumns().get(i);
            JLabel l = new JLabel();
            l.setText(" " + c.name + "  ");
            l.setFont(this.nonbold);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            this.jPanel1.add((Component)l, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i;
            Object v = this.rows.get((int)(this.rowSorter != null ? this.rowSorter.convertRowIndexToModel((int)row) : row)).values[i];
            if (selectableFields) {
                f = new JTextField();
                ((JTextComponent)f).setText(v == null ? "" : v.toString());
                f.setEnabled(v != null);
                ((JTextComponent)f).setEditable(false);
                this.jPanel1.add((Component)f, gridBagConstraints);
                continue;
            }
            f = new JLabel();
            ((JLabel)f).setText((v == null ? "null" : v.toString()) + "    ");
            f.setFont(v == null ? this.italic : this.nonbold);
            if (v == null) {
                f.setForeground(Color.GRAY);
            }
            this.jPanel1.add((Component)f, gridBagConstraints);
            f.setBackground(i % 2 == 0 ? this.BG1 : this.BG2);
            l.setBackground(i % 2 == 0 ? this.BG1 : this.BG2);
            f.setOpaque(true);
            l.setOpaque(true);
            if (this.table.primaryKey != null && this.table.primaryKey.getColumns().contains(c)) {
                l.setForeground(this.FG1);
                continue;
            }
            l.setForeground(Color.BLUE);
        }
        if (selectableFields) {
            JLabel l = new JLabel();
            l.setText(" ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i;
            this.jPanel1.add((Component)l, gridBagConstraints);
        }
        this.invalidate();
        this.validate();
        this.setSize(this.getWidth() - 1, this.getHeight() - 1);
        this.setSize(this.getWidth() + 1, this.getHeight() + 1);
        this.onRowChanged(row);
    }

    protected abstract void onRowChanged(int var1);

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.rowSpinner = new JSpinner();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(" Row ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.rowSpinner, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setText("jLabel2");
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints());
        this.jTextField1.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }
}

