/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultDesktopManager;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.ConditionEditor;
import net.sf.jailer.ui.DbConnectionDialog;
import net.sf.jailer.ui.QueryBuilderDialog;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.ui.databrowser.BrowserContentPane;
import net.sf.jailer.ui.databrowser.DataBrowser;
import net.sf.jailer.ui.databrowser.QueryBuilderPathSelector;
import net.sf.jailer.ui.databrowser.Reference;
import net.sf.jailer.ui.databrowser.Row;
import net.sf.jailer.ui.databrowser.SchemaMappingDialog;
import net.sf.jailer.ui.databrowser.TreeLayoutOptimizer;
import net.sf.jailer.util.CancellationException;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.Pair;
import net.sf.jailer.util.SqlUtil;
import prefuse.util.GraphicsLib;

public abstract class Desktop
extends JDesktopPane {
    private final Reference<DataModel> datamodel;
    private final Icon jailerIcon;
    public static final int BROWSERTABLE_DEFAULT_WIDTH = 476;
    private final int BROWSERTABLE_DEFAULT_MIN = 0;
    private final int BROWSERTABLE_DEFAULT_HEIGHT = 460;
    private final int BROWSERTABLE_DEFAULT_DISTANCE = 64;
    private boolean running;
    private boolean renderLinks;
    public final Map<String, String> schemaMapping = new TreeMap<String, String>();
    public Session session;
    DbConnectionDialog dbConnectionDialog;
    private Set<Pair<BrowserContentPane, Row>> currentClosure = new HashSet<Pair<BrowserContentPane, Row>>();
    private Set<Pair<BrowserContentPane, String>> currentClosureRowIDs = new HashSet<Pair<BrowserContentPane, String>>();
    private final QueryBuilderDialog queryBuilderDialog;
    private final QueryBuilderPathSelector queryBuilderPathSelector;
    private Method getPreciseWheelRotation;
    private List<RowBrowser> tableBrowsers = new ArrayList<RowBrowser>();
    private long lastPTS = 0L;
    private Map<RowBrowser, Map<String, List<Link>>> rbSourceToLinks = null;
    private Polygon m_arrowHead;
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager manager;
    private final DataBrowser parentFrame;
    LayoutMode layoutMode = LayoutMode.MEDIUM;
    private Map<Rectangle, double[]> precBounds = new HashMap<Rectangle, double[]>();
    private static Collection<Desktop> desktops = new ArrayList<Desktop>();
    private boolean loadSchemaMapping = true;
    private final String LF = System.getProperty("line.separator", "\n");
    private String currentSessionFileName = null;
    private final PriorityBlockingQueue<BrowserContentPane.RunnableWithPriority> runnableQueue = new PriorityBlockingQueue<BrowserContentPane.RunnableWithPriority>(100, new Comparator<BrowserContentPane.RunnableWithPriority>(){

        @Override
        public int compare(BrowserContentPane.RunnableWithPriority o1, BrowserContentPane.RunnableWithPriority o2) {
            return o2.getPriority() - o1.getPriority();
        }
    });
    private static final int MAX_CONCURRENT_CONNECTIONS = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Desktop(Reference<DataModel> datamodel, Icon jailerIcon, Session session, DataBrowser parentFrame, DbConnectionDialog dbConnectionDialog) {
        for (int i = 0; i < 6; ++i) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        BrowserContentPane.RunnableWithPriority take = null;
                        try {
                            take = (BrowserContentPane.RunnableWithPriority)Desktop.this.runnableQueue.take();
                            take.run();
                            continue;
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        catch (CancellationException e) {
                            continue;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }, "PQueue Worker " + i);
            t.setDaemon(true);
            t.start();
        }
        this.parentFrame = parentFrame;
        this.datamodel = datamodel;
        this.jailerIcon = jailerIcon;
        this.queryBuilderDialog = new QueryBuilderDialog(parentFrame);
        this.queryBuilderPathSelector = new QueryBuilderPathSelector((Frame)parentFrame, true);
        this.dbConnectionDialog = dbConnectionDialog;
        this.queryBuilderDialog.sqlEditButton.setVisible(true);
        this.queryBuilderDialog.sqlEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this.addTableBrowser(null, 0, null, null, Desktop.this.queryBuilderDialog.getSQL(), null, null, true);
                Desktop.this.queryBuilderDialog.setVisible(false);
            }
        });
        try {
            this.getPreciseWheelRotation = MouseWheelEvent.class.getMethod("getPreciseWheelRotation", new Class[0]);
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            this.session = session;
            datamodel.get().getUniversalPrimaryKey(session);
            this.setAutoscrolls(true);
            this.manager = new MDIDesktopManager(this);
            this.setDesktopManager(this.manager);
            Desktop exc = this;
            synchronized (exc) {
                this.running = true;
            }
            Thread updateUIThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Desktop desktop = Desktop.this;
                        synchronized (desktop) {
                            if (!Desktop.this.running) {
                                return;
                            }
                        }
                        try {
                            Thread.sleep(300L);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    boolean cl = Desktop.this.calculateLinks();
                                    if (cl) {
                                        Desktop.this.repaintDesktop();
                                    }
                                }
                            });
                        }
                        catch (InterruptedException e) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                    }
                }
            });
            updateUIThread.setDaemon(true);
            updateUIThread.start();
        }
        catch (Exception e) {
            UIUtil.showException(null, "Error", e);
        }
        desktops.add(this);
        this.updateMenu();
    }

    public synchronized RowBrowser addTableBrowser(RowBrowser parent, int parentRowIndex, Table table, Association association, String condition, Integer limit, Boolean selectDistinct, boolean reload) {
        HashSet<String> titles = new HashSet<String>();
        for (RowBrowser rb : this.tableBrowsers) {
            titles.add(rb.internalFrame.getTitle());
        }
        this.demaximize();
        String title = null;
        if (table != null && titles.contains(title = this.datamodel.get().getDisplayName(table))) {
            int i = 2;
            while (true) {
                String titelPlusI;
                if (!titles.contains(titelPlusI = title + " (" + i + ")")) {
                    title = titelPlusI;
                    break;
                }
                ++i;
            }
        }
        final RowBrowser tableBrowser = new RowBrowser();
        final JInternalFrame jInternalFrame = new JInternalFrame(table == null ? "SQL" : title);
        jInternalFrame.setClosable(true);
        jInternalFrame.setIconifiable(true);
        jInternalFrame.setMaximizable(true);
        jInternalFrame.setVisible(true);
        jInternalFrame.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                Desktop.this.onMouseWheelMoved(evt);
                Desktop.this.onMouseWheelMoved(evt, Desktop.this.parentFrame.getDesktopScrollPane());
            }
        });
        GroupLayout jInternalFrame1Layout = new GroupLayout(jInternalFrame.getContentPane());
        jInternalFrame.getContentPane().setLayout(jInternalFrame1Layout);
        jInternalFrame1Layout.setHorizontalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 162, Short.MAX_VALUE));
        jInternalFrame1Layout.setVerticalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 102, Short.MAX_VALUE));
        jInternalFrame.setResizable(true);
        if (this.jailerIcon != null) {
            jInternalFrame.setFrameIcon(this.jailerIcon);
        }
        this.add((Component)jInternalFrame, JLayeredPane.DEFAULT_LAYER);
        jInternalFrame.addPropertyChangeListener("maximum", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Desktop.this.manager.resizeDesktop();
            }
        });
        jInternalFrame.addPropertyChangeListener("icon", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (jInternalFrame.isIcon()) {
                    Desktop.this.demaximize();
                    tableBrowser.setHidden(true);
                    try {
                        jInternalFrame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        });
        jInternalFrame.addPropertyChangeListener("selected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    Desktop.this.updateMenu();
                }
            }
        });
        jInternalFrame.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                Desktop.this.repaintDesktop();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Desktop.this.repaintDesktop();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Desktop.this.repaintDesktop();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Desktop.this.repaintDesktop();
            }
        });
        final BrowserContentPane browserContentPane = new BrowserContentPane(this.datamodel.get(), table, condition, this.session, parent == null || parentRowIndex < 0 ? null : parent.browserContentPane.rows.get(parentRowIndex), parent == null || parentRowIndex >= 0 ? null : parent.browserContentPane.rows, association, this.parentFrame, this.currentClosure, this.currentClosureRowIDs, limit, selectDistinct, reload){

            @Override
            protected QueryBuilderDialog getQueryBuilderDialog() {
                return Desktop.this.queryBuilderDialog;
            }

            @Override
            protected QueryBuilderPathSelector getQueryBuilderPathSelector() {
                return Desktop.this.queryBuilderPathSelector;
            }

            @Override
            protected void navigateTo(Association association, int rowIndex, Row row) {
                Desktop.this.addTableBrowser(tableBrowser, rowIndex, association.destination, association, "", null, null, true);
            }

            @Override
            protected void onContentChange(List<Row> rows, boolean reloadChildren) {
                Desktop.this.updateChildren(tableBrowser, rows);
                for (RowBrowser rb : Desktop.this.tableBrowsers) {
                    if (rb.parent != tableBrowser) continue;
                    Desktop.this.updateChildren(rb, rb.browserContentPane.rows);
                    if (!reloadChildren || rb.browserContentPane.parentRow != null) continue;
                    rb.browserContentPane.reloadRows();
                }
            }

            @Override
            protected void onRedraw() {
                Desktop.this.repaintDesktop();
            }

            @Override
            protected JFrame getOwner() {
                return Desktop.this.parentFrame;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void addRowToRowLink(Row parentRow, Row childRow) {
                Desktop desktop = Desktop.this;
                synchronized (desktop) {
                    RowToRowLink rowToRowLink = new RowToRowLink();
                    rowToRowLink.parentRow = parentRow;
                    rowToRowLink.childRow = childRow;
                    rowToRowLink.color = Desktop.this.getAssociationColor(this.association);
                    tableBrowser.rowToRowLinks.add(rowToRowLink);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void beforeReload() {
                Desktop desktop = Desktop.this;
                synchronized (desktop) {
                    tableBrowser.rowToRowLinks.clear();
                }
            }

            @Override
            protected void findClosure(Row row) {
                HashSet<Pair<BrowserContentPane, Row>> rows = new HashSet<Pair<BrowserContentPane, Row>>();
                this.findClosure(row, rows, false);
                this.currentClosure.addAll(rows);
                rows = new HashSet();
                this.findClosure(row, rows, true);
                this.currentClosure.addAll(rows);
            }

            @Override
            protected void findClosure(Row row, Set<Pair<BrowserContentPane, Row>> closure, boolean forward) {
                block6: {
                    block7: {
                        Pair<8, Row> thisRow = new Pair<8, Row>(this, row);
                        if (closure.contains(thisRow)) break block6;
                        closure.add(thisRow);
                        if (!forward) break block7;
                        for (RowBrowser child : Desktop.this.tableBrowsers) {
                            if (child.parent != tableBrowser) continue;
                            if (child.browserContentPane.parentRow != null && row.rowId.equals(child.browserContentPane.parentRow.rowId)) {
                                for (Row r : child.browserContentPane.rows) {
                                    child.browserContentPane.findClosure(r, closure, forward);
                                }
                            }
                            for (RowToRowLink rowToRowLink : child.rowToRowLinks) {
                                if (!row.rowId.equals(rowToRowLink.parentRow.rowId)) continue;
                                child.browserContentPane.findClosure(rowToRowLink.childRow, closure, forward);
                            }
                        }
                        break block6;
                    }
                    if (tableBrowser.parent == null) break block6;
                    if (tableBrowser.browserContentPane.parentRow != null) {
                        tableBrowser.parent.browserContentPane.findClosure(tableBrowser.browserContentPane.parentRow, closure, forward);
                    }
                    for (RowToRowLink rowToRowLink : tableBrowser.rowToRowLinks) {
                        if (!row.rowId.equals(rowToRowLink.childRow.rowId)) continue;
                        tableBrowser.parent.browserContentPane.findClosure(rowToRowLink.parentRow, closure, forward);
                    }
                }
            }

            private void createAnchorSQL(RowBrowser rb, StringBuilder rowIds, boolean indent) {
                boolean f = true;
                for (Row row : rb.browserContentPane.rows) {
                    if (!f) {
                        rowIds.append(indent ? " or\n       " : " or\n");
                    }
                    f = false;
                    rowIds.append(SqlUtil.replaceAliases(row.rowId, "A", "A"));
                }
                rowIds.append("");
            }

            @Override
            protected QueryBuilderDialog.Relationship createQBRelations(boolean withParents) {
                QueryBuilderDialog.Relationship root = new QueryBuilderDialog.Relationship();
                root.whereClause = ConditionEditor.toMultiLine(this.getAndConditionText().trim()).replaceAll("(\r|\n)+", " ");
                if (root.whereClause.length() == 0) {
                    root.whereClause = null;
                }
                StringBuilder rowIds = new StringBuilder("");
                this.createAnchorSQL(tableBrowser, rowIds, withParents);
                root.anchorWhereClause = rowIds.length() == 0 ? null : rowIds.toString();
                root.children.addAll(this.createQBChildrenRelations(null, !withParents));
                Association a = this.association;
                QueryBuilderDialog.Relationship r = root;
                RowBrowser childRB = tableBrowser;
                RowBrowser rb = tableBrowser.parent;
                while (rb != null && a != null) {
                    if (!withParents) {
                        root.needsAnchor = true;
                        break;
                    }
                    QueryBuilderDialog.Relationship child = new QueryBuilderDialog.Relationship();
                    child.children.addAll(rb.browserContentPane.createQBChildrenRelations(childRB, false));
                    child.parent = r;
                    r.children.add(0, child);
                    child.whereClause = ConditionEditor.toMultiLine(rb.browserContentPane.getAndConditionText().trim()).replaceAll("(\r|\n)+", " ");
                    if (child.whereClause.length() == 0) {
                        child.whereClause = null;
                    }
                    r.anchor = child.association = a.reversalAssociation;
                    a = rb.association;
                    rowIds = new StringBuilder("");
                    this.createAnchorSQL(rb, rowIds, true);
                    child.anchorWhereClause = rowIds.length() == 0 ? null : rowIds.toString();
                    r.originalParent = child;
                    if (childRB.rowIndex >= 0 && (childRB.rowIndex != 0 || childRB.parent == null || childRB.parent.browserContentPane == null || childRB.parent.browserContentPane.rows == null || childRB.parent.browserContentPane.rows.size() != 1)) {
                        String w = childRB.browserContentPane.parentRow.rowId;
                        child.whereClause = null;
                        r.whereClause = w;
                        break;
                    }
                    r = child;
                    childRB = rb;
                    rb = rb.parent;
                }
                return root;
            }

            @Override
            protected List<QueryBuilderDialog.Relationship> createQBChildrenRelations(RowBrowser tabu, boolean all) {
                ArrayList<QueryBuilderDialog.Relationship> result = new ArrayList<QueryBuilderDialog.Relationship>();
                for (RowBrowser rb : Desktop.this.tableBrowsers) {
                    if (rb.parent != tableBrowser || rb == tabu) continue;
                    boolean singleRowParent = rb.rowIndex >= 0 && (rb.rowIndex != 0 || rb.parent == null || rb.parent.browserContentPane == null || rb.parent.browserContentPane.rows == null || rb.parent.browserContentPane.rows.size() != 1);
                    QueryBuilderDialog.Relationship child = new QueryBuilderDialog.Relationship();
                    child.whereClause = ConditionEditor.toMultiLine(rb.browserContentPane.getAndConditionText().trim()).replaceAll("(\r|\n)+", " ");
                    child.joinOperator = QueryBuilderDialog.JoinOperator.LeftJoin;
                    if (child.whereClause.length() == 0) {
                        child.whereClause = null;
                    }
                    if (singleRowParent) {
                        String andIsParent = rb.browserContentPane.parentRow.rowId;
                        child.whereClause = child.whereClause == null ? andIsParent : "(" + child.whereClause + ") and (" + andIsParent + ")";
                    }
                    child.association = rb.association;
                    if (child.association == null) continue;
                    child.children.addAll(rb.browserContentPane.createQBChildrenRelations(tabu, all));
                    result.add(child);
                }
                return result;
            }

            @Override
            protected void openSchemaMappingDialog() {
                Desktop.this.openSchemaMappingDialog(false);
            }

            @Override
            protected void openSchemaAnalyzer() {
                Desktop.this.openSchemaAnalyzer();
            }

            @Override
            protected DbConnectionDialog getDbConnectionDialog() {
                return Desktop.this.dbConnectionDialog;
            }

            @Override
            protected double getLayoutFactor() {
                return Desktop.this.layoutMode.factor;
            }

            @Override
            protected List<RowBrowser> getChildBrowsers() {
                return Desktop.this.getChildBrowsers(tableBrowser, false);
            }

            @Override
            protected RowBrowser getParentBrowser() {
                return tableBrowser.parent;
            }

            @Override
            protected List<RowBrowser> getTableBrowser() {
                return new ArrayList<RowBrowser>(Desktop.this.tableBrowsers);
            }

            @Override
            protected void onHide() {
                Desktop.this.demaximize();
                tableBrowser.setHidden(true);
            }

            @Override
            protected void unhide() {
                tableBrowser.setHidden(false);
            }

            @Override
            protected void adjustClosure(BrowserContentPane tabu) {
                Desktop.this.adjustClosure(tabu);
            }

            @Override
            protected void close() {
                Desktop.this.closeAll(Collections.singleton(tableBrowser));
            }

            @Override
            protected void showInNewWindow() {
                Desktop.this.showInNewWindow(tableBrowser);
            }

            @Override
            protected void appendLayout() {
                Desktop.this.restoreSession(tableBrowser);
            }

            @Override
            protected PriorityBlockingQueue<BrowserContentPane.RunnableWithPriority> getRunnableQueue() {
                return Desktop.this.runnableQueue;
            }

            @Override
            protected void collectPositions(Map<String, Map<String, double[]>> positions) {
                Desktop.this.collectPositions(tableBrowser, positions);
            }
        };
        Rectangle r = this.layout(parentRowIndex < 0, parent, association, browserContentPane, new ArrayList<RowBrowser>(), 0, -1);
        browserContentPane.rowsTableScrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                Desktop.this.onMouseWheelMoved(evt);
                Desktop.this.onMouseWheelMoved(evt, browserContentPane.rowsTableScrollPane);
            }
        });
        jInternalFrame.setBounds(r);
        tableBrowser.internalFrame = jInternalFrame;
        tableBrowser.browserContentPane = browserContentPane;
        tableBrowser.rowIndex = parentRowIndex;
        tableBrowser.parent = parent;
        tableBrowser.association = association;
        if (association != null) {
            tableBrowser.color = this.getAssociationColor(association);
        }
        this.tableBrowsers.add(tableBrowser);
        this.initIFrame(jInternalFrame, browserContentPane);
        jInternalFrame.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
                Desktop.this.repaintDesktop();
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
                Desktop.this.repaintDesktop();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                Desktop.this.close(tableBrowser, true);
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
            }
        });
        this.checkDesktopSize();
        this.scrollToCenter(jInternalFrame);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException e1) {
            // empty catch block
        }
        if (browserContentPane.sqlBrowserContentPane != null) {
            if (this.layoutMode == LayoutMode.THUMBNAIL || this.layoutMode == LayoutMode.TINY) {
                try {
                    jInternalFrame.setMaximum(true);
                }
                catch (PropertyVetoException e1) {
                    // empty catch block
                }
            }
            browserContentPane.sqlBrowserContentPane.sqlEditorPane.grabFocus();
        } else {
            browserContentPane.andCondition.grabFocus();
        }
        this.updateMenu();
        return tableBrowser;
    }

    private void demaximize() {
        for (RowBrowser rb : this.tableBrowsers) {
            try {
                rb.internalFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    private void initIFrame(final JInternalFrame jInternalFrame, final BrowserContentPane browserContentPane) {
        final JPanel thumbnail = new JPanel();
        JPanel thumbnailInner = new JPanel();
        thumbnail.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        thumbnail.add((Component)thumbnailInner, gridBagConstraints);
        thumbnailInner.setLayout(new FlowLayout(1, 0, 0));
        String title = jInternalFrame.getTitle();
        String suffix = null;
        Pattern tPat = Pattern.compile("^(.*)(\\([0-9]+\\))$");
        Matcher matcher = tPat.matcher(title);
        if (matcher.matches()) {
            title = matcher.group(1);
            suffix = matcher.group(2);
        }
        ArrayList<String> labels = new ArrayList<String>();
        final ArrayList<JLabel> jLabels = new ArrayList<JLabel>();
        for (int i = 0; i < title.length(); ++i) {
            labels.add(title.substring(i, i + 1));
        }
        if (suffix != null) {
            labels.add(suffix);
        }
        for (String l : labels) {
            JLabel jl = new JLabel(l);
            jLabels.add(jl);
            thumbnailInner.add(jl);
        }
        browserContentPane.setOnReloadAction(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (browserContentPane.rows == null) break block4;
                    if (browserContentPane.rows.size() == 0) {
                        for (JLabel l : jLabels) {
                            l.setForeground(Color.GRAY);
                        }
                    } else {
                        for (JLabel l : jLabels) {
                            l.setForeground(Color.BLACK);
                        }
                    }
                }
            }
        });
        jInternalFrame.getContentPane().setLayout(new CardLayout());
        jInternalFrame.getContentPane().add((Component)browserContentPane, "C");
        jInternalFrame.getContentPane().add((Component)thumbnail, "T");
        thumbnail.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JPopupMenu popup = browserContentPane.createPopupMenu(null, -1, 0, 0, false);
                JPopupMenu popup2 = browserContentPane.createSqlPopupMenu(null, -1, 0, 0, true);
                popup.add(new JSeparator());
                for (Component c : popup2.getComponents()) {
                    popup.add(c);
                }
                UIUtil.fit(popup);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.initIFrameContent(jInternalFrame, browserContentPane, thumbnail);
        jInternalFrame.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Desktop.this.initIFrameContent(jInternalFrame, browserContentPane, thumbnail);
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
    }

    private void initIFrameContent(JInternalFrame jInternalFrame, BrowserContentPane browserContentPane, JPanel thumbnail) {
        if (jInternalFrame.getWidth() < 150 || jInternalFrame.getHeight() < 150) {
            ((CardLayout)jInternalFrame.getContentPane().getLayout()).show(jInternalFrame.getContentPane(), "T");
        } else {
            ((CardLayout)jInternalFrame.getContentPane().getLayout()).show(jInternalFrame.getContentPane(), "C");
        }
    }

    private Color getAssociationColor(Association association) {
        Color color = new Color(0, 100, 255);
        if (association.isInsertDestinationBeforeSource()) {
            color = new Color(170, 0, 0);
        }
        if (association.isInsertSourceBeforeDestination()) {
            color = new Color(0, 112, 0);
        }
        if (association.isIgnored()) {
            color = new Color(153, 153, 153);
        }
        return color;
    }

    private Rectangle layout(boolean fullSize, RowBrowser parent, Association association, BrowserContentPane browserContentPane, Collection<RowBrowser> ignore, int maxH, int xPosition) {
        boolean ok;
        int x = (int)(0.0 * this.layoutMode.factor);
        int y = (int)(0.0 * this.layoutMode.factor);
        while (parent != null && parent.isHidden()) {
            parent = parent.parent;
        }
        if (parent != null) {
            x = (int)((double)(parent.internalFrame.getX() + parent.internalFrame.getWidth()) + 64.0 * this.layoutMode.factor);
            y = parent.internalFrame.getY();
        }
        if (maxH > 0) {
            y = maxH;
        }
        if (xPosition >= 0) {
            x = (int)((double)(xPosition * 540) * this.layoutMode.factor);
        }
        int h = (int)(460.0 * this.layoutMode.factor);
        Rectangle r = new Rectangle(x, y, (int)(476.0 * this.layoutMode.factor), h);
        do {
            ok = true;
            for (RowBrowser tb : this.tableBrowsers) {
                if (ignore.contains(tb) || tb.isHidden() || !tb.internalFrame.getBounds().intersects(r)) continue;
                ok = false;
                break;
            }
            r = new Rectangle(x, y, (int)(476.0 * this.layoutMode.factor), h);
            y = (int)((double)y + 8.0 * this.layoutMode.factor);
        } while (!ok);
        return r;
    }

    protected synchronized void updateChildren(RowBrowser tableBrowser, List<Row> rows) {
        boolean hasParent = false;
        tableBrowser.browserContentPane.highlightedRows.clear();
        block0: for (RowBrowser rowBrowser : this.tableBrowsers) {
            if (rowBrowser == tableBrowser.parent) {
                hasParent = true;
            }
            if (rowBrowser.parent != tableBrowser) continue;
            rowBrowser.rowIndex = -1;
            for (int i = 0; i < rows.size(); ++i) {
                if (rowBrowser.browserContentPane.parentRow == null || !rowBrowser.browserContentPane.parentRow.rowId.equals(rows.get((int)i).rowId)) continue;
                rowBrowser.rowIndex = i;
                tableBrowser.browserContentPane.highlightedRows.add(i);
                continue block0;
            }
        }
        if (!hasParent) {
            tableBrowser.rowToRowLinks.clear();
        } else {
            IdentityHashMap<Row, Integer> rowIndex = new IdentityHashMap<Row, Integer>();
            HashMap<String, Integer> rowIDIndex = new HashMap<String, Integer>();
            IdentityHashMap<Row, Integer> parentRowIndex = new IdentityHashMap<Row, Integer>();
            HashMap<String, Integer> parentRowIDIndex = new HashMap<String, Integer>();
            for (int i = 0; i < rows.size(); ++i) {
                Integer iI = i;
                Row r = rows.get(i);
                rowIndex.put(r, iI);
                rowIDIndex.put(r.rowId, iI);
            }
            List<Row> parentRows = tableBrowser.parent.browserContentPane.rows;
            for (int i = 0; i < parentRows.size(); ++i) {
                Integer iI = i;
                Row r = parentRows.get(i);
                parentRowIndex.put(r, iI);
                parentRowIDIndex.put(r.rowId, iI);
            }
            for (RowToRowLink rowToRowLink : tableBrowser.rowToRowLinks) {
                rowToRowLink.childRowIndex = -1;
                Integer i = (Integer)rowIndex.get(rowToRowLink.childRow);
                if (i != null) {
                    rowToRowLink.childRowIndex = i;
                }
                if (rowToRowLink.childRowIndex < 0 && (i = (Integer)rowIDIndex.get(rowToRowLink.childRow.rowId)) != null) {
                    rowToRowLink.childRowIndex = i;
                }
                rowToRowLink.parentRowIndex = -1;
                i = (Integer)parentRowIndex.get(rowToRowLink.parentRow);
                if (i != null) {
                    rowToRowLink.parentRowIndex = i;
                }
                if (rowToRowLink.parentRowIndex >= 0 || (i = (Integer)parentRowIDIndex.get(rowToRowLink.parentRow.rowId)) == null) continue;
                rowToRowLink.parentRowIndex = i;
            }
        }
    }

    private void repaintDesktop() {
        this.calculateLinks();
        JScrollPane scrollPane = this.getScrollPane();
        scrollPane.setSize(scrollPane.getWidth() + 1, scrollPane.getHeight() + 1);
        scrollPane.setSize(scrollPane.getWidth() - 1, scrollPane.getHeight() - 1);
        scrollPane.invalidate();
        scrollPane.validate();
    }

    private synchronized boolean calculateLinks() {
        boolean changed = false;
        for (RowBrowser tableBrowser : this.tableBrowsers) {
            int max;
            JInternalFrame internalFrame = tableBrowser.internalFrame;
            if (internalFrame.isMaximum()) {
                changed = this.renderLinks;
                this.renderLinks = false;
                if (changed) {
                    this.rbSourceToLinks = null;
                }
                return changed;
            }
            if (tableBrowser.parent == null) continue;
            int BORDER = 6;
            int BOT_H = 32;
            int x1 = internalFrame.getX() + internalFrame.getWidth() / 2;
            int y1 = internalFrame.getY() + internalFrame.getHeight() / 2;
            RowBrowser visParent = tableBrowser.parent;
            while (visParent != null && visParent.isHidden()) {
                visParent = visParent.parent;
            }
            if (visParent == null) {
                visParent = tableBrowser.parent;
            }
            int midx = visParent.internalFrame.getX() + visParent.internalFrame.getWidth() / 2;
            Rectangle cellRect = new Rectangle();
            boolean ignoreScrolling = false;
            int i = 0;
            if (tableBrowser.rowIndex >= 0) {
                i = tableBrowser.parent.browserContentPane.rowsTable.getRowSorter().convertRowIndexToView(tableBrowser.rowIndex);
                cellRect = tableBrowser.parent.browserContentPane.rowsTable.getCellRect(i, 0, true);
                if (tableBrowser.parent.browserContentPane.rows != null && tableBrowser.parent.browserContentPane.rows.size() == 1) {
                    cellRect.setBounds(cellRect.x, 0, cellRect.width, Math.min(cellRect.height, 20));
                    ignoreScrolling = true;
                }
            }
            int x2 = visParent.internalFrame.getX();
            int y = cellRect.y;
            y = cellRect.height * i;
            int y2 = visParent.internalFrame.getY() + y + Math.min(cellRect.height / 2, 100);
            x2 += visParent.internalFrame.getWidth() - BORDER;
            Container p = visParent.browserContentPane.rowsTable;
            if (ignoreScrolling) {
                p = p.getParent();
            }
            while (p != visParent.internalFrame) {
                y2 += p.getY();
                p = p.getParent();
            }
            int min = visParent.internalFrame.getY() + Math.min(cellRect.height, 20);
            if (y2 < min) {
                y2 = min;
            }
            if (y2 > (max = visParent.internalFrame.getY() + visParent.internalFrame.getHeight() - BOT_H)) {
                y2 = max;
            }
            if (tableBrowser.rowIndex < 0) {
                y2 = visParent.internalFrame.getY() + visParent.internalFrame.getHeight() / 2;
            }
            if (x1 != tableBrowser.x1 || y1 != tableBrowser.y1 || x2 != tableBrowser.x2 || y2 != tableBrowser.y2) {
                changed = true;
                tableBrowser.x1 = x1;
                tableBrowser.y1 = y1;
                tableBrowser.x2 = x2;
                tableBrowser.y2 = y2;
            }
            for (RowToRowLink rowToRowLink : tableBrowser.rowToRowLinks) {
                y2 = -1;
                x2 = -1;
                y1 = -1;
                x1 = -1;
                try {
                    if (rowToRowLink.childRowIndex >= 0 && rowToRowLink.parentRowIndex >= 0) {
                        int drr;
                        int drl;
                        int dlr;
                        int dll;
                        int dmin;
                        cellRect = new Rectangle();
                        i = 0;
                        visParent = tableBrowser.parent;
                        while (visParent != null && visParent.isHidden()) {
                            visParent = visParent.parent;
                        }
                        if (visParent == null) {
                            visParent = tableBrowser.parent;
                        }
                        boolean r2 = (dmin = Math.min(dll = Math.abs(visParent.internalFrame.getX() - internalFrame.getX()), Math.min(dlr = Math.abs(visParent.internalFrame.getX() - (internalFrame.getX() + internalFrame.getWidth())), Math.min(drl = Math.abs(visParent.internalFrame.getX() + visParent.internalFrame.getWidth() - internalFrame.getX()), drr = Math.abs(visParent.internalFrame.getX() + visParent.internalFrame.getWidth() - (internalFrame.getX() + internalFrame.getWidth())))))) == drl || dmin == drr;
                        boolean r1 = dmin == dlr || dmin == drr;
                        ignoreScrolling = false;
                        if (rowToRowLink.childRowIndex >= 0) {
                            i = tableBrowser.browserContentPane.rowsTable.getRowSorter().convertRowIndexToView(rowToRowLink.childRowIndex);
                            cellRect = tableBrowser.browserContentPane.rowsTable.getCellRect(i, 0, true);
                            if (tableBrowser.browserContentPane.rows != null && tableBrowser.browserContentPane.rows.size() == 1) {
                                cellRect.setBounds(cellRect.x, 0, cellRect.width, Math.min(cellRect.height, 20));
                                ignoreScrolling = true;
                            }
                        }
                        x1 = internalFrame.getX();
                        y = cellRect.height * i;
                        y1 = internalFrame.getY() + y + cellRect.height / 2;
                        x1 += BORDER;
                        p = tableBrowser.browserContentPane.rowsTable;
                        if (ignoreScrolling) {
                            p = p.getParent();
                        }
                        while (p != internalFrame) {
                            y1 += p.getY();
                            p = p.getParent();
                        }
                        min = internalFrame.getY() + cellRect.height;
                        if (y1 < min) {
                            y1 = min;
                        }
                        if (y1 > (max = internalFrame.getY() + internalFrame.getHeight() - BOT_H)) {
                            y1 = max;
                        }
                        ignoreScrolling = false;
                        cellRect = new Rectangle();
                        i = 0;
                        if (rowToRowLink.parentRowIndex >= 0) {
                            i = tableBrowser.parent.browserContentPane.rowsTable.getRowSorter().convertRowIndexToView(rowToRowLink.parentRowIndex);
                            cellRect = tableBrowser.parent.browserContentPane.rowsTable.getCellRect(i, 0, true);
                            if (tableBrowser.parent.browserContentPane.rows != null && tableBrowser.parent.browserContentPane.rows.size() == 1) {
                                cellRect.setBounds(cellRect.x, 0, cellRect.width, Math.min(cellRect.height, 20));
                                ignoreScrolling = true;
                            }
                        }
                        x2 = visParent.internalFrame.getX();
                        y = cellRect.height * i;
                        y2 = visParent.internalFrame.getY() + y + cellRect.height / 2;
                        x2 += visParent.internalFrame.getWidth() - BORDER;
                        p = visParent.browserContentPane.rowsTable;
                        if (ignoreScrolling) {
                            p = p.getParent();
                        }
                        while (p != visParent.internalFrame) {
                            y2 += p.getY();
                            p = p.getParent();
                        }
                        min = visParent.internalFrame.getY() + cellRect.height;
                        if (y2 < min) {
                            y2 = min;
                        }
                        if (y2 > (max = visParent.internalFrame.getY() + visParent.internalFrame.getHeight() - BOT_H)) {
                            y2 = max;
                        }
                    }
                    if (x1 == rowToRowLink.x1 && y1 == rowToRowLink.y1 && x2 == rowToRowLink.x2 && y2 == rowToRowLink.y2) continue;
                    changed = true;
                    rowToRowLink.x1 = x1;
                    rowToRowLink.y1 = y1;
                    rowToRowLink.x2 = x2;
                    rowToRowLink.y2 = y2;
                }
                catch (Exception e) {}
            }
        }
        if (!this.renderLinks) {
            changed = true;
        }
        this.renderLinks = true;
        if (this.lastPTS + 1000L < System.currentTimeMillis()) {
            changed = true;
        }
        if (changed) {
            this.lastPTS = System.currentTimeMillis();
        }
        if (changed) {
            this.rbSourceToLinks = null;
        }
        return changed;
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        super.paint(graphics);
        if (graphics instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)graphics;
            if (this.renderLinks) {
                if (this.rbSourceToLinks == null) {
                    this.rbSourceToLinks = new HashMap<RowBrowser, Map<String, List<Link>>>();
                    String ALL = "-";
                    for (RowBrowser tableBrowser : this.tableBrowsers) {
                        TreeMap<String, ArrayList<Link>> links = new TreeMap<String, ArrayList<Link>>();
                        this.rbSourceToLinks.put(tableBrowser, links);
                        if (tableBrowser.internalFrame.isIcon() || tableBrowser.parent != null && tableBrowser.parent.internalFrame.isIcon()) continue;
                        Color color = tableBrowser.color;
                        if (tableBrowser.parent != null && (tableBrowser.rowIndex >= 0 || tableBrowser.rowToRowLinks.isEmpty())) {
                            String sourceRowID = "-";
                            String destRowID = "-";
                            if (tableBrowser.browserContentPane.parentRow != null) {
                                destRowID = tableBrowser.browserContentPane.parentRow.rowId;
                            }
                            Link link = new Link(tableBrowser, tableBrowser.parent, sourceRowID, destRowID, tableBrowser.x1, tableBrowser.y1, tableBrowser.x2, tableBrowser.y2, color, tableBrowser.parent == null || tableBrowser.rowIndex < 0, true);
                            ArrayList<Link> l = (ArrayList<Link>)links.get(sourceRowID);
                            if (l == null) {
                                l = new ArrayList<Link>();
                                links.put(sourceRowID, l);
                            }
                            l.add(link);
                        }
                        for (RowToRowLink rowToRowLink : tableBrowser.rowToRowLinks) {
                            if (rowToRowLink.x1 < 0) continue;
                            String sourceRowID = rowToRowLink.childRow.rowId;
                            String destRowID = rowToRowLink.parentRow.rowId;
                            if (!(tableBrowser.isHidden() || tableBrowser.parent != null && tableBrowser.parent.isHidden())) {
                                sourceRowID = "";
                            }
                            Link link = new Link(tableBrowser, tableBrowser.parent, sourceRowID, destRowID, rowToRowLink.x1, rowToRowLink.y1, rowToRowLink.x2, rowToRowLink.y2, color, false, false);
                            ArrayList<Link> l = (ArrayList<Link>)links.get(sourceRowID);
                            if (l == null) {
                                l = new ArrayList<Link>();
                                links.put(sourceRowID, l);
                            }
                            l.add(link);
                        }
                    }
                    ArrayList<Object> toJoinList = new ArrayList<Object>();
                    for (RowBrowser tableBrowser : this.tableBrowsers) {
                        if (tableBrowser.parent == null || !tableBrowser.parent.isHidden()) continue;
                        ArrayList<Link> newLinks = new ArrayList<Link>();
                        Map<String, List<Link>> links = this.rbSourceToLinks.get(tableBrowser);
                        for (Map.Entry<String, List<Link>> e : links.entrySet()) {
                            for (Link link : e.getValue()) {
                                List<Object> ll;
                                link.visible = false;
                                if (link.destRowID == "-") {
                                    ll = new ArrayList();
                                    for (List<Link> list : this.rbSourceToLinks.get(link.to).values()) {
                                        for (Link l : list) {
                                            ll.add(l);
                                        }
                                    }
                                } else {
                                    ll = this.rbSourceToLinks.get(link.to).get(link.destRowID);
                                }
                                toJoinList.clear();
                                if (ll != null) {
                                    toJoinList.addAll(ll);
                                }
                                if ((ll = this.rbSourceToLinks.get(link.to).get("-")) != null) {
                                    toJoinList.addAll(ll);
                                }
                                for (Link link2 : toJoinList) {
                                    link2.visible = false;
                                    Color color = Color.black;
                                    boolean intersect = link.intersect;
                                    boolean dotted = link.dotted || link2.dotted;
                                    newLinks.add(new Link(link.from, link2.to, link.sourceRowID, link2.destRowID, link.x1, link.y1, link2.x2, link2.y2, color, dotted, intersect));
                                }
                            }
                        }
                        for (Link link : newLinks) {
                            links.get(link.sourceRowID).add(link);
                        }
                    }
                }
                Boolean[] arr$ = new Boolean[]{true, false};
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    boolean pbg = arr$[i$];
                    HashSet<Long> linesHash = new HashSet<Long>(200000);
                    for (RowBrowser tableBrowser : this.rbSourceToLinks.keySet()) {
                        if (tableBrowser.isHidden()) continue;
                        Map<String, List<Link>> links = this.rbSourceToLinks.get(tableBrowser);
                        for (Map.Entry<String, List<Link>> e : links.entrySet()) {
                            for (Link link : e.getValue()) {
                                if (!link.visible || link.from.isHidden() || link.to.isHidden()) continue;
                                Color color = pbg ? Color.white : link.color;
                                Point2D.Double start = new Point2D.Double(link.x2, link.y2);
                                Point2D.Double end = new Point2D.Double(link.x1, link.y1);
                                this.paintLink(start, end, color, g2d, tableBrowser, pbg, link.intersect, linesHash, link.dotted);
                            }
                        }
                    }
                }
            }
        }
    }

    private void paintLink(Point2D start, Point2D end, Color color, Graphics2D g2d, RowBrowser tableBrowser, boolean pbg, boolean intersect, Set<Long> lineHashes, boolean dotted) {
        double w;
        g2d.setColor(color);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(!intersect ? (float)(pbg ? 3 : 1) : (float)(pbg ? 5 : 3));
        g2d.setStroke(dotted ? new BasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), new float[]{2.0f, 6.0f}, 1.0f) : stroke);
        AffineTransform t = new AffineTransform();
        t.setToRotation(0.7853981633974483);
        Point2D.Double p = new Point2D.Double();
        Point2D.Double shift = new Point2D.Double();
        double d = start.distance(end) / 3.0;
        ((Point2D)p).setLocation((end.getX() - start.getX()) / d, (end.getY() - start.getY()) / d);
        t.transform(p, shift);
        start.setLocation(start.getX() + ((Point2D)shift).getX(), start.getY() + ((Point2D)shift).getY());
        end.setLocation(end.getX() + ((Point2D)shift).getX(), end.getY() + ((Point2D)shift).getY());
        if (intersect) {
            Point2D[] sect = new Point2D[10];
            int i = GraphicsLib.intersectLineRectangle(start, end, tableBrowser.internalFrame.getBounds(), sect);
            if (i == 0) {
                return;
            }
            end = sect[0];
        }
        if (start.distance(end) < 2.0) {
            return;
        }
        long lineHash = (long)start.hashCode() + 0x80000000L * (long)end.hashCode();
        if (lineHashes.contains(lineHash)) {
            return;
        }
        lineHashes.add(lineHash);
        this.m_arrowHead = new Polygon();
        double ws = 0.5;
        double hs = 0.6666666666666666;
        double h = w = !intersect ? (double)(pbg ? 3 : 3) : (double)(pbg ? 3 : 3);
        this.m_arrowHead.addPoint(0, 0);
        this.m_arrowHead.addPoint((int)(ws * -w), (int)(hs * -h));
        this.m_arrowHead.addPoint((int)(ws * w), (int)(hs * -h));
        this.m_arrowHead.addPoint(0, 0);
        AffineTransform at = this.getArrowTrans(start, end, 10.0);
        Shape m_curArrow = at.createTransformedShape(this.m_arrowHead);
        Point2D lineEnd = end;
        lineEnd.setLocation(0.0, -2.0);
        at.transform(lineEnd, lineEnd);
        g2d.drawLine((int)start.getX(), (int)start.getY(), (int)end.getX(), (int)end.getY());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.fill(m_curArrow);
        if (pbg) {
            g2d.draw(m_curArrow);
        }
    }

    protected AffineTransform getArrowTrans(Point2D p1, Point2D p2, double width) {
        AffineTransform m_arrowTrans = new AffineTransform();
        m_arrowTrans.setToTranslation(p2.getX(), p2.getY());
        m_arrowTrans.rotate(-1.5707963267948966 + Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX()));
        if (width > 1.0) {
            double scalar = width / 2.0;
            m_arrowTrans.scale(scalar, scalar);
        }
        return m_arrowTrans;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    public Component add(JInternalFrame frame) {
        Point p;
        JInternalFrame[] array = this.getAllFrames();
        Component retval = super.add(frame);
        this.checkDesktopSize();
        if (array.length > 0) {
            p = array[0].getLocation();
            p.x += FRAME_OFFSET;
            p.y += FRAME_OFFSET;
        } else {
            p = new Point(0, 0);
        }
        frame.setLocation(p.x, p.y);
        if (frame.isResizable()) {
            int w = this.getWidth() - this.getWidth() / 3;
            int h = this.getHeight() - this.getHeight() / 3;
            if ((double)w < frame.getMinimumSize().getWidth()) {
                w = (int)frame.getMinimumSize().getWidth();
            }
            if ((double)h < frame.getMinimumSize().getHeight()) {
                h = (int)frame.getMinimumSize().getHeight();
            }
            frame.setSize(w, h);
        }
        this.moveToFront(frame);
        frame.setVisible(true);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            frame.toBack();
        }
        return retval;
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.checkDesktopSize();
    }

    public void cascadeFrames() {
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
        int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
        for (int i = allFrames.length - 1; i >= 0; --i) {
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            x += FRAME_OFFSET;
            y += FRAME_OFFSET;
        }
    }

    public void tileFrames() {
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height / allFrames.length;
        int y = 0;
        for (int i = 0; i < allFrames.length; ++i) {
            allFrames[i].setSize(this.getBounds().width, frameHeight);
            allFrames[i].setLocation(0, y);
            y += frameHeight;
        }
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }

    private JScrollPane getScrollPane() {
        JViewport viewPort;
        if (this.getParent() instanceof JViewport && (viewPort = (JViewport)this.getParent()).getParent() instanceof JScrollPane) {
            return (JScrollPane)viewPort.getParent();
        }
        return null;
    }

    public synchronized void stop() {
        this.running = false;
        desktops.remove(this);
        for (RowBrowser rb : this.tableBrowsers) {
            rb.browserContentPane.cancelLoadJob(false);
        }
        if (this.session != null) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Session session = Desktop.this.session;
                        synchronized (session) {
                            Desktop.this.session.shutDown();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }).start();
        }
    }

    public void layoutBrowser() {
        JInternalFrame selectedFrame = this.getSelectedFrame();
        ArrayList<RowBrowser> all = new ArrayList<RowBrowser>(this.tableBrowsers);
        this.layout(all, 0);
        this.optimizeLayout();
        all.clear();
        int maxH = 0;
        for (RowBrowser rb : this.tableBrowsers) {
            if (rb.browserContentPane.table instanceof BrowserContentPane.SqlStatementTable) {
                all.add(rb);
                continue;
            }
            maxH = Math.max(maxH, rb.internalFrame.getBounds().y + rb.internalFrame.getBounds().height);
        }
        this.layout(all, maxH + (int)(16.0 * this.layoutMode.factor));
        this.checkDesktopSize();
        if (selectedFrame != null) {
            try {
                selectedFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            this.scrollToCenter(selectedFrame);
        }
    }

    private void layout(List<RowBrowser> toLayout, int maxH) {
        ArrayList<RowBrowser> roots = new ArrayList<RowBrowser>();
        for (RowBrowser rb : toLayout) {
            if (rb.parent != null) continue;
            roots.add(rb);
        }
        while (!roots.isEmpty()) {
            ArrayList<RowBrowser> nextColumn = new ArrayList<RowBrowser>();
            int i = 0;
            for (RowBrowser rb : roots) {
                try {
                    rb.internalFrame.setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
                int xPosition = -1;
                if (maxH > 0) {
                    xPosition = i;
                }
                rb.internalFrame.setBounds(this.layout(rb.rowIndex < 0, rb.parent, rb.association, rb.browserContentPane, toLayout, maxH, xPosition));
                rb.browserContentPane.adjustRowTableColumnsWidth();
                toLayout.remove(rb);
                for (RowBrowser rbc : toLayout) {
                    if (rbc.parent != rb) continue;
                    nextColumn.add(rbc);
                }
                ++i;
            }
            roots = nextColumn;
        }
    }

    private void optimizeLayout() {
        TreeLayoutOptimizer.Node<Object> root = new TreeLayoutOptimizer.Node<Object>(null);
        this.collectChildren(root);
        TreeLayoutOptimizer.optimizeTreeLayout(root);
        this.arrangeNodes(root);
    }

    private void collectChildren(TreeLayoutOptimizer.Node<RowBrowser> root) {
        List<RowBrowser> children = root.getUserObject() == null ? this.getRootBrowsers(true) : this.getChildBrowsers(root.getUserObject(), true);
        for (RowBrowser rb : children) {
            if (rb.browserContentPane.table instanceof BrowserContentPane.SqlStatementTable) continue;
            TreeLayoutOptimizer.Node<RowBrowser> childNode = new TreeLayoutOptimizer.Node<RowBrowser>(rb);
            root.addChild(childNode);
            this.collectChildren(childNode);
        }
    }

    private void arrangeNodes(TreeLayoutOptimizer.Node<RowBrowser> root) {
        if (root.getUserObject() != null) {
            JInternalFrame iFrame = root.getUserObject().internalFrame;
            int x = (int)(0.0 * this.layoutMode.factor);
            int y = (int)(0.0 * this.layoutMode.factor);
            int h = (int)(460.0 * this.layoutMode.factor);
            Rectangle r = new Rectangle(x += (root.getLevel() - 1) * (int)(540.0 * this.layoutMode.factor), y += (int)(root.getPosition() * 468.0 * this.layoutMode.factor), (int)(476.0 * this.layoutMode.factor), h);
            iFrame.setBounds(r);
        }
        for (TreeLayoutOptimizer.Node<RowBrowser> child : root.getChildren()) {
            this.arrangeNodes(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescaleLayout(LayoutMode layoutMode, Point fixed) {
        double scale = layoutMode.factor / this.layoutMode.factor;
        if (fixed == null) {
            fixed = new Point(this.getVisibleRect().x + this.getVisibleRect().width / 2, this.getVisibleRect().y + this.getVisibleRect().height / 2);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.layoutMode = layoutMode;
            HashMap<Rectangle, double[]> newPrecBounds = new HashMap<Rectangle, double[]>();
            for (RowBrowser rb : new ArrayList<RowBrowser>(this.tableBrowsers)) {
                Rectangle bounds;
                double[] pBounds;
                if (rb.internalFrame.isMaximum()) {
                    try {
                        rb.internalFrame.setMaximum(false);
                    }
                    catch (PropertyVetoException e) {
                        // empty catch block
                    }
                }
                pBounds = (pBounds = this.precBounds.get(bounds = rb.internalFrame.getBounds())) == null ? new double[]{(double)bounds.x * scale, (double)bounds.y * scale, (double)bounds.width * scale, (double)bounds.height * scale} : new double[]{pBounds[0] * scale, pBounds[1] * scale, pBounds[2] * scale, pBounds[3] * scale};
                Rectangle newBounds = new Rectangle((int)pBounds[0], (int)pBounds[1], (int)pBounds[2], (int)pBounds[3]);
                rb.internalFrame.setBounds(newBounds);
                rb.browserContentPane.adjustRowTableColumnsWidth();
                newPrecBounds.put(newBounds, pBounds);
            }
            this.precBounds = newPrecBounds;
            this.manager.resizeDesktop();
            Rectangle vr = new Rectangle(Math.max(0, (int)((double)fixed.x * scale - (double)(this.getVisibleRect().width / 2))), Math.max(0, (int)((double)fixed.y * scale - (double)(this.getVisibleRect().height / 2))), this.getVisibleRect().width, this.getVisibleRect().height);
            this.scrollRectToVisible(vr);
            this.updateMenu(layoutMode);
            this.adjustClosure(null);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void onMouseWheelMoved(MouseWheelEvent e, JScrollPane scrollPane) {
        if (!e.isControlDown() && e.getScrollAmount() != 0 && e.getScrollType() == 0) {
            JScrollBar toScroll = scrollPane.getVerticalScrollBar();
            int direction = 0;
            if (!(toScroll != null && toScroll.isVisible() && (e.getModifiers() & 8) == 0 || (toScroll = scrollPane.getHorizontalScrollBar()) != null && toScroll.isVisible())) {
                return;
            }
            if (e.getWheelRotation() != 0) {
                direction = e.getWheelRotation() < 0 ? -1 : 1;
            }
            double f = 1.0;
            if (this.getPreciseWheelRotation != null) {
                try {
                    double pwr = (Double)this.getPreciseWheelRotation.invoke((Object)e, new Object[0]);
                    direction = pwr == 0.0 ? 0 : (pwr < 0.0 ? -1 : 1);
                    f = Math.abs(pwr);
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            if (direction != 0) {
                int oldValue = toScroll.getValue();
                int blockIncrement = toScroll.getUnitIncrement(direction);
                int delta = (int)(f * (double)blockIncrement * (double)(direction > 0 ? 1 : -1));
                int newValue = oldValue + delta;
                if (delta > 0 && newValue < oldValue) {
                    newValue = toScroll.getMaximum();
                } else if (delta < 0 && newValue > oldValue) {
                    newValue = toScroll.getMinimum();
                }
                toScroll.setValue(newValue);
            }
        }
    }

    void onMouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            int d = 0;
            if (e.getWheelRotation() < 0) {
                d = -1;
            }
            if (e.getWheelRotation() > 0) {
                d = 1;
            }
            if (d != 0) {
                for (RowBrowser rb : new ArrayList<RowBrowser>(this.tableBrowsers)) {
                    if (!rb.internalFrame.isMaximum()) continue;
                    return;
                }
                if ((d += this.layoutMode.ordinal()) >= 0 && d < LayoutMode.values().length) {
                    Point fixed = SwingUtilities.convertPoint(e.getComponent(), e.getPoint().x, e.getPoint().y, this);
                    this.rescaleLayout(LayoutMode.values()[d], fixed);
                }
            }
        }
    }

    public void closeAll() {
        this.closeAll(new ArrayList<RowBrowser>(this.tableBrowsers));
    }

    public void closeAll(Collection<RowBrowser> toClose) {
        for (RowBrowser rb : toClose) {
            this.close(rb, false);
            this.getDesktopManager().closeFrame(rb.internalFrame);
        }
        this.updateMenu();
    }

    private void close(RowBrowser tableBrowser, boolean convertChildrenToRoots) {
        ArrayList<RowBrowser> children = new ArrayList<RowBrowser>();
        for (RowBrowser tb : this.tableBrowsers) {
            if (tb.parent != tableBrowser) continue;
            tb.parent = null;
            children.add(tb);
        }
        this.tableBrowsers.remove(tableBrowser);
        tableBrowser.browserContentPane.cancelLoadJob(true);
        if (convertChildrenToRoots) {
            for (RowBrowser child : children) {
                child.convertToRoot();
            }
        }
        for (RowBrowser rb : this.tableBrowsers) {
            this.updateChildren(rb, rb.browserContentPane.rows);
        }
        this.repaintDesktop();
        this.updateMenu();
    }

    public void reloadDataModel(Map<String, String> schemamapping) throws Exception {
        this.reloadDataModel(schemamapping, true);
    }

    public void reloadDataModel(Map<String, String> schemamapping, boolean forAll) throws Exception {
        try {
            Container pFrame = SwingUtilities.getWindowAncestor(this);
            if (pFrame == null) {
                pFrame = this;
            }
            String filename = ".tempsession-" + System.currentTimeMillis();
            this.storeSession(filename);
            DataModel newModel = new DataModel(schemamapping);
            this.datamodel.set(newModel);
            this.restoreSession(null, pFrame, filename);
            File file = new File(filename);
            file.delete();
        }
        catch (Throwable e) {
            UIUtil.showException(this, "Error", e);
        }
        if (forAll) {
            for (Desktop desktop : desktops) {
                if (desktop == this) continue;
                desktop.reloadDataModel(desktop.schemaMapping, false);
            }
        }
    }

    public void reloadRoots() throws Exception {
        for (RowBrowser rb : this.tableBrowsers) {
            if (rb.browserContentPane == null || rb.parent != null) continue;
            rb.browserContentPane.reloadRows();
        }
    }

    public abstract void openSchemaAnalyzer();

    public void openSchemaMappingDialog(boolean silent) {
        try {
            Map<String, String> mapping = this.schemaMapping;
            if (this.loadSchemaMapping || silent) {
                mapping = SchemaMappingDialog.restore(this.dbConnectionDialog);
                this.loadSchemaMapping = false;
            }
            if (!silent) {
                SchemaMappingDialog schemaMappingDialog = new SchemaMappingDialog(this.parentFrame, this.datamodel.get(), this.dbConnectionDialog, this.session, mapping);
                mapping = schemaMappingDialog.getMapping();
            }
            if (mapping != null) {
                SchemaMappingDialog.store(mapping, this.dbConnectionDialog);
                this.schemaMapping.clear();
                this.schemaMapping.putAll(mapping);
                this.parentFrame.updateStatusBar();
                this.reloadDataModel(mapping, !silent);
                this.reloadRoots();
            }
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    public void createExtractionModel() {
        TreeSet<String> titles = new TreeSet<String>();
        HashMap<String, RowBrowser> rowBrowserByTitle = new HashMap<String, RowBrowser>();
        for (RowBrowser rb : this.tableBrowsers) {
            if (rb.browserContentPane.table == null || rb.browserContentPane.table instanceof BrowserContentPane.SqlStatementTable) continue;
            titles.add(rb.internalFrame.getTitle());
            rowBrowserByTitle.put(rb.internalFrame.getTitle(), rb);
        }
        String s = (String)JOptionPane.showInputDialog(this.parentFrame, "Select subject table", "Subject", 3, null, titles.toArray(), null);
        if (s != null) {
            ((RowBrowser)rowBrowserByTitle.get((Object)s)).browserContentPane.openExtractionModelEditor();
        }
    }

    void updateMenu() {
        boolean hasTableBrowser = false;
        boolean hasIFrame = false;
        for (RowBrowser rb : this.tableBrowsers) {
            hasIFrame = true;
            if (rb.browserContentPane.table instanceof BrowserContentPane.SqlStatementTable) continue;
            hasTableBrowser = true;
        }
        this.updateMenu(hasTableBrowser, hasIFrame);
    }

    protected void updateMenu(boolean hasTableBrowser, boolean hasIFrame) {
        if (!hasIFrame && !hasTableBrowser) {
            this.currentSessionFileName = null;
        }
    }

    protected abstract void updateMenu(LayoutMode var1);

    public void storeSession() {
        File file;
        String sFile;
        String fnProp = null;
        for (RowBrowser rb : this.tableBrowsers) {
            if (fnProp != null || rb.parent != null || rb.browserContentPane.table == null || rb.browserContentPane.table instanceof BrowserContentPane.SqlStatementTable) continue;
            fnProp = this.datamodel.get().getDisplayName(rb.browserContentPane.table).replace(' ', '-').replace('\"', '-').replace('\'', '-').replace('(', '-').replace(')', '-').toLowerCase() + ".dbl";
        }
        if (this.currentSessionFileName != null) {
            fnProp = this.currentSessionFileName;
        }
        File startDir = CommandLineParser.getInstance().newFile("layout");
        Container pFrame = SwingUtilities.getWindowAncestor(this);
        if (pFrame == null) {
            pFrame = this;
        }
        if (!((sFile = UIUtil.choseFile(fnProp == null ? null : new File(startDir, fnProp), startDir.getPath(), "Store Layout", ".dbl", pFrame, true, false)) == null || (file = new File(sFile)).exists() && 0 != JOptionPane.showConfirmDialog(pFrame, "The file '" + sFile + " already exists. Do you wont to replace the existing file?", "Store Layout", 0, 3))) {
            try {
                this.storeSession(sFile);
            }
            catch (Throwable e) {
                UIUtil.showException(this, "Error", e);
            }
            this.currentSessionFileName = sFile;
        }
    }

    private void storeSession(String sFile) throws IOException {
        int i = 1;
        HashMap<RowBrowser, Integer> browserNumber = new HashMap<RowBrowser, Integer>();
        for (RowBrowser rb : this.tableBrowsers) {
            browserNumber.put(rb, i++);
        }
        FileWriter out = new FileWriter(new File(sFile));
        out.write("Layout; " + (Object)((Object)this.layoutMode) + this.LF);
        for (RowBrowser rb : this.tableBrowsers) {
            if (rb.parent != null) continue;
            this.storeSession(rb, browserNumber, out);
        }
        out.close();
    }

    private void storeSession(RowBrowser rb, Map<RowBrowser, Integer> browserNumber, FileWriter out) throws IOException {
        if (rb.browserContentPane.table != null) {
            String csv = browserNumber.get(rb) + "; " + (rb.parent == null ? "" : (Serializable)browserNumber.get(rb.parent)) + "; ";
            String where = rb.browserContentPane.getAndConditionText().trim();
            if (rb.browserContentPane.parentRow != null) {
                where = where.length() > 0 ? "(" + where + ") and (" + rb.browserContentPane.parentRow.rowId + ")" : rb.browserContentPane.parentRow.rowId;
            }
            csv = csv + where + "; ";
            csv = csv + rb.internalFrame.getLocation().x + "; " + rb.internalFrame.getLocation().y + "; ";
            csv = csv + rb.internalFrame.getSize().width + "; " + rb.internalFrame.getSize().height + "; ";
            csv = csv + rb.browserContentPane.limitBox.getSelectedItem() + "; " + rb.browserContentPane.selectDistinctCheckBox.isSelected() + "; ";
            csv = rb.browserContentPane.table instanceof BrowserContentPane.SqlStatementTable ? csv + "Q; " + CsvFile.encodeCell(rb.browserContentPane.sqlBrowserContentPane.sqlEditorPane.getText()) + "; " : csv + "T; " + CsvFile.encodeCell(rb.browserContentPane.table.getName()) + "; " + (rb.association == null ? "" : CsvFile.encodeCell(rb.association.getName())) + "; ";
            csv = csv + rb.isHidden() + "; ";
            out.append(csv).append(this.LF);
            for (RowBrowser child : this.tableBrowsers) {
                if (child.parent != rb) continue;
                this.storeSession(child, browserNumber, out);
            }
        }
    }

    public void restoreSession(RowBrowser toBeAppended) {
        String sFile;
        File startDir = CommandLineParser.getInstance().newFile("layout");
        Container pFrame = SwingUtilities.getWindowAncestor(this);
        if (pFrame == null) {
            pFrame = this;
        }
        if ((sFile = UIUtil.choseFile(null, startDir.getPath(), toBeAppended == null ? "Restore Layout" : "Append Layout", ".dbl", pFrame, true, true)) != null) {
            try {
                this.restoreSession(toBeAppended, pFrame, sFile);
                if (toBeAppended == null) {
                    this.currentSessionFileName = sFile;
                }
            }
            catch (Throwable e) {
                UIUtil.showException(this, "Error", e);
            }
        }
    }

    private void restoreSession(RowBrowser toBeAppended, Component pFrame, String sFile) throws Exception {
        String tbaPeerID = null;
        HashMap<String, RowBrowser> rbByID = new HashMap<String, RowBrowser>();
        List<CsvFile.Line> lines = new CsvFile(new File(sFile)).getLines();
        if (toBeAppended == null) {
            this.closeAll();
        }
        ArrayList<RowBrowser> toBeLoaded = new ArrayList<RowBrowser>();
        ArrayList<String> unknownTables = new ArrayList<String>();
        for (CsvFile.Line l : lines) {
            if (l.cells.get(0).equals("Layout")) {
                try {
                    if (toBeAppended != null) continue;
                    this.layoutMode = LayoutMode.valueOf(l.cells.get(1));
                    this.updateMenu(this.layoutMode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            String id = l.cells.get(0);
            String parent = l.cells.get(1);
            String where = l.cells.get(2);
            Point loc = new Point(Integer.parseInt(l.cells.get(3)), Integer.parseInt(l.cells.get(4)));
            Dimension size = new Dimension(Integer.parseInt(l.cells.get(5)), Integer.parseInt(l.cells.get(6)));
            int limit = Integer.parseInt(l.cells.get(7));
            boolean selectDistinct = Boolean.parseBoolean(l.cells.get(8));
            RowBrowser rb = null;
            if ("T".equals(l.cells.get(9))) {
                Table table = this.datamodel.get().getTable(l.cells.get(10));
                if (table == null) {
                    unknownTables.add(l.cells.get(10));
                } else {
                    Association association = this.datamodel.get().namedAssociations.get(l.cells.get(11));
                    RowBrowser parentRB = (RowBrowser)rbByID.get(parent);
                    if (association == null) {
                        parentRB = null;
                    }
                    boolean add = true;
                    if (toBeAppended != null) {
                        if (tbaPeerID == null) {
                            add = false;
                            if (parent.trim().length() == 0 && table.equals(toBeAppended.browserContentPane.table)) {
                                tbaPeerID = id;
                            }
                        } else if (tbaPeerID.equals(parent)) {
                            parentRB = toBeAppended;
                        } else if (!rbByID.containsKey(parent)) {
                            add = false;
                        }
                    }
                    if (add) {
                        rb = this.addTableBrowser(parentRB, -1, table, parentRB != null ? association : null, where, limit, selectDistinct, false);
                        if (id.length() > 0) {
                            rbByID.put(id, rb);
                        }
                        if (parentRB == null || parentRB == toBeAppended) {
                            toBeLoaded.add(rb);
                        }
                    }
                }
            } else if (toBeAppended == null) {
                rb = this.addTableBrowser(null, 0, null, null, where, limit, selectDistinct, false);
                toBeLoaded.add(rb);
            }
            if (rb == null) continue;
            rb.setHidden(Boolean.parseBoolean(l.cells.get(12)));
            if (toBeAppended != null) continue;
            rb.internalFrame.setLocation(loc);
            rb.internalFrame.setSize(size);
        }
        this.checkDesktopSize();
        this.makePrimaryRootVisible();
        for (RowBrowser rb : toBeLoaded) {
            rb.browserContentPane.reloadRows();
        }
        if (toBeAppended != null && toBeLoaded.isEmpty()) {
            JOptionPane.showMessageDialog(pFrame, "Layout doesn't contain table \"" + this.datamodel.get().getDisplayName(toBeAppended.browserContentPane.table) + "\" as root.");
        } else if (!unknownTables.isEmpty()) {
            String pList = "";
            for (String ut : unknownTables) {
                pList = pList + ut + "\n";
            }
            JOptionPane.showMessageDialog(pFrame, "Unknown tables:\n\n" + pList + "\n");
        }
    }

    private void makePrimaryRootVisible() {
        RowBrowser root = null;
        for (RowBrowser rb : this.getRootBrowsers(true)) {
            if (rb.browserContentPane.table == null || rb.browserContentPane.table instanceof BrowserContentPane.SqlStatementTable) continue;
            root = rb;
            break;
        }
        if (root != null) {
            try {
                root.internalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.scrollToCenter(root.internalFrame);
        } else {
            this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
    }

    public JInternalFrame[] getAllFramesFromTableBrowsers() {
        ArrayList<JInternalFrame> frames = new ArrayList<JInternalFrame>();
        for (RowBrowser rb : this.tableBrowsers) {
            frames.add(rb.internalFrame);
        }
        return frames.toArray(new JInternalFrame[frames.size()]);
    }

    public List<RowBrowser> getRootBrowsers(boolean ignoreHidden) {
        ArrayList<RowBrowser> roots = new ArrayList<RowBrowser>();
        if (ignoreHidden) {
            for (RowBrowser rb : this.tableBrowsers) {
                if (rb.isHidden()) continue;
                RowBrowser p = rb.parent;
                while (p != null && p.isHidden()) {
                    p = p.parent;
                }
                if (p != null) continue;
                roots.add(rb);
            }
        } else {
            for (RowBrowser rb : this.tableBrowsers) {
                if (rb.parent != null) continue;
                roots.add(rb);
            }
        }
        return roots;
    }

    public List<RowBrowser> getBrowsers() {
        return new ArrayList<RowBrowser>(this.tableBrowsers);
    }

    public List<RowBrowser> getChildBrowsers(RowBrowser parent, boolean ignoreHidden) {
        ArrayList<RowBrowser> roots = new ArrayList<RowBrowser>();
        if (ignoreHidden) {
            for (RowBrowser rb : this.tableBrowsers) {
                if (rb.parent != parent) continue;
                if (rb.isHidden()) {
                    roots.addAll(this.getChildBrowsers(rb, true));
                    continue;
                }
                roots.add(rb);
            }
        } else {
            for (RowBrowser rb : this.tableBrowsers) {
                if (rb.parent != parent) continue;
                roots.add(rb);
            }
        }
        return roots;
    }

    protected synchronized void adjustClosure(BrowserContentPane tabu) {
        for (RowBrowser rb : this.tableBrowsers) {
            if (rb.browserContentPane == tabu) continue;
            ArrayList rowsOfRB = new ArrayList();
            for (Pair<BrowserContentPane, Row> r : this.currentClosure) {
                if (r.a != rb.browserContentPane) continue;
                rowsOfRB.add(r.b);
            }
            if (rowsOfRB.isEmpty()) continue;
            Rectangle firstRowPos = null;
            Rectangle lastRowPos = null;
            Rectangle visibleRect = rb.browserContentPane.rowsTable.getVisibleRect();
            for (Row r : rowsOfRB) {
                int index = rb.browserContentPane.rows.indexOf(r);
                if (index < 0) {
                    for (int n = 0; n < rb.browserContentPane.rows.size(); ++n) {
                        if (!r.rowId.equals(rb.browserContentPane.rows.get((int)n).rowId)) continue;
                        index = n;
                        break;
                    }
                }
                if (index < 0) continue;
                index = rb.browserContentPane.rowsTable.getRowSorter().convertRowIndexToView(index);
                Rectangle pos = rb.browserContentPane.rowsTable.getCellRect(index, 0, false);
                if (pos.y >= visibleRect.y && pos.y + pos.height < visibleRect.y + visibleRect.height) {
                    firstRowPos = null;
                    lastRowPos = null;
                    break;
                }
                if (firstRowPos == null || firstRowPos.y > pos.y) {
                    firstRowPos = pos;
                }
                if (lastRowPos != null && lastRowPos.y >= pos.y) continue;
                lastRowPos = pos;
            }
            if (lastRowPos != null) {
                rb.browserContentPane.rowsTable.scrollRectToVisible(new Rectangle(visibleRect.x, lastRowPos.y - lastRowPos.height, 1, 3 * lastRowPos.height));
            }
            if (firstRowPos == null) continue;
            rb.browserContentPane.rowsTable.scrollRectToVisible(new Rectangle(visibleRect.x, firstRowPos.y - firstRowPos.height, 1, 3 * firstRowPos.height));
        }
        this.repaintDesktop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInNewWindow(RowBrowser tableBrowser) {
        DataBrowser newDataBrowser = this.openNewDataBrowser();
        if (newDataBrowser != null) {
            newDataBrowser.desktop.layoutMode = this.layoutMode;
            newDataBrowser.desktop.updateMenu(this.layoutMode);
            StringBuilder cond = new StringBuilder();
            HashSet<String> known = new HashSet<String>();
            Desktop desktop = this;
            synchronized (desktop) {
                for (Row r : tableBrowser.browserContentPane.rows) {
                    if (known.contains(r.rowId)) continue;
                    known.add(r.rowId);
                    if (cond.length() > 0) {
                        cond.append(" or \n");
                    }
                    cond.append("(" + SqlUtil.replaceAliases(r.rowId, "A", "A") + ")");
                }
            }
            RowBrowser root = this.addTableBrowserSubTree(newDataBrowser, tableBrowser, null, cond.toString());
            root.browserContentPane.reloadRows();
            newDataBrowser.arrangeLayout();
            try {
                JInternalFrame iFrame = root.internalFrame;
                newDataBrowser.desktop.scrollToCenter(iFrame);
                iFrame.setSelected(true);
                iFrame.grabFocus();
            }
            catch (PropertyVetoException e1) {
                // empty catch block
            }
        }
    }

    private RowBrowser addTableBrowserSubTree(DataBrowser newDataBrowser, RowBrowser tableBrowser, RowBrowser parent, String rootCond) {
        Object limitO = tableBrowser.browserContentPane.limitBox.getSelectedItem();
        Integer limit = null;
        if (limitO instanceof Integer) {
            limit = (Integer)limitO;
        }
        RowBrowser rb = parent == null ? newDataBrowser.desktop.addTableBrowser(null, -1, tableBrowser.browserContentPane.table, null, rootCond == null ? tableBrowser.browserContentPane.getAndConditionText() : rootCond, limit, tableBrowser.browserContentPane.selectDistinctCheckBox.isSelected(), false) : newDataBrowser.desktop.addTableBrowser(parent, tableBrowser.rowIndex, tableBrowser.browserContentPane.table, tableBrowser.browserContentPane.association, rootCond == null ? tableBrowser.browserContentPane.getAndConditionText() : rootCond, limit, tableBrowser.browserContentPane.selectDistinctCheckBox.isSelected(), false);
        rb.setHidden(tableBrowser.isHidden());
        for (RowBrowser child : this.getChildBrowsers(tableBrowser, false)) {
            this.addTableBrowserSubTree(newDataBrowser, child, rb, null);
        }
        return rb;
    }

    protected abstract DataBrowser openNewDataBrowser();

    public void scrollToCenter(JInternalFrame iFrame) {
        this.demaximize();
        int w = this.getVisibleRect().width;
        int h = this.getVisibleRect().height;
        int x = iFrame.getBounds().x + iFrame.getBounds().width / 2 - this.getVisibleRect().width / 2;
        int y = iFrame.getBounds().y + iFrame.getBounds().height / 2 - this.getVisibleRect().height / 2;
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        Rectangle r = new Rectangle(x, y, Math.max(1, w), Math.max(1, h));
        this.scrollRectToVisible(r);
    }

    private void collectPositions(RowBrowser root, Map<String, Map<String, double[]>> positions) {
        LinkedList<Pair<RowBrowser, Pair<Integer, Integer>>> toDo = new LinkedList<Pair<RowBrowser, Pair<Integer, Integer>>>();
        toDo.add(new Pair<RowBrowser, Pair<Integer, Integer>>(root, new Pair<Integer, Integer>(1, 1)));
        String subject = root.browserContentPane.table.getName();
        double scaleX = 0.35 / this.layoutMode.factor;
        double scaleY = 0.3 / this.layoutMode.factor;
        double scher = 2.0;
        while (!toDo.isEmpty()) {
            Pair rowBrowser = (Pair)toDo.remove(0);
            int i = 1;
            for (RowBrowser child : this.getChildBrowsers((RowBrowser)rowBrowser.a, true)) {
                toDo.add(new Pair<RowBrowser, Pair<Integer, Integer>>(child, new Pair<Integer, Integer>((Integer)((Pair)rowBrowser.b).a + 1, i++)));
            }
            String table = ((RowBrowser)rowBrowser.a).browserContentPane.table.getName();
            Map<String, double[]> tablePos = positions.get(subject);
            if (tablePos == null) {
                tablePos = new TreeMap<String, double[]>();
                positions.put(subject, tablePos);
            }
            if (tablePos.containsKey(table)) continue;
            double x = ((RowBrowser)rowBrowser.a).internalFrame.getX();
            double y = ((RowBrowser)rowBrowser.a).internalFrame.getY();
            tablePos.put(table, new double[]{x * scaleX + scher * (double)(2 * ((Integer)((Pair)rowBrowser.b).b % 2) - 1), y * scaleY + scher * (double)(2 * ((Integer)((Pair)rowBrowser.b).a % 2) - 1), 1.0});
        }
    }

    public static enum LayoutMode {
        THUMBNAIL(0.22),
        TINY(0.569),
        SMALL(0.75),
        MEDIUM(1.0),
        LARGE(1.4);

        public final double factor;

        private LayoutMode(double factor) {
            this.factor = factor;
        }
    }

    class MDIDesktopManager
    extends DefaultDesktopManager {
        private Desktop desktop;

        public MDIDesktopManager(Desktop desktop2) {
            this.desktop = desktop2;
        }

        @Override
        public void endResizingFrame(JComponent f) {
            super.endResizingFrame(f);
            this.resizeDesktop();
        }

        @Override
        public void endDraggingFrame(JComponent f) {
            super.endDraggingFrame(f);
            this.resizeDesktop();
        }

        public void setNormalSize() {
            JScrollPane scrollPane = this.getScrollPane();
            int x = 0;
            int y = 0;
            Insets scrollInsets = this.getScrollPaneInsets();
            if (scrollPane != null) {
                Dimension d = scrollPane.getVisibleRect().getSize();
                if (scrollPane.getBorder() != null) {
                    d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
                }
                d.setSize(d.getWidth() - 20.0, d.getHeight() - 20.0);
                this.desktop.setAllSize(x, y);
                scrollPane.invalidate();
                scrollPane.validate();
            }
        }

        private Insets getScrollPaneInsets() {
            JScrollPane scrollPane = this.getScrollPane();
            if (scrollPane == null) {
                return new Insets(0, 0, 0, 0);
            }
            return this.getScrollPane().getBorder().getBorderInsets(scrollPane);
        }

        private JScrollPane getScrollPane() {
            JViewport viewPort;
            if (this.desktop.getParent() instanceof JViewport && (viewPort = (JViewport)this.desktop.getParent()).getParent() instanceof JScrollPane) {
                return (JScrollPane)viewPort.getParent();
            }
            return null;
        }

        public void resizeDesktop() {
            int x = 0;
            int y = 0;
            JScrollPane scrollPane = this.getScrollPane();
            Insets scrollInsets = this.getScrollPaneInsets();
            if (scrollPane != null) {
                boolean isMaximized = false;
                JInternalFrame[] allFrames = this.desktop.getAllFrames();
                for (int i = 0; i < allFrames.length; ++i) {
                    if (!allFrames[i].isVisible()) continue;
                    if (allFrames[i].isMaximum()) {
                        isMaximized = true;
                    }
                    if (allFrames[i].getX() + allFrames[i].getWidth() > x) {
                        x = allFrames[i].getX() + allFrames[i].getWidth();
                    }
                    if (allFrames[i].getY() + allFrames[i].getHeight() <= y) continue;
                    y = allFrames[i].getY() + allFrames[i].getHeight();
                }
                Dimension d = scrollPane.getVisibleRect().getSize();
                if (scrollPane.getBorder() != null) {
                    d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
                }
                if ((double)x <= d.getWidth() || isMaximized) {
                    x = (int)d.getWidth() - 20;
                }
                if ((double)y <= d.getHeight() || isMaximized) {
                    y = (int)d.getHeight() - 20;
                }
                this.desktop.setAllSize(x, y);
                scrollPane.invalidate();
                scrollPane.validate();
            }
        }
    }

    private static class Link {
        public boolean visible = true;
        public final RowBrowser from;
        public final RowBrowser to;
        public final String sourceRowID;
        public final String destRowID;
        public int x1;
        public int y1;
        public int x2;
        public int y2;
        public final Color color;
        public final boolean dotted;
        public final boolean intersect;

        public Link(RowBrowser from, RowBrowser to, String sourceRowID, String destRowID, int x1, int y1, int x2, int y2, Color color, boolean dotted, boolean intersect) {
            this.from = from;
            this.to = to;
            this.sourceRowID = sourceRowID;
            this.destRowID = destRowID;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.color = color;
            this.dotted = dotted;
            this.intersect = intersect;
        }
    }

    public class RowBrowser {
        public JInternalFrame internalFrame;
        public BrowserContentPane browserContentPane;
        public RowBrowser parent;
        public Association association;
        public int rowIndex;
        public int x1;
        public int y1;
        public int x2;
        public int y2;
        public Color color;
        public List<RowToRowLink> rowToRowLinks = new ArrayList<RowToRowLink>();
        private boolean hidden;

        public void convertToRoot() {
            this.rowIndex = -1;
            this.association = null;
            this.parent = null;
            this.browserContentPane.convertToRoot();
        }

        public void setHidden(boolean hidden) {
            if (hidden == this.hidden) {
                return;
            }
            Desktop.this.rbSourceToLinks = null;
            if (hidden) {
                this.internalFrame.setVisible(false);
            } else {
                this.internalFrame.setVisible(true);
                Rectangle r = Desktop.this.layout(this.rowIndex < 0, this.parent, this.association, this.browserContentPane, new ArrayList(), 0, -1);
                this.internalFrame.setBounds(r);
                Desktop.this.scrollRectToVisible(this.internalFrame.getBounds());
                try {
                    this.internalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.internalFrame.grabFocus();
            }
            this.hidden = hidden;
            Desktop.this.checkDesktopSize();
            Desktop.this.updateMenu();
        }

        public boolean isHidden() {
            return this.hidden;
        }
    }

    public class RowToRowLink {
        public Row parentRow;
        public Row childRow;
        public int parentRowIndex = -1;
        public int childRowIndex = -1;
        public int x1 = -1;
        public int y1;
        public int x2;
        public int y2;
        public Color color;
    }
}

