/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jsyntaxpane.DefaultSyntaxKit;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Jailer;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.modelbuilder.ModelBuilder;
import net.sf.jailer.ui.About;
import net.sf.jailer.ui.AnalyseOptionsDialog;
import net.sf.jailer.ui.AssociationListUI;
import net.sf.jailer.ui.BrowserLauncher;
import net.sf.jailer.ui.DataModelEditor;
import net.sf.jailer.ui.DataModelManager;
import net.sf.jailer.ui.DataModelManagerDialog;
import net.sf.jailer.ui.DbConnectionDialog;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.ui.databrowser.DataBrowserContext;
import net.sf.jailer.ui.databrowser.Desktop;
import net.sf.jailer.ui.databrowser.NewTableBrowser;
import net.sf.jailer.ui.databrowser.Reference;
import net.sf.jailer.ui.databrowser.TipDialog;
import org.apache.log4j.PropertyConfigurator;

public class DataBrowser
extends JFrame {
    Desktop desktop;
    private ImageIcon jailerIcon = null;
    private final Reference<DataModel> datamodel;
    private DbConnectionDialog dbConnectionDialog;
    private Session session;
    private final AssociationListUI borderBrowser;
    private static final String PLAFSETTING = ".plaf2.ui";
    private JMenuItem aboutMenuItem;
    private JMenuItem analyseMenuItem;
    private JLabel associatedWith;
    private JPanel borderBrowserPanel;
    private JPanel borderBrowserTitledPanel;
    private JMenuItem cloaseAllMenuItem;
    public JLabel connectivityState;
    private JMenuItem createExtractionModelMenuItem;
    private JMenuItem dataModelEditorjMenuItem;
    private JLabel dependsOn;
    private JLabel hasDependent;
    private JMenuItem helpForum;
    private JMenu helpMenu;
    private JPanel hiddenPanel;
    private JLabel ignored;
    private JInternalFrame jInternalFrame1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JRadioButtonMenuItem largeLayoutRadioButtonMenuItem;
    private JMenuItem layoutMenuItem;
    private JPanel legende;
    private JPanel legende1;
    private JPanel legende2;
    private JRadioButtonMenuItem mediumLayoutRadioButtonMenuItem;
    private JMenuBar menuBar;
    private JMenu menuTools;
    private JMenu menuWindow;
    private JLabel modelName;
    private JLabel modelPath;
    private JTree navigationTree;
    private JScrollPane navigationTreeScrollPane;
    private JMenuItem newWindowMenuItem;
    private JMenuItem reconnectMenuItem;
    private JMenuItem restoreSessionItem;
    private JMenuItem schemaMappingMenuItem;
    private JLabel schemaName;
    private JPanel schemaNamePanel;
    private JRadioButtonMenuItem smallLayoutRadioButtonMenuItem;
    private JMenuItem storeSessionItem;
    private JRadioButtonMenuItem thumbnailLayoutRadioButtonMenuItem;
    private JRadioButtonMenuItem tinyLayoutRadioButtonMenuItem;
    private JLabel titleLabel;
    private JMenu view;
    private boolean disableBorderBrowserUpdates = false;
    private Map<JInternalFrame, TreeNodeForRowBrowser> treeNodeByIFrame = new HashMap<JInternalFrame, TreeNodeForRowBrowser>();
    private TreeSelectionListener navigationTreeListener = null;

    public DataBrowser(DataModel datamodel, Table root, String condition, DbConnectionDialog dbConnectionDialog, boolean embedded) throws Exception {
        this.datamodel = new Reference<DataModel>(datamodel);
        this.dbConnectionDialog = dbConnectionDialog != null ? new DbConnectionDialog((Frame)this, dbConnectionDialog, DataBrowserContext.getAppName()) : null;
        this.borderBrowser = new AssociationListUI("Resolve", "Resolve selected Associations", true){

            @Override
            protected void applyAction(Collection<AssociationListUI.AssociationModel> selection) {
                DataBrowser.this.resolveSelection(selection);
            }
        };
        if (embedded) {
            DataBrowserContext.setSupportsDataModelUpdates(false);
        }
        this.initComponents();
        if (this.jScrollPane1.getVerticalScrollBar() != null) {
            this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        }
        if (this.jScrollPane1.getHorizontalScrollBar() != null) {
            this.jScrollPane1.getHorizontalScrollBar().setUnitIncrement(16);
        }
        this.hiddenPanel.setVisible(false);
        this.borderBrowserPanel.add((Component)this.borderBrowser, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.jPanel4.add((Component)new JPanel(){
            private static final long serialVersionUID = -947582621664272477L;

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(1, 300);
            }
        }, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.borderBrowserTitledPanel.add((Component)new JPanel(){
            private static final long serialVersionUID = -947582621664272477L;

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(1, 180);
            }
        }, gridBagConstraints);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        this.navigationTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
        this.navigationTree.setCellRenderer(renderer);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.thumbnailLayoutRadioButtonMenuItem);
        buttonGroup.add(this.tinyLayoutRadioButtonMenuItem);
        buttonGroup.add(this.smallLayoutRadioButtonMenuItem);
        buttonGroup.add(this.mediumLayoutRadioButtonMenuItem);
        buttonGroup.add(this.largeLayoutRadioButtonMenuItem);
        this.mediumLayoutRadioButtonMenuItem.setSelected(true);
        this.setTitle(DataBrowserContext.getAppName(false));
        if (embedded) {
            this.menuTools.setVisible(false);
        }
        if (DataBrowserContext.isStandAlone()) {
            this.aboutMenuItem.setText("About " + DataBrowserContext.getAppName(true));
        }
        this.jSeparator6.setVisible(false);
        this.view.setVisible(false);
        try {
            for (final UIManager.LookAndFeelInfo lfInfo : UIManager.getInstalledLookAndFeels()) {
                JMenuItem mItem = new JMenuItem();
                mItem.setText(lfInfo.getName());
                this.view.add(mItem);
                mItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        DataBrowser.this.setPLAF(lfInfo.getClassName());
                    }
                });
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.jailerIcon = new ImageIcon(this.getClass().getResource("/net/sf/jailer/resource/jailer.png"));
            this.setIconImage(this.jailerIcon.getImage());
        }
        catch (Throwable t) {
            try {
                this.jailerIcon = new ImageIcon(this.getClass().getResource("/net/sf/jailer/resource/jailer.gif"));
                this.setIconImage(this.jailerIcon.getImage());
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        this.jailerIcon.setImage(this.jailerIcon.getImage().getScaledInstance(16, 16, 4));
        if (dbConnectionDialog != null) {
            this.createSession(dbConnectionDialog);
        }
        this.desktop = new Desktop(this.datamodel, this.jailerIcon, this.session, this, dbConnectionDialog){

            @Override
            public void openSchemaAnalyzer() {
                DataBrowser.this.updateDataModel();
            }

            @Override
            protected void updateMenu(boolean hasTableBrowser, boolean hasIFrame) {
                DataBrowser.this.storeSessionItem.setEnabled(hasIFrame);
                DataBrowser.this.createExtractionModelMenuItem.setEnabled(hasTableBrowser);
                DataBrowser.this.updateIFramesBar();
                super.updateMenu(hasTableBrowser, hasIFrame);
            }

            @Override
            protected void updateMenu(Desktop.LayoutMode layoutMode) {
                if (layoutMode == Desktop.LayoutMode.TINY) {
                    DataBrowser.this.tinyLayoutRadioButtonMenuItem.setSelected(true);
                } else if (layoutMode == Desktop.LayoutMode.SMALL) {
                    DataBrowser.this.smallLayoutRadioButtonMenuItem.setSelected(true);
                } else if (layoutMode == Desktop.LayoutMode.MEDIUM) {
                    DataBrowser.this.mediumLayoutRadioButtonMenuItem.setSelected(true);
                } else if (layoutMode == Desktop.LayoutMode.LARGE) {
                    DataBrowser.this.largeLayoutRadioButtonMenuItem.setSelected(true);
                } else if (layoutMode == Desktop.LayoutMode.THUMBNAIL) {
                    DataBrowser.this.thumbnailLayoutRadioButtonMenuItem.setSelected(true);
                }
            }

            @Override
            protected DataBrowser openNewDataBrowser() {
                try {
                    return DataBrowser.openNewDataBrowser((DataModel)DataBrowser.this.datamodel.get(), this.dbConnectionDialog, false);
                }
                catch (Exception e) {
                    UIUtil.showException(this, "Error", e);
                    return null;
                }
            }
        };
        this.jScrollPane1.setViewportView(this.desktop);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                DataBrowser.this.desktop.stop();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        MouseInputAdapter mia = new MouseInputAdapter(){
            int m_XDifference;
            int m_YDifference;
            Container c;

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                this.c = DataBrowser.this.desktop.getParent();
                if (this.c instanceof JViewport) {
                    JViewport jv = (JViewport)this.c;
                    Point p = jv.getViewPosition();
                    int newX = p.x - (e.getX() - this.m_XDifference);
                    int newY = p.y - (e.getY() - this.m_YDifference);
                    int maxX = DataBrowser.this.desktop.getWidth() - jv.getWidth();
                    int maxY = DataBrowser.this.desktop.getHeight() - jv.getHeight();
                    if (newX < 0) {
                        newX = 0;
                    }
                    if (newX > maxX) {
                        newX = maxX;
                    }
                    if (newY < 0) {
                        newY = 0;
                    }
                    if (newY > maxY) {
                        newY = maxY;
                    }
                    jv.setViewPosition(new Point(newX, newY));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                DataBrowser.this.setCursor(Cursor.getPredefinedCursor(13));
                this.m_XDifference = e.getX();
                this.m_YDifference = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                DataBrowser.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 3) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                JMenuItem i = new JMenuItem("Arrange Layout");
                popup.add(i);
                i.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataBrowser.this.layoutMenuItemActionPerformed(e);
                    }
                });
                ButtonGroup group = new ButtonGroup();
                popup.add(new JSeparator());
                i = new JRadioButtonMenuItem("Thumbnail Layout");
                i.setSelected(DataBrowser.this.desktop.layoutMode == Desktop.LayoutMode.THUMBNAIL);
                group.add(i);
                popup.add(i);
                i.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataBrowser.this.thumbnailLayoutRadioButtonMenuItemActionPerformed(e);
                    }
                });
                i = new JRadioButtonMenuItem("Tiny Layout");
                i.setSelected(DataBrowser.this.desktop.layoutMode == Desktop.LayoutMode.TINY);
                group.add(i);
                popup.add(i);
                i.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataBrowser.this.tinyLayoutRadioButtonMenuItemActionPerformed(e);
                    }
                });
                i = new JRadioButtonMenuItem("Small Layout");
                i.setSelected(DataBrowser.this.desktop.layoutMode == Desktop.LayoutMode.SMALL);
                group.add(i);
                popup.add(i);
                i.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataBrowser.this.smallLayoutRadioButtonMenuItemActionPerformed(e);
                    }
                });
                i = new JRadioButtonMenuItem("Medium Layout");
                i.setSelected(DataBrowser.this.desktop.layoutMode == Desktop.LayoutMode.MEDIUM);
                group.add(i);
                popup.add(i);
                i.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataBrowser.this.mediumLayoutRadioButtonMenuItemActionPerformed(e);
                    }
                });
                i = new JRadioButtonMenuItem("Large Layout");
                i.setSelected(DataBrowser.this.desktop.layoutMode == Desktop.LayoutMode.LARGE);
                group.add(i);
                popup.add(i);
                i.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataBrowser.this.largeLayoutRadioButtonMenuItemActionPerformed(e);
                    }
                });
                popup.show(DataBrowser.this.desktop, e.getX(), e.getY());
            }
        };
        this.desktop.addMouseMotionListener(mia);
        this.desktop.addMouseListener(mia);
        this.setLocation(60, 50);
        this.setSize(900, 640);
        if (root != null) {
            this.desktop.addTableBrowser(null, 0, root, null, condition, null, null, true);
        }
        this.schemaNamePanel.addMouseListener(new MouseAdapter(){
            private boolean in = false;

            @Override
            public void mousePressed(MouseEvent e) {
                DataBrowser.this.desktop.openSchemaMappingDialog(false);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                this.in = true;
                this.updateBorder();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                this.in = false;
                this.updateBorder();
            }

            private void updateBorder() {
                DataBrowser.this.schemaNamePanel.setBorder(new SoftBevelBorder(this.in ? 1 : 0));
            }
        });
        this.updateStatusBar();
    }

    private void createSession(DbConnectionDialog dbConnectionDialog) throws Exception {
        DbConnectionDialog.ConnectionInfo connection = dbConnectionDialog.currentConnection;
        this.session = new Session(connection.driverClass, connection.url, connection.user, connection.password);
        ArrayList<String> args = new ArrayList<String>();
        dbConnectionDialog.addDbArgs(args);
        this.session.setCliArguments(args);
        this.session.setPassword(dbConnectionDialog.getPassword());
    }

    protected void setConnection(DbConnectionDialog dbConnectionDialog) throws Exception {
        DbConnectionDialog.ConnectionInfo connection;
        if (dbConnectionDialog != null) {
            dbConnectionDialog = new DbConnectionDialog((Frame)this, dbConnectionDialog, DataBrowserContext.getAppName());
        }
        this.dbConnectionDialog = dbConnectionDialog;
        this.desktop.dbConnectionDialog = dbConnectionDialog;
        if (dbConnectionDialog != null && (connection = dbConnectionDialog.currentConnection) != null) {
            this.createSession(dbConnectionDialog);
            this.desktop.session = this.session;
            this.datamodel.get().getUniversalPrimaryKey(this.session);
            this.updateStatusBar();
            if (this.desktop != null) {
                this.desktop.updateMenu();
                for (Desktop.RowBrowser rb : this.desktop.getBrowsers()) {
                    rb.browserContentPane.session = this.session;
                    rb.browserContentPane.rows.clear();
                }
                for (Desktop.RowBrowser rb : this.desktop.getRootBrowsers(false)) {
                    rb.browserContentPane.reloadRows();
                }
            }
        }
    }

    public void updateStatusBar() {
        String lastMod;
        int MAX_LENGTH = 50;
        DbConnectionDialog.ConnectionInfo connection = this.dbConnectionDialog != null ? this.dbConnectionDialog.currentConnection : null;
        String dburl = connection != null ? connection.url : " ";
        this.connectivityState.setToolTipText(dburl);
        String string = dburl = connection != null ? connection.user + "@" + connection.alias : " ";
        if (dburl.length() > 50) {
            dburl = dburl.substring(0, 47) + "...";
        }
        this.connectivityState.setText(dburl);
        DataModel dataModel = this.datamodel != null ? this.datamodel.get() : null;
        String modelname = "Data Model \"" + (dataModel == null ? "New Model" : dataModel.getName()) + "\"";
        String string2 = lastMod = dataModel == null ? "" : dataModel.getLastModifiedAsString();
        if (lastMod.length() > 0) {
            lastMod = " (" + lastMod + ")";
        }
        this.modelName.setText(modelname);
        this.modelName.setToolTipText(modelname + lastMod);
        String modelpath = CommandLineParser.getInstance().getDataModelFolder();
        try {
            modelpath = CommandLineParser.getInstance().newFile(modelpath).getAbsolutePath();
        }
        catch (Throwable t) {
            // empty catch block
        }
        modelpath = modelpath + File.separator;
        this.modelPath.setToolTipText(modelpath);
        if (modelpath.length() > 54) {
            modelpath = modelpath.substring(0, 25) + "..." + modelpath.substring(modelpath.length() - 25);
        }
        this.modelPath.setText(modelpath);
        String nonDefaultSchema = null;
        if (this.desktop.schemaMapping != null) {
            for (Map.Entry<String, String> e : this.desktop.schemaMapping.entrySet()) {
                if (e.getKey().equalsIgnoreCase(e.getValue())) continue;
                nonDefaultSchema = e.getValue();
                break;
            }
        }
        this.schemaNamePanel.setVisible(nonDefaultSchema != null);
        if (nonDefaultSchema != null) {
            if (nonDefaultSchema.equals("")) {
                this.schemaName.setText("Default Schema");
            } else {
                this.schemaName.setText("Schema " + nonDefaultSchema + "");
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel11 = new JPanel();
        this.legende1 = new JPanel();
        this.modelName = new JLabel();
        this.modelPath = new JLabel();
        this.legende = new JPanel();
        this.dependsOn = new JLabel();
        this.hasDependent = new JLabel();
        this.associatedWith = new JLabel();
        this.ignored = new JLabel();
        this.schemaNamePanel = new JPanel();
        this.schemaName = new JLabel();
        this.legende2 = new JPanel();
        this.connectivityState = new JLabel();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.navigationTreeScrollPane = new JScrollPane();
        this.navigationTree = new JTree();
        this.jLabel2 = new JLabel();
        this.borderBrowserTitledPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.borderBrowserPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jInternalFrame1 = new JInternalFrame();
        this.jLabel1 = new JLabel();
        this.hiddenPanel = new JPanel();
        this.menuBar = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.storeSessionItem = new JMenuItem();
        this.restoreSessionItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.reconnectMenuItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.cloaseAllMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.schemaMappingMenuItem = new JMenuItem();
        this.menuTools = new JMenu();
        this.analyseMenuItem = new JMenuItem();
        this.dataModelEditorjMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.createExtractionModelMenuItem = new JMenuItem();
        this.menuWindow = new JMenu();
        this.layoutMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.thumbnailLayoutRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.tinyLayoutRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.smallLayoutRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.mediumLayoutRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.largeLayoutRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.newWindowMenuItem = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.view = new JMenu();
        this.helpMenu = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.helpForum = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel11.setLayout(new GridBagLayout());
        this.legende1.setBorder(new SoftBevelBorder(0));
        this.legende1.setLayout(new GridBagLayout());
        this.modelName.setFont(new Font("Dialog", 0, 12));
        this.modelName.setText("Data Model \"Demo\"");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 12);
        this.legende1.add((Component)this.modelName, gridBagConstraints);
        this.modelPath.setFont(new Font("Dialog", 0, 12));
        this.modelPath.setForeground(Color.gray);
        this.modelPath.setText("/home/jailer/datamodel/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.legende1.add((Component)this.modelPath, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel11.add((Component)this.legende1, gridBagConstraints);
        this.legende.setBorder(new SoftBevelBorder(0));
        this.legende.setLayout(new FlowLayout(1, 0, 0));
        this.dependsOn.setFont(new Font("Dialog", 0, 12));
        this.dependsOn.setForeground(new Color(170, 0, 0));
        this.dependsOn.setText(" depends on");
        this.legende.add(this.dependsOn);
        this.hasDependent.setFont(new Font("Dialog", 0, 12));
        this.hasDependent.setForeground(new Color(0, 112, 0));
        this.hasDependent.setText("  has dependent");
        this.legende.add(this.hasDependent);
        this.associatedWith.setFont(new Font("Dialog", 0, 12));
        this.associatedWith.setForeground(new Color(0, 100, 255));
        this.associatedWith.setText("  associated with");
        this.legende.add(this.associatedWith);
        this.ignored.setFont(new Font("Dialog", 0, 12));
        this.ignored.setForeground(new Color(153, 153, 153));
        this.ignored.setText("  disabled ");
        this.legende.add(this.ignored);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel11.add((Component)this.legende, gridBagConstraints);
        this.schemaNamePanel.setBorder(new SoftBevelBorder(0));
        this.schemaNamePanel.setLayout(new GridBagLayout());
        this.schemaName.setFont(new Font("Dialog", 0, 12));
        this.schemaName.setText("Schema");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 12);
        this.schemaNamePanel.add((Component)this.schemaName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel11.add((Component)this.schemaNamePanel, gridBagConstraints);
        this.legende2.setBorder(new SoftBevelBorder(0));
        this.legende2.setLayout(new GridBagLayout());
        this.connectivityState.setFont(new Font("Dialog", 0, 12));
        this.connectivityState.setText("offline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 6);
        this.legende2.add((Component)this.connectivityState, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel11.add((Component)this.legende2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(340);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jSplitPane2.setDividerLocation(350);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(1.0);
        this.jSplitPane2.setContinuousLayout(true);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel4.setBorder(null);
        this.jPanel4.setLayout(new GridBagLayout());
        this.navigationTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DataBrowser.this.navigationTreeMouseClicked(evt);
            }
        });
        this.navigationTreeScrollPane.setViewportView(this.navigationTree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.navigationTreeScrollPane, gridBagConstraints);
        this.jLabel2.setText(" Navigation Tree");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.jSplitPane2.setLeftComponent(this.jPanel4);
        this.borderBrowserTitledPanel.setBorder(null);
        this.borderBrowserTitledPanel.setLayout(new GridBagLayout());
        this.titleLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.borderBrowserTitledPanel.add((Component)this.titleLabel, gridBagConstraints);
        this.borderBrowserPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.borderBrowserTitledPanel.add((Component)this.borderBrowserPanel, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.borderBrowserTitledPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jSplitPane2, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        this.jPanel5.setLayout(new BorderLayout());
        this.jScrollPane1.setAutoscrolls(true);
        this.jScrollPane1.setWheelScrollingEnabled(false);
        this.jScrollPane1.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                DataBrowser.this.jScrollPane1MouseWheelMoved(evt);
            }
        });
        this.jInternalFrame1.setVisible(true);
        this.jLabel1.setText("jLabel1");
        this.jInternalFrame1.getContentPane().add((Component)this.jLabel1, "Center");
        this.jScrollPane1.setViewportView(this.jInternalFrame1);
        this.jPanel5.add((Component)this.jScrollPane1, "Center");
        this.hiddenPanel.setBorder(BorderFactory.createTitledBorder(null, "Hidden"));
        this.hiddenPanel.setLayout(new GridBagLayout());
        this.jPanel5.add((Component)this.hiddenPanel, "South");
        this.jSplitPane1.setRightComponent(this.jPanel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jSplitPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jMenu1.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.jMenuItem1.setText("New Table Browser");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItem3.setText("New SQL Browser");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu1.add(this.jSeparator4);
        this.storeSessionItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.storeSessionItem.setText("Store Layout");
        this.storeSessionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.storeSessionItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.storeSessionItem);
        this.restoreSessionItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.restoreSessionItem.setText("Restore Layout");
        this.restoreSessionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.restoreSessionItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.restoreSessionItem);
        this.jMenu1.add(this.jSeparator2);
        this.reconnectMenuItem.setText("Reconnect...");
        this.reconnectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.reconnectMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.reconnectMenuItem);
        this.jMenu1.add(this.jSeparator7);
        this.cloaseAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 3));
        this.cloaseAllMenuItem.setText("Close All");
        this.cloaseAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.cloaseAllMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.cloaseAllMenuItem);
        this.jMenu1.add(this.jSeparator3);
        this.schemaMappingMenuItem.setText("Schema Mapping");
        this.schemaMappingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.schemaMappingMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.schemaMappingMenuItem);
        this.menuBar.add(this.jMenu1);
        this.menuTools.setText("DataModel");
        this.analyseMenuItem.setText("Analyse Database");
        this.analyseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.analyseMenuItemActionPerformed(evt);
            }
        });
        this.menuTools.add(this.analyseMenuItem);
        this.dataModelEditorjMenuItem.setText("Data Model Editor");
        this.dataModelEditorjMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.dataModelEditorjMenuItemActionPerformed(evt);
            }
        });
        this.menuTools.add(this.dataModelEditorjMenuItem);
        this.menuBar.add(this.menuTools);
        this.jMenu2.setText("Tools");
        this.createExtractionModelMenuItem.setText("Create Extraction Model");
        this.createExtractionModelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.createExtractionModelMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.createExtractionModelMenuItem);
        this.menuBar.add(this.jMenu2);
        this.menuWindow.setText("Window");
        this.layoutMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.layoutMenuItem.setText("Arrange Layout");
        this.layoutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.layoutMenuItemActionPerformed(evt);
            }
        });
        this.menuWindow.add(this.layoutMenuItem);
        this.menuWindow.add(this.jSeparator5);
        this.thumbnailLayoutRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, 2));
        this.thumbnailLayoutRadioButtonMenuItem.setText("Thumbnail Layout");
        this.thumbnailLayoutRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.thumbnailLayoutRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.menuWindow.add(this.thumbnailLayoutRadioButtonMenuItem);
        this.tinyLayoutRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        this.tinyLayoutRadioButtonMenuItem.setText("Tiny Layout");
        this.tinyLayoutRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.tinyLayoutRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.menuWindow.add(this.tinyLayoutRadioButtonMenuItem);
        this.smallLayoutRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        this.smallLayoutRadioButtonMenuItem.setText("Small Layout");
        this.smallLayoutRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.smallLayoutRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.menuWindow.add(this.smallLayoutRadioButtonMenuItem);
        this.mediumLayoutRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 2));
        this.mediumLayoutRadioButtonMenuItem.setText("Medium Layout");
        this.mediumLayoutRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.mediumLayoutRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.menuWindow.add(this.mediumLayoutRadioButtonMenuItem);
        this.largeLayoutRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(52, 2));
        this.largeLayoutRadioButtonMenuItem.setText("Large Layout");
        this.largeLayoutRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.largeLayoutRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.menuWindow.add(this.largeLayoutRadioButtonMenuItem);
        this.menuWindow.add(this.jSeparator1);
        this.newWindowMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newWindowMenuItem.setText("New Window");
        this.newWindowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.newWindowMenuItemActionPerformed(evt);
            }
        });
        this.menuWindow.add(this.newWindowMenuItem);
        this.menuWindow.add(this.jSeparator6);
        this.view.setText("Look&Feel");
        this.menuWindow.add(this.view);
        this.menuBar.add(this.menuWindow);
        this.helpMenu.setText("Help");
        this.jMenuItem4.setText("Manual");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.jMenuItem4);
        this.helpForum.setText("Forum");
        this.helpForum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.helpForumActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpForum);
        this.aboutMenuItem.setText("About Jailer");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void newWindowMenuItemActionPerformed(ActionEvent evt) {
        try {
            DataBrowser.openNewDataBrowser(this.datamodel.get(), this.dbConnectionDialog, false);
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectMenuItemActionPerformed(ActionEvent evt) {
        DataBrowser dataBrowser = this;
        synchronized (dataBrowser) {
            if (this.dbConnectionDialog.connect("Reconnect")) {
                try {
                    this.setConnection(this.dbConnectionDialog);
                }
                catch (Exception e) {
                    UIUtil.showException(this, "Error", e);
                }
            }
        }
    }

    private void thumbnailLayoutRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.desktop.rescaleLayout(Desktop.LayoutMode.THUMBNAIL, null);
        this.wheelzoomTip();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.openNewTableBrowser(false);
    }

    private void cloaseAllMenuItemActionPerformed(ActionEvent evt) {
        this.desktop.closeAll();
    }

    private void schemaMappingMenuItemActionPerformed(ActionEvent evt) {
        this.desktop.openSchemaMappingDialog(false);
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.desktop.addTableBrowser(null, 0, null, null, "", null, null, true);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        try {
            if (DataBrowserContext.isStandAlone()) {
                BrowserLauncher.openURL(new URI("http://dbeauty.sourceforge.net"));
            } else {
                BrowserLauncher.openURL(new URI("http://jailer.sourceforge.net/doc/data-browsing.html"));
            }
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void createExtractionModelMenuItemActionPerformed(ActionEvent evt) {
        this.desktop.createExtractionModel();
    }

    private void storeSessionItemActionPerformed(ActionEvent evt) {
        this.desktop.storeSession();
    }

    private void restoreSessionItemActionPerformed(ActionEvent evt) {
        this.desktop.restoreSession(null);
    }

    private void tinyLayoutRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.desktop.rescaleLayout(Desktop.LayoutMode.TINY, null);
        this.wheelzoomTip();
    }

    private void wheelzoomTip() {
        TipDialog.showTip(this, "WHEELZOOM", "While holding down the Ctrl-key you can use the mouse-wheel to zoom in or out.");
    }

    private void smallLayoutRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.desktop.rescaleLayout(Desktop.LayoutMode.SMALL, null);
        this.wheelzoomTip();
    }

    private void mediumLayoutRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.desktop.rescaleLayout(Desktop.LayoutMode.MEDIUM, null);
        this.wheelzoomTip();
    }

    private void largeLayoutRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.desktop.rescaleLayout(Desktop.LayoutMode.LARGE, null);
        this.wheelzoomTip();
    }

    private void navigationTreeMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            Object sel;
            TreePath node = this.navigationTree.getPathForLocation(evt.getX(), evt.getY());
            if (node == null) {
                for (int x = this.navigationTree.getWidth(); x > 0 && (node = this.navigationTree.getPathForLocation(x, evt.getY())) == null; x -= 32) {
                }
            }
            if (node != null && (sel = node.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                Object selNode = ((DefaultMutableTreeNode)sel).getUserObject();
                Desktop.RowBrowser rowBrowser = null;
                int row = 0;
                if (selNode instanceof TreeNodeForRowBrowser) {
                    rowBrowser = ((TreeNodeForRowBrowser)selNode).rowBrowser;
                    row = ((TreeNodeForRowBrowser)selNode).rowIndex;
                }
                if (rowBrowser != null) {
                    this.navigationTree.setSelectionRow(row);
                    JPopupMenu popup = rowBrowser.browserContentPane.createPopupMenu(null, -1, 0, 0, false);
                    JPopupMenu popup2 = rowBrowser.browserContentPane.createSqlPopupMenu(null, -1, 0, 0, true);
                    popup.add(new JSeparator());
                    for (Component c : popup2.getComponents()) {
                        popup.add(c);
                    }
                    UIUtil.fit(popup);
                    popup.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }
    }

    private void layoutMenuItemActionPerformed(ActionEvent evt) {
        this.arrangeLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arrangeLayout() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.desktop.layoutBrowser();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void jScrollPane1MouseWheelMoved(MouseWheelEvent evt) {
        this.desktop.onMouseWheelMoved(evt);
        this.desktop.onMouseWheelMoved(evt, this.jScrollPane1);
    }

    private void openNewTableBrowser(boolean offerAlternatives) {
        new NewTableBrowser(this, this.datamodel.get(), offerAlternatives){

            @Override
            void openTableBrowser(String tableName) {
                DataBrowser.this.desktop.addTableBrowser(null, 0, ((DataModel)DataBrowser.this.datamodel.get()).getTableByDisplayName(tableName), null, "", null, null, true);
            }

            @Override
            void openDatabaseAnalyzer() {
                DataBrowser.this.updateDataModel();
            }

            @Override
            void restoreSession() {
                DataBrowser.this.desktop.restoreSession(null);
            }
        };
    }

    private void helpForumActionPerformed(ActionEvent evt) {
        try {
            if (DataBrowserContext.isStandAlone()) {
                BrowserLauncher.openURL(new URI("https://sourceforge.net/apps/phpbb/dbeauty/index.php"));
            } else {
                BrowserLauncher.openURL(new URI("https://sourceforge.net/forum/?group_id=197260"));
            }
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        About about = new About((Frame)this, true);
        about.setTitle(DataBrowserContext.getAppName(false));
        if (DataBrowserContext.isStandAlone()) {
            about.homeTextField.setText("http://dbeauty.sourceforge.net");
            about.forumTextField.setText("https://sourceforge.net/apps/phpbb/dbeauty/index.php");
            about.nameLabel.setText(DataBrowserContext.getAppName(false));
        }
        about.pack();
        about.setLocation(this.getLocation().x + (this.getSize().width - about.getPreferredSize().width) / 2, this.getLocation().y + (this.getSize().height - about.getPreferredSize().height) / 2);
        about.setVisible(true);
    }

    private void analyseMenuItemActionPerformed(ActionEvent evt) {
        this.updateDataModel();
    }

    private void dataModelEditorjMenuItemActionPerformed(ActionEvent evt) {
        this.openDataModelEditor();
    }

    public static void main(final String[] args) {
        String configFileName = "jailer.xml";
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            JOptionPane.showMessageDialog(null, "File '" + configFileName + "' not found!", "Missing configuration file", 0);
            return;
        }
        try {
            Logger.getLogger("prefuse").setLevel(Level.OFF);
            new Jailer(1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            CommandLineParser.parse(args, true);
        }
        catch (Exception e) {
            UIUtil.showException(null, "Illegal arguments", e);
        }
        try {
            File file = new File(DataModel.getDatamodelFolder());
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSyntaxKit.initKit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                try {
                    CommandLineParser.parse(args, true);
                    try {
                        String plaf = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
                        UIManager.setLookAndFeel(plaf);
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    DataModelManagerDialog dataModelManagerDialog = new DataModelManagerDialog(DataBrowserContext.getAppName(true) + " - Relational Data Browser"){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected void onSelect() {
                            try {
                                DataModel datamodel = new DataModel();
                                DataBrowser.openNewDataBrowser(datamodel, null, true);
                            }
                            catch (Exception e) {
                                UIUtil.showException(null, "Error", e);
                            }
                        }
                    };
                    ToolTipManager.sharedInstance().setInitialDelay(400);
                    ToolTipManager.sharedInstance().setDismissDelay(20000);
                    dataModelManagerDialog.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static DataBrowser openNewDataBrowser(DataModel datamodel, DbConnectionDialog dbConnectionDialog, boolean maximize) throws Exception {
        boolean silent = dbConnectionDialog != null;
        DataBrowser dataBrowser = new DataBrowser(datamodel, null, "", null, false);
        dataBrowser.setDefaultCloseOperation(2);
        if (maximize) {
            dataBrowser.setExtendedState(6);
        }
        dataBrowser.setVisible(true);
        dbConnectionDialog = dbConnectionDialog == null ? new DbConnectionDialog((Frame)dataBrowser, DataBrowserContext.getAppName(), null) : new DbConnectionDialog((Frame)dataBrowser, dbConnectionDialog, DataBrowserContext.getAppName());
        if (DataBrowserContext.isStandAlone()) {
            dbConnectionDialog.setJdbcHelpURL("http://dbeauty.sourceforge.net/jdbc.html");
        }
        if (dbConnectionDialog.isConnected || dbConnectionDialog.connect(DataBrowserContext.getAppName(true))) {
            dataBrowser.setConnection(dbConnectionDialog);
            dataBrowser.askForDataModel();
            dataBrowser.desktop.openSchemaMappingDialog(true);
            dataBrowser.updateStatusBar();
            if (!silent) {
                dataBrowser.openNewTableBrowser(true);
            }
        } else {
            if (dbConnectionDialog.isConnected) {
                dataBrowser.setConnection(dbConnectionDialog);
            }
            for (int i = 0; i < dataBrowser.menuBar.getMenuCount(); ++i) {
                JMenu menu = dataBrowser.menuBar.getMenu(i);
                if (menu == dataBrowser.helpMenu) continue;
                for (int j = 0; j < menu.getItemCount(); ++j) {
                    JMenuItem item = menu.getItem(j);
                    if (item == null) continue;
                    item.setEnabled(false);
                }
            }
        }
        return dataBrowser;
    }

    private void openDataModelEditor() {
        try {
            String modelname = this.datamodel == null || this.datamodel.get() == null ? "New Model" : this.datamodel.get().getName();
            DataModelEditor dataModelEditor = new DataModelEditor(this, false, false, null, null, null, modelname, null);
            dataModelEditor.setVisible(true);
            this.desktop.reloadDataModel(this.desktop.schemaMapping);
            this.updateStatusBar();
            this.askForDataModel();
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataModel() {
        try {
            List<String> schemas;
            ArrayList<String> args = new ArrayList<String>();
            args.add("build-model");
            this.dbConnectionDialog.addDbArgs(args);
            AnalyseOptionsDialog analyseOptionsDialog = new AnalyseOptionsDialog((Frame)this, this.datamodel == null ? null : this.datamodel.get());
            boolean[] isDefaultSchema = new boolean[1];
            String[] defaultSchema = new String[1];
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                schemas = this.dbConnectionDialog.getDBSchemas(defaultSchema);
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (analyseOptionsDialog.edit(schemas, defaultSchema[0], isDefaultSchema, this.dbConnectionDialog.currentConnection.user)) {
                String schema = analyseOptionsDialog.getSelectedSchema();
                if (schema != null) {
                    args.add("-schema");
                    args.add(schema);
                }
                if (!isDefaultSchema[0]) {
                    args.add("-qualifyNames");
                }
                ModelBuilder.assocFilter = analyseOptionsDialog.getAssociationLineFilter();
                if (DataBrowserContext.isStandAlone()) {
                    UIUtil.disableWarnings = true;
                }
                if (UIUtil.runJailer(this, args, false, true, false, true, null, this.dbConnectionDialog.getPassword(), null, null, false, true, false)) {
                    ModelBuilder.assocFilter = null;
                    String modelname = this.datamodel == null || this.datamodel.get() == null ? "New Model" : this.datamodel.get().getName();
                    DataModelEditor dataModelEditor = new DataModelEditor(this, true, analyseOptionsDialog.isRemoving(), null, analyseOptionsDialog.getTableLineFilter(), analyseOptionsDialog.getAssociationLineFilter(), modelname, schema == null ? this.dbConnectionDialog.getName() : schema);
                    if (dataModelEditor.dataModelHasChanged()) {
                        dataModelEditor.setVisible(true);
                    }
                    this.desktop.reloadDataModel(this.desktop.schemaMapping);
                    this.updateStatusBar();
                    this.askForDataModel();
                }
            } else {
                this.askForDataModel();
            }
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
        finally {
            ModelBuilder.assocFilter = null;
        }
    }

    private void setPLAF(String plaf) {
        try {
            UIManager.setLookAndFeel(plaf);
            SwingUtilities.updateComponentTreeUI(this);
            try {
                File file = new File(PLAFSETTING);
                file.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                File plafSetting = new File(PLAFSETTING);
                PrintWriter out = new PrintWriter(plafSetting);
                out.println(plaf);
                out.close();
            }
            catch (Exception x) {}
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void askForDataModel() {
        try {
            if (this.datamodel.get().getTables().isEmpty()) {
                switch (JOptionPane.showOptionDialog(this, "Data model \"" + (String)DataModelManager.getModelDetails((String)DataModelManager.getCurrentModelSubfolder()).a + "\" is empty.", DataBrowserContext.getAppName(true), 0, 1, null, new Object[]{"Analyze Database", "Data Model Editor"}, null)) {
                    case 0: {
                        this.updateDataModel();
                        break;
                    }
                    case 1: {
                        this.openDataModelEditor();
                    }
                }
            } else if (!new File(DataModel.getColumnsFile()).exists()) {
                switch (JOptionPane.showOptionDialog(this, "No column definition found.", DataBrowserContext.getAppName(true), 0, 1, null, new Object[]{"Analyze Database", "Data Model Editor"}, null)) {
                    case 0: {
                        this.updateDataModel();
                        break;
                    }
                    case 1: {
                        this.openDataModelEditor();
                    }
                }
            }
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void updateIFramesBar() {
        this.updateNavigationTree();
        this.updateBorderBrowser();
        this.updateHiddenPanel();
    }

    private void updateHiddenPanel() {
        if (this.desktop == null) {
            return;
        }
        this.hiddenPanel.removeAll();
        this.hiddenPanel.setVisible(false);
        int num = this.desktop.getAllFrames().length;
        if (num == 0) {
            this.jPanel1.revalidate();
            return;
        }
        int COLUMNS = 7;
        int y = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = y;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        JPanel iFramesRowPanel = new JPanel();
        iFramesRowPanel.setLayout(new GridBagLayout());
        this.hiddenPanel.add((Component)iFramesRowPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = COLUMNS + 2;
        gridBagConstraints.gridy = y;
        gridBagConstraints.weightx = 1.0;
        iFramesRowPanel.add((Component)new JLabel(" "), gridBagConstraints);
        int x = 1;
        boolean visible = false;
        for (final Desktop.RowBrowser rb : this.desktop.getBrowsers()) {
            if (!rb.isHidden()) continue;
            visible = true;
            if (++x > COLUMNS) {
                x = 1;
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = ++y;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                iFramesRowPanel = new JPanel();
                iFramesRowPanel.setLayout(new GridBagLayout());
                this.hiddenPanel.add((Component)iFramesRowPanel, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = COLUMNS + 2;
                gridBagConstraints.gridy = y;
                gridBagConstraints.weightx = 1.0;
                iFramesRowPanel.add((Component)new JLabel(" "), gridBagConstraints);
            }
            final JToggleButton toggleButton = new JToggleButton();
            toggleButton.setText(rb.internalFrame.getTitle());
            toggleButton.setSelected(false);
            toggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    toggleButton.setSelected(true);
                    rb.setHidden(false);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = x;
            gridBagConstraints.gridy = y;
            iFramesRowPanel.add((Component)toggleButton, gridBagConstraints);
            this.hiddenPanel.setVisible(visible);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBorderBrowser() {
        if (this.disableBorderBrowserUpdates) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ArrayList<AssociationListUI.AssociationModel> model = new ArrayList<AssociationListUI.AssociationModel>();
            if (this.desktop != null) {
                this.titleLabel.setText(" Related Rows");
                ArrayList<Desktop.RowBrowser> allChildren = new ArrayList<Desktop.RowBrowser>();
                for (Desktop.RowBrowser rb : this.desktop.getBrowsers()) {
                    if (rb.internalFrame != this.desktop.getSelectedFrame() || rb.isHidden()) continue;
                    allChildren.add(rb);
                    allChildren.addAll(this.collectChildren(rb));
                    this.titleLabel.setText(" Related Rows of Subtree " + rb.internalFrame.getTitle());
                    break;
                }
                for (Desktop.RowBrowser rb : allChildren) {
                    if (rb.browserContentPane.table == null) continue;
                    HashSet<Association> associations = new HashSet<Association>(rb.browserContentPane.table.associations);
                    for (Desktop.RowBrowser c : this.desktop.getChildBrowsers(rb, false)) {
                        if (c.browserContentPane.association == null) continue;
                        associations.remove(c.browserContentPane.association);
                    }
                    if (rb.browserContentPane.association != null && rb.parent != null && allChildren.contains(rb.parent)) {
                        associations.remove(rb.browserContentPane.association.reversalAssociation);
                    }
                    for (Association association : associations) {
                        model.add(new BrowserAssociationModel(rb, association));
                    }
                }
            }
            this.borderBrowser.setModel(model);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveSelection(Collection<AssociationListUI.AssociationModel> selection) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.disableBorderBrowserUpdates = true;
            JInternalFrame currentSelection = this.desktop.getSelectedFrame();
            for (AssociationListUI.AssociationModel a : selection) {
                BrowserAssociationModel associationModel = (BrowserAssociationModel)a;
                this.desktop.addTableBrowser(associationModel.getRowBrowser(), -1, associationModel.getAssociation().destination, associationModel.getAssociation(), "", null, null, true);
            }
            if (currentSelection != null) {
                try {
                    currentSelection.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.disableBorderBrowserUpdates = false;
            this.updateBorderBrowser();
        }
    }

    private List<Desktop.RowBrowser> collectChildren(Desktop.RowBrowser rb) {
        ArrayList<Desktop.RowBrowser> result = new ArrayList<Desktop.RowBrowser>();
        for (Desktop.RowBrowser c : this.desktop.getChildBrowsers(rb, true)) {
            result.add(c);
        }
        for (Desktop.RowBrowser c : this.desktop.getChildBrowsers(rb, true)) {
            result.addAll(this.collectChildren(c));
        }
        return result;
    }

    private void updateNavigationTree() {
        JInternalFrame activeFrame;
        Object node;
        if (this.navigationTreeListener != null) {
            this.navigationTree.getSelectionModel().removeTreeSelectionListener(this.navigationTreeListener);
        }
        DbConnectionDialog.ConnectionInfo connection = this.dbConnectionDialog != null ? this.dbConnectionDialog.currentConnection : null;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(connection != null ? " " + connection.alias : " ");
        this.treeNodeByIFrame.clear();
        int[] count = new int[]{1};
        if (this.desktop != null) {
            for (Desktop.RowBrowser rb : this.desktop.getRootBrowsers(true)) {
                int n = count[0];
                count[0] = n + 1;
                node = new DefaultMutableTreeNode(new TreeNodeForRowBrowser(rb, n));
                root.add((MutableTreeNode)node);
                this.addChildNodes((DefaultMutableTreeNode)node, rb, count);
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.navigationTree.setModel(treeModel);
        for (int i = 0; i < count[0]; ++i) {
            this.navigationTree.expandRow(i);
        }
        JInternalFrame jInternalFrame = activeFrame = this.desktop != null ? this.desktop.getSelectedFrame() : null;
        if (activeFrame != null && (node = this.treeNodeByIFrame.get(activeFrame)) != null) {
            this.navigationTree.setSelectionRow(((TreeNodeForRowBrowser)node).rowIndex);
            Rectangle bounds = this.navigationTree.getRowBounds(((TreeNodeForRowBrowser)node).rowIndex);
            this.navigationTree.scrollRectToVisible(new Rectangle(bounds.x, bounds.y, 1, bounds.height));
        }
        this.navigationTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object lastPathComponent;
                if (e.getPath() != null && (lastPathComponent = e.getPath().getLastPathComponent()) != null && lastPathComponent instanceof DefaultMutableTreeNode) {
                    Object userObject = ((DefaultMutableTreeNode)lastPathComponent).getUserObject();
                    if (userObject instanceof TreeNodeForRowBrowser) {
                        try {
                            JInternalFrame iFrame = ((TreeNodeForRowBrowser)userObject).rowBrowser.internalFrame;
                            DataBrowser.this.desktop.scrollToCenter(iFrame);
                            iFrame.setSelected(true);
                            iFrame.grabFocus();
                        }
                        catch (PropertyVetoException e1) {
                            // empty catch block
                        }
                        return;
                    }
                    DataBrowser.this.openNewTableBrowser(false);
                }
                DataBrowser.this.updateNavigationTree();
            }
        };
        this.navigationTree.getSelectionModel().addTreeSelectionListener(this.navigationTreeListener);
    }

    private void addChildNodes(DefaultMutableTreeNode node, Desktop.RowBrowser browser, int[] count) {
        for (Desktop.RowBrowser rb : this.desktop.getChildBrowsers(browser, true)) {
            int n = count[0];
            count[0] = n + 1;
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new TreeNodeForRowBrowser(rb, n));
            node.add(childNode);
            this.addChildNodes(childNode, rb, count);
        }
    }

    public JScrollPane getDesktopScrollPane() {
        return this.jScrollPane1;
    }

    static {
        InputStream in = Jailer.class.getResourceAsStream("/net/sf/jailer/resource/log4j.properties");
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PropertyConfigurator.configure(p);
    }

    private class TreeNodeForRowBrowser {
        public final Desktop.RowBrowser rowBrowser;
        public final int rowIndex;
        private final String title;

        public TreeNodeForRowBrowser(Desktop.RowBrowser rowBrowser, int rowIndex) {
            this.rowBrowser = rowBrowser;
            this.rowIndex = rowIndex;
            this.title = " " + rowBrowser.internalFrame.getTitle() + "  ";
            DataBrowser.this.treeNodeByIFrame.put(rowBrowser.internalFrame, this);
        }

        public String toString() {
            return this.title;
        }
    }

    private static class BrowserAssociationModel
    extends AssociationListUI.DefaultAssociationModel {
        private final Desktop.RowBrowser rowBrowser;

        public BrowserAssociationModel(Desktop.RowBrowser rowBrowser, Association association) {
            super(association);
            this.rowBrowser = rowBrowser;
        }

        @Override
        public String getSourceName() {
            return this.rowBrowser.internalFrame.getTitle();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof BrowserAssociationModel) {
                BrowserAssociationModel otherModel = (BrowserAssociationModel)other;
                return this.rowBrowser == otherModel.rowBrowser && this.association == otherModel.association;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.rowBrowser.hashCode() + 3 * this.association.hashCode();
        }

        public Desktop.RowBrowser getRowBrowser() {
            return this.rowBrowser;
        }

        public Association getAssociation() {
            return this.association;
        }
    }
}

