/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui.databrowser;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.PriorityBlockingQueue;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Configuration;
import net.sf.jailer.ScriptFormat;
import net.sf.jailer.database.Session;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.PrimaryKey;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.modelbuilder.JDBCMetaDataBasedModelElementFinder;
import net.sf.jailer.ui.ConditionEditor;
import net.sf.jailer.ui.DbConnectionDialog;
import net.sf.jailer.ui.ExtractionModelFrame;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.QueryBuilderDialog;
import net.sf.jailer.ui.RestrictionDefinition;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.ui.databrowser.DataBrowserContext;
import net.sf.jailer.ui.databrowser.Desktop;
import net.sf.jailer.ui.databrowser.DetailsView;
import net.sf.jailer.ui.databrowser.LobValue;
import net.sf.jailer.ui.databrowser.QueryBuilderPathSelector;
import net.sf.jailer.ui.databrowser.Row;
import net.sf.jailer.ui.databrowser.RowCounter;
import net.sf.jailer.ui.databrowser.SQLBrowserContentPane;
import net.sf.jailer.ui.databrowser.SQLDMLBuilder;
import net.sf.jailer.ui.databrowser.SQLDMLPanel;
import net.sf.jailer.ui.databrowser.SbEDialog;
import net.sf.jailer.ui.scrollmenu.JScrollC2Menu;
import net.sf.jailer.ui.scrollmenu.JScrollPopupMenu;
import net.sf.jailer.util.CancellationException;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.Pair;
import net.sf.jailer.util.SqlUtil;

public abstract class BrowserContentPane
extends JPanel {
    private static final Integer[] ROW_LIMITS = new Integer[]{200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 70000, 100000};
    private static boolean asking = false;
    private Runnable reloadAction;
    private LoadJob currentLoadJob;
    Table table;
    Row parentRow;
    DataModel dataModel;
    Association association;
    List<Row> rows = new ArrayList<Row>();
    private final Map<Pair<String, Association>, Pair<Long, Long>> rowCountCache = Collections.synchronizedMap(new HashMap());
    private final long MAX_ROWCOUNTCACHE_RETENTION_TIME = 300000L;
    private int noNonDistinctRows;
    private int noDistinctRows;
    Set<Integer> highlightedRows = new HashSet<Integer>();
    private Set<Integer> pkColumns = new HashSet<Integer>();
    Session session;
    private int currentRowSelection = -1;
    private List<Row> parentRows;
    protected final Set<Pair<BrowserContentPane, Row>> currentClosure;
    protected Set<Pair<BrowserContentPane, String>> currentClosureRowIDs;
    private DetailsView singleRowDetailsView;
    private int initialRowHeight;
    public SQLBrowserContentPane sqlBrowserContentPane;
    private boolean suppressReload;
    private static final String ROWNUMBERALIAS = "RN";
    protected static final String NULL = "null";
    protected static final int MAXLOBLENGTH = 2000;
    private final DefaultComboBoxModel andCondModel = new DefaultComboBoxModel();
    boolean isPending = false;
    private boolean suppessReloadOnAndConditionAction = false;
    private String currentSelectedRowCondition = "";
    private long lastReloadTS = 0L;
    private boolean isLimitExceeded = false;
    javax.swing.JComboBox andCondition;
    private JLabel andLabel;
    private JButton cancelLoadButton;
    private JPanel cardPanel;
    private JLabel dropA;
    private JLabel dropB;
    private JLabel fetchLabel;
    private JLabel from;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JLabel join;
    private JPanel joinPanel;
    javax.swing.JComboBox limitBox;
    private JButton loadButton;
    private JLabel on;
    private JPanel onPanel;
    private JLabel openEditorLabel;
    private JPanel pendingNonpendingPanel;
    private JLabel relatedRowsLabel;
    private JPanel relatedRowsPanel;
    private JLabel rowsCount;
    public JTable rowsTable;
    JScrollPane rowsTableScrollPane;
    JCheckBox selectDistinctCheckBox;
    private JLabel sqlLabel1;
    private JPanel sqlPanel;
    private JLabel where;
    private JPanel wherePanel;
    private ConditionEditor andConditionEditor;
    private Icon conditionEditorIcon;
    private Icon conditionEditorSelectedIcon;
    private Icon dropDownIcon;

    public void setOnReloadAction(Runnable runnable) {
        this.reloadAction = runnable;
    }

    public BrowserContentPane(DataModel dataModel, final Table table, String condition, Session session, Row parentRow, List<Row> parentRows, final Association association, Frame parentFrame, Set<Pair<BrowserContentPane, Row>> currentClosure, Set<Pair<BrowserContentPane, String>> currentClosureRowIDs, Integer limit, Boolean selectDistinct, boolean reload) {
        String dir = "/net/sf/jailer/resource";
        try {
            this.conditionEditorIcon = new ImageIcon(this.getClass().getResource(dir + "/edit.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.conditionEditorSelectedIcon = new ImageIcon(this.getClass().getResource(dir + "/edit_s.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dir = "/net/sf/jailer/resource";
        try {
            this.dropDownIcon = new ImageIcon(this.getClass().getResource(dir + "/dropdown.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.table = table;
        this.session = session;
        this.dataModel = dataModel;
        this.parentRow = parentRow;
        this.parentRows = parentRows;
        this.association = association;
        this.currentClosure = currentClosure;
        this.currentClosureRowIDs = currentClosureRowIDs;
        this.suppressReload = true;
        if (table == null) {
            this.table = new SqlStatementTable(null, null, false);
        }
        this.initComponents();
        this.setPendingState(false, false);
        this.dropA.setText(null);
        this.dropA.setIcon(this.dropDownIcon);
        this.sqlLabel1.setIcon(this.dropDownIcon);
        this.dropA.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BrowserContentPane.this.openColumnDropDownBox(BrowserContentPane.this.dropA, "A", table);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BrowserContentPane.this.dropA.setEnabled(false);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BrowserContentPane.this.dropA.setEnabled(true);
            }
        });
        if (association != null) {
            this.dropB.setText(null);
            this.dropB.setIcon(this.dropDownIcon);
            this.dropB.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    BrowserContentPane.this.openColumnDropDownBox(BrowserContentPane.this.dropB, "B", association.source);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    BrowserContentPane.this.dropB.setEnabled(false);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    BrowserContentPane.this.dropB.setEnabled(true);
                }
            });
        }
        this.andCondModel.addElement("");
        this.andCondition.setModel(this.andCondModel);
        this.andCondition.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BrowserContentPane.this.suppessReloadOnAndConditionAction && e.getStateChange() == 1) {
                    BrowserContentPane.this.historizeAndCondition(e.getItem());
                    BrowserContentPane.this.reloadRows();
                }
            }
        });
        this.initialRowHeight = this.rowsTable.getRowHeight();
        this.rowsTable = new JTable(){
            private int[] x = new int[2];
            private int[] y = new int[2];
            private Color color = new Color(0, 0, 200);

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (!(graphics instanceof Graphics2D)) {
                    return;
                }
                RowSorter<? extends TableModel> rowSorter = BrowserContentPane.this.rowsTable.getRowSorter();
                for (int i = 0; i < BrowserContentPane.this.rowsTable.getRowCount(); ++i) {
                    if (rowSorter.convertRowIndexToView(i) == i) continue;
                    return;
                }
                int maxI = Math.min(BrowserContentPane.this.rowsTable.getRowCount(), BrowserContentPane.this.rows.size());
                for (int i = 0; i < maxI; ++i) {
                    if (!BrowserContentPane.this.rows.get(i).isBlockEnd()) continue;
                    Graphics2D g2d = (Graphics2D)graphics;
                    g2d.setColor(this.color);
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setStroke(new BasicStroke(1.0f));
                    Rectangle r = BrowserContentPane.this.rowsTable.getCellRect(i, 0, false);
                    this.x[0] = (int)r.getMinX();
                    this.y[0] = (int)r.getMaxY();
                    r = BrowserContentPane.this.rowsTable.getCellRect(i, BrowserContentPane.this.rowsTable.getColumnCount() - 1, false);
                    this.x[1] = (int)r.getMaxX();
                    this.y[1] = (int)r.getMaxY();
                    g2d.drawPolyline(this.x, this.y, 2);
                }
            }
        };
        this.rowsTable.setAutoCreateRowSorter(true);
        this.rowsTable.setAutoResizeMode(0);
        this.rowsTableScrollPane.setViewportView(this.rowsTable);
        this.setAndCondition(condition, true);
        this.from.setText(table == null ? "" : this.dataModel.getDisplayName(table));
        this.adjustGui();
        this.rowsTable.setShowGrid(false);
        final TableCellRenderer defaultTableCellRenderer = this.rowsTable.getDefaultRenderer(String.class);
        this.rowsTable.setDefaultRenderer(Object.class, new TableCellRenderer(){
            final Color BG1 = new Color(255, 255, 255);
            final Color BG2 = new Color(230, 255, 255);
            final Color BG3 = new Color(190, 195, 255);
            final Color FG1 = new Color(155, 0, 0);
            final Font font = new JLabel().getFont();
            final Font nonbold = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
            final Font bold = new Font(this.nonbold.getName(), this.nonbold.getStyle() | 1, this.nonbold.getSize());
            final Font italic = new Font(this.nonbold.getName(), this.nonbold.getStyle() | 2, this.nonbold.getSize());
            final Font italicBold = new Font(this.nonbold.getName(), this.nonbold.getStyle() | 2 | 1, this.nonbold.getSize());

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                isSelected = BrowserContentPane.this.currentRowSelection == row || BrowserContentPane.this.currentRowSelection == -2;
                Component render = defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (value instanceof Row) {
                    Row theRow = (Row)value;
                    Pair<BrowserContentPane, String> pair = new Pair<BrowserContentPane, String>(BrowserContentPane.this, theRow.rowId);
                    BrowserContentPane.this.singleRowDetailsView.setBorderColor(isSelected ? render.getBackground() : (BrowserContentPane.this.currentClosureRowIDs.contains(pair) ? this.BG3 : Color.WHITE));
                    return BrowserContentPane.this.singleRowDetailsView;
                }
                RowSorter<? extends TableModel> rowSorter = BrowserContentPane.this.rowsTable.getRowSorter();
                if (render instanceof JLabel) {
                    if (!isSelected) {
                        if (row < BrowserContentPane.this.rows.size() && BrowserContentPane.this.currentClosureRowIDs.contains(new Pair<BrowserContentPane, String>(BrowserContentPane.this, BrowserContentPane.this.rows.get((int)rowSorter.convertRowIndexToModel((int)row)).rowId))) {
                            ((JLabel)render).setBackground(this.BG3);
                        } else {
                            ((JLabel)render).setBackground(row % 2 == 0 ? this.BG1 : this.BG2);
                        }
                    }
                    ((JLabel)render).setForeground(BrowserContentPane.this.pkColumns.contains(BrowserContentPane.this.rowsTable.convertColumnIndexToModel(column)) ? this.FG1 : Color.BLACK);
                    boolean isNull = false;
                    if (((JLabel)render).getText() == BrowserContentPane.NULL) {
                        ((JLabel)render).setForeground(Color.gray);
                        ((JLabel)render).setFont(this.italic);
                        isNull = true;
                    }
                    try {
                        if (isNull) {
                            ((JLabel)render).setFont(BrowserContentPane.this.highlightedRows.contains(rowSorter.convertRowIndexToModel(row)) ? this.italicBold : this.italic);
                        } else {
                            ((JLabel)render).setFont(BrowserContentPane.this.highlightedRows.contains(rowSorter.convertRowIndexToModel(row)) ? this.bold : this.nonbold);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return render;
            }
        });
        this.rowsTable.setRowSelectionAllowed(false);
        this.rowsTable.setColumnSelectionAllowed(false);
        this.rowsTable.setCellSelectionEnabled(false);
        this.rowsTable.setEnabled(false);
        this.rowsTableScrollPane.getVerticalScrollBar().setUnitIncrement(32);
        this.rowsTable.addMouseListener(new MouseListener(){
            private JPopupMenu lastMenu;

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int ri = BrowserContentPane.this.rowsTable.rowAtPoint(e.getPoint());
                if (ri >= 0) {
                    int i = BrowserContentPane.this.rowsTable.getRowSorter().convertRowIndexToModel(ri);
                    Row row = BrowserContentPane.this.rows.get(i);
                    if (this.lastMenu == null || !this.lastMenu.isVisible()) {
                        if (e.getButton() != 1 || e.getClickCount() > 1) {
                            BrowserContentPane.this.currentRowSelection = ri;
                            BrowserContentPane.this.onRedraw();
                            Rectangle r = BrowserContentPane.this.rowsTable.getCellRect(ri, 0, false);
                            int x = Math.max(e.getPoint().x, (int)r.getMinX());
                            int y = (int)r.getMaxY() - 2;
                            if (BrowserContentPane.this.singleRowDetailsView != null) {
                                y = e.getY();
                            }
                            Point p = SwingUtilities.convertPoint(BrowserContentPane.this.rowsTable, x, y, null);
                            JPopupMenu popup = BrowserContentPane.this.createPopupMenu(row, i, p.x + BrowserContentPane.this.getOwner().getX(), p.y + BrowserContentPane.this.getOwner().getY(), BrowserContentPane.this.rows.size() == 1);
                            popup.show(BrowserContentPane.this.rowsTable, x, y);
                            popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent evt) {
                                    if (Boolean.FALSE.equals(evt.getNewValue())) {
                                        BrowserContentPane.this.currentRowSelection = -1;
                                        BrowserContentPane.this.onRedraw();
                                    }
                                }
                            });
                            this.lastMenu = popup;
                        } else {
                            BrowserContentPane.this.setCurrentRowSelection(ri);
                            BrowserContentPane.this.setCurrentRowSelection(-1);
                        }
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.andConditionEditor = new ConditionEditor(parentFrame, null);
        this.openEditorLabel.setIcon(this.conditionEditorIcon);
        this.openEditorLabel.setText(null);
        this.openEditorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String cond = BrowserContentPane.this.andConditionEditor.edit(BrowserContentPane.this.getAndConditionText(), "Table", "A", table, null, null, null, false);
                if (cond != null && !BrowserContentPane.this.getAndConditionText().equals(ConditionEditor.toSingleLine(cond))) {
                    BrowserContentPane.this.setAndCondition(cond, true);
                    BrowserContentPane.this.loadButton.grabFocus();
                    BrowserContentPane.this.reloadRows();
                }
                BrowserContentPane.this.openEditorLabel.setIcon(BrowserContentPane.this.conditionEditorSelectedIcon);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                BrowserContentPane.this.openEditorLabel.setIcon(BrowserContentPane.this.conditionEditorSelectedIcon);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                BrowserContentPane.this.openEditorLabel.setIcon(BrowserContentPane.this.conditionEditorIcon);
            }
        });
        this.relatedRowsPanel.addMouseListener(new MouseAdapter(){
            private JPopupMenu popup;
            private boolean in = false;

            @Override
            public void mousePressed(MouseEvent e) {
                this.popup = BrowserContentPane.this.createPopupMenu(null, -1, 0, 0, false);
                BrowserContentPane.this.setCurrentRowSelection(-2);
                this.popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (Boolean.FALSE.equals(evt.getNewValue())) {
                            popup = null;
                            this.updateBorder();
                            BrowserContentPane.this.setCurrentRowSelection(-1);
                        }
                    }
                });
                this.popup.show(BrowserContentPane.this.relatedRowsPanel, 0, BrowserContentPane.this.relatedRowsPanel.getHeight());
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                this.in = true;
                this.updateBorder();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                this.in = false;
                this.updateBorder();
            }

            private void updateBorder() {
                BrowserContentPane.this.relatedRowsPanel.setBorder(new SoftBevelBorder(this.in || this.popup != null ? 1 : 0));
            }
        });
        this.sqlPanel.addMouseListener(new MouseAdapter(){
            private JPopupMenu popup;
            private boolean in = false;

            @Override
            public void mousePressed(MouseEvent e) {
                this.popup = BrowserContentPane.this.createSqlPopupMenu(BrowserContentPane.this.parentRow, 0, 300, 300, false);
                BrowserContentPane.this.setCurrentRowSelection(-2);
                this.popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (Boolean.FALSE.equals(evt.getNewValue())) {
                            popup = null;
                            this.updateBorder();
                            BrowserContentPane.this.setCurrentRowSelection(-1);
                        }
                    }
                });
                this.popup.show(BrowserContentPane.this.sqlPanel, 0, BrowserContentPane.this.sqlPanel.getHeight());
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                this.in = true;
                this.updateBorder();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                this.in = false;
                this.updateBorder();
            }

            private void updateBorder() {
                BrowserContentPane.this.sqlPanel.setBorder(new SoftBevelBorder(this.in || this.popup != null ? 1 : 0));
            }
        });
        this.limitBox.setModel(new DefaultComboBoxModel<Integer>(ROW_LIMITS));
        this.limitBox.setSelectedIndex(association == null ? 0 : 1);
        if (limit != null) {
            this.limitBox.setSelectedItem(limit);
        }
        if (selectDistinct != null) {
            this.selectDistinctCheckBox.setSelected(selectDistinct);
        }
        this.updateTableModel(0, false);
        if (this.table instanceof SqlStatementTable) {
            this.sqlBrowserContentPane = new SQLBrowserContentPane();
            this.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.sqlBrowserContentPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.sqlBrowserContentPane.editorPanel.add((Component)this.limitBox, gridBagConstraints);
            this.sqlBrowserContentPane.rowListPanel.add((Component)this.cardPanel, "Center");
            this.cardPanel.setVisible(true);
            this.sqlBrowserContentPane.sqlEditorPane.setContentType("text/sql");
            this.sqlBrowserContentPane.sqlEditorPane.setText(condition);
            this.sqlBrowserContentPane.sqlEditorPane.setCaretPosition(0);
            this.sqlBrowserContentPane.reloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    BrowserContentPane.this.reloadRows();
                }
            });
            this.sqlBrowserContentPane.detailsButton.setEnabled(false);
            this.sqlBrowserContentPane.detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowserContentPane.this.openDetails(300, 300);
                }
            });
        }
        this.suppressReload = false;
        if (reload) {
            this.reloadRows();
        }
    }

    void setPendingState(boolean pending, boolean propagate) {
        this.isPending = pending;
        ((CardLayout)this.pendingNonpendingPanel.getLayout()).show(this.pendingNonpendingPanel, pending ? "pending" : "nonpending");
        if (propagate) {
            for (Desktop.RowBrowser child : this.getChildBrowsers()) {
                child.browserContentPane.setPendingState(pending, propagate);
            }
        }
    }

    protected void historizeAndCondition(Object item) {
        if (item == null) {
            return;
        }
        for (int i = 0; i < this.andCondModel.getSize(); ++i) {
            if (!item.equals(this.andCondModel.getElementAt(i))) continue;
            return;
        }
        this.andCondModel.insertElementAt(item, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAndCondition(String cond, boolean historize) {
        try {
            this.suppessReloadOnAndConditionAction = true;
            this.andCondition.setSelectedItem(ConditionEditor.toSingleLine(cond));
            if (historize) {
                this.historizeAndCondition(ConditionEditor.toSingleLine(cond));
            }
        }
        finally {
            this.suppessReloadOnAndConditionAction = false;
        }
    }

    String getAndConditionText() {
        Object sel = this.andCondition.getSelectedItem();
        if (sel == null) {
            return "";
        }
        return sel.toString().trim();
    }

    private void adjustGui() {
        if (this.association == null) {
            this.joinPanel.setVisible(false);
            this.onPanel.setVisible(false);
            this.wherePanel.setVisible(false);
            this.jLabel1.setText(" ");
            this.jLabel4.setText(" ");
            this.jLabel9.setText(" ");
            this.jLabel6.setVisible(false);
            this.dropB.setVisible(false);
            this.andLabel.setText(" Where ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 8;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 12;
        } else {
            this.join.setText(this.dataModel.getDisplayName(this.association.source));
            this.on.setText(!this.association.reversed ? SqlUtil.reversRestrictionCondition(this.association.getUnrestrictedJoinCondition()) : this.association.getUnrestrictedJoinCondition());
            this.updateWhereField();
            this.join.setToolTipText(this.join.getText());
            this.on.setToolTipText(this.on.getText());
            this.where.setToolTipText(this.where.getText());
        }
    }

    public JPopupMenu createPopupMenu(final Row row, final int rowIndex, final int x, final int y, boolean navigateFromAllRows) {
        ArrayList<String> assList = new ArrayList<String>();
        HashMap<String, Association> assMap = new HashMap<String, Association>();
        for (Association a : this.table.associations) {
            int n = 0;
            for (Association a2 : this.table.associations) {
                if (a.destination != a2.destination) continue;
                ++n;
            }
            int c = 32;
            c = a.isIgnored() ? 52 : (a.isInsertDestinationBeforeSource() ? 49 : (a.isInsertSourceBeforeDestination() ? 50 : 51));
            String name = (char)c + a.getDataModel().getDisplayName(a.destination) + (n > 1 ? " on " + a.getName() : "");
            assList.add(name);
            assMap.put(name, a);
        }
        Collections.sort(assList);
        final Object context = new Object();
        AllNonEmptyItem allNonEmpty = new AllNonEmptyItem();
        JPopupMenu popup = new JPopupMenu();
        popup = this.createNavigationMenu(popup, row, rowIndex, assList, assMap, "Parents", "1", navigateFromAllRows, 80, allNonEmpty, context);
        popup = this.createNavigationMenu(popup, row, rowIndex, assList, assMap, "Children", "2", navigateFromAllRows, 60, allNonEmpty, context);
        popup = this.createNavigationMenu(popup, row, rowIndex, assList, assMap, "Associated Rows", "3", navigateFromAllRows, 40, allNonEmpty, context);
        popup = this.createNavigationMenu(popup, row, rowIndex, assList, assMap, "Detached Rows", "4", navigateFromAllRows, 40, allNonEmpty, context);
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.cancel();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.cancel();
            }

            private void cancel() {
                CancellationHandler.cancelSilently(context);
                BrowserContentPane.this.getRunnableQueue().add(new RunnableWithPriority(){

                    @Override
                    public void run() {
                        CancellationHandler.reset(context);
                    }

                    @Override
                    public int getPriority() {
                        return 0;
                    }
                });
            }
        });
        if (!this.isPending && !this.rows.isEmpty()) {
            popup.add(allNonEmpty);
            allNonEmpty.setInitialText();
        }
        if (row != null) {
            if (!(this.table instanceof SqlStatementTable)) {
                popup.add(new JSeparator());
            }
            JMenuItem det = new JMenuItem("Details");
            popup.add(det);
            det.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog d = new JDialog(BrowserContentPane.this.getOwner(), BrowserContentPane.this.table instanceof SqlStatementTable ? "" : BrowserContentPane.this.dataModel.getDisplayName(BrowserContentPane.this.table), true);
                    d.getContentPane().add(new DetailsView(BrowserContentPane.this.rows, BrowserContentPane.this.rowsTable.getRowCount(), BrowserContentPane.this.dataModel, BrowserContentPane.this.table, rowIndex, BrowserContentPane.this.rowsTable.getRowSorter(), true){

                        @Override
                        protected void onRowChanged(int row) {
                            BrowserContentPane.this.setCurrentRowSelection(row);
                        }
                    });
                    d.pack();
                    d.setLocation(x, y);
                    d.setSize(400, d.getHeight() + 20);
                    UIUtil.fit(d);
                    d.setVisible(true);
                    BrowserContentPane.this.setCurrentRowSelection(-1);
                }
            });
            if (!(this.table instanceof SqlStatementTable)) {
                JMenuItem sr;
                popup.add(new JSeparator());
                JMenuItem qb = new JMenuItem("Query Builder");
                popup.add(qb);
                qb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ArrayList<String> whereClauses = new ArrayList<String>();
                        whereClauses.add(SqlUtil.replaceAliases(row.rowId, "A", "A"));
                        BrowserContentPane.this.getQueryBuilderDialog().buildQuery(BrowserContentPane.this.table, true, false, new ArrayList<Association>(), whereClauses, BrowserContentPane.this.dataModel);
                    }
                });
                if (!this.currentSelectedRowCondition.equals("") && this.currentSelectedRowCondition.equals(this.getAndConditionText()) && this.rows.size() == 1) {
                    sr = new JMenuItem("Deselect Row");
                    popup.add(sr);
                    sr.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            BrowserContentPane.this.andCondition.setSelectedItem("");
                            BrowserContentPane.this.reloadRows();
                        }
                    });
                } else {
                    sr = new JMenuItem("Select Row");
                    sr.setEnabled(this.rows.size() > 1);
                    popup.add(sr);
                    sr.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String cond = SqlUtil.replaceAliases(row.rowId, "A", "A");
                            String currentCond = BrowserContentPane.this.getAndConditionText().trim();
                            if (currentCond.length() > 0) {
                                cond = "(" + cond + ") and (" + currentCond + ")";
                            }
                            BrowserContentPane.this.andCondition.setSelectedItem(cond);
                            BrowserContentPane.this.currentSelectedRowCondition = cond;
                            BrowserContentPane.this.reloadRows();
                        }
                    });
                }
                JMenu sql = new JMenu("SQL/DML");
                final String rowName = this.dataModel.getDisplayName(this.table) + "(" + SqlUtil.replaceAliases(row.rowId, null, null) + ")";
                JMenuItem insert = new JMenuItem("Insert");
                sql.add(insert);
                insert.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BrowserContentPane.this.openSQLDialog("Insert Row " + rowName, x, y, SQLDMLBuilder.buildInsert(BrowserContentPane.this.table, row, true, BrowserContentPane.this.session));
                    }
                });
                JMenuItem update = new JMenuItem("Update");
                sql.add(update);
                update.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BrowserContentPane.this.openSQLDialog("Update Row " + rowName, x, y, SQLDMLBuilder.buildUpdate(BrowserContentPane.this.table, row, true, BrowserContentPane.this.session));
                    }
                });
                JMenuItem delete = new JMenuItem("Delete");
                sql.add(delete);
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BrowserContentPane.this.openSQLDialog("Delete Row " + rowName, x, y, SQLDMLBuilder.buildDelete(BrowserContentPane.this.table, row, true, BrowserContentPane.this.session));
                    }
                });
                popup.add(sql);
            }
        }
        return popup;
    }

    public JPopupMenu createSqlPopupMenu(final Row parentrow, int rowIndex, final int x, final int y, boolean forNavTree) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem qb = new JMenuItem("Open Query Builder");
        popup.add(qb);
        qb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.openQueryBuilder();
            }
        });
        popup.add(new JSeparator());
        JMenuItem snw = new JMenuItem("Show in New Window");
        popup.add(snw);
        snw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.showInNewWindow();
            }
        });
        JMenuItem al = new JMenuItem("Append Layout...");
        popup.add(al);
        al.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.appendLayout();
            }
        });
        popup.add(new JSeparator());
        JMenuItem extractionModel = new JMenuItem("Create Extraction Model");
        popup.add(extractionModel);
        extractionModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.openExtractionModelEditor();
            }
        });
        popup.add(new JSeparator());
        if (!forNavTree) {
            JMenuItem det = new JMenuItem("Details");
            popup.add(det);
            det.setEnabled(this.rows.size() > 0);
            det.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowserContentPane.this.openDetails(x, y);
                }
            });
        }
        JMenu sqlDml = new JMenu("SQL/DML");
        popup.add(sqlDml);
        JMenuItem insertNewRow = new JMenuItem("Insert New Row");
        sqlDml.add(insertNewRow);
        final String tableName = this.dataModel.getDisplayName(this.table);
        insertNewRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.openSQLDialog("Insert New Row Into " + tableName, x, y, SQLDMLBuilder.buildInsert(BrowserContentPane.this.table, BrowserContentPane.this.createNewRow(parentrow, BrowserContentPane.this.table), true, BrowserContentPane.this.session));
            }
        });
        JMenuItem insert = new JMenuItem("Inserts");
        sqlDml.add(insert);
        insert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.openSQLDialog("Insert Into " + tableName, x, y, new Object(){

                    public String toString() {
                        return SQLDMLBuilder.buildInsert(BrowserContentPane.this.table, BrowserContentPane.this.rows, BrowserContentPane.this.session);
                    }
                });
            }
        });
        JMenuItem update = new JMenuItem("Updates");
        sqlDml.add(update);
        update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.openSQLDialog("Update " + tableName, x, y, new Object(){

                    public String toString() {
                        return SQLDMLBuilder.buildUpdate(BrowserContentPane.this.table, BrowserContentPane.this.rows, BrowserContentPane.this.session);
                    }
                });
            }
        });
        JMenuItem delete = new JMenuItem("Deletes");
        sqlDml.add(delete);
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.openSQLDialog("Delete from " + tableName, x, y, new Object(){

                    public String toString() {
                        return SQLDMLBuilder.buildDelete(BrowserContentPane.this.table, BrowserContentPane.this.rows, BrowserContentPane.this.session);
                    }
                });
            }
        });
        insert.setEnabled(this.rows.size() > 0);
        update.setEnabled(this.rows.size() > 0);
        delete.setEnabled(this.rows.size() > 0);
        popup.add(new JSeparator());
        JMenuItem m = new JMenuItem("Hide from View");
        popup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserContentPane.this.onHide();
            }
        });
        m = new JMenuItem("Close" + (this.getChildBrowsers().isEmpty() ? "" : " Subtree"));
        popup.add(m);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.closeSubTree(BrowserContentPane.this);
            }

            private void closeSubTree(BrowserContentPane cp) {
                for (Desktop.RowBrowser c : cp.getChildBrowsers()) {
                    this.closeSubTree(c.browserContentPane);
                }
                cp.close();
            }
        });
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openExtractionModelEditor() {
        Container parent = SwingUtilities.getWindowAncestor(this);
        if (parent == null) {
            parent = this;
        }
        parent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            File newFile;
            String file;
            String subjectCondition;
            String ts = new SimpleDateFormat("HH-mm-ss-SSS").format(new Date());
            Table stable = this.table;
            QueryBuilderDialog.Relationship root = this.createQBRelations(false);
            HashSet<Association> restrictedAssociations = new HashSet<Association>();
            HashSet<Association> restrictedDependencies = new HashSet<Association>();
            HashSet<RestrictionDefinition> restrictedDependencyDefinitions = new HashSet<RestrictionDefinition>();
            List<RestrictionDefinition> restrictionDefinitions = this.createRestrictions(root, stable, restrictedAssociations, restrictedDependencies, restrictedDependencyDefinitions);
            TreeSet<String> parents = new TreeSet<String>();
            for (Association association : restrictedDependencies) {
                parents.add(this.dataModel.getDisplayName(association.destination));
            }
            final SbEDialog sbEDialog = new SbEDialog(SwingUtilities.getWindowAncestor(this), "Create Extraction Model for Subject \"" + this.dataModel.getDisplayName(stable) + "\".", parents.isEmpty() ? "" : "\n\n" + parents.size() + " disregarded parent tables.");
            sbEDialog.regardButton.setVisible(!parents.isEmpty());
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Component result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (value instanceof DefaultMutableTreeNode && !(((DefaultMutableTreeNode)value).getUserObject() instanceof String)) {
                        if (result instanceof JLabel) {
                            ((JLabel)result).setForeground(Color.red);
                        } else {
                            ((JLabel)result).setForeground(Color.black);
                        }
                    }
                    return result;
                }
            };
            renderer.setOpenIcon(null);
            renderer.setLeafIcon(null);
            renderer.setClosedIcon(null);
            sbEDialog.browserTree.setCellRenderer(renderer);
            int[] count = new int[]{0};
            DefaultTreeModel treeModel = new DefaultTreeModel(this.addChildNodes(this, restrictedDependencies, count));
            sbEDialog.browserTree.setModel(treeModel);
            for (int i = 0; i < count[0]; ++i) {
                sbEDialog.browserTree.expandRow(i);
            }
            sbEDialog.browserTree.scrollRowToVisible(0);
            sbEDialog.browserTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    sbEDialog.browserTree.getSelectionModel().clearSelection();
                }
            });
            sbEDialog.setVisible(true);
            if (!sbEDialog.ok) {
                return;
            }
            if (sbEDialog.regardButton.isSelected()) {
                restrictionDefinitions.removeAll(restrictedDependencyDefinitions);
                for (Association a : restrictedDependencies) {
                    this.disableDisregardedNonParentsOfDestination(a, restrictedAssociations, restrictionDefinitions);
                }
            }
            String string = subjectCondition = root.needsAnchor ? root.anchorWhereClause : root.whereClause;
            if (subjectCondition == null) {
                subjectCondition = "";
            }
            subjectCondition = SqlUtil.replaceAliases(subjectCondition, "T", "T");
            int i = 1;
            while (true) {
                file = "extractionmodel" + File.separator + "by-example";
                newFile = CommandLineParser.getInstance().newFile(file);
                newFile.mkdirs();
                file = file + File.separator + "SbE-" + this.dataModel.getDisplayName(stable).replaceAll("[\"'\\[\\]]", "") + "-" + ts + (i > 1 ? "-" + Integer.toString(i) : "") + ".csv";
                newFile = CommandLineParser.getInstance().newFile(file);
                if (!newFile.exists()) break;
                ++i;
            }
            TreeMap<String, Map<String, double[]>> positions = new TreeMap<String, Map<String, double[]>>();
            this.collectPositions(positions);
            this.dataModel.save(file, stable, subjectCondition, ScriptFormat.SQL, restrictionDefinitions, positions);
            if (DataBrowserContext.isStandAlone()) {
                parent.setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(parent, "Jailer Extraction Model created:\n'" + file + "'\n\nJailer Database Subsetter Tool can be found at http://jailer.sourceforge.net", "Jailer Extraction Model", 1);
            } else {
                ExtractionModelFrame extractionModelFrame = ExtractionModelFrame.createFrame(file, false);
                extractionModelFrame.setDbConnectionDialogClone(this.getDbConnectionDialog());
                extractionModelFrame.markDirty();
                extractionModelFrame.expandAll();
                newFile.delete();
            }
        }
        catch (Throwable e) {
            parent.setCursor(Cursor.getPredefinedCursor(0));
            UIUtil.showException(this, "Error", e);
        }
        finally {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private DefaultMutableTreeNode addChildNodes(BrowserContentPane browserContentPane, Collection<Association> restrictedDependencies, int[] count) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.dataModel.getDisplayName(browserContentPane.table));
        count[0] = count[0] + 1;
        HashSet<Table> regardedChildren = new HashSet<Table>();
        for (Desktop.RowBrowser rb : browserContentPane.getChildBrowsers()) {
            DefaultMutableTreeNode childNode = this.addChildNodes(rb.browserContentPane, restrictedDependencies, count);
            node.add(childNode);
            regardedChildren.add(rb.browserContentPane.table);
        }
        for (final Association dep : restrictedDependencies) {
            if (dep.source != browserContentPane.table || regardedChildren.contains(dep.destination)) continue;
            node.add(new DefaultMutableTreeNode(new Object(){
                String item;
                {
                    this.item = BrowserContentPane.this.dataModel.getDisplayName(dep.destination);
                }

                public String toString() {
                    return this.item;
                }
            }));
            count[0] = count[0] + 1;
        }
        return node;
    }

    private void disableDisregardedNonParentsOfDestination(Association a, Collection<Association> regardedAssociations, List<RestrictionDefinition> restrictionDefinitions) {
        for (Association npa : a.destination.associations) {
            if (regardedAssociations.contains(npa)) continue;
            regardedAssociations.add(npa);
            if (npa.isInsertDestinationBeforeSource()) {
                this.disableDisregardedNonParentsOfDestination(npa, regardedAssociations, restrictionDefinitions);
                continue;
            }
            RestrictionDefinition rest = new RestrictionDefinition(npa.source, npa.destination, npa.getName(), null, true);
            restrictionDefinitions.add(rest);
        }
    }

    private List<RestrictionDefinition> createRestrictions(QueryBuilderDialog.Relationship root, Table subject, Collection<Association> regardedAssociations, Collection<Association> restrictedDependencies, Collection<RestrictionDefinition> restrictedDependencyDefinitions) {
        ArrayList<RestrictionDefinition> restrictionDefinitions = new ArrayList<RestrictionDefinition>();
        HashMap<Association, List<RestrictionLiteral>> restrictionLiterals = new HashMap<Association, List<RestrictionLiteral>>();
        this.collectRestrictionLiterals(restrictionLiterals, root, subject, 0);
        for (Association association : restrictionLiterals.keySet()) {
            RestrictionDefinition rest = this.createRestrictionDefinition(association, restrictionLiterals, true);
            regardedAssociations.add(association);
            if (!rest.isIgnored && (rest.condition == null || rest.condition.trim().length() == 0)) continue;
            restrictionDefinitions.add(rest);
            if (!association.isInsertDestinationBeforeSource() || !rest.isIgnored) continue;
            restrictedDependencies.add(association);
            restrictedDependencyDefinitions.add(rest);
        }
        return restrictionDefinitions;
    }

    private RestrictionDefinition createRestrictionDefinition(Association association, Map<Association, List<RestrictionLiteral>> restrictionLiterals, boolean checkReversal) {
        boolean isIgnored;
        List<RestrictionLiteral> lits = restrictionLiterals.get(association);
        boolean useDistance = false;
        boolean hasTrue = false;
        boolean hasNotTrue = false;
        boolean hasNotFalse = false;
        Object lastDist = null;
        for (RestrictionLiteral l : lits) {
            if (l.isIgnoredIfReversalIsRestricted) {
                if (checkReversal) {
                    RestrictionDefinition revRest = this.createRestrictionDefinition(association.reversalAssociation, restrictionLiterals, false);
                    if (revRest.isIgnored || revRest.condition != null && revRest.condition.trim().length() > 0) {
                        l.isIgnored = true;
                    } else {
                        l.isIgnored = false;
                        l.condition = null;
                    }
                    l.isIgnoredIfReversalIsRestricted = false;
                } else {
                    l.isIgnored = true;
                    l.isIgnoredIfReversalIsRestricted = false;
                }
            }
            if (!l.isIgnored) {
                hasNotFalse = true;
                if (l.condition == null || l.condition.trim().length() == 0) {
                    hasTrue = true;
                    continue;
                }
                hasNotTrue = true;
                continue;
            }
            hasNotTrue = true;
        }
        String condition = null;
        if (!hasNotFalse) {
            isIgnored = true;
        } else if (!hasNotTrue) {
            isIgnored = false;
        } else if (hasTrue && !useDistance) {
            isIgnored = false;
        } else {
            for (RestrictionLiteral l : lits) {
                if (l.isIgnored) continue;
                String c = null;
                if (useDistance) {
                    String string = c = l.distanceFromRoot == 0 ? "A.$IS_SUBJECT" : "A.$DISTANCE=" + l.distanceFromRoot;
                }
                if (l.condition != null && l.condition.trim().length() > 0) {
                    c = c == null ? l.condition : c + " and (" + l.condition + ")";
                }
                if (condition == null) {
                    condition = c;
                    continue;
                }
                condition = condition + " or " + c;
            }
            isIgnored = false;
        }
        RestrictionDefinition rest = new RestrictionDefinition(association.source, association.destination, association.getName(), condition, isIgnored);
        return rest;
    }

    private void collectRestrictionLiterals(Map<Association, List<RestrictionLiteral>> restrictionLiterals, QueryBuilderDialog.Relationship root, Table subject, int distanceFromRoot) {
        for (Association association : subject.associations) {
            ArrayList<QueryBuilderDialog.Relationship> children = new ArrayList<QueryBuilderDialog.Relationship>();
            for (QueryBuilderDialog.Relationship r : root.children) {
                if (r.association != association) continue;
                children.add(r);
            }
            if (children.isEmpty()) {
                children.add(null);
            }
            for (QueryBuilderDialog.Relationship child : children) {
                List<RestrictionLiteral> literals;
                RestrictionLiteral restrictionLiteral = new RestrictionLiteral();
                restrictionLiteral.distanceFromRoot = distanceFromRoot;
                restrictionLiteral.isIgnored = false;
                if (child == null) {
                    restrictionLiteral.isIgnored = true;
                    if (root.association != null && association == root.association.reversalAssociation && (association.getCardinality() == Cardinality.MANY_TO_ONE || association.getCardinality() == Cardinality.ONE_TO_ONE)) {
                        restrictionLiteral.isIgnoredIfReversalIsRestricted = true;
                    }
                } else {
                    restrictionLiteral.condition = child.whereClause == null ? "" : SqlUtil.replaceAliases(child.whereClause, "B", "A");
                    this.collectRestrictionLiterals(restrictionLiterals, child, association.destination, distanceFromRoot + 1);
                }
                if ((literals = restrictionLiterals.get(association)) == null) {
                    literals = new ArrayList<RestrictionLiteral>();
                    restrictionLiterals.put(association, literals);
                }
                literals.add(restrictionLiteral);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSQLDialog(String titel, int x, int y, Object sql) {
        JDialog d;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String LF = System.getProperty("line.separator", "\n");
            String sqlString = sql.toString().trim() + LF;
            if ((long)sqlString.length() > 0x200000L) {
                String fn;
                if (1 == JOptionPane.showOptionDialog(this, "SQL Script is too long (" + sqlString.length() / 1024 + " KB) to be edited.", "SQL Script too long", 0, 1, null, new Object[]{"Ok", "Save Script"}, "Save Script") && (fn = UIUtil.choseFile(null, ".", "Save SQL Script", ".sql", this, false, false, false)) != null) {
                    try {
                        PrintWriter out = new PrintWriter(new FileWriter(fn));
                        out.print(sqlString);
                        out.close();
                    }
                    catch (Throwable e) {
                        UIUtil.showException(this, "Error saving script", e);
                    }
                }
                return;
            }
            d = new JDialog(this.getOwner(), "SQL/DML - " + titel, true);
            d.getContentPane().add(new SQLDMLPanel(sqlString, this.session, new Runnable(){

                @Override
                public void run() {
                    BrowserContentPane.this.reloadRows();
                }
            }));
            d.pack();
            d.setLocation(x - 50, y - 100);
            d.setSize(700, Math.max(d.getHeight() + 20, 400));
            d.setLocation(this.getOwner().getX() + (this.getOwner().getWidth() - d.getWidth()) / 2, this.getOwner().getY() + (this.getOwner().getHeight() - d.getHeight()) / 2);
            UIUtil.fit(d);
        }
        catch (Throwable e) {
            UIUtil.showException(this, "Error", e);
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        d.setVisible(true);
    }

    protected void setCurrentRowSelection(int i) {
        this.currentRowSelection = i;
        if (i >= 0) {
            this.currentClosure.clear();
            this.findClosure(this.rows.get(this.rowsTable.getRowSorter().convertRowIndexToModel(i)));
            Rectangle visibleRect = this.rowsTable.getVisibleRect();
            Rectangle pos = this.rowsTable.getCellRect(i, 0, false);
            this.rowsTable.scrollRectToVisible(new Rectangle(visibleRect.x, pos.y, 1, pos.height));
        }
        this.currentClosureRowIDs.clear();
        for (Pair<BrowserContentPane, Row> r : this.currentClosure) {
            this.currentClosureRowIDs.add(new Pair(r.a, ((Row)r.b).rowId));
        }
        this.adjustClosure(this);
    }

    private JPopupMenu createNavigationMenu(JPopupMenu popup, final Row row, final int rowIndex, List<String> assList, Map<String, Association> assMap, String title, String prefix, final boolean navigateFromAllRows, final int rowCountPriority, final AllNonEmptyItem allNonEmptyItem, final Object context) {
        JScrollC2Menu nav = new JScrollC2Menu(title);
        if (prefix.equals("1")) {
            nav.setForeground(new Color(170, 0, 0));
        }
        if (prefix.equals("2")) {
            nav.setForeground(new Color(0, 112, 0));
        }
        if (prefix.equals("3")) {
            nav.setForeground(new Color(0, 100, 255));
        }
        if (prefix.equals("4")) {
            nav.setForeground(new Color(153, 153, 153));
        }
        JScrollC2Menu current = nav;
        int l = 0;
        for (String name : assList) {
            if (!name.startsWith(prefix)) continue;
            final Association association = assMap.get(name);
            ++l;
            JMenuItem item = new JMenuItem("  " + name.substring(1) + "   ");
            final JLabel countLabel = new JLabel(". >99999 "){

                @Override
                public void paint(Graphics g) {
                    if (!this.getText().startsWith(".")) {
                        super.paint(g);
                    }
                }
            };
            boolean excludeFromANEmpty = false;
            for (Desktop.RowBrowser child : this.getChildBrowsers()) {
                if (association != child.association || (rowIndex >= 0 || child.rowIndex >= 0) && rowIndex != child.rowIndex) continue;
                item.setFont(new Font(item.getFont().getName(), item.getFont().getStyle() | 2, item.getFont().getSize()));
                excludeFromANEmpty = true;
                break;
            }
            final ActionListener itemAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowserContentPane.this.highlightedRows.add(rowIndex);
                    if (navigateFromAllRows) {
                        BrowserContentPane.this.navigateTo(association, -1, null);
                    } else {
                        BrowserContentPane.this.navigateTo(association, rowIndex, row);
                    }
                }
            };
            item.addActionListener(itemAction);
            if (!excludeFromANEmpty) {
                ++allNonEmptyItem.todo;
            }
            final boolean fExcludeFromANEmpty = excludeFromANEmpty;
            if (!this.isPending && !this.rows.isEmpty()) {
                this.getRunnableQueue().add(new RunnableWithPriority(){
                    final int MAX_RC = 1000;

                    @Override
                    public int getPriority() {
                        return rowCountPriority;
                    }

                    @Override
                    public void run() {
                        long rowCount;
                        Pair<String, Association> key;
                        List<Row> r;
                        if (rowIndex < 0) {
                            r = BrowserContentPane.this.rows;
                            key = new Pair<String, Association>("", association);
                        } else {
                            r = Collections.singletonList(row);
                            key = new Pair<String, Association>(row.rowId, association);
                        }
                        Pair cachedCount = (Pair)BrowserContentPane.this.rowCountCache.get(key);
                        if (cachedCount != null && (Long)cachedCount.b > System.currentTimeMillis()) {
                            rowCount = (Long)cachedCount.a;
                        } else {
                            RowCounter rc = new RowCounter(BrowserContentPane.this.table, association, r, BrowserContentPane.this.session);
                            try {
                                rowCount = rc.countRows(BrowserContentPane.this.getAndConditionText(), context, 1001, false);
                            }
                            catch (SQLException e) {
                                rowCount = -1L;
                            }
                            BrowserContentPane.this.rowCountCache.put(key, new Pair<Long, Long>(rowCount, System.currentTimeMillis() + 300000L));
                        }
                        final long count = rowCount;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String cs = " " + (count < 0L ? "?" : (count > 1000L ? ">1000" : Long.valueOf(count))) + " ";
                                countLabel.setText(cs);
                                if (count == 0L) {
                                    countLabel.setForeground(Color.lightGray);
                                }
                                if (!fExcludeFromANEmpty) {
                                    allNonEmptyItem.rowsCounted(count, itemAction);
                                }
                            }
                        });
                    }
                });
            }
            if (current != null) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = l;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                ((JMenu)current).getPopupMenu().add((Component)item, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = l;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 13;
                gridBagConstraints.weightx = 1.0;
                ((JMenu)current).getPopupMenu().add((Component)countLabel, gridBagConstraints);
                continue;
            }
            popup.add(item);
        }
        if (l > 0) {
            popup.add(nav);
        }
        return popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadRows() {
        if (!this.suppressReload) {
            this.lastReloadTS = System.currentTimeMillis();
            this.cancelLoadJob(true);
            this.setPendingState(true, true);
            this.rows.clear();
            this.updateMode("loading");
            this.setPendingState(false, false);
            int limit = 100;
            if (this.limitBox.getSelectedItem() instanceof Integer) {
                limit = (Integer)this.limitBox.getSelectedItem();
            }
            LoadJob reloadJob = new LoadJob(limit, this.table instanceof SqlStatementTable ? this.sqlBrowserContentPane.sqlEditorPane.getText() : this.getAndConditionText(), this.selectDistinctCheckBox.isSelected());
            BrowserContentPane browserContentPane = this;
            synchronized (browserContentPane) {
                this.currentLoadJob = reloadJob;
            }
            this.getRunnableQueue().add(reloadJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadRows(String andCond, List<Row> rows, Object context, int limit, boolean selectDistinct) throws SQLException {
        if (this.table instanceof SqlStatementTable) {
            try {
                this.session.setSilent(true);
                HashMap<String, List<Row>> rowsMap = new HashMap<String, List<Row>>();
                this.reloadRows(andCond, null, rowsMap, context, limit, false, null, false);
                if (rowsMap.get("") != null) {
                    rows.addAll((Collection)rowsMap.get(""));
                }
            }
            finally {
                this.session.setSilent(false);
            }
            return;
        }
        List<Row> pRows = this.parentRows;
        pRows = pRows == null ? Collections.singletonList(this.parentRow) : new ArrayList<Row>(pRows);
        HashMap<String, Row> rowSet = new HashMap<String, Row>();
        if (this.parentRows != null) {
            this.beforeReload();
        }
        this.noNonDistinctRows = 0;
        this.noDistinctRows = 0;
        if (this.association != null && this.association.source.primaryKey.getColumns().isEmpty()) {
            this.loadRowBlocks(andCond, rows, context, limit, selectDistinct, pRows, rowSet, 1);
        } else {
            try {
                this.loadRowBlocks(andCond, rows, context, limit, selectDistinct, pRows, rowSet, 510);
                return;
            }
            catch (SQLException e) {
                Session._log.warn("failed, try another blocking-size");
                try {
                    this.loadRowBlocks(andCond, rows, context, limit, selectDistinct, pRows, rowSet, 300);
                    return;
                }
                catch (SQLException e2) {
                    Session._log.warn("failed, try another blocking-size");
                    try {
                        this.loadRowBlocks(andCond, rows, context, limit, selectDistinct, pRows, rowSet, 100);
                        return;
                    }
                    catch (SQLException e3) {
                        Session._log.warn("failed, try another blocking-size");
                        try {
                            this.loadRowBlocks(andCond, rows, context, limit, selectDistinct, pRows, rowSet, 40);
                            return;
                        }
                        catch (SQLException e4) {
                            Session._log.warn("failed, try another blocking-size");
                        }
                    }
                }
            }
        }
        this.loadRowBlocks(andCond, rows, context, limit, selectDistinct, pRows, rowSet, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRowBlocks(String andCond, List<Row> rows, Object context, int limit, boolean selectDistinct, List<Row> pRows, Map<String, Row> rowSet, int NUM_PARENTS) throws SQLException {
        ArrayList parentBlocks = new ArrayList();
        ArrayList<Row> currentBlock = new ArrayList<Row>();
        HashSet<String> regPRows = new HashSet<String>();
        parentBlocks.add(currentBlock);
        for (Row pRow : pRows) {
            if (currentBlock.size() >= NUM_PARENTS) {
                currentBlock = new ArrayList();
                parentBlocks.add(currentBlock);
            }
            currentBlock.add(pRow);
        }
        if (!pRows.isEmpty()) {
            Iterator<Row> i$ = parentBlocks.iterator();
            while (i$.hasNext()) {
                ArrayList<Row> pRowBlockI;
                ArrayList<Row> pRowBlock = pRowBlockI = (ArrayList<Row>)((Object)i$.next());
                HashMap<String, List<Row>> newBlockRows = new HashMap<String, List<Row>>();
                boolean loaded = false;
                if (pRowBlock.size() == 1 && pRowBlock.get(0) == null) {
                    pRowBlock = null;
                }
                if (Configuration.forDbms(this.session).getSqlLimitSuffix() != null) {
                    try {
                        this.session.setSilent(true);
                        this.reloadRows(andCond, pRowBlock, newBlockRows, context, limit, false, Configuration.forDbms(this.session).getSqlLimitSuffix(), selectDistinct);
                        loaded = true;
                    }
                    catch (SQLException e) {
                        Session._log.warn("failed, try another limit-strategy");
                    }
                    finally {
                        this.session.setSilent(false);
                    }
                }
                if (!loaded) {
                    try {
                        this.session.setSilent(true);
                        this.reloadRows(andCond, pRowBlock, newBlockRows, context, limit, true, null, selectDistinct);
                        loaded = true;
                    }
                    catch (SQLException e) {
                        Session._log.warn("failed, try another limit-strategy");
                    }
                    finally {
                        this.session.setSilent(false);
                    }
                    if (!loaded) {
                        this.reloadRows(andCond, pRowBlock, newBlockRows, context, limit, false, null, selectDistinct);
                    }
                }
                if (pRowBlock == null) {
                    pRowBlock = new ArrayList<Row>();
                    pRowBlock.add(null);
                }
                for (Row pRow : pRowBlock) {
                    String rId;
                    boolean dupParent = false;
                    if (pRow != null) {
                        if (regPRows.contains(pRow.rowId)) {
                            dupParent = true;
                        }
                        regPRows.add(pRow.rowId);
                    }
                    ArrayList newRows = new ArrayList();
                    String string = rId = pRow == null ? "" : pRow.rowId;
                    if (newBlockRows.get(rId) != null) {
                        newRows.addAll((Collection)newBlockRows.get(rId));
                    }
                    if (this.parentRows != null) {
                        if (!newRows.isEmpty()) {
                            ((Row)newRows.get(newRows.size() - 1)).setBlockEnd(true);
                        }
                        for (Row row : newRows) {
                            Row exRow = rowSet.get(row.rowId);
                            if (!dupParent) {
                                if (exRow != null) {
                                    ++this.noNonDistinctRows;
                                } else {
                                    ++this.noDistinctRows;
                                }
                            }
                            if (exRow != null && (selectDistinct || dupParent)) {
                                this.addRowToRowLink(pRow, exRow);
                                continue;
                            }
                            rows.add(row);
                            this.addRowToRowLink(pRow, row);
                            rowSet.put(row.rowId, row);
                            --limit;
                        }
                    } else {
                        rows.addAll(newRows);
                        limit -= newRows.size();
                    }
                    if (limit > 0) continue;
                    break;
                }
                if (limit > 0) continue;
                break;
            }
        }
    }

    private void reloadRows(String andCond, List<Row> parentRows, Map<String, List<Row>> rows, Object context, int limit, boolean useOLAPLimitation, String sqlLimitSuffix, boolean selectDistinct) throws SQLException {
        try {
            this.reloadRows0(andCond, parentRows, rows, context, parentRows == null ? limit : Math.max(5000, limit), useOLAPLimitation, sqlLimitSuffix, selectDistinct);
        }
        catch (SQLException e) {
            if (selectDistinct) {
                this.reloadRows0(andCond, parentRows, rows, context, limit, useOLAPLimitation, sqlLimitSuffix, false);
            }
            throw e;
        }
    }

    private void reloadRows0(String andCond, final List<Row> parentRows, final Map<String, List<Row>> rows, Object context, int limit, boolean useOLAPLimitation, String sqlLimitSuffix, boolean selectDistinct) throws SQLException {
        boolean selectParentPK;
        String sql = "Select ";
        final HashSet<String> pkColumnNames = new HashSet<String>();
        final HashSet<String> parentPkColumnNames = new HashSet<String>();
        boolean bl = selectParentPK = this.association != null && parentRows != null && parentRows.size() > 1;
        if (this.table instanceof SqlStatementTable) {
            sql = andCond;
            this.table.setColumns(new ArrayList<Column>());
        } else {
            String name;
            int i;
            boolean limitSuffixInSelectClause;
            String olapPrefix = "Select ";
            String olapSuffix = ") S Where S.RN <= " + limit;
            boolean bl2 = limitSuffixInSelectClause = sqlLimitSuffix != null && (sqlLimitSuffix.toLowerCase().startsWith("top ") || sqlLimitSuffix.toLowerCase().startsWith("first "));
            if (sqlLimitSuffix != null && limitSuffixInSelectClause) {
                sql = sql + sqlLimitSuffix.replace("%s", Integer.toString(limit)) + " ";
            }
            boolean f = true;
            if (selectParentPK) {
                i = 0;
                for (Column column : this.association.source.primaryKey.getColumns()) {
                    name = column.name;
                    sql = sql + (!f ? ", " : "") + "B." + name + " AS B" + i;
                    olapPrefix = olapPrefix + (!f ? ", " : "") + "S.B" + i;
                    ++i;
                    f = false;
                }
            }
            i = 0;
            for (Column column : this.table.getColumns()) {
                name = column.name;
                sql = sql + (!f ? ", " : "") + "A." + name + " AS A" + i;
                olapPrefix = olapPrefix + (!f ? ", " : "") + "S.A" + i;
                ++i;
                f = false;
            }
            f = true;
            String orderBy = "";
            String olapOrderBy = "";
            if (selectParentPK) {
                int j = 0;
                for (Column pk : this.association.source.primaryKey.getColumns()) {
                    parentPkColumnNames.add(pk.name);
                    orderBy = orderBy + (f ? "" : ", ") + "B." + pk.name;
                    olapOrderBy = olapOrderBy + (f ? "" : ", ") + "S.B" + j;
                    ++j;
                    f = false;
                }
            }
            int j = 0;
            for (Column pk : this.table.primaryKey.getColumns()) {
                pkColumnNames.add(pk.name);
                orderBy = orderBy + (f ? "" : ", ") + "A." + pk.name;
                olapOrderBy = olapOrderBy + (f ? "" : ", ") + "S.A" + j;
                ++j;
                f = false;
            }
            if (useOLAPLimitation) {
                sql = sql + ", row_number() over(";
                if (useOLAPLimitation) {
                    sql = sql + "order by -1";
                }
                sql = sql + ") as RN";
            }
            sql = sql + " From ";
            if (this.association != null) {
                sql = sql + this.association.source.getName() + " B join ";
            }
            sql = sql + this.table.getName() + " A";
            if (this.association != null) {
                sql = this.association.reversed ? sql + " on " + this.association.getUnrestrictedJoinCondition() : sql + " on " + SqlUtil.reversRestrictionCondition(this.association.getUnrestrictedJoinCondition());
            }
            boolean whereExists = false;
            if (parentRows != null && !parentRows.isEmpty()) {
                if (parentRows.size() == 1) {
                    sql = sql + " Where (" + parentRows.get((int)0).rowId + ")";
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (Row parentRow : parentRows) {
                        if (sb.length() == 0) {
                            sb.append(" Where ((");
                        } else {
                            sb.append(" or (");
                        }
                        sb.append(parentRow.rowId).append(")");
                    }
                    sb.append(")");
                    sql = sql + sb.toString();
                }
                whereExists = true;
            }
            if (andCond.trim().length() > 0) {
                sql = sql + (whereExists ? " and" : " Where") + " (" + ConditionEditor.toMultiLine(andCond) + ")";
            }
            if (orderBy.length() > 0 && sqlLimitSuffix != null && !useOLAPLimitation) {
                sql = sql + " order by " + orderBy;
            }
            olapPrefix = olapPrefix + " From (";
            if (useOLAPLimitation) {
                sql = olapPrefix + sql + olapSuffix + " Order by " + olapOrderBy;
            }
            if (sqlLimitSuffix != null && !limitSuffixInSelectClause) {
                sql = sql + " " + sqlLimitSuffix.replace("%s", Integer.toString(limit));
            }
        }
        if (sql.length() > 0) {
            this.session.executeQuery(sql, new Session.AbstractResultSetReader(){
                Map<Integer, Integer> typeCache = new HashMap<Integer, Integer>();
                int rowNr = 0;

                @Override
                public void readCurrentRow(ResultSet resultSet) throws SQLException {
                    ArrayList<Row> cRows;
                    if (BrowserContentPane.this.table instanceof SqlStatementTable && rows.isEmpty()) {
                        for (int ci = 1; ci <= this.getMetaData(resultSet).getColumnCount(); ++ci) {
                            BrowserContentPane.this.table.getColumns().add(new Column(this.getMetaData(resultSet).getColumnName(ci), this.getMetaData(resultSet).getColumnTypeName(ci), -1, -1));
                        }
                    }
                    int i = 1;
                    int vi = 0;
                    String parentRowId = "";
                    if (selectParentPK) {
                        Object[] v = new Object[BrowserContentPane.this.association.source.primaryKey.getColumns().size()];
                        for (Column column : BrowserContentPane.this.association.source.primaryKey.getColumns()) {
                            parentRowId = this.readRowFromResultSet(parentPkColumnNames, resultSet, i, vi, parentRowId, v, column, null);
                            ++i;
                            ++vi;
                        }
                    } else if (parentRows != null && parentRows.size() == 1) {
                        parentRowId = ((Row)parentRows.get((int)0)).rowId;
                    }
                    HashMap<String, String> pkColumn = new HashMap<String, String>();
                    Object[] v = new Object[BrowserContentPane.this.table.getColumns().size()];
                    vi = 0;
                    for (Column column : BrowserContentPane.this.table.getColumns()) {
                        this.readRowFromResultSet(pkColumnNames, resultSet, i, vi, "", v, column, pkColumn);
                        ++i;
                        ++vi;
                    }
                    String rowId = "";
                    if (BrowserContentPane.this.table.primaryKey != null) {
                        for (Column column : BrowserContentPane.this.table.primaryKey.getColumns()) {
                            if (rowId.length() > 0) {
                                rowId = rowId + " and ";
                            }
                            rowId = rowId + (String)pkColumn.get(column.name);
                        }
                    } else {
                        rowId = Integer.toString(++this.rowNr);
                    }
                    if ((cRows = (ArrayList<Row>)rows.get(parentRowId)) == null) {
                        cRows = new ArrayList<Row>();
                        rows.put(parentRowId, cRows);
                    }
                    cRows.add(new Row(rowId, v));
                }

                private String readClob(Clob clob) throws SQLException, IOException {
                    return this.readCharacterStream(clob.getCharacterStream());
                }

                private String readSQLXML(SQLXML xml) throws SQLException, IOException {
                    return this.readCharacterStream(xml.getCharacterStream());
                }

                private String readCharacterStream(Reader reader) throws IOException {
                    int b;
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(reader);
                    while (-1 != (b = br.read())) {
                        sb.append((char)b);
                        if (sb.length() <= 2000) continue;
                        sb.append("...");
                        break;
                    }
                    br.close();
                    return sb.toString();
                }

                private String readRowFromResultSet(Set<String> pkColumnNames2, ResultSet resultSet, int i, int vi, String rowId, Object[] v, Column column, Map<String, String> pkColumn) throws SQLException {
                    Object value = "";
                    int type = SqlUtil.getColumnType(resultSet, this.getMetaData(resultSet), i, this.typeCache);
                    if (type == 2004 || type == 2005 || type == 2009) {
                        Object object = resultSet.getObject(i);
                        if (object == null || resultSet.wasNull()) {
                            value = null;
                        }
                        if (object instanceof Blob) {
                            try {
                                final long length = ((Blob)object).length();
                                value = new LobValue(){

                                    public String toString() {
                                        return "<Blob> " + length + " bytes";
                                    }
                                };
                            }
                            catch (Exception e) {
                                value = new LobValue(){

                                    public String toString() {
                                        return "<Blob>";
                                    }
                                };
                            }
                        }
                        if (object instanceof Clob) {
                            try {
                                final String content = this.readClob((Clob)object);
                                value = new LobValue(){

                                    public String toString() {
                                        return content;
                                    }
                                };
                            }
                            catch (Exception e) {
                                value = new LobValue(){

                                    public String toString() {
                                        return "<Clob>";
                                    }
                                };
                                e.printStackTrace();
                            }
                        }
                        if (object instanceof SQLXML) {
                            try {
                                final String content = this.readSQLXML((SQLXML)object);
                                value = new LobValue(){

                                    public String toString() {
                                        return content;
                                    }
                                };
                            }
                            catch (Exception e) {
                                value = new LobValue(){

                                    public String toString() {
                                        return "<XML>";
                                    }
                                };
                                e.printStackTrace();
                            }
                        }
                    } else {
                        Object o = SqlUtil.getObject(resultSet, this.getMetaData(resultSet), i, this.typeCache);
                        boolean isPK = false;
                        if (pkColumnNames2.isEmpty()) {
                            boolean bl = isPK = type != 2004 && type != 2005 && type != 70 && type != 2000 && type != 2011 && type != 0 && type != 1111 && type != 2006 && type != 2009 && type != 2002;
                        }
                        if (pkColumnNames2.contains(column.name) || isPK) {
                            String cVal = SqlUtil.toSql(o, BrowserContentPane.this.session);
                            String pkValue = "B." + column.name + (BrowserContentPane.NULL.equalsIgnoreCase(cVal) ? " is null" : "=" + cVal);
                            if (pkColumn != null) {
                                pkColumn.put(column.name, pkValue);
                            }
                            rowId = rowId + (rowId.length() == 0 ? "" : " and ") + pkValue;
                        }
                        if (o == null || resultSet.wasNull()) {
                            value = null;
                        }
                        if (o != null) {
                            value = o;
                        }
                    }
                    v[vi] = value;
                    return rowId;
                }
            }, null, context, limit);
        }
    }

    private Desktop.RowBrowser parentWithExceededLimit() {
        Desktop.RowBrowser parent = this.getParentBrowser();
        while (parent != null) {
            if (parent.browserContentPane.isLimitExceeded) {
                return parent;
            }
            parent = parent.browserContentPane.getParentBrowser();
        }
        return null;
    }

    private void updateTableModel(int limit, boolean limitExceeded) {
        this.pkColumns.clear();
        Object[] columnNames = new String[this.table.getColumns().size()];
        HashSet<String> pkColumnNames = new HashSet<String>();
        if (this.table.primaryKey != null) {
            for (Column pk : this.table.primaryKey.getColumns()) {
                pkColumnNames.add(pk.name);
            }
        }
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this.table.getColumns().get((int)i).name;
            if (!pkColumnNames.contains(columnNames[i])) continue;
            this.pkColumns.add(i);
        }
        this.singleRowDetailsView = null;
        int rn = 0;
        if (this.rows.size() != 1) {
            DefaultTableModel dtm = new DefaultTableModel(columnNames, 0){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            for (Row row : this.rows) {
                Object[] rowData = new Object[this.table.getColumns().size()];
                for (int i = 0; i < this.table.getColumns().size(); ++i) {
                    rowData[i] = row.values[i];
                    if (rowData[i] != null) continue;
                    rowData[i] = NULL;
                }
                dtm.addRow(rowData);
                if (++rn < limit) continue;
                break;
            }
            this.rowsTable.setModel(dtm);
            this.rowsTable.setRowHeight(this.initialRowHeight);
            TableRowSorter<39> sorter = new TableRowSorter<39>(dtm);
            for (int i = 0; i < columnNames.length; ++i) {
                sorter.setComparator(i, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        if (o1.getClass().equals(o2.getClass())) {
                            if (o1 instanceof Comparable) {
                                return ((Comparable)o1).compareTo(o2);
                            }
                            return 0;
                        }
                        return o1.getClass().getName().compareTo(o2.getClass().getName());
                    }
                });
            }
            this.rowsTable.setRowSorter(sorter);
        } else {
            this.singleRowDetailsView = new DetailsView(Collections.singletonList(this.rows.get(0)), 1, this.dataModel, this.table, 0, null, false){

                @Override
                protected void onRowChanged(int row) {
                }
            };
            DefaultTableModel dtm = new DefaultTableModel(new String[]{"Single Row Details"}, 0){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            for (Row row : this.rows) {
                dtm.addRow(new Object[]{row});
                if (++rn < limit) continue;
                break;
            }
            this.rowsTable.setModel(dtm);
            this.rowsTable.setRowHeight(this.singleRowDetailsView.getPreferredSize().height);
        }
        this.adjustRowTableColumnsWidth();
        this.rowsTable.setIntercellSpacing(new Dimension(0, 0));
        int size = this.rows.size();
        if (size > limit) {
            size = limit;
        }
        this.rowsCount.setText((limitExceeded ? " more than " : " ") + size + " row" + (size != 1 ? "s" : ""));
        Desktop.RowBrowser theParentWithExceededLimit = this.parentWithExceededLimit();
        this.rowsCount.setForeground(limitExceeded || theParentWithExceededLimit != null ? Color.RED : new JLabel().getForeground());
        if (theParentWithExceededLimit == null) {
            this.rowsCount.setToolTipText(null);
        } else {
            this.rowsCount.setToolTipText("potentially incomplete because " + theParentWithExceededLimit.internalFrame.getTitle() + " exceeded row limit");
        }
        int nndr = this.noNonDistinctRows;
        if (this.noDistinctRows + this.noNonDistinctRows >= limit) {
            --nndr;
        }
        this.selectDistinctCheckBox.setVisible(nndr > 0);
        this.selectDistinctCheckBox.setText("select distinct (-" + nndr + " row" + (nndr == 1 ? "" : "s") + ")");
        if (this.sqlBrowserContentPane != null) {
            this.sqlBrowserContentPane.detailsButton.setEnabled(!this.rows.isEmpty());
        }
        this.isLimitExceeded = limitExceeded;
    }

    public void adjustRowTableColumnsWidth() {
        DefaultTableModel dtm = (DefaultTableModel)this.rowsTable.getModel();
        for (int i = 0; i < this.rowsTable.getColumnCount(); ++i) {
            TableColumn column = this.rowsTable.getColumnModel().getColumn(i);
            int width = ((int)(476.0 * this.getLayoutFactor()) - 18) / this.rowsTable.getColumnCount();
            Component comp = this.rowsTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.rowsTable, column.getHeaderValue(), false, false, 0, i);
            width = Math.max(width, comp.getPreferredSize().width);
            for (int line = 0; line < this.rowsTable.getRowCount(); ++line) {
                comp = this.rowsTable.getCellRenderer(line, i).getTableCellRendererComponent(this.rowsTable, dtm.getValueAt(line, i), false, false, line, i);
                width = Math.max(width, comp.getPreferredSize().width + (this.singleRowDetailsView == null ? 16 : 0));
                if (this.singleRowDetailsView == null) {
                    width = Math.min(width, 400);
                }
                if (line > 2000) break;
            }
            column.setPreferredWidth(width);
        }
    }

    private void initComponents() {
        this.wherePanel = new JPanel();
        this.where = new JLabel();
        this.jPanel7 = new JPanel();
        this.loadButton = new JButton();
        this.andCondition = new JComboBox();
        this.onPanel = new JPanel();
        this.on = new JLabel();
        this.joinPanel = new JPanel();
        this.join = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel10 = new JPanel();
        this.from = new JLabel();
        this.jLabel5 = new JLabel();
        this.pendingNonpendingPanel = new JPanel();
        this.cardPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.cancelLoadButton = new JButton();
        this.jPanel1 = new JPanel();
        this.rowsTableScrollPane = new JScrollPane();
        this.rowsTable = new JTable();
        this.jPanel6 = new JPanel();
        this.rowsCount = new JLabel();
        this.selectDistinctCheckBox = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel9 = new JLabel();
        this.andLabel = new JLabel();
        this.openEditorLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.fetchLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.limitBox = new JComboBox();
        this.relatedRowsPanel = new JPanel();
        this.relatedRowsLabel = new JLabel();
        this.jPanel9 = new JPanel();
        this.sqlPanel = new JPanel();
        this.sqlLabel1 = new JLabel();
        this.dropA = new JLabel();
        this.dropB = new JLabel();
        this.setLayout(new GridBagLayout());
        this.wherePanel.setMinimumSize(new Dimension(66, 17));
        this.wherePanel.setLayout(new BorderLayout());
        this.where.setFont(new Font("DejaVu Sans", 0, 14));
        this.where.setText("jLabel3");
        this.wherePanel.add((Component)this.where, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.wherePanel, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.loadButton.setText(" Reload ");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserContentPane.this.loadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel7.add((Component)this.loadButton, gridBagConstraints);
        this.andCondition.setEditable(true);
        this.andCondition.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.andCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel7, gridBagConstraints);
        this.onPanel.setMinimumSize(new Dimension(66, 17));
        this.onPanel.setLayout(new BorderLayout());
        this.on.setFont(new Font("DejaVu Sans", 0, 14));
        this.on.setText("jLabel3");
        this.onPanel.add((Component)this.on, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.onPanel, gridBagConstraints);
        this.joinPanel.setMinimumSize(new Dimension(66, 17));
        this.joinPanel.setLayout(new GridBagLayout());
        this.join.setFont(new Font("DejaVu Sans", 0, 14));
        this.join.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.joinPanel.add((Component)this.join, gridBagConstraints);
        this.jLabel6.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel6.setText(" as B  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.joinPanel.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.joinPanel, gridBagConstraints);
        this.jPanel10.setMinimumSize(new Dimension(66, 17));
        this.jPanel10.setLayout(new GridBagLayout());
        this.from.setFont(new Font("DejaVu Sans", 0, 14));
        this.from.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel10.add((Component)this.from, gridBagConstraints);
        this.jLabel5.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText(" as A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel10.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel10, gridBagConstraints);
        this.pendingNonpendingPanel.setLayout(new CardLayout());
        this.cardPanel.setLayout(new CardLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel2.setForeground(new Color(141, 16, 16));
        this.jLabel2.setText("loading...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.cancelLoadButton.setText("Cancel");
        this.cancelLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserContentPane.this.cancelLoadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.cancelLoadButton, gridBagConstraints);
        this.cardPanel.add((Component)this.jPanel2, "loading");
        this.jPanel1.setLayout(new GridBagLayout());
        this.rowsTableScrollPane.setWheelScrollingEnabled(false);
        this.rowsTable.setAutoCreateRowSorter(true);
        this.rowsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.rowsTable.setAutoResizeMode(0);
        this.rowsTableScrollPane.setViewportView(this.rowsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.rowsTableScrollPane, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.rowsCount.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.rowsCount, gridBagConstraints);
        this.selectDistinctCheckBox.setSelected(true);
        this.selectDistinctCheckBox.setText("select distinct (-100 rows)");
        this.selectDistinctCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserContentPane.this.selectDistinctCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.selectDistinctCheckBox, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.jPanel1.add((Component)this.jPanel6, gridBagConstraints);
        this.cardPanel.add((Component)this.jPanel1, "table");
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel10.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel10.setForeground(new Color(141, 16, 16));
        this.jLabel10.setText("Error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel5.add((Component)this.jLabel10, gridBagConstraints);
        this.cardPanel.add((Component)this.jPanel5, "error");
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel8.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel8.setForeground(new Color(141, 16, 16));
        this.jLabel8.setText("Cancelled");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel4.add((Component)this.jLabel8, gridBagConstraints);
        this.cardPanel.add((Component)this.jPanel4, "cancelled");
        this.pendingNonpendingPanel.add((Component)this.cardPanel, "nonpending");
        this.jPanel8.setLayout(new GridBagLayout());
        this.jLabel11.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel11.setForeground(new Color(141, 16, 16));
        this.jLabel11.setText("pending...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel8.add((Component)this.jLabel11, gridBagConstraints);
        this.pendingNonpendingPanel.add((Component)this.jPanel8, "pending");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pendingNonpendingPanel, gridBagConstraints);
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel1.setText(" Join ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel4.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel4.setText(" On ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel9.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel9.setText(" Where ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel9, gridBagConstraints);
        this.andLabel.setFont(new Font("DejaVu Sans", 1, 13));
        this.andLabel.setText(" And  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.andLabel, gridBagConstraints);
        this.openEditorLabel.setText(" And  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.openEditorLabel, gridBagConstraints);
        this.jLabel3.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel3.setText(" From ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.fetchLabel.setFont(new Font("DejaVu Sans", 1, 13));
        this.fetchLabel.setText(" Limit  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.fetchLabel, gridBagConstraints);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        this.limitBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.limitBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BrowserContentPane.this.limitBoxItemStateChanged(evt);
            }
        });
        this.jPanel3.add(this.limitBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.relatedRowsPanel.setBorder(new SoftBevelBorder(0));
        this.relatedRowsPanel.setLayout(new BoxLayout(this.relatedRowsPanel, 2));
        this.relatedRowsLabel.setText(" Related Rows ");
        this.relatedRowsPanel.add(this.relatedRowsLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        this.add((Component)this.relatedRowsPanel, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.jPanel9, gridBagConstraints);
        this.sqlPanel.setBorder(new SoftBevelBorder(0));
        this.sqlPanel.setLayout(new BoxLayout(this.sqlPanel, 2));
        this.sqlLabel1.setText(" Menu ");
        this.sqlPanel.add(this.sqlLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.add((Component)this.sqlPanel, gridBagConstraints);
        this.dropA.setFont(new Font("DejaVu Sans", 1, 13));
        this.dropA.setText("drop");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.dropA, gridBagConstraints);
        this.dropB.setFont(new Font("DejaVu Sans", 1, 13));
        this.dropB.setText("drop");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.dropB, gridBagConstraints);
    }

    private void cancelLoadButtonActionPerformed(ActionEvent evt) {
        this.cancelLoadJob(false);
        this.updateMode("cancelled");
    }

    private void selectDistinctCheckBoxActionPerformed(ActionEvent evt) {
        this.reloadRows();
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        if (System.currentTimeMillis() - this.lastReloadTS > 200L) {
            this.reloadRows();
        }
    }

    private void limitBoxItemStateChanged(ItemEvent evt) {
        this.reloadRows();
    }

    private void openQueryBuilder() {
        QueryBuilderDialog.Relationship root = this.createQBRelations(true);
        root.selectColumns = true;
        this.getQueryBuilderDialog().buildQuery(this.table, root, this.dataModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLoadJob(boolean propagate) {
        LoadJob cLoadJob;
        BrowserContentPane browserContentPane = this;
        synchronized (browserContentPane) {
            cLoadJob = this.currentLoadJob;
        }
        if (cLoadJob != null) {
            cLoadJob.cancel();
        }
        if (propagate) {
            for (Desktop.RowBrowser child : this.getChildBrowsers()) {
                child.browserContentPane.cancelLoadJob(propagate);
            }
        }
    }

    private void updateMode(String mode) {
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, mode);
    }

    private void openColumnDropDownBox(JLabel label, String alias, Table table) {
        JScrollPopupMenu popup = new JScrollPopupMenu();
        ArrayList<String> columns = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            columns.add(alias + "." + column.name);
        }
        for (final String string : columns) {
            if (string.equals("")) {
                popup.add(new JSeparator());
                continue;
            }
            JMenuItem m = new JMenuItem(string);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BrowserContentPane.this.andCondition.isEnabled() && BrowserContentPane.this.andCondition.isEditable()) {
                        if (BrowserContentPane.this.andCondition.getEditor() != null && BrowserContentPane.this.andCondition.getEditor().getEditorComponent() instanceof JTextField) {
                            JTextField f = (JTextField)BrowserContentPane.this.andCondition.getEditor().getEditorComponent();
                            int pos = f.getCaretPosition();
                            String current = f.getText();
                            if (pos < 0 || pos >= current.length()) {
                                BrowserContentPane.this.setAndCondition(current + string, false);
                            } else {
                                BrowserContentPane.this.setAndCondition(current.substring(0, pos) + string + current.substring(pos), false);
                                f.setCaretPosition(pos + string.length());
                            }
                        }
                        BrowserContentPane.this.andCondition.grabFocus();
                    }
                }
            });
            popup.add(m);
        }
        UIUtil.fit(popup);
        ((JPopupMenu)popup).show(label, 0, label.getHeight());
    }

    private Row createNewRow(Row parentrow, Table table) {
        Row row = new Row(null, new Object[table.getColumns().size()]);
        if (parentrow != null && this.association != null) {
            Map<Column, Column> sToDMap = this.association.createSourceToDestinationKeyMapping();
            for (Map.Entry<Column, Column> e : sToDMap.entrySet()) {
                int iS = -1;
                for (int i = 0; i < this.association.source.getColumns().size(); ++i) {
                    if (e.getKey() != this.association.source.getColumns().get(i)) continue;
                    iS = i;
                    break;
                }
                int iD = -1;
                for (int i = 0; i < this.association.destination.getColumns().size(); ++i) {
                    if (e.getValue() != this.association.destination.getColumns().get(i)) continue;
                    iD = i;
                    break;
                }
                if (iS < 0 || iD < 0) continue;
                row.values[iD] = parentrow.values[iS];
            }
        }
        return row;
    }

    protected abstract void navigateTo(Association var1, int var2, Row var3);

    protected abstract void onContentChange(List<Row> var1, boolean var2);

    protected abstract void onRedraw();

    protected abstract void onHide();

    protected abstract void beforeReload();

    protected abstract QueryBuilderDialog.Relationship createQBRelations(boolean var1);

    protected abstract List<QueryBuilderDialog.Relationship> createQBChildrenRelations(Desktop.RowBrowser var1, boolean var2);

    protected abstract void addRowToRowLink(Row var1, Row var2);

    protected abstract JFrame getOwner();

    protected abstract void findClosure(Row var1);

    protected abstract void findClosure(Row var1, Set<Pair<BrowserContentPane, Row>> var2, boolean var3);

    protected abstract QueryBuilderDialog getQueryBuilderDialog();

    protected abstract QueryBuilderPathSelector getQueryBuilderPathSelector();

    protected abstract void openSchemaMappingDialog();

    protected abstract void openSchemaAnalyzer();

    protected abstract DbConnectionDialog getDbConnectionDialog();

    protected abstract double getLayoutFactor();

    protected abstract List<Desktop.RowBrowser> getChildBrowsers();

    protected abstract Desktop.RowBrowser getParentBrowser();

    protected abstract List<Desktop.RowBrowser> getTableBrowser();

    protected abstract void unhide();

    protected abstract void close();

    protected abstract void showInNewWindow();

    protected abstract void appendLayout();

    protected abstract void adjustClosure(BrowserContentPane var1);

    protected abstract PriorityBlockingQueue<RunnableWithPriority> getRunnableQueue();

    protected abstract void collectPositions(Map<String, Map<String, double[]>> var1);

    private void openDetails(int x, int y) {
        JDialog d = new JDialog(this.getOwner(), this.table instanceof SqlStatementTable ? "" : this.dataModel.getDisplayName(this.table), true);
        d.getContentPane().add(new DetailsView(this.rows, this.rowsTable.getRowCount(), this.dataModel, this.table, 0, this.rowsTable.getRowSorter(), true){

            @Override
            protected void onRowChanged(int row) {
                BrowserContentPane.this.setCurrentRowSelection(row);
            }
        });
        d.pack();
        d.setLocation(x, y);
        d.setSize(400, d.getHeight() + 20);
        UIUtil.fit(d);
        d.setVisible(true);
        this.setCurrentRowSelection(-1);
    }

    private void updateWhereField() {
        if (this.association != null) {
            this.where.setText(this.parentRow == null ? (this.parentRows != null && this.parentRows.size() > 0 ? this.parentRows.get((int)0).rowId + (this.parentRows.size() > 1 ? " or ..." : "") : "") : this.parentRow.rowId);
            this.where.setToolTipText(this.where.getText());
        }
    }

    public void convertToRoot() {
        this.association = null;
        this.parentRow = null;
        this.parentRows = null;
        this.currentClosureRowIDs.clear();
        this.adjustGui();
        this.reloadRows();
    }

    public static interface RunnableWithPriority
    extends Runnable {
        public int getPriority();
    }

    private static class RestrictionLiteral {
        public String condition;
        public int distanceFromRoot;
        public boolean isIgnored;
        public boolean isIgnoredIfReversalIsRestricted = false;

        private RestrictionLiteral() {
        }

        public String toString() {
            return "Cond:" + this.condition + " Dist: " + this.distanceFromRoot + " isIgnored: " + this.isIgnored + " isIgnoredIfReversalIsRestricted: " + this.isIgnoredIfReversalIsRestricted;
        }
    }

    private class AllNonEmptyItem
    extends JMenuItem {
        int todo;
        int done;
        private List<ActionListener> todoList = new ArrayList<ActionListener>();
        private final String initText = "Counting rows... ";

        AllNonEmptyItem() {
            this.setEnabled(false);
            this.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Container parent = SwingUtilities.getWindowAncestor(BrowserContentPane.this);
                    if (parent == null) {
                        parent = BrowserContentPane.this;
                    }
                    parent.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        for (ActionListener al : AllNonEmptyItem.this.todoList) {
                            al.actionPerformed(e);
                        }
                    }
                    finally {
                        parent.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }

        public void rowsCounted(long count, ActionListener itemAction) {
            int p;
            ++this.done;
            if (count != 0L) {
                this.todoList.add(itemAction);
            }
            int n = p = this.todo > 0 ? 100 * this.done / this.todo : 0;
            if (this.done < this.todo) {
                this.setText("Counting rows... " + p + "%");
            } else {
                this.setText("All non-empty (" + this.todoList.size() + ")");
                this.setEnabled(true);
            }
        }

        public void setInitialText() {
            if (this.todoList.isEmpty()) {
                this.setText("All non-empty (0)");
            } else {
                this.setText("Counting rows... 100%");
            }
        }
    }

    static class SqlStatementTable
    extends Table {
        public SqlStatementTable(String name, PrimaryKey primaryKey, boolean defaultUpsert) {
            super(name, primaryKey, defaultUpsert);
        }
    }

    final class LoadJob
    implements RunnableWithPriority {
        private List<Row> rows = Collections.synchronizedList(new ArrayList());
        private Exception exception;
        private boolean isCanceled;
        private final int limit;
        private final String andCond;
        private final boolean selectDistinct;
        private boolean finished;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LoadJob(int limit, String andCond, boolean selectDistinct) {
            this.andCond = andCond;
            this.selectDistinct = selectDistinct;
            LoadJob loadJob = this;
            synchronized (loadJob) {
                this.limit = limit;
                this.finished = false;
                this.isCanceled = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int l;
            LoadJob loadJob = this;
            synchronized (loadJob) {
                l = this.limit;
                if (this.isCanceled) {
                    CancellationHandler.reset(this);
                    return;
                }
            }
            BrowserContentPane.this.rowCountCache.clear();
            try {
                BrowserContentPane.this.reloadRows(this.andCond, this.rows, this, l + 1, this.selectDistinct);
                CancellationHandler.checkForCancellation(this);
                loadJob = this;
                synchronized (loadJob) {
                    this.finished = true;
                }
            }
            catch (SQLException e) {
                List<Row> list = this.rows;
                synchronized (list) {
                    this.exception = e;
                }
            }
            catch (CancellationException e) {
                Session._log.info("cancelled");
                CancellationHandler.reset(this);
                return;
            }
            CancellationHandler.reset(this);
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block25: {
                        int l;
                        Exception e;
                        boolean limitExceeded = false;
                        List list = LoadJob.this.rows;
                        synchronized (list) {
                            e = LoadJob.this.exception;
                            l = LoadJob.this.limit;
                            while (LoadJob.this.rows.size() > LoadJob.this.limit) {
                                limitExceeded = true;
                                LoadJob.this.rows.remove(LoadJob.this.rows.size() - 1);
                            }
                            LoadJob.this.isCanceled = true;
                        }
                        if (e != null) {
                            BrowserContentPane.this.updateMode("error");
                            BrowserContentPane.this.unhide();
                            if (!asking) {
                                try {
                                    if (BrowserContentPane.this.table.getName() != null && !BrowserContentPane.this.table.exists(BrowserContentPane.this.session, JDBCMetaDataBasedModelElementFinder.getDefaultSchema(BrowserContentPane.this.session, BrowserContentPane.this.session.getSchemaName()))) {
                                        asking = true;
                                        String schemaMappingOption = "Schema Mapping";
                                        switch (JOptionPane.showOptionDialog(BrowserContentPane.this, "Table \"" + BrowserContentPane.this.table.getName() + "\" not found!", "Unknown table", 0, 1, null, new Object[]{"Cancel", schemaMappingOption, "Analyze Database"}, "Cancel")) {
                                            case 1: {
                                                BrowserContentPane.this.openSchemaMappingDialog();
                                                break;
                                            }
                                            case 2: {
                                                BrowserContentPane.this.openSchemaAnalyzer();
                                            }
                                        }
                                        asking = false;
                                        break block25;
                                    }
                                    UIUtil.showException(BrowserContentPane.this, "Error", e);
                                }
                                catch (Exception e1) {
                                    asking = false;
                                    UIUtil.showException(BrowserContentPane.this, "Error", e);
                                }
                            }
                        } else {
                            TreeSet<String> prevIDs = new TreeSet<String>();
                            int prevSize = 0;
                            long prevHash = 0L;
                            if (BrowserContentPane.this.rows != null) {
                                prevSize = BrowserContentPane.this.rows.size();
                                for (Row r : BrowserContentPane.this.rows) {
                                    prevIDs.add(r.rowId);
                                    try {
                                        for (Object v : r.values) {
                                            if (v == null) continue;
                                            prevHash = 2L * prevHash + (long)v.hashCode();
                                        }
                                    }
                                    catch (RuntimeException e1) {
                                    }
                                }
                            }
                            BrowserContentPane.this.onContentChange(new ArrayList<Row>(), false);
                            BrowserContentPane.this.rows.clear();
                            BrowserContentPane.this.rows.addAll(LoadJob.this.rows);
                            BrowserContentPane.this.updateTableModel(l, limitExceeded);
                            TreeSet<String> currentIDs = new TreeSet<String>();
                            long currentHash = 0L;
                            if (LoadJob.this.rows != null) {
                                for (Row r : LoadJob.this.rows) {
                                    currentIDs.add(r.rowId);
                                    try {
                                        for (Object v : r.values) {
                                            if (v == null) continue;
                                            currentHash = 2L * currentHash + (long)v.hashCode();
                                        }
                                    }
                                    catch (RuntimeException e1) {
                                    }
                                }
                            }
                            BrowserContentPane.this.setPendingState(false, true);
                            BrowserContentPane.this.onContentChange(LoadJob.this.rows, true);
                            BrowserContentPane.this.updateMode("table");
                            BrowserContentPane.this.updateWhereField();
                            if (BrowserContentPane.this.reloadAction != null) {
                                BrowserContentPane.this.reloadAction.run();
                            }
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            LoadJob loadJob = this;
            synchronized (loadJob) {
                if (this.isCanceled) {
                    return;
                }
                this.isCanceled = true;
                if (this.finished) {
                    return;
                }
            }
            CancellationHandler.cancel(this);
        }

        @Override
        public int getPriority() {
            return 100;
        }
    }
}

