/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.xml.XmlUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlSketchBuilder {
    public static String buildSketch(Table table, int depth) throws Exception {
        if (table == null) {
            return "";
        }
        Document sketch = table.getXmlTemplateAsDocument();
        if (sketch.getChildNodes().getLength() > 0 && sketch.getChildNodes().item(0) instanceof Element) {
            XmlSketchBuilder.insertAssociationSketch((Element)sketch.getChildNodes().item(0), table, sketch, depth);
        }
        return XmlUtil.build(sketch);
    }

    private static void insertAssociationSketch(Element element, Table table, Document doc, int depth) throws DOMException, ParserConfigurationException, SAXException, IOException {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                Element e = (Element)children.item(i);
                if ("http://jailer.sf.net/".equals(e.getNamespaceURI()) && "assoc".equals(e.getLocalName()) && e.getTextContent() != null) {
                    Node[] ae;
                    Association association = null;
                    for (Association a : table.associations) {
                        if (a.getAggregationSchema() == AggregationSchema.NONE || !a.getName().equals(e.getTextContent().trim())) continue;
                        association = a;
                        break;
                    }
                    if (association != null && depth < 3 && (ae = XmlSketchBuilder.insertAssociationSketch(association, doc, depth + 1)) != null) {
                        for (Node n : ae) {
                            element.insertBefore(doc.importNode(n, true), e);
                            ++i;
                        }
                    }
                    element.removeChild(e);
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    private static Node[] insertAssociationSketch(Association association, Document doc, int depth) throws ParserConfigurationException, SAXException, IOException {
        if (association.getAggregationSchema() == AggregationSchema.EXPLICIT_LIST) {
            Element e1 = doc.createElement(association.getAggregationTagName());
            Element e2 = doc.createElement(association.destination.getUnqualifiedName().toLowerCase());
            e1.appendChild(e2);
            if (association.getCardinality() != Cardinality.MANY_TO_ONE && association.getCardinality() != Cardinality.ONE_TO_ONE) {
                e1.appendChild(doc.createComment("..."));
            }
            return new Node[]{e1};
        }
        if (association.getAggregationSchema() == AggregationSchema.IMPLICIT_LIST) {
            Element e1 = doc.createElement(association.getAggregationTagName());
            if (association.getCardinality() != Cardinality.MANY_TO_ONE && association.getCardinality() != Cardinality.ONE_TO_ONE) {
                Comment c = doc.createComment("...");
                return new Node[]{e1, c};
            }
            return new Node[]{e1};
        }
        if (association.getAggregationSchema() == AggregationSchema.FLAT) {
            Document sketch = association.destination.getXmlTemplateAsDocument();
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (sketch.getChildNodes().getLength() > 0 && sketch.getChildNodes().item(0) instanceof Element) {
                XmlSketchBuilder.insertAssociationSketch((Element)sketch.getChildNodes().item(0), association.destination, sketch, depth + 1);
            }
            NodeList children = sketch.getChildNodes().item(0).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                nodes.add(children.item(i));
            }
            if (association.getCardinality() != Cardinality.MANY_TO_ONE && association.getCardinality() != Cardinality.ONE_TO_ONE) {
                nodes.add(sketch.createComment("..."));
            }
            return nodes.toArray(new Node[nodes.size()]);
        }
        return null;
    }

    public static String buildSketch2(Table table, int depth) {
        StringBuilder sb = new StringBuilder();
        if (table != null && depth < 2) {
            ArrayList<Association> sortedSourceAssociations = new ArrayList<Association>(table.associations);
            Collections.sort(sortedSourceAssociations, new Comparator<Association>(){

                @Override
                public int compare(Association o1, Association o2) {
                    return o1.destination.getName().compareTo(o2.destination.getName());
                }
            });
            if (depth == 0) {
                sb.append("<" + table.getUnqualifiedName().toLowerCase() + ">\n");
                sb.append("    -- elements of " + table.getUnqualifiedName() + " --\n");
            }
            String indent = "    ";
            for (Association a : sortedSourceAssociations) {
                if (a.getAggregationSchema() == AggregationSchema.EXPLICIT_LIST) {
                    sb.append(indent + "<" + a.getAggregationTagName() + ">\n");
                    sb.append(indent + "    <" + a.destination.getUnqualifiedName().toLowerCase() + "/>\n");
                    if (a.getCardinality() != Cardinality.MANY_TO_ONE && a.getCardinality() != Cardinality.ONE_TO_ONE) {
                        sb.append(indent + "    <" + a.destination.getUnqualifiedName().toLowerCase() + "/>\n");
                        sb.append(indent + "      ...\n");
                    }
                    sb.append(indent + "</" + a.getAggregationTagName() + ">\n");
                    continue;
                }
                if (a.getAggregationSchema() == AggregationSchema.IMPLICIT_LIST) {
                    sb.append(indent + "<" + a.getAggregationTagName() + "/>\n");
                    if (a.getCardinality() == Cardinality.MANY_TO_ONE || a.getCardinality() == Cardinality.ONE_TO_ONE) continue;
                    sb.append(indent + "<" + a.getAggregationTagName() + "/>\n");
                    sb.append(indent + "  ...\n");
                    continue;
                }
                if (a.getAggregationSchema() != AggregationSchema.FLAT) continue;
                sb.append(indent + "-- elements of " + a.destination.getUnqualifiedName() + "(flattened " + a.getName() + ") --\n");
                sb.append(XmlSketchBuilder.buildSketch2(a.destination, depth + 1));
                if (a.getCardinality() == Cardinality.MANY_TO_ONE || a.getCardinality() == Cardinality.ONE_TO_ONE) continue;
                sb.append(indent + "-- elements of " + a.destination.getUnqualifiedName() + "(flattened " + a.getName() + ") --\n");
                sb.append(indent + "     ...\n");
            }
            if (depth == 0) {
                sb.append("</" + table.getUnqualifiedName().toLowerCase() + ">\n");
            }
        }
        return sb.toString();
    }
}

