/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.UIUtil;

public class XmlSettingsDialog
extends JDialog {
    private boolean okClicked;
    private static String[] datePatternOptions = new String[]{"dd-MM-yyyy", "dd/MM/yyyy", "dd.MM.yyyy", "dd.MMM.yyyy", "dd MMMM yyyy", "MM-dd-yyyy", "MM/dd/yyyy", "MMM d, yyyy", "yyyy.d.M", "dd MMM yyyy", "dd-MMM-yyyy", "dd.MM.yyyy.", "d MMM yyyy", "d MMM, yyyy", "d-MMM-yyyy", "d/MMM/yyyy", "d/MM/yyyy", "d.MM.yyyy", "d.M.yyyy", "Gy.MM.dd", "yyyy-M-d", "yyyy/M/d", "yyyy. M. d", "yyyy.M.d", "yyyy'?'M'?'d'?'", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "yyyy.MM.dd.", "yyyy MMM d", "yyyy-MMM-dd", "dd MMM yy", "dd-MMM-yy", "MM d, yy"};
    private static String[] timePatternOptions = new String[]{"dd/MM/yyyy HH:mm:ss", "dd.MM.yyyy HH:mm:ss", "dd.MM.yyyy. HH.mm.ss", "dd.MM.yyyy H:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy.MM.dd HH:mm:ss", "yyyy/MM/dd H:mm:ss", "yyyy.MM.dd. H:mm:ss", "yyyy-MMM-dd HH:mm:ss", "dd/MM/yyyy HH.mm.ss", "dd.MM.yyyy HH.mm.ss", "dd.MM.yyyy. HH.mm.ss", "dd.MM.yyyy H.mm.ss", "yyyy-MM-dd HH.mm.ss", "yyyy.MM.dd HH.mm.ss", "yyyy/MM/dd H.mm.ss", "yyyy.MM.dd. H.mm.ss", "yyyy-MMM-dd HH.mm.ss", "dd/MM/yyyy-HH.mm.ss", "dd.MM.yyyy-HH.mm.ss", "dd.MM.yyyy.-HH.mm.ss", "dd.MM.yyyy-H.mm.ss", "yyyy-MM-dd-HH.mm.ss", "yyyy.MM.dd-HH.mm.ss", "yyyy/MM/dd-H.mm.ss", "yyyy.MM.dd.-H.mm.ss", "yyyy-MMM-dd-HH.mm.ss", "dd MMM yy H:mm:ss", "dd MMM yyyy HH:mm:ss", "dd-MMM-yyyy HH:mm:ss", "dd.MMM.yyyy HH:mm:ss", "dd-MMM-yyyy H:mm:ss", "dd-MM-yyyy HH:mm:ss", "d MMM yyyy HH:mm:ss", "d-MMM-yyyy HH:mm:ss", "d MMM yyyy H:mm:ss", "d MMM yyyy, H:mm:ss", "d-MMM-yyyy H:mm:ss", "d-MMM-yyyy H.mm.ss", "d/MMM/yyyy H:mm:ss", "d/MM/yyyy HH:mm:ss", "d.MM.yyyy H:mm:ss", "d.M.yyyy HH:mm:", "d.M.yyyy HH:mm:ss", "d.M.yyyy H:mm:ss", "d.M.yyyy H.mm.ss", "Gy.MM.dd H:mm:ss", "HH:mm:ss dd-MM-yyyy", "HH:mm:ss dd/MM/yyyy", "yyyy.d.M HH:mm:ss", "yyyy.M.d HH.mm.ss", "yyyy MMM d HH:mm:ss"};
    private JButton Ok;
    private JLabel dateExample;
    private javax.swing.JComboBox datePattern;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JCheckBox noRootTag;
    private JTextField rootTag;
    private JLabel timestampExample;
    private javax.swing.JComboBox timestampPattern;
    private static final long serialVersionUID = -2752715206964965549L;

    public XmlSettingsDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.setModal(true);
        this.setLocation(100, 150);
        this.datePattern.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlSettingsDialog.this.updateExamples();
            }
        });
        this.timestampPattern.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlSettingsDialog.this.updateExamples();
            }
        });
        this.datePattern.setModel(new DefaultComboBoxModel<String>(datePatternOptions));
        this.timestampPattern.setModel(new DefaultComboBoxModel<String>(timePatternOptions));
        this.timestampPattern.getEditor().setItem("yyyy.MM.dd.-H.mm.ss   ");
        this.timestampExample.setText("yyyy.MM.dd.-H.mm.ss   ");
        this.pack();
        UIUtil.initPeer();
    }

    public boolean edit(DataModel dataModel) {
        DataModel.XmlSettings xmlSettings = dataModel.getXmlSettings();
        this.datePattern.getEditor().setItem(xmlSettings.datePattern);
        this.timestampPattern.getEditor().setItem(xmlSettings.timestampPattern);
        this.rootTag.setText(xmlSettings.rootTag);
        this.noRootTag.setSelected("".equals(xmlSettings.rootTag));
        this.rootTag.setEditable(!"".equals(xmlSettings.rootTag));
        this.updateExamples();
        this.okClicked = false;
        this.setVisible(true);
        if (this.okClicked) {
            boolean change = false;
            String newDatePattern = this.datePattern.getEditor().getItem().toString();
            String newTimestampPattern = this.timestampPattern.getEditor().getItem().toString();
            String newRootTag = this.rootTag.getText().trim();
            if (this.noRootTag.isSelected()) {
                newRootTag = "";
            }
            if (!newDatePattern.equals(xmlSettings.datePattern)) {
                xmlSettings.datePattern = newDatePattern;
                change = true;
            }
            if (!newTimestampPattern.equals(xmlSettings.timestampPattern)) {
                xmlSettings.timestampPattern = newTimestampPattern;
                change = true;
            }
            if (!newRootTag.equals(xmlSettings.rootTag)) {
                xmlSettings.rootTag = newRootTag;
                change = true;
            }
            return change;
        }
        return false;
    }

    private void updateExamples() {
        Date now = new Date();
        String dateExampleText = "- invalid pattern -";
        String timestampExampleText = "- invalid pattern -";
        try {
            dateExampleText = new SimpleDateFormat(this.datePattern.getEditor().getItem().toString()).format(now);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            timestampExampleText = new SimpleDateFormat(this.timestampPattern.getEditor().getItem().toString()).format(now);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.dateExample.setText(dateExampleText);
        this.timestampExample.setText(timestampExampleText);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.Ok = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.datePattern = new JComboBox();
        this.timestampPattern = new JComboBox();
        this.rootTag = new JTextField();
        this.dateExample = new JLabel();
        this.timestampExample = new JLabel();
        this.noRootTag = new JCheckBox();
        this.setTitle("XML Settings");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.Ok.setText("OK");
        this.Ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XmlSettingsDialog.this.OkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.Ok, gridBagConstraints);
        this.jLabel1.setText("Date pattern ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Timestamp pattern ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Root tag");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.datePattern.setModel(new DefaultComboBoxModel<String>(new String[]{"Eintrag 1", "Eintrag 2", "Eintrag 3", "Eintrag 4"}));
        this.datePattern.setEditable(true);
        this.datePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XmlSettingsDialog.this.datePatternActionPerformed(evt);
            }
        });
        this.datePattern.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                XmlSettingsDialog.this.datePatternKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.datePattern, gridBagConstraints);
        this.timestampPattern.setModel(new DefaultComboBoxModel<String>(new String[]{"Eintrag 1", "Eintrag 2", "Eintrag 3", "Eintrag 4"}));
        this.timestampPattern.setEditable(true);
        this.timestampPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XmlSettingsDialog.this.timestampPatternActionPerformed(evt);
            }
        });
        this.timestampPattern.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                XmlSettingsDialog.this.timestampPatternKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.timestampPattern, gridBagConstraints);
        this.rootTag.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.rootTag, gridBagConstraints);
        this.dateExample.setText("jLabel4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 20;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.getContentPane().add((Component)this.dateExample, gridBagConstraints);
        this.timestampExample.setText("jLabel5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 20;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.getContentPane().add((Component)this.timestampExample, gridBagConstraints);
        this.noRootTag.setText("no root tag");
        this.noRootTag.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                XmlSettingsDialog.this.noRootTagItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.noRootTag, gridBagConstraints);
        this.pack();
    }

    private void timestampPatternKeyTyped(KeyEvent evt) {
        this.updateExamples();
    }

    private void timestampPatternActionPerformed(ActionEvent evt) {
        this.updateExamples();
    }

    private void datePatternKeyTyped(KeyEvent evt) {
        this.updateExamples();
    }

    private void datePatternActionPerformed(ActionEvent evt) {
        this.updateExamples();
    }

    private void OkActionPerformed(ActionEvent evt) {
        this.okClicked = true;
        this.setVisible(false);
    }

    private void noRootTagItemStateChanged(ItemEvent evt) {
        this.rootTag.setEditable(!this.noRootTag.isSelected());
    }
}

