/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.Jailer;
import net.sf.jailer.database.SqlException;
import net.sf.jailer.progress.ProgressListener;
import net.sf.jailer.ui.JailerConsole;
import net.sf.jailer.ui.ProgressPanel;
import net.sf.jailer.ui.SqlErrorDialog;
import net.sf.jailer.ui.scrollmenu.JScrollC2PopupMenu;
import net.sf.jailer.ui.scrollmenu.JScrollPopupMenu;
import net.sf.jailer.util.CancellationException;
import net.sf.jailer.util.CancellationHandler;
import org.apache.log4j.Logger;

public class UIUtil {
    private static final Logger _log = Logger.getLogger(UIUtil.class);
    private static final File cdSettings = new File(".cdsettings");
    public static boolean disableWarnings = false;

    public static String choseFile(File selectedFile, String startDir, String description, String extension, Component parent, boolean addExtension, boolean forLoad) {
        return UIUtil.choseFile(selectedFile, startDir, description, extension, parent, addExtension, forLoad, true);
    }

    public static String choseFile(File selectedFile, String startDir, String description, final String extension, Component parent, boolean addExtension, boolean forLoad, final boolean allowZip) {
        int returnVal;
        String newStartDir = UIUtil.restoreCurrentDir(extension);
        if (newStartDir != null) {
            startDir = newStartDir;
        }
        JFileChooser fileChooser = new JFileChooser(startDir);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(extension) || pathname.getName().toLowerCase().endsWith(extension + ".gz") || pathname.getName().toLowerCase().endsWith(extension + ".zip");
            }

            @Override
            public String getDescription() {
                if ((extension.endsWith(".sql") || extension.endsWith(".xml")) && allowZip) {
                    return "*" + extension + " *" + extension + ".zip";
                }
                return "*" + extension;
            }
        };
        fileChooser.setFileFilter(filter);
        fileChooser.setDialogTitle(description);
        if (selectedFile != null) {
            fileChooser.setSelectedFile(selectedFile);
        }
        fileChooser.setDialogType(forLoad ? 0 : 1);
        int n = returnVal = forLoad ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        if (returnVal == 0) {
            String fn = "";
            try {
                File f = fileChooser.getSelectedFile();
                String work = new File(".").getCanonicalPath();
                if (f.getCanonicalPath().startsWith(work)) {
                    fn = f.getName();
                    for (f = f.getParentFile(); f != null && !f.getCanonicalPath().equals(work); f = f.getParentFile()) {
                        fn = f.getName() + File.separator + fn;
                    }
                } else {
                    fn = f.getCanonicalPath();
                }
                if (!(!addExtension || fn.endsWith(extension) || allowZip && fn.endsWith(extension + ".zip"))) {
                    fn = fn + extension;
                }
                try {
                    UIUtil.storeCurrentDir(extension, fileChooser.getSelectedFile().getParent());
                }
                catch (Exception e) {
                    // empty catch block
                }
                return fn;
            }
            catch (IOException e1) {
                try {
                    fn = fileChooser.getSelectedFile().getCanonicalPath();
                    if (!(!addExtension || fn.endsWith(extension) || allowZip && fn.endsWith(extension + ".zip"))) {
                        fn = fn + extension;
                    }
                    return fn;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private static void storeCurrentDir(String key, String currentDir) {
        try {
            Map<String, String> cd = new HashMap<String, String>();
            if (cdSettings.exists()) {
                try {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(cdSettings));
                    cd = (Map)in.readObject();
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            cdSettings.delete();
            cd.put(key, currentDir);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cdSettings));
            out.writeObject(cd);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String restoreCurrentDir(String key) {
        if (cdSettings.exists()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(cdSettings));
                String cd = (String)((Map)in.readObject()).get(key);
                in.close();
                return cd;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean runJailer(Window ownerOfConsole, List<String> cliArgs, boolean showLogfileButton, boolean printCommandLine, boolean showExplainLogButton, boolean closeOutputWindow, String continueOnErrorQuestion, String password, ProgressListener progressListener, ProgressPanel progressPanel, boolean showExeptions, boolean fullSize, boolean returnFalseOnError) {
        return UIUtil.runJailer(ownerOfConsole, cliArgs, showLogfileButton, printCommandLine, showExplainLogButton, closeOutputWindow, continueOnErrorQuestion, password, progressListener, progressPanel, showExeptions, fullSize, false, returnFalseOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean runJailer(Window ownerOfConsole, List<String> cliArgs, boolean showLogfileButton, final boolean printCommandLine, boolean showExplainLogButton, final boolean closeOutputWindow, String continueOnErrorQuestion, String password, final ProgressListener progressListener, final ProgressPanel progressPanel, final boolean showExeptions, boolean fullSize, final boolean closeOutputWindowOnError, boolean returnFalseOnError) {
        JDialog dialog = new JDialog(ownerOfConsole);
        ArrayList<String> args = new ArrayList<String>(cliArgs);
        final StringBuffer arglist = UIUtil.createCLIArgumentString(password, args);
        final String[] argsarray = new String[args.size()];
        int i = 0;
        for (String arg : args) {
            argsarray[i++] = arg.trim();
        }
        final JailerConsole outputView = new JailerConsole(ownerOfConsole, dialog, showLogfileButton, showExplainLogButton, progressPanel, fullSize);
        final PrintStream originalOut = System.out;
        final boolean[] ready = new boolean[]{true};
        System.setOut(new PrintStream(new OutputStream(){
            private int lineNr = 0;
            StringBuffer buffer = new StringBuffer();

            @Override
            public synchronized void write(byte[] arg0, int arg1, int arg2) throws IOException {
                super.write(arg0, arg1, arg2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int b) throws IOException {
                boolean wasReady;
                if (b != 64) {
                    originalOut.write(b);
                }
                StringBuffer stringBuffer = this.buffer;
                synchronized (stringBuffer) {
                    wasReady = ready[0];
                    if (b != 64) {
                        this.buffer.append((char)b);
                    }
                }
                if ((char)b == '\n') {
                    ++this.lineNr;
                }
                if (((char)b == '\n' && this.lineNr % 60 == 0 || (char)b == '@') && wasReady) {
                    stringBuffer = this.buffer;
                    synchronized (stringBuffer) {
                        ready[0] = false;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                StringBuffer stringBuffer = buffer;
                                synchronized (stringBuffer) {
                                    if (buffer.length() > 0) {
                                        outputView.appendText(buffer.toString());
                                        buffer.setLength(0);
                                    }
                                }
                                ready[0] = true;
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }));
        final boolean[] exceptionShown = new boolean[1];
        try {
            try {
                FileOutputStream out;
                File exportLog = new File("export.log");
                File sqlLog = new File("sql.log");
                if (exportLog.exists()) {
                    out = new FileOutputStream(exportLog);
                    out.close();
                }
                if (sqlLog.exists()) {
                    out = new FileOutputStream(sqlLog);
                    out.close();
                }
            }
            catch (Exception e) {
                UIUtil.showException(null, "Error", e);
            }
            final boolean[] result = new boolean[]{false};
            final Throwable[] exp = new Throwable[1];
            final StringBuffer warnings = new StringBuffer();
            final boolean[] fin = new boolean[]{false};
            outputView.dialog.addWindowListener(new WindowAdapter(){
                boolean cancelled = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosing(WindowEvent e) {
                    Class<UIUtil> clazz = UIUtil.class;
                    synchronized (UIUtil.class) {
                        boolean f = exp[0] == null;
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        if (this.cancelled && f) {
                            JOptionPane.showMessageDialog(outputView.dialog, "Cancellation in progress...", "Cancellation", 1);
                        }
                        if (exp[0] == null && !fin[0] && !this.cancelled && JOptionPane.showConfirmDialog(outputView.dialog, "Cancel operation?", "Cancellation", 0, 3) == 0) {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    CancellationHandler.cancel(null);
                                }
                            }).start();
                            outputView.dialog.setTitle("Jailer Console - cancelling...");
                            if (progressListener != null) {
                                progressListener.newStage("cancelling", true, true);
                            }
                            this.cancelled = true;
                        }
                        return;
                    }
                }
            });
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    int i = 0;
                    while (true) {
                        try {
                            Thread.sleep(i == 0 ? 500L : 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        boolean[] blArray = fin;
                        // MONITORENTER : fin
                        if (fin[0]) {
                            // MONITOREXIT : blArray
                            return;
                        }
                        System.out.print("@");
                        // MONITOREXIT : blArray
                        ++i;
                    }
                }
            }).start();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (printCommandLine) {
                            _log.info("arguments: " + arglist.toString().trim());
                        }
                        result[0] = Jailer.jailerMain(argsarray, disableWarnings ? new StringBuffer() : warnings, progressListener);
                    }
                    catch (Throwable t) {
                        Class<UIUtil> clazz = UIUtil.class;
                        synchronized (UIUtil.class) {
                            exp[0] = t;
                            // ** MonitorExit[var2_5] (shouldn't be in output)
                        }
                    }
                    finally {
                        System.out.println("@");
                        Class<UIUtil> clazz = UIUtil.class;
                        synchronized (UIUtil.class) {
                            fin[0] = true;
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                    {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Class<UIUtil> clazz = UIUtil.class;
                                synchronized (UIUtil.class) {
                                    outputView.dialog.setDefaultCloseOperation(2);
                                    if (progressListener != null) {
                                        progressListener.newStage(exp[0] == null ? "finished" : "failed", exp[0] != null, true);
                                    }
                                    if (exp[0] instanceof CancellationException || closeOutputWindowOnError || closeOutputWindow && result[0] && exp[0] == null && warnings.length() == 0) {
                                        outputView.dialog.setVisible(false);
                                    } else {
                                        outputView.finish(result[0] && exp[0] == null);
                                        if (result[0] && warnings.length() > 0) {
                                            JOptionPane.showMessageDialog(outputView.dialog, warnings.length() > 800 ? warnings.substring(0, 800) + "..." : warnings.toString(), "Warning", 1);
                                            outputView.dialog.setVisible(false);
                                        } else if (showExeptions && exp[0] != null && !(exp[0] instanceof CancellationException)) {
                                            UIUtil.showException(outputView.dialog, "Error", exp[0]);
                                            exceptionShown[0] = true;
                                        }
                                        if (result[0] && progressPanel != null) {
                                            progressPanel.confirm();
                                        }
                                    }
                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                    return;
                                }
                            }
                        });
                        return;
                    }
                }
            }, "jailer-main").start();
            outputView.dialog.setVisible(true);
            Class<UIUtil> clazz = UIUtil.class;
            // MONITORENTER : net.sf.jailer.ui.UIUtil.class
            if (exp[0] != null) {
                if (!returnFalseOnError) throw exp[0];
                result[0] = false;
            }
            // MONITOREXIT : clazz
            if (!result[0] && continueOnErrorQuestion != null) {
                result[0] = JOptionPane.showConfirmDialog(outputView.dialog, continueOnErrorQuestion, "Error", 0) == 0;
            }
            boolean bl = result[0];
            return bl;
        }
        catch (Throwable t) {
            if (t instanceof CancellationException) {
                CancellationHandler.reset(null);
            } else {
                boolean shown = false;
                Class<UIUtil> clazz = UIUtil.class;
                // MONITORENTER : net.sf.jailer.ui.UIUtil.class
                shown = exceptionShown[0];
                // MONITOREXIT : clazz
                if (!shown) {
                    UIUtil.showException(null, "Error", t);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            System.setOut(originalOut);
        }
    }

    public static StringBuffer createCLIArgumentString(String password, List<String> args) {
        args.add("-datamodel");
        args.add(CommandLineParser.getInstance().getDataModelFolder());
        args.add("-script-enhancer");
        args.add(CommandLineParser.getInstance().enhancerFolder);
        if (CommandLineParser.getInstance().workingFolder != null) {
            args.add("-working-folder");
            args.add(CommandLineParser.getInstance().workingFolder);
        }
        StringBuffer arglist = new StringBuffer();
        for (String arg : args) {
            if (arg != null && arg.equals(password) && password.length() > 0) {
                arglist.append(" \"<password>\"");
                continue;
            }
            if ("".equals(arg) || arg.contains(" ") || arg.contains("<") || arg.contains(">") || arg.contains("*") || arg.contains("?") || arg.contains("|") || arg.contains("$") || arg.contains("\"") || arg.contains("'") || arg.contains("\\") || arg.contains(";") || arg.contains("&")) {
                arglist.append(" \"");
                for (int j = 0; j < arg.length(); ++j) {
                    char c = arg.charAt(j);
                    if (c == '\"' || c == '$') {
                        arglist.append("\\");
                    }
                    arglist.append(c);
                }
                arglist.append("\"");
                continue;
            }
            arglist.append(" " + arg);
        }
        return arglist;
    }

    public static void showException(Component parent, String title, Throwable t) {
        t.printStackTrace();
        if (!(t instanceof ClassNotFoundException)) {
            while (t.getCause() != null && t != t.getCause() && !(t instanceof SqlException)) {
                t = t.getCause();
            }
        }
        if (t instanceof SqlException) {
            String message = ((SqlException)t).message;
            String sql = ((SqlException)t).sqlStatement;
            new SqlErrorDialog(parent == null ? null : SwingUtilities.getWindowAncestor(parent), UIUtil.lineWrap(message, 120).toString(), UIUtil.lineWrap(sql, 140).toString());
            return;
        }
        StringBuilder msg = UIUtil.lineWrap(t.getMessage(), 80);
        JOptionPane.showMessageDialog(parent, msg.toString().trim(), title + " - " + t.getClass().getName(), 0);
    }

    private static StringBuilder lineWrap(String message, int maxwidth) {
        StringBuilder msg = new StringBuilder();
        Pattern wrapRE = Pattern.compile("(\\S\\S{" + maxwidth + ",}|.{1," + maxwidth + "})(\\s+|$)");
        Matcher m = wrapRE.matcher(message == null ? "" : message);
        while (m.find()) {
            String line = m.group();
            while (line.length() > maxwidth + 10) {
                msg.append(line.substring(0, maxwidth) + "\n");
                line = line.substring(maxwidth);
            }
            msg.append(line + (line.contains("\n") ? "" : "\n"));
        }
        return msg;
    }

    public static void loadTableList(List<String> list, String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                list.add(line);
            }
            in.close();
        }
    }

    public static void initPeer() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void fit(JDialog d) {
        try {
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int hd = d.getY() + d.getHeight() - (dim.height - 80);
            if (hd > 0) {
                d.setSize(d.getWidth(), Math.max(d.getHeight() - hd, 150));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void showMaxMemory() {
        long memSize = 0L;
        try {
            int MB = 0x100000;
            ArrayList<byte[]> mem = new ArrayList<byte[]>();
            while (true) {
                mem.add(new byte[0x100000]);
                memSize += 0x100000L;
            }
        }
        catch (OutOfMemoryError e) {
            JOptionPane.showConfirmDialog(null, "MaxMem=" + memSize, "", 1);
            return;
        }
    }

    public static void replace(JComponent component, JComponent replacement) {
        Container parent = component.getParent();
        GridBagConstraints c = ((GridBagLayout)parent.getLayout()).getConstraints(component);
        parent.remove(component);
        if (replacement != null) {
            parent.add((Component)replacement, c);
        }
    }

    public static void wireComponentWithButton(JComponent component, final JButton button) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() > 1 && button.isEnabled()) {
                    button.doClick();
                }
            }
        });
        component.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' && button.isEnabled()) {
                    button.doClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
    }

    public static void fit(JPopupMenu popup) {
        if (!(popup instanceof JScrollPopupMenu) && !(popup instanceof JScrollC2PopupMenu)) {
            int MAX_ITEMS = 40;
            Component[] comps = popup.getComponents();
            popup.removeAll();
            JMenu current = null;
            int ci = 1;
            for (int i = 0; i < comps.length; ++i) {
                if (ci > 40 && i < comps.length - 5) {
                    ci = 1;
                    JMenu newMenu = new JMenu("more...");
                    if (current == null) {
                        popup.add(newMenu);
                    } else {
                        current.add(newMenu);
                    }
                    current = newMenu;
                }
                if (current == null) {
                    popup.add(comps[i]);
                } else {
                    current.add(comps[i]);
                }
                ++ci;
            }
        }
    }
}

