/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.ModelElement;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.progress.ProgressListener;
import net.sf.jailer.ui.ProgressPanel;
import net.sf.jailer.ui.ProgressTable;

public class UIProgressListener
implements ProgressListener {
    private final ProgressTable progressTable;
    private final List<Map<ModelElement, Long>> collections = new ArrayList<Map<ModelElement, Long>>();
    private final Map<String, Long> rowsPerTable = new TreeMap<String, Long>();
    private int today = -1;
    private int lastUpdated = -1;
    private boolean lastRowIsUptodate = false;
    private boolean stop = false;
    private long exportedRows = 0L;
    private long collectedRows = 0L;
    private String currentStep = "";
    private boolean isErrorStage = false;
    private boolean stopClock = false;
    private boolean rowsPerTableIsUptodate = false;
    private final DataModel dataModel;
    private Map<Table, Integer> inProgress = new HashMap<Table, Integer>();
    private boolean cleanupLastLine = false;

    public UIProgressListener(final ProgressTable progressTable, final ProgressPanel progressPanel, DataModel dataModel) {
        this.progressTable = progressTable;
        this.dataModel = dataModel;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final long startTime = System.currentTimeMillis();
                while (!UIProgressListener.this.getStop()) {
                    final long[] nextUpdateTS = new long[]{0L};
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    boolean update = false;
                    boolean timeForUpdate = true;
                    UIProgressListener uIProgressListener = UIProgressListener.this;
                    synchronized (uIProgressListener) {
                        boolean bl = update = UIProgressListener.this.today >= 0 && (UIProgressListener.this.lastUpdated != UIProgressListener.this.today || !UIProgressListener.this.lastRowIsUptodate);
                        if (nextUpdateTS[0] != 0L && System.currentTimeMillis() < nextUpdateTS[0]) {
                            timeForUpdate = false;
                        }
                    }
                    final boolean fUpdate = update;
                    if (!timeForUpdate) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (fUpdate) {
                                UIProgressListener.this.addOrUpdateRows();
                            }
                            UIProgressListener uIProgressListener = UIProgressListener.this;
                            synchronized (uIProgressListener) {
                                progressTable.setTotalNumberOfCollectedRows(UIProgressListener.this.collectedRows);
                                progressPanel.collectedRowsLabel.setText("" + UIProgressListener.this.collectedRows);
                                progressPanel.exportedRowsLabel.setText("" + UIProgressListener.this.exportedRows);
                                progressPanel.stepLabel.setText(UIProgressListener.this.currentStep);
                                if (UIProgressListener.this.isErrorStage) {
                                    progressPanel.stepLabel.setForeground(Color.RED);
                                }
                                if (!UIProgressListener.this.rowsPerTableIsUptodate) {
                                    progressPanel.updateRowsPerTable(UIProgressListener.this.rowsPerTable);
                                    UIProgressListener.this.rowsPerTableIsUptodate = true;
                                }
                                long t = System.currentTimeMillis();
                                if (!UIProgressListener.this.stopClock) {
                                    long et = (t - startTime) / 1000L;
                                    long sec = et % 60L;
                                    long min = et / 60L % 60L;
                                    long h = et / 3600L;
                                    progressPanel.elapsedTimeLabel.setText((h < 10L ? "0" : "") + h + ":" + (min < 10L ? "0" : "") + min + ":" + (sec < 10L ? "0" : "") + sec);
                                }
                                nextUpdateTS[0] = t + 200L;
                            }
                        }
                    });
                }
            }
        }).start();
    }

    private synchronized void addOrUpdateRows() {
        for (int day = this.lastUpdated + (this.lastRowIsUptodate ? 1 : 0); day <= this.today; ++day) {
            if (day < 0) continue;
            this.addOrUpdateRow(day);
        }
        this.lastUpdated = this.today;
        this.lastRowIsUptodate = true;
    }

    private void addOrUpdateRow(int day) {
        HashMap<Table, ProgressTable.CellInfo> row = new HashMap<Table, ProgressTable.CellInfo>();
        for (Map.Entry<ModelElement, Long> e : this.collections.get(day).entrySet()) {
            ProgressTable.CellInfo cell = (ProgressTable.CellInfo)row.get(this.getDestination(e.getKey()));
            if (cell != null) {
                cell.inProgress = this.inProgress.containsKey(this.getDestination(e.getKey()));
                if (e.getValue() == null) {
                    cell.numberOfRows = -1L;
                } else if (cell.numberOfRows >= 0L) {
                    cell.numberOfRows += e.getValue().longValue();
                }
            } else {
                cell = new ProgressTable.CellInfo();
                cell.inProgress = this.inProgress.containsKey(this.getDestination(e.getKey()));
                cell.numberOfRows = e.getValue() == null ? -1L : e.getValue();
                cell.tableName = this.dataModel.getDisplayName(this.getDestination(e.getKey()));
                cell.parentNames = new HashSet<String>();
                row.put(this.getDestination(e.getKey()), cell);
            }
            if (!(e.getKey() instanceof Association) || day != this.today && (e.getValue() == null || e.getValue() <= 0L)) continue;
            cell.parentNames.add(this.dataModel.getDisplayName(((Association)e.getKey()).source));
        }
        ArrayList<ProgressTable.CellInfo> theRow = new ArrayList<ProgressTable.CellInfo>(row.values());
        if (day < this.today || this.cleanupLastLine) {
            if (day > 1) {
                Iterator i = theRow.iterator();
                while (i.hasNext()) {
                    if (((ProgressTable.CellInfo)i.next()).numberOfRows != 0L) continue;
                    i.remove();
                }
            }
            this.cleanupLastLine = false;
        }
        if (day == this.lastUpdated) {
            this.progressTable.replaceLastRow(theRow, day);
        } else {
            this.progressTable.addRow(theRow, day);
            this.progressTable.adjustColumnWidth();
        }
    }

    private Table getDestination(ModelElement key) {
        if (key instanceof Association) {
            return ((Association)key).destination;
        }
        return (Table)key;
    }

    @Override
    public synchronized void collected(int day, ModelElement modelElement, long rc) {
        Table destination = this.getDestination(modelElement);
        Integer count = this.inProgress.get(destination);
        if (count == null || count <= 1) {
            this.inProgress.remove(destination);
        } else {
            this.inProgress.put(destination, count - 1);
        }
        if (this.collections.size() > day) {
            this.collections.get(day).put(modelElement, rc);
            if (rc < 0L) {
                this.collections.get(day).remove(modelElement);
            } else {
                this.collectedRows += rc;
                if (rc > 0L) {
                    this.rowsPerTableIsUptodate = false;
                    String tableName = this.dataModel.getDisplayName(this.getDestination(modelElement));
                    if (this.rowsPerTable.containsKey(tableName)) {
                        this.rowsPerTable.put(tableName, this.rowsPerTable.get(tableName) + rc);
                    } else {
                        this.rowsPerTable.put(tableName, rc);
                    }
                }
            }
            this.lastRowIsUptodate = false;
        }
    }

    @Override
    public synchronized void collectionJobEnqueued(int day, ModelElement modelElement) {
        this.today = day;
        while (this.collections.size() <= this.today) {
            this.collections.add(new HashMap());
        }
        this.collections.get(this.today).put(modelElement, null);
        this.lastRowIsUptodate = false;
    }

    @Override
    public synchronized void collectionJobStarted(int day, ModelElement modelElement) {
        Table destination = this.getDestination(modelElement);
        Integer count = this.inProgress.get(destination);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.inProgress.put(destination, count);
        this.lastRowIsUptodate = false;
    }

    private synchronized boolean getStop() {
        return this.stop;
    }

    public synchronized void stop() {
        this.stop = true;
    }

    @Override
    public synchronized void exported(Table table, long rc) {
        this.exportedRows += rc;
    }

    @Override
    public synchronized void newStage(String stage, boolean isErrorStage, boolean isFinalStage) {
        this.currentStep = stage;
        this.isErrorStage = isErrorStage;
        this.stopClock = isFinalStage;
        this.lastRowIsUptodate = false;
        this.cleanupLastLine = true;
    }
}

