/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.CsvFile;

public class TableEditor
extends JDialog {
    private Collection<CsvFile.Line> tables;
    private Collection<CsvFile.Line> associations;
    private List<String> excludeFromDeletionList = new ArrayList<String>();
    private final Map<String, String> displayNames;
    private List<String> initialDataTablesList = new ArrayList<String>();
    private boolean needsSave;
    private boolean isOk;
    private CsvFile.Line currentTableLine;
    private CsvFile.Line currentColumnLine;
    private JButton addButton;
    private JTextField column;
    private JTable columnsTable;
    private JButton deleteButton;
    private JTextField displayName;
    private JButton downButton;
    private JCheckBox excludeFromDeletion;
    private JCheckBox exportAllRows;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextField nameField;
    private JCheckBox primaryKey;
    private JButton upButton;
    private JButton updateButton;
    private JCheckBox upsertCheckbox;
    private static final long serialVersionUID = -3331167410435129849L;

    public TableEditor(Dialog parent, Map<String, String> displayNames, Collection<CsvFile.Line> tables, List<CsvFile.Line> associations, List<String> excludeFromDeletionList, List<String> initialDataTablesList) {
        super(parent, true);
        this.tables = tables;
        this.associations = associations;
        this.excludeFromDeletionList = excludeFromDeletionList;
        this.initialDataTablesList = initialDataTablesList;
        this.displayNames = displayNames;
        this.initComponents();
        this.primaryKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int s = TableEditor.this.columnsTable.getSelectedRow();
                TableEditor.this.updateButtonActionPerformed(e);
                if (s >= 0) {
                    TableEditor.this.columnsTable.getSelectionModel().addSelectionInterval(s, s);
                }
            }
        });
        this.columnsTable.setSelectionMode(0);
        final Color BG1 = new Color(255, 255, 255);
        final Color BG2 = new Color(230, 255, 255);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 2081014492388534455L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component render = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    render.setBackground(row % 2 == 0 ? BG1 : BG2);
                }
                Column col = Column.parse(((TableEditor)TableEditor.this).currentColumnLine.cells.get(1 + row));
                render.setForeground(Color.BLACK);
                for (Column pk : TableEditor.this.getCurrentPrimaryKeys()) {
                    if (!pk.name.equals(col.name)) continue;
                    render.setForeground(Color.RED);
                    break;
                }
                return render;
            }
        };
        this.columnsTable.setDefaultRenderer(Object.class, renderer);
        this.columnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TableEditor.this.columnsTable.getSelectedRow() < 0) {
                    TableEditor.this.column.setText("");
                    TableEditor.this.primaryKey.setSelected(false);
                } else {
                    String selectedColumn = ((TableEditor)TableEditor.this).currentColumnLine.cells.get(1 + TableEditor.this.columnsTable.getSelectedRow());
                    TableEditor.this.column.setText(selectedColumn);
                    Column selCol = Column.parse(selectedColumn);
                    TableEditor.this.primaryKey.setSelected(false);
                    for (Column pk : TableEditor.this.getCurrentPrimaryKeys()) {
                        if (!pk.name.equals(selCol.name)) continue;
                        TableEditor.this.primaryKey.setSelected(true);
                        break;
                    }
                }
                TableEditor.this.updateEnableState();
            }
        });
        this.setSize(600, 600);
        this.setLocation(parent.getLocation().x + parent.getSize().width / 2 - this.getPreferredSize().width / 2, parent.getLocation().y + parent.getSize().height / 2 - this.getPreferredSize().height / 2);
        this.column.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TableEditor.this.updateEnableState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableEditor.this.updateEnableState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableEditor.this.updateEnableState();
            }
        });
        UIUtil.initPeer();
    }

    private List<Column> getCurrentPrimaryKeys() {
        ArrayList<Column> pk = new ArrayList<Column>();
        for (int i = 2; i < this.currentTableLine.length && this.currentTableLine.cells.get(i).length() != 0; ++i) {
            pk.add(Column.parse(this.currentTableLine.cells.get(i)));
        }
        return pk;
    }

    private List<Column> getCurrentColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int i = 1; i < this.currentColumnLine.length && this.currentColumnLine.cells.get(i).length() != 0; ++i) {
            columns.add(Column.parse(this.currentColumnLine.cells.get(i)));
        }
        return columns;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.nameField = new JTextField();
        this.upsertCheckbox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel3 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.excludeFromDeletion = new JCheckBox();
        this.exportAllRows = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.columnsTable = new JTable();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.jPanel3 = new JPanel();
        this.column = new JTextField();
        this.addButton = new JButton();
        this.updateButton = new JButton();
        this.deleteButton = new JButton();
        this.primaryKey = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.displayName = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Table");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText(" Name ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(" Columns ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.nameField.setText("jTextField1j");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.nameField, gridBagConstraints);
        this.upsertCheckbox.setText(" generate 'Upsert'-statements for exported rows");
        this.upsertCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.getContentPane().add((Component)this.upsertCheckbox, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButton1.setText("Ok");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        this.jLabel3.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.excludeFromDeletion.setText(" exclude from deletion");
        this.excludeFromDeletion.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.excludeFromDeletion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.excludeFromDeletionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.excludeFromDeletion, gridBagConstraints);
        this.exportAllRows.setText(" always export all rows (initial-data)");
        this.exportAllRows.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.exportAllRows, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.columnsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Titel 1", "Titel 2", "Titel 3", "Titel 4"}));
        this.jScrollPane1.setViewportView(this.columnsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.upButton.setText("Up");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 2, 0, 0);
        this.jPanel2.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText("Down");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel2.add((Component)this.downButton, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.column.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.columnActionPerformed(evt);
            }
        });
        this.column.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                TableEditor.this.columnInputMethodTextChanged(evt);
            }
        });
        this.column.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TableEditor.this.columnKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                TableEditor.this.columnKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 22, 0, 0);
        this.jPanel3.add((Component)this.column, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel2.add((Component)this.addButton, gridBagConstraints);
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.updateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel2.add((Component)this.updateButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel2.add((Component)this.deleteButton, gridBagConstraints);
        this.primaryKey.setText(" primary key");
        this.primaryKey.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 22, 0, 0);
        this.jPanel2.add((Component)this.primaryKey, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel4.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel7.setText(" Display name  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.displayName.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.displayName, gridBagConstraints);
        this.pack();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        try {
            int i;
            Column column = Column.parse(this.column.getText());
            for (i = 1; i < this.currentColumnLine.length; ++i) {
                if (!Column.parse((String)this.currentColumnLine.cells.get((int)i)).name.equals(column.name)) continue;
                this.currentColumnLine.cells.remove(i);
                --this.currentColumnLine.length;
                break;
            }
            for (i = 2; i < this.currentTableLine.length && this.currentTableLine.cells.get(i).length() != 0; ++i) {
                if (!Column.parse((String)this.currentTableLine.cells.get((int)i)).name.equals(column.name)) continue;
                this.currentTableLine.cells.remove(i);
                --this.currentTableLine.length;
                break;
            }
            this.columnsTable.setModel(this.columnsTableModel());
            this.updateEnableState();
            this.needsSave = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        try {
            Column column = Column.parse(this.column.getText());
            for (int i = 1; i < this.currentColumnLine.length; ++i) {
                if (!Column.parse((String)this.currentColumnLine.cells.get((int)i)).name.equals(column.name)) continue;
                this.currentColumnLine.cells.set(i, column.toSQL(null) + (column.isIdentityColumn ? " identity" : ""));
                break;
            }
            boolean found = false;
            for (int i = 2; i < this.currentTableLine.length && this.currentTableLine.cells.get(i).length() != 0; ++i) {
                if (!Column.parse((String)this.currentTableLine.cells.get((int)i)).name.equals(column.name)) continue;
                found = true;
                if (this.primaryKey.isSelected()) {
                    this.currentTableLine.cells.set(i, column.toSQL(null) + (column.isIdentityColumn ? " identity" : ""));
                    break;
                }
                this.currentTableLine.cells.remove(i);
                --this.currentTableLine.length;
                break;
            }
            if (!found && this.primaryKey.isSelected()) {
                this.currentTableLine.cells.add(this.currentTableLine.length - 2, column.toSQL(null) + (column.isIdentityColumn ? " identity" : ""));
                ++this.currentTableLine.length;
            }
            this.columnsTable.setModel(this.columnsTableModel());
            this.updateEnableState();
            this.needsSave = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int i = 0;
        while (true) {
            String newColumn;
            Column column = null;
            if (i == 0) {
                try {
                    column = Column.parse(this.column.getText());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (column == null) {
                column = new Column("new" + (i > 0 ? Integer.valueOf(i) : ""), "varchar", 100, -1);
            }
            if (!this.currentColumnLine.cells.contains(newColumn = column.toSQL(null) + (column.isIdentityColumn ? " identity" : ""))) {
                this.currentColumnLine.cells.add(this.currentColumnLine.length, newColumn);
                ++this.currentColumnLine.length;
                if (this.primaryKey.isSelected()) {
                    this.currentTableLine.cells.add(this.currentTableLine.length - 2, newColumn);
                    ++this.currentTableLine.length;
                }
                break;
            }
            ++i;
        }
        this.columnsTable.setModel(this.columnsTableModel());
        this.updateEnableState();
        this.needsSave = true;
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int i = this.columnsTable.getSelectedRow();
        if (i >= 0 && i < this.currentColumnLine.length - 2) {
            this.swapColumns(i, i + 1);
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int i = this.columnsTable.getSelectedRow();
        if (i > 0) {
            this.swapColumns(i, i - 1);
        }
    }

    private void swapColumns(int i, int j) {
        String h = this.currentColumnLine.cells.get(i + 1);
        this.currentColumnLine.cells.set(i + 1, this.currentColumnLine.cells.get(j + 1));
        this.currentColumnLine.cells.set(j + 1, h);
        this.columnsTable.setModel(this.columnsTableModel());
        this.columnsTable.getSelectionModel().setSelectionInterval(j, j);
        this.needsSave = true;
    }

    private void columnKeyReleased(KeyEvent evt) {
    }

    private void columnInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void columnKeyTyped(KeyEvent evt) {
    }

    private void columnActionPerformed(ActionEvent evt) {
    }

    private void excludeFromDeletionActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String msg = null;
        if (this.nameField.getText().trim().length() == 0) {
            msg = "No table name";
        } else if (this.getCurrentPrimaryKeys().isEmpty()) {
            msg = "Primary key missing";
        } else {
            for (CsvFile.Line l : this.tables) {
                if (l == this.currentTableLine || !l.cells.get(0).equals(this.nameField.getText().trim())) continue;
                msg = "Table already exists";
                break;
            }
        }
        if (msg == null) {
            String dn = this.displayNames.get(this.currentTableLine.cells.get(0));
            if (dn == null) {
                dn = "";
            }
            if (!this.displayName.getText().trim().equals(dn) && this.displayNames.containsValue(this.displayName.getText().trim())) {
                msg = "duplicate display name";
            }
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        } else {
            this.isOk = true;
            this.setVisible(false);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public boolean edit(CsvFile.Line tableLine, Map<String, CsvFile.Line> columnLines) {
        this.needsSave = false;
        this.currentTableLine = tableLine;
        this.currentColumnLine = columnLines.get(tableLine.cells.get(0));
        if (this.currentColumnLine == null) {
            this.currentColumnLine = new CsvFile.Line("", new ArrayList<String>(Arrays.asList(tableLine.cells.get(0))));
            if (this.currentColumnLine.length == 0) {
                this.currentColumnLine.length = 1;
            }
        }
        ArrayList<String> oldTableLineCells = new ArrayList<String>(this.currentTableLine.cells);
        int oldTableLineLength = this.currentTableLine.length;
        ArrayList<String> oldColumnLineCells = new ArrayList<String>(this.currentColumnLine.cells);
        int oldColumnLineLength = this.currentColumnLine.length;
        String dn = "";
        if (this.displayNames.containsKey(tableLine.cells.get(0))) {
            dn = this.displayNames.get(tableLine.cells.get(0));
        }
        this.displayName.setText(dn);
        this.nameField.setText(tableLine.cells.get(0));
        this.upsertCheckbox.setSelected("Y".equals(tableLine.cells.get(1)));
        String origDisplayName = this.displayName.getText().trim();
        String origName = this.nameField.getText().trim();
        boolean origUpsert = this.upsertCheckbox.isSelected();
        this.isOk = false;
        boolean origExcludeSet = this.excludeFromDeletionList.contains(origName);
        this.excludeFromDeletion.setSelected(origExcludeSet);
        boolean origExportAllSet = this.initialDataTablesList.contains(origName);
        this.exportAllRows.setSelected(origExportAllSet);
        this.columnsTable.setModel(this.columnsTableModel());
        this.updateEnableState();
        this.setVisible(true);
        boolean excludeSet = this.excludeFromDeletion.isSelected();
        boolean exportAllSet = this.exportAllRows.isSelected();
        if (this.isOk && (!origDisplayName.equals(this.displayName.getText()) || !origName.equals(this.nameField.getText()) || this.needsSave || origUpsert != this.upsertCheckbox.isSelected() || origExcludeSet != excludeSet || origExportAllSet != exportAllSet)) {
            columnLines.remove(this.currentColumnLine.cells.get(0));
            this.currentColumnLine.cells.set(0, this.nameField.getText().trim());
            columnLines.put(this.currentColumnLine.cells.get(0), this.currentColumnLine);
            tableLine.cells.set(0, this.nameField.getText().trim());
            tableLine.cells.set(1, this.upsertCheckbox.isSelected() ? "Y" : "N");
            for (int i = 0; i < tableLine.cells.size(); ++i) {
                if (!"".equals(tableLine.cells.get(i))) continue;
                tableLine.cells.set(i + 1, "Data Model Editor");
                break;
            }
            for (CsvFile.Line a : this.associations) {
                if (a.cells.get(0).equalsIgnoreCase(origName.trim())) {
                    a.cells.set(0, this.nameField.getText().trim());
                }
                if (!a.cells.get(1).equalsIgnoreCase(origName.trim())) continue;
                a.cells.set(1, this.nameField.getText().trim());
            }
            this.displayNames.remove(origName);
            dn = this.displayName.getText().trim();
            if (dn.length() > 0) {
                this.displayNames.put(this.nameField.getText().trim(), dn);
            }
            this.excludeFromDeletionList.remove(origName);
            this.initialDataTablesList.remove(origName);
            if (excludeSet) {
                this.excludeFromDeletionList.add(this.nameField.getText().trim());
            }
            if (exportAllSet) {
                this.initialDataTablesList.add(this.nameField.getText().trim());
            }
            return true;
        }
        this.currentTableLine.cells.clear();
        this.currentTableLine.cells.addAll(oldTableLineCells);
        this.currentTableLine.length = oldTableLineLength;
        this.currentColumnLine.cells.clear();
        this.currentColumnLine.cells.addAll(oldColumnLineCells);
        this.currentColumnLine.length = oldColumnLineLength;
        return false;
    }

    private void updateEnableState() {
        Column current;
        try {
            current = Column.parse(this.column.getText());
        }
        catch (Exception e) {
            current = null;
        }
        boolean currentExists = false;
        if (current != null) {
            for (Column c : this.getCurrentColumns()) {
                if (!c.name.equals(current.name)) continue;
                currentExists = true;
                break;
            }
        }
        this.addButton.setEnabled(true);
        this.updateButton.setEnabled(current != null && currentExists);
        this.deleteButton.setEnabled(current != null && currentExists);
        this.upButton.setEnabled(this.columnsTable.getSelectedRow() > 0);
        this.downButton.setEnabled(this.columnsTable.getSelectedRow() >= 0 && this.columnsTable.getSelectedRow() < this.currentColumnLine.length - 2);
    }

    private TableModel columnsTableModel() {
        DefaultTableModel model = new DefaultTableModel(){
            private static final long serialVersionUID = -5655810990374489020L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn("Name");
        model.addColumn("Type");
        model.addColumn("Scale");
        model.addColumn("Precision");
        for (int i = 1; i < this.currentColumnLine.length; ++i) {
            Column column = Column.parse(this.currentColumnLine.cells.get(i));
            model.addRow(new Object[]{column.name, column.type, column.length > 0 ? Integer.valueOf(column.length) : "", column.precision >= 0 ? Integer.valueOf(column.precision) : ""});
        }
        return model;
    }
}

