/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class Settings {
    private final Map<String, JComponent> fields;
    private final String FILENAME;
    public final boolean isNew;
    private Map<String, Map<String, String>> settings = new TreeMap<String, Map<String, String>>();
    public String currentSetting = null;

    public Settings(String fileName, Map<String, JComponent> fields) {
        this.FILENAME = fileName;
        this.fields = fields;
        boolean isNew = true;
        if (new File(this.FILENAME).exists()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.FILENAME));
                this.settings = (Map)in.readObject();
                this.currentSetting = (String)in.readObject();
                in.close();
                isNew = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isNew = isNew;
    }

    public Object[] getSettingNames() {
        return this.settings.keySet().toArray();
    }

    public void save(String name) {
        if (name != null && name.trim().length() > 0) {
            File file;
            HashMap<String, String> setting = new HashMap<String, String>();
            for (Map.Entry<String, JComponent> entry : this.fields.entrySet()) {
                if (entry.getValue() instanceof JTextField) {
                    setting.put(entry.getKey(), ((JTextField)entry.getValue()).getText());
                    continue;
                }
                if (!(entry.getValue() instanceof JCheckBox)) continue;
                setting.put(entry.getKey(), Boolean.valueOf(((JCheckBox)entry.getValue()).isSelected()).toString());
            }
            this.settings.put(name.trim(), setting);
            this.currentSetting = name;
            try {
                file = new File(this.FILENAME);
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                file = new File(this.FILENAME);
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
                out.writeObject(this.settings);
                out.writeObject(this.currentSetting);
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void restore(String name) {
        Map<String, String> setting;
        if (name != null && name.trim().length() > 0 && (setting = this.settings.get(name.trim())) != null) {
            for (Map.Entry<String, JComponent> entry : this.fields.entrySet()) {
                if (entry.getValue() instanceof JTextField) {
                    ((JTextField)entry.getValue()).setText(setting.get(entry.getKey()));
                    continue;
                }
                if (!(entry.getValue() instanceof JCheckBox)) continue;
                ((JCheckBox)entry.getValue()).setSelected(Boolean.valueOf(setting.get(entry.getKey())));
            }
        }
    }
}

