/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.extractionmodel.ExtractionModel;

public class RestrictionDefinition {
    public final Table from;
    public final Table to;
    public final String name;
    public final String condition;
    public final boolean isIgnored;

    public RestrictionDefinition(Table from, Table to, String name, String condition, boolean isIgnored) {
        this.from = from;
        this.to = to;
        this.name = name;
        this.condition = condition;
        this.isIgnored = isIgnored;
    }

    public static List<RestrictionDefinition> fromRestrictionModel(ExtractionModel extractionModel) {
        ArrayList<RestrictionDefinition> list = new ArrayList<RestrictionDefinition>();
        for (Table table : extractionModel.dataModel.getTables()) {
            for (Association association : table.associations) {
                if (!association.isRestricted()) continue;
                list.add(new RestrictionDefinition(association.source, association.destination, association.getName(), association.isIgnored() ? "disabled" : association.getRestrictionCondition(), association.isIgnored()));
            }
        }
        Collections.sort(list, new Comparator<RestrictionDefinition>(){

            @Override
            public int compare(RestrictionDefinition o1, RestrictionDefinition o2) {
                return (o1.from.getName() + " " + o1.to.getName() + " " + o1.name + " " + o1.condition).compareTo(o2.from.getName() + " " + o2.to.getName() + " " + o2.name + " " + o2.condition);
            }
        });
        return list;
    }
}

