/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashSet;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.AssociationListUI;
import net.sf.jailer.ui.ClosureBorderDialog;

public abstract class RestrictedDependenciesListDialog
extends ClosureBorderDialog {
    private static final long serialVersionUID = -7151994890007647782L;

    public RestrictedDependenciesListDialog(Frame parent) {
        super(parent, false);
        this.setTitle("Restricted Dependencies");
        this.setLocation(60, 120);
        this.setSize(500, 500);
        this.setAlwaysOnTop(true);
        this.refresh();
    }

    @Override
    public void refresh() {
        DataModel datamodel = this.getDataModel();
        if (datamodel != null) {
            HashSet<Association> restDeps = new HashSet<Association>();
            for (Table table : datamodel.getTables()) {
                for (Association association : table.associations) {
                    if (association.getRestrictionCondition() == null || !association.isInsertDestinationBeforeSource()) continue;
                    restDeps.add(association);
                }
            }
            ArrayList<AssociationListUI.AssociationModel> model = new ArrayList<AssociationListUI.AssociationModel>();
            for (Association association : restDeps) {
                model.add(new AssociationListUI.DefaultAssociationModel(association));
            }
            this.associationListUI.setModel(model);
        }
    }
}

