/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.SqlUtil;

public class QueryBuilderDialog
extends JDialog {
    private Font font = new JLabel("normal").getFont();
    private Font nonBoldFont = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
    private Table subject;
    private boolean selectDistinct = false;
    private Map<List<Association>, String> originalAnchorSQL = new HashMap<List<Association>, String>();
    private Map<List<Association>, String> originalConditionSQL = new HashMap<List<Association>, String>();
    private Map<List<Association>, Association> originalAnchor = new HashMap<List<Association>, Association>();
    private Relationship rootRelationship;
    private String prevSQL = "";
    private DataModel datamodel;
    private List<Association> associationsOnPath;
    private String mlm = "";
    private JButton clipboardButton;
    private JButton clipboardSingleLineButton;
    private JCheckBox distinctCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane2;
    private JButton joinAWithBButton;
    private JTextField mlmTextField;
    private JPanel relationshipsPanel;
    private JButton saveButton;
    public JButton sqlEditButton;
    private JEditorPane sqlTextArea;
    private ImageIcon joinImage = null;
    private ImageIcon minusImage = null;
    private static final long serialVersionUID = -2801831496446636545L;

    public QueryBuilderDialog(Frame parent) {
        super(parent, true);
        String dir = "/net/sf/jailer/resource";
        try {
            this.joinImage = new ImageIcon(new ImageIcon(this.getClass().getResource(dir + "/collapsed.png")).getImage().getScaledInstance(22, 18, 4));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.minusImage = new ImageIcon(new ImageIcon(this.getClass().getResource(dir + "/minus.png")).getImage().getScaledInstance(22, 18, 4));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initComponents();
        this.distinctCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                QueryBuilderDialog.this.selectDistinct = QueryBuilderDialog.this.distinctCheckBox.isSelected();
                QueryBuilderDialog.this.updateSQL();
            }
        });
        this.mlmTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                QueryBuilderDialog.this.appendMLM(QueryBuilderDialog.this.mlmTextField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                QueryBuilderDialog.this.appendMLM(QueryBuilderDialog.this.mlmTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                QueryBuilderDialog.this.appendMLM(QueryBuilderDialog.this.mlmTextField.getText());
            }
        });
        this.sqlTextArea.setContentType("text/sql");
        this.sqlEditButton.setVisible(false);
        this.pack();
        this.setSize(Math.max(700, this.getWidth()), 500);
        UIUtil.initPeer();
    }

    private void initComponents() {
        this.relationshipsPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.sqlTextArea = new JEditorPane();
        this.jPanel2 = new JPanel();
        this.joinAWithBButton = new JButton();
        this.saveButton = new JButton();
        this.clipboardSingleLineButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.mlmTextField = new JTextField();
        this.clipboardButton = new JButton();
        this.sqlEditButton = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.distinctCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Query Builder");
        this.getContentPane().setLayout(new GridBagLayout());
        this.relationshipsPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.relationshipsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.relationshipsPanel, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), "SQL Query", 0, 0, new Font("DejaVu Sans", 0, 12), new Color(86, 82, 125)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.sqlTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.joinAWithBButton.setText(" Join selected Tables");
        this.joinAWithBButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.joinAWithBButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.jPanel2.add((Component)this.joinAWithBButton, gridBagConstraints);
        this.saveButton.setText(" Save ");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.saveButton, gridBagConstraints);
        this.clipboardSingleLineButton.setText(" Copy as Single Line ");
        this.clipboardSingleLineButton.setToolTipText(" Copy the query as a single line to the clipboard");
        this.clipboardSingleLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.clipboardSingleLineButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.jPanel2.add((Component)this.clipboardSingleLineButton, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel1.setText("multi-line continuation  ");
        this.jLabel1.setToolTipText("multi-line continuation character");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 16;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.mlmTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.clipboardButton.setText(" Copy to Clipboard ");
        this.clipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.clipboardButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.clipboardButton, gridBagConstraints);
        this.sqlEditButton.setText(" Execute ");
        this.sqlEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderDialog.this.sqlEditButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel2.add((Component)this.sqlEditButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel2.setText("Select ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.jPanel5.add((Component)this.jLabel2, gridBagConstraints);
        this.distinctCheckBox.setText("distinct");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.distinctCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.getContentPane().add((Component)this.jPanel5, gridBagConstraints);
        this.pack();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        String fn = UIUtil.choseFile(null, ".", "Save SQL Query", "", this, false, false);
        if (fn != null) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(fn));
                out.print(this.sqlTextArea.getText());
                out.close();
            }
            catch (Exception e) {
                UIUtil.showException(this, "Error saving query", e);
            }
        }
    }

    private void clipboardButtonActionPerformed(ActionEvent evt) {
        this.sqlTextArea.selectAll();
        this.sqlTextArea.copy();
        this.sqlTextArea.select(0, 0);
    }

    private void joinAWithBButtonActionPerformed(ActionEvent evt) {
        this.createPathQuery(null);
    }

    private void clipboardSingleLineButtonActionPerformed(ActionEvent evt) {
        String orig = this.sqlTextArea.getText();
        this.sqlTextArea.setText(orig.replaceAll(" *(\n|\r)+ *", " "));
        this.sqlTextArea.selectAll();
        this.sqlTextArea.copy();
        this.sqlTextArea.setText(orig);
        this.sqlTextArea.select(0, 0);
    }

    private void sqlEditButtonActionPerformed(ActionEvent evt) {
    }

    private void resetRelationshipsPanel() {
        this.relationshipsPanel.removeAll();
        List<Relationship> relationships = this.rootRelationship.flatten(0, null, true);
        for (int y = 0; y < relationships.size(); ++y) {
            JTextField aliasField;
            DefaultComboBoxModel<JoinOperator> aModel;
            JLabel label;
            final Relationship relationship = relationships.get(y);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            if (y == 0) {
                label = new JLabel();
                label.setText(y == 0 ? " From  " : " Join  ");
                label.setFont(this.nonBoldFont);
                this.relationshipsPanel.add((Component)label, gridBagConstraints);
            } else if (relationship.association != null) {
                JComboBox joinCB = new JComboBox();
                aModel = new DefaultComboBoxModel<JoinOperator>(JoinOperator.values());
                joinCB.setModel(aModel);
                joinCB.setSelectedItem((Object)relationship.joinOperator);
                joinCB.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            relationship.joinOperator = (JoinOperator)((Object)e.getItem());
                            QueryBuilderDialog.this.resetRelationshipsPanel();
                            QueryBuilderDialog.this.updateSQL();
                        }
                    }
                });
                this.relationshipsPanel.add((Component)joinCB, gridBagConstraints);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0 + relationship.level * 12, 2, 0);
            gridBagConstraints.anchor = 17;
            JComboBox tableCB = null;
            if (relationship != this.rootRelationship) {
                tableCB = new JComboBox(){
                    private boolean layingOut = false;
                    private static final long serialVersionUID = -6555670830339032571L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doLayout() {
                        try {
                            this.layingOut = true;
                            super.doLayout();
                        }
                        finally {
                            this.layingOut = false;
                        }
                    }

                    @Override
                    public Dimension getSize() {
                        Dimension sz = super.getSize();
                        if (!this.layingOut) {
                            sz.width = Math.max(sz.width, super.getPreferredSize().width);
                        }
                        return sz;
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(Math.min(super.getPreferredSize().width, 300), super.getPreferredSize().height);
                    }
                };
                aModel = new DefaultComboBoxModel();
                aModel.addElement((JoinOperator)((Object)""));
                Table lastTable = relationship.parent == this.rootRelationship ? this.subject : relationship.parent.association.destination;
                for (Association a : lastTable.associations) {
                    aModel.addElement((JoinOperator)((Object)this.joinTableRender(lastTable, a)));
                }
                tableCB.setModel(aModel);
                if (relationship.association != null) {
                    tableCB.setSelectedItem(this.joinTableRender(lastTable, relationship.association));
                }
                final Table ft = lastTable;
                tableCB.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            Association sa = null;
                            for (Association a : ft.associations) {
                                if (!QueryBuilderDialog.this.joinTableRender(ft, a).equals(e.getItem())) continue;
                                sa = a;
                                break;
                            }
                            if (sa != null) {
                                relationship.association = sa;
                                relationship.children.clear();
                                relationship.anchorWhereClause = (String)QueryBuilderDialog.this.originalAnchorSQL.get(relationship.getPathToRoot());
                                relationship.whereClause = (String)QueryBuilderDialog.this.originalConditionSQL.get(relationship.getPathToRoot());
                                relationship.anchor = (Association)QueryBuilderDialog.this.originalAnchor.get(relationship.getPathToRoot());
                                if (relationship.parent != null && !relationship.parent.children.contains(relationship)) {
                                    relationship.parent.children.add(relationship);
                                }
                            } else if (relationship.parent != null) {
                                relationship.parent.children.remove(relationship);
                            }
                            QueryBuilderDialog.this.resetRelationshipsPanel();
                            QueryBuilderDialog.this.updateSQL();
                        }
                    }
                });
                this.relationshipsPanel.add((Component)tableCB, gridBagConstraints);
                final JLabel minusLabel = new JLabel();
                minusLabel.setText(null);
                minusLabel.setIcon(this.minusImage);
                minusLabel.setToolTipText("remove this table from query");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 4, 0, 0);
                minusLabel.setEnabled(false);
                final JComboBox combobox = tableCB;
                minusLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent evt) {
                        minusLabel.setEnabled(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent evt) {
                        minusLabel.setEnabled(false);
                    }

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        combobox.setSelectedItem("");
                    }
                });
                if (relationship.association != null) {
                    this.relationshipsPanel.add((Component)minusLabel, gridBagConstraints);
                }
            } else {
                label = new JLabel();
                label.setText(this.subject.getName());
                this.relationshipsPanel.add((Component)label, gridBagConstraints);
            }
            if (relationship.association == null && relationship != this.rootRelationship) {
                final JLabel jlabel = new JLabel();
                jlabel.setText(null);
                jlabel.setIcon(this.joinImage);
                jlabel.setToolTipText("join another table");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = y - 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 4, 0, 0);
                this.relationshipsPanel.add((Component)jlabel, gridBagConstraints);
                final JComboBox finalTCB = tableCB;
                finalTCB.setVisible(false);
                jlabel.setEnabled(false);
                jlabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent evt) {
                        jlabel.setEnabled(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent evt) {
                        jlabel.setEnabled(false);
                    }

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        finalTCB.setVisible(true);
                        jlabel.setVisible(false);
                    }
                });
            }
            if (relationship.association == null && relationship != this.rootRelationship) continue;
            label = new JLabel();
            label.setText("   as ");
            label.setFont(this.nonBoldFont);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 5;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            this.relationshipsPanel.add((Component)label, gridBagConstraints);
            String alias = "";
            if (relationship != null && relationship.aliasTextField != null) {
                alias = relationship.aliasTextField.getText();
            }
            relationship.aliasTextField = aliasField = new JTextField(alias);
            relationship.originalBGColor = aliasField.getBackground();
            aliasField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    QueryBuilderDialog.this.checkAliases();
                    QueryBuilderDialog.this.updateSQL();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    QueryBuilderDialog.this.checkAliases();
                    QueryBuilderDialog.this.updateSQL();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    QueryBuilderDialog.this.checkAliases();
                    QueryBuilderDialog.this.updateSQL();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 6;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            this.relationshipsPanel.add((Component)aliasField, gridBagConstraints);
            final JCheckBox selectColumnsCB = new JCheckBox("select columns");
            selectColumnsCB.setSelected(relationship.selectColumns);
            selectColumnsCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    relationship.selectColumns = selectColumnsCB.isSelected();
                    QueryBuilderDialog.this.updateSQL();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 8;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.relationshipsPanel.add((Component)selectColumnsCB, gridBagConstraints);
        }
        JLabel label = new JLabel();
        label.setText("                ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = relationships.size() + 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.relationshipsPanel.add((Component)label, gridBagConstraints);
        this.checkAliases();
        this.updateSQL();
        this.validate();
    }

    private String joinTableRender(Table from, Association association) {
        int n = 0;
        for (Association a : from.associations) {
            if (a.destination != association.destination) continue;
            ++n;
        }
        return this.datamodel.getDisplayName(association.destination) + (n > 1 ? " on " + association.getName() : "");
    }

    private void checkAliases() {
        List<Relationship> relationships = this.rootRelationship.flatten(0, null, false);
        for (Relationship a : relationships) {
            a.aliasTextField.setBackground(a.originalBGColor);
        }
        for (Relationship a : relationships) {
            a.aliasSuggestion = null;
            for (Relationship b : relationships) {
                Table tableB;
                if (a == b) continue;
                String ta = a.aliasTextField.getText().trim();
                Table tableA = a.association == null ? this.subject : a.association.destination;
                String tb = b.aliasTextField.getText().trim();
                Table table = tableB = b.association == null ? this.subject : b.association.destination;
                if (ta.length() == 0) {
                    ta = this.unquote(tableA.getUnqualifiedName());
                }
                if (tb.length() == 0) {
                    tb = this.unquote(tableB.getUnqualifiedName());
                }
                if (!ta.equalsIgnoreCase(tb)) continue;
                String as = null;
                String aName = this.unquote(tableA.getUnqualifiedName());
                for (int i = 1; i <= aName.length(); ++i) {
                    as = aName.substring(0, i);
                    if (as.endsWith("_")) continue;
                    boolean unique = true;
                    for (Relationship c : relationships) {
                        Table tableC = c.association == null ? this.subject : c.association.destination;
                        if (this.unquote(tableC.getUnqualifiedName()).equalsIgnoreCase(aName) || !this.unquote(tableC.getUnqualifiedName()).toLowerCase().startsWith(as.toLowerCase())) continue;
                        unique = false;
                        break;
                    }
                    if (unique) break;
                }
                a.aliasSuggestion = as;
                Color bg = new Color(255, 150, 140);
                a.aliasTextField.setBackground(bg);
                b.aliasTextField.setBackground(bg);
            }
        }
    }

    private String unquote(String name) {
        String fcStr;
        char fc;
        if (!name.isEmpty() && !Character.isLetterOrDigit(fc = name.charAt(0)) && fc != '_' && name.startsWith(fcStr = Character.toString(fc)) && name.endsWith(fcStr)) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    private void updateSQL() {
        this.appendMLM("");
        String currentSql = this.prevSQL;
        String sql = this.sqlTextArea.getText();
        String suffix = "";
        if (sql.startsWith(currentSql)) {
            suffix = sql.substring(currentSql.length());
        }
        this.prevSQL = this.createSQL(false);
        this.sqlTextArea.setText(this.prevSQL + suffix);
        this.appendMLM(this.mlmTextField.getText());
        this.sqlTextArea.setCaretPosition(0);
    }

    public String getSQL() {
        this.appendMLM("");
        String sql = this.sqlTextArea.getText();
        this.appendMLM(this.mlmTextField.getText());
        this.sqlTextArea.setCaretPosition(0);
        return sql;
    }

    private String createSQL(boolean singleLine) {
        int i;
        Relationship r;
        int i2;
        StringBuffer sql = new StringBuffer("Select " + (this.selectDistinct ? "distinct " : ""));
        String lf = System.getProperty("line.separator", "\n");
        String tab = "       ";
        List<Relationship> relationships = this.rootRelationship.flatten(0, null, false);
        boolean needsIndent = false;
        for (Relationship r2 : relationships) {
            if (r2.children.size() <= 1) continue;
            needsIndent = true;
            break;
        }
        if (!singleLine) {
            int sa = 0;
            for (int i3 = 0; i3 < relationships.size(); ++i3) {
                Relationship r3 = relationships.get(i3);
                if (!r3.selectColumns) continue;
                ++sa;
            }
            if (sa > 1) {
                sql.append(lf + tab);
            }
        }
        boolean selectAll = true;
        boolean fr = true;
        for (i2 = 0; i2 < relationships.size(); ++i2) {
            r = relationships.get(i2);
            Table t = r.association == null ? this.subject : r.association.destination;
            r.alias = r.aliasTextField.getText().trim();
            if (r.alias.equals("")) {
                r.alias = t.getName();
            }
            if (!r.selectColumns) continue;
            selectAll = false;
            if (!fr) {
                sql.append(", ");
                if (!singleLine) {
                    sql.append(lf + tab);
                }
            }
            fr = false;
            boolean f = true;
            for (Column c : t.getColumns()) {
                if (!f) {
                    sql.append(", ");
                }
                f = false;
                sql.append(r.alias + "." + c.name);
            }
        }
        if (selectAll) {
            sql.append("*");
        }
        if (!singleLine) {
            sql.append(lf);
        } else {
            sql.append(" ");
        }
        sql.append("From ");
        for (i2 = 0; i2 < relationships.size(); ++i2) {
            Table t;
            r = relationships.get(i2);
            String indent = "";
            if (needsIndent) {
                for (int l = 0; l < r.level; ++l) {
                    indent = indent + "  ";
                }
            }
            Table table = t = r.association == null ? this.subject : r.association.destination;
            if (r.association != null) {
                sql.append(singleLine ? " " : lf + tab + indent);
                sql.append((Object)((Object)r.joinOperator) + " ");
            } else if (relationships.size() > 1) {
                sql.append(singleLine ? "" : lf + tab + indent);
            }
            sql.append(t.getName());
            String alias = r.aliasTextField.getText().trim();
            if (alias.length() > 0) {
                sql.append(" " + alias);
            } else {
                alias = t.getName();
            }
            String lastAlias = "";
            Relationship parent = r.parent;
            if (parent != null && (lastAlias = parent.aliasTextField.getText().trim()).length() <= 0) {
                String string = lastAlias = parent.association == null ? this.subject.getName() : parent.association.destination.getName();
            }
            if (r.association == null) continue;
            String jc = !r.association.reversed ? SqlUtil.replaceAliases(r.association.getUnrestrictedJoinCondition(), lastAlias, alias) : SqlUtil.replaceAliases(r.association.getUnrestrictedJoinCondition(), alias, lastAlias);
            if (r.joinOperator == JoinOperator.LeftJoin && r.originalParent == null && r.whereClause != null) {
                jc = "(" + jc + ") and (" + SqlUtil.replaceAliases(r.whereClause, r.alias, lastAlias) + ")";
            }
            sql.append(" on " + jc);
        }
        boolean f = true;
        int lines = 0;
        for (i = 0; i < relationships.size(); ++i) {
            Relationship r4 = relationships.get(i);
            if (r4.whereClause == null) continue;
            ++lines;
        }
        for (i = 0; i < relationships.size(); ++i) {
            Relationship r5 = relationships.get(i);
            String lastAlias = "";
            Relationship parent = r5.originalParent;
            if (parent == null) {
                parent = r5.parent;
            }
            if (parent != null && (lastAlias = parent.aliasTextField.getText().trim()).length() <= 0) {
                lastAlias = parent.association == null ? this.subject.getName() : parent.association.destination.getName();
            }
            boolean appendAnd = true;
            if (r5.anchorWhereClause != null && r5.anchor != null) {
                boolean anchorExists = false;
                for (Relationship c : r5.children) {
                    if (c.association != r5.anchor) continue;
                    anchorExists = true;
                    break;
                }
                if (!anchorExists) {
                    appendAnd = false;
                    if (f) {
                        sql.append(singleLine ? " " : lf);
                        sql.append("Where");
                        sql.append(singleLine || lines == 1 ? " " : lf + tab);
                    } else {
                        sql.append(singleLine ? " " : lf + tab);
                        sql.append("and ");
                    }
                    sql.append("(" + SqlUtil.replaceAliases(r5.anchorWhereClause, r5.alias, lastAlias) + ")");
                    f = false;
                }
            }
            if (!appendAnd || r5.whereClause == null || r5.joinOperator != JoinOperator.Join && r5.originalParent == null) continue;
            if (f) {
                sql.append(singleLine ? " " : lf);
                sql.append("Where");
                sql.append(singleLine || lines == 1 ? " " : lf + tab);
            } else {
                sql.append(singleLine ? " " : lf + tab);
                sql.append("and ");
            }
            sql.append("(" + SqlUtil.replaceAliases(r5.whereClause, r5.alias, lastAlias) + ")");
            f = false;
        }
        if (singleLine) {
            sql.append(" ");
            return sql.toString().replaceAll(" *(\n|\r)+ *", " ");
        }
        sql.append(" " + lf);
        String sqlString = sql.toString().trim();
        sqlString = sqlString + lf;
        return sqlString;
    }

    public void buildQuery(Table table, boolean usePath, boolean showJoinButton, List<Association> associationsOnPath, List<String> whereClauses, DataModel datamodel) {
        Relationship firstR;
        this.associationsOnPath = associationsOnPath;
        if (table == null) {
            return;
        }
        this.sqlTextArea.setText("");
        this.mlmTextField.setText("");
        this.datamodel = datamodel;
        this.subject = table;
        this.rootRelationship = firstR = new Relationship();
        firstR.selectColumns = true;
        firstR.whereClause = null;
        if (whereClauses != null && whereClauses.size() > 0) {
            firstR.whereClause = whereClauses.get(0);
        }
        if (usePath && !associationsOnPath.isEmpty()) {
            this.createPathQuery(whereClauses);
        }
        if (associationsOnPath.isEmpty() || !showJoinButton) {
            this.joinAWithBButton.setVisible(false);
        } else {
            this.joinAWithBButton.setVisible(true);
        }
        this.resetRelationshipsPanel();
        ArrayList<JTextField> tf = new ArrayList<JTextField>();
        ArrayList<String> as = new ArrayList<String>();
        for (Relationship r : this.rootRelationship.flatten(0, null, false)) {
            if (r.aliasSuggestion == null) continue;
            tf.add(r.aliasTextField);
            as.add(r.aliasSuggestion);
        }
        HashMap counterPerAlias = new HashMap();
        for (int i = 0; i < tf.size(); ++i) {
            Integer c = (Integer)counterPerAlias.get(as.get(i));
            if (c == null) {
                c = 1;
            }
            counterPerAlias.put(as.get(i), c + 1);
            ((JTextField)tf.get(i)).setText((String)as.get(i) + c);
        }
        this.checkAliases();
        this.setLocation(this.getParent().getX() + (this.getParent().getWidth() - this.getWidth()) / 2, this.getParent().getY() + (this.getParent().getHeight() - this.getHeight()) / 2);
        UIUtil.fit(this);
        this.setVisible(true);
    }

    public void buildQuery(Table table, Relationship root, DataModel datamodel) {
        if (table == null) {
            return;
        }
        this.sqlTextArea.setText("");
        this.mlmTextField.setText("");
        this.datamodel = datamodel;
        this.subject = table;
        this.rootRelationship = root;
        this.joinAWithBButton.setVisible(false);
        this.resetRelationshipsPanel();
        ArrayList<JTextField> tf = new ArrayList<JTextField>();
        ArrayList<String> as = new ArrayList<String>();
        boolean distinct = false;
        for (Relationship r : this.rootRelationship.flatten(0, null, false)) {
            if (r.aliasSuggestion != null) {
                tf.add(r.aliasTextField);
                as.add(r.aliasSuggestion);
            }
            if (r.association != null && r.joinOperator != JoinOperator.Join) {
                distinct = true;
            }
            this.originalAnchorSQL.put(r.getPathToRoot(), r.anchorWhereClause);
            this.originalConditionSQL.put(r.getPathToRoot(), r.whereClause);
            this.originalAnchor.put(r.getPathToRoot(), r.anchor);
        }
        HashMap counterPerAlias = new HashMap();
        for (int i = 0; i < tf.size(); ++i) {
            Integer c = (Integer)counterPerAlias.get(as.get(i));
            if (c == null) {
                c = 1;
            }
            counterPerAlias.put(as.get(i), c + 1);
            ((JTextField)tf.get(i)).setText((String)as.get(i) + c);
        }
        this.checkAliases();
        this.setLocation(this.getParent().getX() + (this.getParent().getWidth() - this.getWidth()) / 2, this.getParent().getY() + (this.getParent().getHeight() - this.getHeight()) / 2);
        UIUtil.fit(this);
        this.distinctCheckBox.setSelected(distinct);
        this.setVisible(true);
    }

    private void createPathQuery(List<String> whereClauses) {
        Relationship firstR;
        this.rootRelationship = firstR = new Relationship();
        firstR.selectColumns = true;
        if (whereClauses != null && whereClauses.size() > 0) {
            firstR.whereClause = whereClauses.get(0);
        }
        this.subject = this.associationsOnPath.get((int)0).source;
        for (int i = 0; i < this.associationsOnPath.size(); ++i) {
            Association a = this.associationsOnPath.get(i);
            Relationship r = new Relationship();
            r.association = a;
            if (whereClauses != null && whereClauses.size() > i + 1) {
                r.whereClause = whereClauses.get(i + 1);
            }
            firstR.children.add(r);
            firstR = r;
        }
        this.resetRelationshipsPanel();
    }

    private void appendMLM(String mlm) {
        if ((mlm = mlm.trim()).length() > 1) {
            mlm = mlm.substring(0, 1);
        }
        if (this.mlm.equals(mlm)) {
            return;
        }
        if (this.mlm.length() > 0) {
            String omlm = this.mlm;
            if ("\\|[]()^-$".indexOf(omlm) >= 0) {
                omlm = "\\" + omlm;
            }
            this.sqlTextArea.setText(this.sqlTextArea.getText().replaceAll(" " + omlm + "([\n\r])", "$1"));
            this.sqlTextArea.select(0, 0);
        }
        this.mlm = mlm;
        if (mlm.length() > 0) {
            if ("\\".equals(mlm) || "$".equals(mlm)) {
                mlm = "\\" + mlm;
            }
            this.sqlTextArea.setText(this.sqlTextArea.getText().replaceAll("([^\n\r;])([\n\r])", "$1 " + mlm + "$2"));
            this.sqlTextArea.select(0, 0);
        }
    }

    public static class Relationship {
        public List<Relationship> children = new ArrayList<Relationship>();
        public Relationship parent;
        public String whereClause;
        public String anchorWhereClause;
        public Association anchor;
        public boolean needsAnchor = false;
        public Association association;
        public JoinOperator joinOperator = JoinOperator.Join;
        public int level;
        public List<Relationship> origChildren = null;
        public JTextField aliasTextField;
        public Color originalBGColor;
        public boolean selectColumns;
        public String alias;
        public String aliasSuggestion;
        public Relationship originalParent;

        public List<Association> getPathToRoot() {
            ArrayList<Association> path = new ArrayList<Association>();
            path.add(this.association);
            if (this.parent != null) {
                path.addAll(this.parent.getPathToRoot());
            }
            return path;
        }

        public List<Relationship> flatten(int level, Relationship parent, boolean withLastPseudoChild) {
            this.level = level;
            this.parent = parent;
            ArrayList<Relationship> flat = new ArrayList<Relationship>();
            flat.add(this);
            if (withLastPseudoChild) {
                Relationship lastChild = new Relationship();
                lastChild.parent = this;
                lastChild.level = level + 1;
                flat.add(lastChild);
            }
            for (Relationship child : this.children) {
                flat.addAll(child.flatten(level + 1, this, withLastPseudoChild));
            }
            return flat;
        }

        public void dump(int level) {
            String indent = "                     ".substring(0, level * 4);
            System.out.println(indent + (this.association == null ? "" : this.association.source.getName() + " -> " + this.association.destination.getName()));
            System.out.println(indent + this.anchorWhereClause);
            for (Relationship r : this.children) {
                r.dump(level + 1);
            }
        }
    }

    public static enum JoinOperator {
        Join("Join"),
        LeftJoin("Left Join");

        private final String operator;

        private JoinOperator(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }
    }
}

