/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ProgressTable
extends JTable {
    private static final int MAX_TABLES_PER_LINE = 7;
    private final List<Color> bgColors = new ArrayList<Color>();
    private final Color BG1 = new Color(255, 255, 255);
    private final Color BG2 = new Color(240, 255, 255);
    private final Color SELECTED_FG = new Color(180, 160, 0);
    private final Color INPROGRESS_FG = new Color(255, 40, 0);
    private List<List<CellInfo>> cellInfos = new ArrayList<List<CellInfo>>();
    private Set<CellInfo> selectedCells = new HashSet<CellInfo>();
    private String selectedTableName = null;
    private long totalNumberOfCollectedRows = 0L;
    private final JPanel cellPanel = new JPanel();
    private final JLabel tableRender = new JLabel("");
    private final JLabel numberRender = new JLabel("");
    private boolean multiSelection = false;
    private DefaultTableModel tableModel;
    private List<CellInfo> lastBestRow = null;
    private int[] originalWidth;
    private static final long serialVersionUID = -6284876860992859979L;

    public ProgressTable() {
        this.setShowGrid(false);
        this.setSurrendersFocusOnKeystroke(true);
        this.tableRender.setHorizontalAlignment(0);
        this.numberRender.setHorizontalAlignment(0);
        this.cellPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.cellPanel.add((Component)this.tableRender, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.cellPanel.add((Component)this.numberRender, gridBagConstraints);
        this.tableRender.setOpaque(true);
        this.numberRender.setOpaque(true);
        this.setRowHeight(this.getRowHeight() * 3);
        final Border defaultBorder = this.cellPanel.getBorder();
        final Border selBorder = BorderFactory.createLineBorder(Color.BLACK, 2);
        this.setDefaultRenderer(Object.class, new TableCellRenderer(){
            private Font font = new JLabel("normal").getFont();
            private Font normal = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
            private Font kursiv = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE | 2, this.font.getSize());
            private Font bold = new Font(this.font.getName(), this.font.getStyle() | 1, this.font.getSize());

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color color = (Color)ProgressTable.this.bgColors.get(row);
                boolean fontIsSet = false;
                ProgressTable.this.tableRender.setForeground(Color.BLACK);
                ProgressTable.this.numberRender.setForeground(Color.BLACK);
                ProgressTable.this.cellPanel.setToolTipText(null);
                ProgressTable.this.cellPanel.setBorder(defaultBorder);
                if (value instanceof CellInfo) {
                    CellInfo cellInfo = (CellInfo)value;
                    if (cellInfo.tableName.equals(ProgressTable.this.selectedTableName)) {
                        ProgressTable.this.cellPanel.setBorder(selBorder);
                    }
                    ProgressTable.this.tableRender.setHorizontalAlignment(0);
                    ProgressTable.this.tableRender.setText(cellInfo.tableName);
                    ProgressTable.this.cellPanel.setToolTipText(cellInfo.tableName);
                    if (ProgressTable.this.selectedCells.contains(cellInfo)) {
                        ProgressTable.this.numberRender.setFont(this.bold);
                        ProgressTable.this.tableRender.setFont(this.bold);
                        fontIsSet = true;
                    }
                    if (cellInfo.numberOfRows < 0L) {
                        ProgressTable.this.numberRender.setText("?");
                        ProgressTable.this.tableRender.setForeground(cellInfo.inProgress ? ProgressTable.this.INPROGRESS_FG : ProgressTable.this.SELECTED_FG);
                        ProgressTable.this.numberRender.setForeground(cellInfo.inProgress ? ProgressTable.this.INPROGRESS_FG : ProgressTable.this.SELECTED_FG);
                    } else if (cellInfo.numberOfRows == 0L) {
                        ProgressTable.this.numberRender.setText(cellInfo.numberOfRows + " rows");
                        ProgressTable.this.tableRender.setForeground(Color.GRAY);
                        ProgressTable.this.numberRender.setForeground(Color.GRAY);
                    } else {
                        long p = 0L;
                        if (ProgressTable.this.totalNumberOfCollectedRows > 0L && (p = cellInfo.numberOfRows * 100L / ProgressTable.this.totalNumberOfCollectedRows) > 100L) {
                            p = 100L;
                        }
                        ProgressTable.this.numberRender.setText(cellInfo.numberOfRows + " rows" + (p == 0L ? "" : " (" + p + "%)"));
                        ProgressTable.this.tableRender.setForeground(Color.BLACK);
                        float f = 0.2f + (float)p / 100.0f * 0.8f;
                        if (f > 1.0f) {
                            f = 1.0f;
                        }
                        if (p == 0L) {
                            f = 0.0f;
                        }
                        ProgressTable.this.numberRender.setForeground(new Color(f, 0.0f, 0.0f));
                    }
                } else {
                    ProgressTable.this.tableRender.setHorizontalAlignment(2);
                    ProgressTable.this.tableRender.setText(" " + value);
                    ProgressTable.this.numberRender.setText("");
                }
                if (!fontIsSet) {
                    ProgressTable.this.numberRender.setFont(this.kursiv);
                    ProgressTable.this.tableRender.setFont(this.normal);
                }
                ProgressTable.this.tableRender.setBackground(color);
                ProgressTable.this.numberRender.setBackground(color);
                ProgressTable.this.cellPanel.setBackground(color);
                return ProgressTable.this.cellPanel;
            }
        });
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Object o;
                int col = ProgressTable.this.getSelectedColumn();
                int row = ProgressTable.this.getSelectedRow();
                if (col >= 1 && row >= 0 && (o = ProgressTable.this.getModel().getValueAt(row, col)) instanceof CellInfo) {
                    CellInfo cellInfo = (CellInfo)o;
                    ProgressTable.this.selectedCells.clear();
                    ProgressTable.this.selectedTableName = cellInfo.tableName;
                    ProgressTable.this.multiSelection = false;
                    ProgressTable.this.selectCell(cellInfo);
                    ProgressTable.this.repaint();
                    ProgressTable.this.getSelectionModel().clearSelection();
                }
            }
        });
        Object[] colNames = new String[8];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = "";
        }
        this.tableModel = new DefaultTableModel(colNames, 0){
            private static final long serialVersionUID = 772166119760096519L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setModel(this.tableModel);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.getColumnModel().getColumns().nextElement().setMaxWidth(50);
        this.setTableHeader(null);
    }

    private void selectCell(CellInfo cellInfo) {
        this.selectedCells.add(cellInfo);
        if (cellInfo.parents != null) {
            for (CellInfo p : cellInfo.parents) {
                this.selectCell(p);
            }
        }
    }

    public void selectAllCells(String tableName) {
        this.multiSelection = true;
        this.selectedCells.clear();
        this.selectedTableName = tableName;
        for (List<CellInfo> cL : this.cellInfos) {
            for (CellInfo cellInfo : cL) {
                if (cellInfo == null || !cellInfo.tableName.equals(tableName) || cellInfo.numberOfRows <= 0L) continue;
                this.selectCell(cellInfo);
            }
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        Color color = new Color(0, 80, 255, 80);
        Color selColor = new Color(255, 0, 0, 120);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int[] x = new int[2];
        int[] y = new int[2];
        ArrayList<int[]> hLineCount = new ArrayList<int[]>();
        for (List<CellInfo> cL : this.cellInfos) {
            for (CellInfo cellInfo : cL) {
                g2d.setColor(this.selectedCells.contains(cellInfo) ? selColor : color);
                g2d.setStroke(new BasicStroke(this.selectedCells.contains(cellInfo) ? 3.0f : 2.0f, 1, 0));
                while (cellInfo != null && hLineCount.size() <= cellInfo.row) {
                    hLineCount.add(new int[7]);
                }
                if (cellInfo == null || cellInfo.parents == null) continue;
                for (CellInfo parent : cellInfo.parents) {
                    int offset = 0;
                    if (cellInfo.column == parent.column) {
                        offset = 0;
                        for (int r = parent.row; r < cellInfo.row; ++r) {
                            if (offset < ((int[])hLineCount.get(r))[cellInfo.column]) {
                                offset = ((int[])hLineCount.get(r))[cellInfo.column];
                            }
                            int[] nArray = (int[])hLineCount.get(r);
                            int n = cellInfo.column;
                            nArray[n] = nArray[n] + 1;
                        }
                        offset = (offset + 1) / 2 * (2 * (offset % 2) - 1) * 6;
                    }
                    Rectangle r = this.getCellRect(cellInfo.row, cellInfo.column + 1, false);
                    x[0] = (int)r.getCenterX();
                    y[0] = (int)r.getMinY() + r.height / 5;
                    r = this.getCellRect(parent.row, parent.column + 1, false);
                    x[1] = (int)r.getCenterX();
                    y[1] = (int)r.getMaxY() - r.height / 4;
                    this.drawArrow(g2d, x[1] + offset, y[1], x[0] + offset, y[0]);
                }
            }
        }
    }

    public boolean isLastRowVisible() {
        if (this.getRowCount() == 0) {
            return false;
        }
        Rectangle r = this.getCellRect(this.getRowCount() - 1, 1, true);
        Rectangle visible = this.getVisibleRect();
        boolean isVisible = r.y <= visible.y + visible.height;
        return isVisible;
    }

    public void replaceLastRow(List<CellInfo> cells, int day) {
        boolean scrollToBottom = this.isLastRowVisible();
        boolean checkSelection = false;
        if (this.selectedTableName != null) {
            for (CellInfo cellInfo : this.cellInfos.get(this.cellInfos.size() - 1)) {
                if (cellInfo == null || !this.selectedTableName.equals(cellInfo.tableName) || !this.selectedCells.contains(cellInfo)) continue;
                this.selectCell(cellInfo);
                checkSelection = true;
                break;
            }
        }
        if (this.cellInfos.size() > 0) {
            TreeSet<Integer> rowsToRemove = new TreeSet<Integer>();
            for (CellInfo ci : this.cellInfos.remove(this.cellInfos.size() - 1)) {
                rowsToRemove.add(ci.row);
            }
            for (int rowI = rowsToRemove.size(); rowI > 0; --rowI) {
                this.tableModel.removeRow(this.tableModel.getRowCount() - 1);
                this.bgColors.remove(this.bgColors.size() - 1);
            }
        }
        this.addRow(cells, day, scrollToBottom);
        if (this.selectedTableName != null && (checkSelection || this.multiSelection)) {
            if (this.multiSelection) {
                this.selectAllCells(this.selectedTableName);
            } else {
                boolean f = false;
                for (CellInfo cellInfo : this.cellInfos.get(this.cellInfos.size() - 1)) {
                    if (cellInfo == null || !this.selectedTableName.equals(cellInfo.tableName)) continue;
                    this.selectCell(cellInfo);
                    f = true;
                    break;
                }
                if (!f) {
                    this.selectedCells.clear();
                    this.selectedTableName = null;
                }
            }
        }
    }

    public void addRow(List<CellInfo> cells, int day) {
        this.addRow(cells, day, this.isLastRowVisible());
    }

    /*
     * WARNING - void declaration
     */
    public void addRow(List<CellInfo> cells, int day, boolean scrollToBottom) {
        Color bg;
        AbstractList row = new LinkedList<CellInfo>(cells);
        int leftPad = (7 - cells.size()) / 2;
        while (leftPad-- > 0) {
            row.add(0, null);
        }
        int s = row.size() * 3 / 2;
        while (row.size() < s) {
            row.add(null);
        }
        while (row.size() % 7 != 0) {
            row.add(null);
        }
        String dayS = "" + day;
        List<CellInfo> parentRow = null;
        for (int i = this.cellInfos.size() - 1; i > 0; --i) {
            if (!this.cellInfos.get(i).isEmpty()) {
                parentRow = this.cellInfos.get(i);
                break;
            }
            dayS = i + ", " + dayS;
        }
        for (CellInfo cellInfo : row) {
            if (cellInfo == null || cellInfo.parentNames == null || parentRow == null) continue;
            cellInfo.parents = new ArrayList<CellInfo>();
            block5: for (String pName : cellInfo.parentNames) {
                for (CellInfo pInfo : parentRow) {
                    if (!pName.equals(pInfo.tableName)) continue;
                    cellInfo.parents.add(pInfo);
                    continue block5;
                }
            }
        }
        boolean takeLastOrdering = false;
        if (this.lastBestRow != null) {
            takeLastOrdering = true;
            HashSet<String> lastNames = new HashSet<String>();
            for (CellInfo ci : this.lastBestRow) {
                if (ci == null) continue;
                lastNames.add(ci.tableName);
            }
            HashSet<String> currentNames = new HashSet<String>();
            for (CellInfo cellInfo : row) {
                if (cellInfo == null) continue;
                currentNames.add(cellInfo.tableName);
            }
            if (!currentNames.equals(lastNames)) {
                takeLastOrdering = false;
            } else {
                for (CellInfo cellInfo : this.lastBestRow) {
                    if (cellInfo == null) continue;
                    CellInfo cie = null;
                    for (CellInfo ciRow : row) {
                        if (ciRow == null || !ciRow.tableName.equals(cellInfo.tableName)) continue;
                        cie = ciRow;
                        break;
                    }
                    if (cie == null) {
                        takeLastOrdering = false;
                        break;
                    }
                    if (cie.parentNames == null && cellInfo.parentNames != null || cie.parentNames != null && cellInfo.parentNames == null) {
                        takeLastOrdering = false;
                        break;
                    }
                    if (cie.parentNames == null || cie.parentNames.equals(cellInfo.parentNames)) continue;
                    takeLastOrdering = false;
                    break;
                }
            }
        }
        if (takeLastOrdering) {
            ArrayList<void> newRow = new ArrayList<void>();
            for (CellInfo ci : this.lastBestRow) {
                void var13_27;
                Object var13_25 = null;
                if (ci != null) {
                    for (CellInfo ciRow : row) {
                        if (ciRow == null || !ciRow.tableName.equals(ci.tableName)) continue;
                        CellInfo cellInfo = ciRow;
                        break;
                    }
                }
                newRow.add(var13_27);
            }
            row = newRow;
        } else {
            int cd = 50000;
            int maxParentRow = 1;
            if (parentRow != null) {
                for (CellInfo cellInfo : parentRow) {
                    if (cellInfo == null || cellInfo.row <= maxParentRow) continue;
                    maxParentRow = cellInfo.row;
                }
            }
            double d = this.fitness(row, maxParentRow);
            ArrayList<CellInfo> bestRow = new ArrayList<CellInfo>(row);
            do {
                for (int a = row.size() - 1; a >= 0; --a) {
                    for (int b = a - 1; b >= 0; --b) {
                        CellInfo cA = (CellInfo)row.get(a);
                        CellInfo cB = (CellInfo)row.get(b);
                        row.set(a, cB);
                        row.set(b, cA);
                        double f = this.fitness(row, maxParentRow);
                        if (f < d) {
                            bestRow = new ArrayList(row);
                            d = f;
                        }
                        row.set(a, cA);
                        row.set(b, cB);
                        if (--cd < 0) break;
                    }
                    if (cd < 0) break;
                }
                if (bestRow == null) continue;
                row = bestRow;
            } while (bestRow != null && cd > 0);
            this.lastBestRow = new ArrayList<CellInfo>(row);
        }
        dayS = " " + dayS;
        this.cellInfos.add(cells);
        int y = this.tableModel.getRowCount();
        int l = 0;
        for (List list : this.cellInfos) {
            if (list.isEmpty()) continue;
            ++l;
        }
        Color color = bg = l % 2 == 0 ? this.BG1 : this.BG2;
        while (!row.isEmpty()) {
            Object[] objectArray = new Object[8];
            boolean rowIsEmpty = true;
            objectArray[0] = dayS;
            dayS = "";
            for (int x = 0; x < 7; ++x) {
                CellInfo cellInfo;
                CellInfo cellInfo2 = cellInfo = row.isEmpty() ? null : (CellInfo)row.remove(0);
                if (cellInfo == null) {
                    objectArray[x + 1] = "";
                    continue;
                }
                rowIsEmpty = false;
                cellInfo.column = x;
                cellInfo.row = y;
                objectArray[x + 1] = cellInfo;
            }
            if (rowIsEmpty) continue;
            this.bgColors.add(bg);
            this.tableModel.addRow(objectArray);
            ++y;
        }
        if (scrollToBottom && this.getRowCount() > 0) {
            Rectangle rectangle = this.getCellRect(this.getRowCount() - 1, 1, true);
            this.scrollRectToVisible(rectangle);
            this.scrollRectToVisible(rectangle);
        }
        this.invalidate();
        this.repaint();
    }

    private double fitness(List<CellInfo> row, int maxParentRow) {
        double f = 0.0;
        int[] conflictCount = new int[7];
        for (int x = row.size() - 1; x >= 0; --x) {
            CellInfo cellInfo = row.get(x);
            if (cellInfo == null || cellInfo.parents == null) continue;
            for (CellInfo parent : cellInfo.parents) {
                double xabs = x % 7 - parent.column;
                if (xabs == 0.0) {
                    int n = parent.column;
                    int n2 = conflictCount[n];
                    conflictCount[n] = n2 + 1;
                    f += (double)(49 * n2);
                }
                double yabs = x / 7 + maxParentRow - parent.row;
                f += xabs * xabs + yabs * yabs / 10.0;
            }
        }
        return f;
    }

    public void setTotalNumberOfCollectedRows(long totalNumberOfCollectedRows) {
        this.totalNumberOfCollectedRows = totalNumberOfCollectedRows;
    }

    private void drawArrow(Graphics2D g, int x, int y, int xx, int yy) {
        float arrowWidth = 6.0f;
        float theta = 0.423f;
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        float[] vecLine = new float[2];
        float[] vecLeft = new float[2];
        xPoints[0] = xx;
        yPoints[0] = yy;
        vecLine[0] = (float)xPoints[0] - (float)x;
        vecLine[1] = (float)yPoints[0] - (float)y;
        vecLeft[0] = -vecLine[1];
        vecLeft[1] = vecLine[0];
        float fLength = (float)Math.sqrt(vecLine[0] * vecLine[0] + vecLine[1] * vecLine[1]);
        float th = arrowWidth / (2.0f * fLength);
        float ta = arrowWidth / (2.0f * ((float)Math.tan(theta) / 2.0f) * fLength);
        float baseX = (float)xPoints[0] - ta * vecLine[0];
        float baseY = (float)yPoints[0] - ta * vecLine[1];
        xPoints[1] = (int)(baseX + th * vecLeft[0]);
        yPoints[1] = (int)(baseY + th * vecLeft[1]);
        xPoints[2] = (int)(baseX - th * vecLeft[0]);
        yPoints[2] = (int)(baseY - th * vecLeft[1]);
        g.drawLine(x, y, (int)baseX, (int)baseY);
        g.fillPolygon(xPoints, yPoints, 3);
    }

    public void adjustColumnWidth() {
        TableColumn col;
        int vColIndex;
        if (this.getRowCount() == 0) {
            return;
        }
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.getColumnModel();
        if (this.originalWidth == null) {
            this.originalWidth = new int[colModel.getColumnCount()];
            for (vColIndex = 0; vColIndex < colModel.getColumnCount(); ++vColIndex) {
                col = colModel.getColumn(vColIndex);
                this.originalWidth[vColIndex] = col.getMaxWidth();
            }
        }
        for (vColIndex = 0; vColIndex < colModel.getColumnCount(); ++vColIndex) {
            col = colModel.getColumn(vColIndex);
            boolean isEmpty = true;
            for (int r = 0; r < this.getRowCount(); ++r) {
                TableCellRenderer renderer = this.getCellRenderer(r, vColIndex);
                Component comp = renderer.getTableCellRendererComponent(this, this.getValueAt(r, vColIndex), false, false, r, vColIndex);
                if (comp == this.cellPanel && this.tableRender.getText().trim().length() <= 0) continue;
                isEmpty = false;
            }
            if (isEmpty) {
                col.setMaxWidth(1);
                continue;
            }
            col.setMaxWidth(this.originalWidth[vColIndex]);
        }
    }

    public static class CellInfo {
        public String tableName;
        public long numberOfRows;
        public Set<String> parentNames;
        public int row;
        public int column;
        public List<CellInfo> parents;
        public boolean inProgress = false;
    }
}

