/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.sf.jailer.database.DMLTransformer;
import net.sf.jailer.ui.ProgressTable;

public class ProgressPanel
extends JPanel {
    private Font font = new JLabel("normal").getFont();
    private Font nonbold = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
    private final ProgressTable progressTable;
    private int currentlySelectedRow = -1;
    private final Color BGCOLOR_OF_SELECTED_ROW = Color.CYAN;
    private List<MouseListener> allMouseListener = new ArrayList<MouseListener>();
    public JLabel collectedRowsLabel;
    public JLabel elapsedTimeLabel;
    public JLabel exportedRowsLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JPanel panel3;
    private JScrollPane progressTableHolder;
    private JPanel rowsPerTablePanel;
    public JLabel stepLabel;
    private static final long serialVersionUID = -2750282839722695036L;

    public ProgressPanel(ProgressTable progressTable) {
        this.progressTable = progressTable;
        this.initComponents();
        this.jLabel1.setForeground(this.jLabel1.getBackground());
        this.progressTableHolder.setViewportView(progressTable);
        this.stepLabel.setFont(this.nonbold);
        this.exportedRowsLabel.setFont(this.nonbold);
        this.collectedRowsLabel.setFont(this.nonbold);
        this.elapsedTimeLabel.setFont(this.nonbold);
        this.progressTableHolder.setColumnHeaderView(null);
    }

    public void updateRowsPerTable(Map<String, Long> rowsPerTable) {
        GridBagConstraints gridBagConstraints;
        this.rowsPerTablePanel.removeAll();
        this.allMouseListener.clear();
        int y = 0;
        for (String tableName : rowsPerTable.keySet()) {
            Color bgColor = y % 2 == 0 ? new Color(240, 255, 255) : Color.WHITE;
            JLabel l = this.createLabel(y, tableName, bgColor);
            l.setText(" " + tableName + " ");
            l.setOpaque(true);
            l.setFont(this.nonbold);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            this.rowsPerTablePanel.add((Component)l, gridBagConstraints);
            l = new JLabel("" + rowsPerTable.get(tableName) + "  ");
            if (y % 2 == 0) {
                l.setBackground(new Color(240, 255, 255));
            } else {
                l.setBackground(Color.WHITE);
            }
            l.setOpaque(true);
            l.setFont(this.nonbold);
            l.setHorizontalAlignment(4);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.rowsPerTablePanel.add((Component)l, gridBagConstraints);
        }
        JLabel l = new JLabel("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = y;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.rowsPerTablePanel.add((Component)l, gridBagConstraints);
    }

    private JLabel createLabel(final int y, final String tableName, Color bgColor) {
        final JLabel label = new JLabel();
        label.setBackground(bgColor);
        MouseListener l = new MouseListener(){
            Color bgColor;

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.bgColor != null) {
                    label.setBackground(this.bgColor);
                }
                if (ProgressPanel.this.currentlySelectedRow == y) {
                    ProgressPanel.this.currentlySelectedRow = -1;
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                for (MouseListener l : ProgressPanel.this.allMouseListener) {
                    if (l == this) continue;
                    l.mouseExited(e);
                }
                if (this.bgColor == null) {
                    this.bgColor = label.getBackground();
                }
                label.setBackground(ProgressPanel.this.BGCOLOR_OF_SELECTED_ROW);
                ProgressPanel.this.currentlySelectedRow = y;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ProgressPanel.this.progressTable.selectAllCells(tableName);
            }
        };
        label.addMouseListener(l);
        if (y == this.currentlySelectedRow) {
            l.mouseEntered(null);
        }
        this.allMouseListener.add(l);
        return label;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.stepLabel = new JLabel();
        this.jLabel5 = new JLabel();
        this.collectedRowsLabel = new JLabel();
        this.exportedRowsLabel = new JLabel();
        this.jPanel5 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.rowsPerTablePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.elapsedTimeLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.panel3 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.progressTableHolder = new JScrollPane();
        this.setLayout(new BoxLayout(this, 2));
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel3.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel3.setText(" Stage ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel4.setText(" Collected Rows  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.stepLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.stepLabel, gridBagConstraints);
        this.jLabel5.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel5.setText(" Exported Rows  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.collectedRowsLabel.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.collectedRowsLabel, gridBagConstraints);
        this.exportedRowsLabel.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.exportedRowsLabel, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Rows per Table"));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportBorder(null);
        this.rowsPerTablePanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.rowsPerTablePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        this.jLabel1.setForeground(new Color(230, 230, 230));
        this.jLabel1.setText("                                     ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel6.setFont(new Font("DejaVu Sans", 1, 13));
        this.jLabel6.setText(" Elapsed Time ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.elapsedTimeLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.elapsedTimeLabel, gridBagConstraints);
        this.jPanel3.add(this.jPanel2);
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        this.panel3.setLayout(new BorderLayout());
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel2.setText(" Day ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.jPanel6.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText(" Progress ");
        this.jLabel7.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.jPanel6.add((Component)this.jLabel7, gridBagConstraints);
        this.panel3.add((Component)this.jPanel6, "First");
        this.panel3.add((Component)this.progressTableHolder, "Center");
        this.jPanel4.add(this.panel3);
        this.jSplitPane1.setRightComponent(this.jPanel4);
        this.add(this.jSplitPane1);
    }

    public void confirm() {
        String message = "Successfully finished.";
        if (DMLTransformer.numberOfExportedLOBs > 0L) {
            message = message + "\n" + DMLTransformer.numberOfExportedLOBs + " CLOBs/BLOBs exported.\n\n" + "Note that the CLOBs/BLOBs can only\n" + "be imported with the 'Import SQL Data' Tool";
        }
        JOptionPane.showMessageDialog(this, message, "Finished", 1);
    }
}

