/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class ParameterSelector
extends JPanel {
    private final ParametersGetter parametersGetter;
    private List<String> parameters;
    JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JTable paramTable;
    private static final long serialVersionUID = 5153763345779925099L;

    public ParameterSelector(final Component parent, final JTextComponent textArea, ParametersGetter parametersGetter) {
        this.parametersGetter = parametersGetter;
        this.parameters = new ArrayList<String>();
        this.initComponents();
        final TableCellRenderer defaultTableCellRenderer = this.paramTable.getDefaultRenderer(String.class);
        this.paramTable.setShowGrid(false);
        this.paramTable.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component render = defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (render instanceof JLabel && !isSelected) {
                    Color BG1 = new Color(255, 255, 255);
                    Color BG2 = new Color(230, 255, 255);
                    ((JLabel)render).setBackground(row % 2 == 0 ? BG1 : BG2);
                }
                return render;
            }
        });
        this.paramTable.setSelectionMode(0);
        this.paramTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            int lastRow = -2;

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                int row = ParameterSelector.this.paramTable.getSelectedRow();
                if (this.lastRow == row) {
                    return;
                }
                this.lastRow = row;
                if (row == 0) {
                    String newParameter = JOptionPane.showInputDialog(parent, "Parameter", "New Parameter", 3);
                    if (newParameter != null) {
                        newParameter = newParameter.trim();
                        String np = "";
                        for (int i = 0; i < newParameter.length(); ++i) {
                            char c = newParameter.charAt(i);
                            if ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789-\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df?#".indexOf(c) < 0) continue;
                            np = np + c;
                        }
                        newParameter = np;
                        if (newParameter.length() > 0) {
                            if (!ParameterSelector.this.parameters.contains(newParameter)) {
                                ParameterSelector.this.parameters.add(newParameter);
                            }
                            textArea.replaceSelection("${" + newParameter + "}");
                            textArea.grabFocus();
                            ParameterSelector.this.refresh();
                        }
                    }
                } else if (row > 0) {
                    textArea.replaceSelection("${" + (String)ParameterSelector.this.parameters.get(row - 1) + "}");
                    textArea.grabFocus();
                }
                ParameterSelector.this.paramTable.getSelectionModel().clearSelection();
            }
        });
        this.updateParameters();
        this.refresh();
    }

    public void updateParameters() {
        this.parameters.clear();
        this.parameters.addAll(this.parametersGetter.getParameters());
        this.refresh();
    }

    private void refresh() {
        Collections.sort(this.parameters);
        Object[][] data = new Object[this.parameters.size() + 1][];
        int i = 0;
        data[i++] = new Object[]{"<new parameter>"};
        for (String s : this.parameters) {
            data[i++] = new Object[]{s};
        }
        this.paramTable.setModel(new DefaultTableModel(data, new Object[]{"Parameter"}){
            private static final long serialVersionUID = 2703862797772451362L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.paramTable = new JTable();
        this.setLayout(new GridLayout(1, 1));
        this.jPanel1.setBorder(null);
        this.jPanel1.setLayout(new GridBagLayout());
        this.paramTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.paramTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        this.add(this.jPanel1);
    }

    public static interface ParametersGetter {
        public Set<String> getParameters();
    }
}

