/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jailer.ui.UIUtil;

public class NewDataModelDialog
extends JDialog {
    private static final long serialVersionUID = 486596745983098673L;
    private final Set<String> existingFoldersLC = new HashSet<String>();
    private Color initialFGColor;
    private String nameEntered = null;
    private JButton createButton;
    private JTextField folderTextField;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField nameTextField;

    public NewDataModelDialog(Frame parent, List<String> existingFolders) {
        super(parent, true);
        for (String s : existingFolders) {
            this.existingFoldersLC.add(s.toLowerCase());
        }
        this.initComponents();
        this.pack();
        this.setSize(Math.max(400, this.getWidth()), this.getHeight());
        this.setLocation(parent.getX() + (parent.getWidth() - this.getWidth()) / 2, parent.getY() + (parent.getHeight() - this.getHeight()) / 2);
        UIUtil.initPeer();
        UIUtil.fit(this);
        this.initialFGColor = this.folderTextField.getForeground();
        this.nameTextField.setText("");
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewDataModelDialog.this.checkName();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewDataModelDialog.this.checkName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewDataModelDialog.this.checkName();
            }
        });
        this.checkName();
        this.setVisible(true);
    }

    private boolean checkName() {
        Color red = Color.red;
        this.folderTextField.setText(this.folderName(this.nameTextField.getText()));
        if (this.nameTextField.getText().trim().length() == 0) {
            this.createButton.setEnabled(false);
            this.folderTextField.setForeground(this.initialFGColor);
            return false;
        }
        if (this.existingFoldersLC.contains(this.folderTextField.getText().toLowerCase())) {
            this.createButton.setEnabled(false);
            this.folderTextField.setForeground(red);
            return false;
        }
        this.createButton.setEnabled(true);
        this.folderTextField.setForeground(this.initialFGColor);
        return true;
    }

    private String folderName(String name) {
        name = name.trim().replaceAll("[^ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789]+", "-");
        return name;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.createButton = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.nameTextField = new JTextField();
        this.folderTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("New Data Model");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.createButton.setText("Create New Data Model");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDataModelDialog.this.createButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.createButton, gridBagConstraints);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDataModelDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Folder  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.nameTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.nameTextField, gridBagConstraints);
        this.folderTextField.setEditable(false);
        this.folderTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.folderTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 14, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        if (this.checkName()) {
            this.nameEntered = this.nameTextField.getText().trim();
        }
        this.setVisible(false);
    }

    public String getNameEntered() {
        return this.nameEntered;
    }

    public String getFolderName() {
        return this.folderName(this.nameEntered);
    }
}

