/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.jailer.ui.FileView;
import net.sf.jailer.ui.ProgressPanel;
import net.sf.jailer.ui.UIUtil;

public class JailerConsole {
    private final ProgressPanel progressPanel;
    public final JDialog dialog;
    private final boolean fullSize;
    private JTextArea jTextArea = null;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane = null;
    private JButton loadExportLog = null;
    private JButton loadSqlLog = null;
    private JButton loadExplainLog = null;

    public JailerConsole(Window owner, JDialog dialog, boolean showLogfileButton, boolean showExplainLogButton, ProgressPanel progressPanel, boolean fullSize) {
        this.dialog = dialog == null ? new JDialog(owner) : dialog;
        this.progressPanel = progressPanel;
        this.fullSize = fullSize;
        this.initialize();
        this.getJTextPane().setAutoscrolls(true);
        Font f = this.getJTextPane().getFont();
        this.getJTextPane().setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
        this.getJTextPane().setLineWrap(false);
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(0);
        this.getLoadExplainLog().setEnabled(false);
        this.getLoadSqlLog().setEnabled(false);
        this.getLoadExportLog().setVisible(false);
        if (!showLogfileButton) {
            this.getLoadSqlLog().setVisible(false);
        }
        if (!showExplainLogButton) {
            this.getLoadExplainLog().setVisible(false);
        }
        UIUtil.initPeer();
    }

    private void initialize() {
        JPanel jPanel = this.getJPanel();
        if (this.progressPanel != null) {
            jPanel.remove(this.getJScrollPane());
            JTabbedPane contentPane = new JTabbedPane();
            contentPane.add((Component)this.progressPanel, "Progress");
            contentPane.add((Component)this.getJScrollPane(), "Console");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            jPanel.add((Component)contentPane, gridBagConstraints);
        }
        if (this.fullSize) {
            this.dialog.setSize(new Dimension(1110, 740));
            this.dialog.setLocation(10, 50);
        } else {
            this.dialog.setSize(new Dimension(600, 400));
            this.dialog.setLocation(200, 250);
        }
        this.dialog.setContentPane(jPanel);
        this.dialog.setTitle("Jailer Console - in progress");
        this.getJTextPane().setFont(new Font("Monospaced", 0, 12));
        this.getLoadExportLog().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new FileView((Dialog)JailerConsole.this.dialog, "export.log");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.getLoadSqlLog().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new FileView((Dialog)JailerConsole.this.dialog, "sql.log");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.getLoadExplainLog().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new FileView((Dialog)JailerConsole.this.dialog, "explain.log");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        UIUtil.fit(this.dialog);
    }

    private JTextArea getJTextPane() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setEditable(false);
        }
        return this.jTextArea;
    }

    public void appendText(String output) {
        int MAXLENGTH = 100000;
        StringBuffer newText = new StringBuffer(this.getJTextPane().getText() + output);
        if (newText.length() > 100000) {
            int fll = newText.indexOf("\n");
            String firstLine = "";
            if (fll > 0) {
                firstLine = newText.substring(0, fll);
            }
            int start = newText.length() - 75000;
            newText = new StringBuffer(firstLine + "\n...\n" + newText.substring(start, newText.length()));
        }
        this.getJTextPane().setText(newText.toString());
    }

    public void finish(boolean ok) {
        this.getLoadSqlLog().setEnabled(true);
        this.getLoadExplainLog().setEnabled(true);
        this.dialog.setTitle("Jailer Console - " + (ok ? "finished" : "failed!"));
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.anchor = 17;
            gridBagConstraints28.gridx = 4;
            gridBagConstraints28.gridy = 1;
            gridBagConstraints28.insets = new Insets(0, 4, 0, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(0, 4, 0, 0);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 5;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.jPanel.add((Component)this.getLoadExportLog(), gridBagConstraints1);
            this.jPanel.add((Component)this.getLoadSqlLog(), gridBagConstraints2);
            this.jPanel.add((Component)this.getLoadExplainLog(), gridBagConstraints28);
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextPane());
        }
        return this.jScrollPane;
    }

    private JButton getLoadExportLog() {
        if (this.loadExportLog == null) {
            this.loadExportLog = new JButton();
            this.loadExportLog.setText("Open Export.log");
        }
        return this.loadExportLog;
    }

    private JButton getLoadSqlLog() {
        if (this.loadSqlLog == null) {
            this.loadSqlLog = new JButton();
            this.loadSqlLog.setText("Open Sql.log");
        }
        return this.loadSqlLog;
    }

    private JButton getLoadExplainLog() {
        if (this.loadExplainLog == null) {
            this.loadExplainLog = new JButton();
            this.loadExplainLog.setText("Open Explain.log");
        }
        return this.loadExplainLog;
    }
}

