/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.ConditionEditor;
import net.sf.jailer.ui.ExtractionModelFrame;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.ParameterSelector;

public class FilterEditorDialog
extends JDialog {
    private final ExtractionModelFrame parent;
    private boolean isInitialized = false;
    private Table selectedTable;
    private boolean refreshing = false;
    private Font font = new JLabel("normal").getFont();
    private Font boldFont = new Font(this.font.getName(), this.font.getStyle() | 1, this.font.getSize());
    private Font nonBoldFont = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
    private Map<Column, JTextField> filterTextfieldsPerColumn = new IdentityHashMap<Column, JTextField>();
    private ConditionEditor conditionEditor;
    private JButton cancelButton;
    private JPanel filterPane;
    private JScrollPane filterScrollPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okButton;
    private javax.swing.JComboBox tableBox;
    private Icon conditionEditorIcon;
    private Icon conditionEditorSelectedIcon;
    private static final long serialVersionUID = 7869830170667759018L;

    public FilterEditorDialog(ExtractionModelFrame parent, ParameterSelector.ParametersGetter parametersGetter) {
        super((Frame)parent, true);
        String dir = "/net/sf/jailer/resource";
        try {
            this.conditionEditorIcon = new ImageIcon(this.getClass().getResource(dir + "/edit.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.conditionEditorSelectedIcon = new ImageIcon(this.getClass().getResource(dir + "/edit_s.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conditionEditor = new ConditionEditor((Frame)parent, parametersGetter);
        this.parent = parent;
        this.initComponents();
        final ListCellRenderer tableBoxRenderer = this.tableBox.getRenderer();
        this.tableBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Table table;
                if (value instanceof String && (table = FilterEditorDialog.this.getDataModel().getTableByDisplayName((String)value)) != null) {
                    int n = 0;
                    for (Column c : table.getColumns()) {
                        if (c.getFilterExpression() == null) continue;
                        ++n;
                    }
                    if (n > 0) {
                        value = value + " (" + n + ")";
                    }
                }
                return tableBoxRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
    }

    private DataModel getDataModel() {
        return this.parent.extractionModelEditor.dataModel;
    }

    public void open(Table table) {
        this.filterTextfieldsPerColumn.clear();
        if (!this.isInitialized) {
            int w = 600;
            int h = 400;
            this.setSize(w, h);
            this.setLocation(Math.max(0, this.parent.getX() + this.parent.getWidth() / 2 - w / 2), Math.max(0, this.parent.getY() + this.parent.getHeight() / 2 - h / 2));
            this.isInitialized = true;
        }
        this.refresh(table);
        this.setVisible(true);
    }

    public void refresh(Table tableToSelect) {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        this.selectedTable = tableToSelect;
        Vector<String> tableNames = new Vector<String>();
        for (Table table : this.getDataModel().getTables()) {
            tableNames.add(this.getDataModel().getDisplayName(table));
        }
        Collections.sort(tableNames);
        tableNames.add(0, "---");
        tableNames.add(0, "All tables");
        DefaultComboBoxModel model = new DefaultComboBoxModel(tableNames);
        this.tableBox.setModel(model);
        if (tableToSelect == null && tableNames.size() > 0) {
            tableToSelect = this.getDataModel().getTableByDisplayName((String)tableNames.firstElement());
        }
        if (tableToSelect != null) {
            this.tableBox.setSelectedItem(this.getDataModel().getDisplayName(tableToSelect));
        } else {
            this.tableBox.setSelectedItem(0);
        }
        this.refreshFilterPane();
        this.refreshing = false;
    }

    private void refreshFilterPane() {
        GridBagConstraints gridBagConstraints;
        this.filterPane.removeAll();
        ArrayList<Table> tables = new ArrayList<Table>();
        if (this.selectedTable != null) {
            tables.add(this.selectedTable);
        } else {
            tables.addAll(this.getDataModel().getTables());
            Collections.sort(tables);
        }
        int y = 0;
        this.filterTextfieldsPerColumn.clear();
        for (final Table table : tables) {
            for (Column c : table.getColumns()) {
                String filter = c.getFilterExpression();
                if (filter == null && this.selectedTable == null) continue;
                JLabel label = new JLabel();
                if (this.selectedTable != null) {
                    label.setText(" T.");
                    label.setFont(this.nonBoldFont);
                    label.setForeground(Color.gray);
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = y;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.anchor = 17;
                    this.filterPane.add((Component)label, gridBagConstraints);
                }
                JPanel columnPanel = new JPanel();
                columnPanel.setLayout(new BorderLayout());
                label = new JLabel();
                final String columnName = (this.selectedTable == null ? " " + table.getUnqualifiedName() + "." : "") + c.name;
                label.setText(columnName);
                label.setFont(filter == null || this.selectedTable == null ? this.nonBoldFont : this.boldFont);
                boolean isPK = false;
                for (Column pk : table.primaryKey.getColumns()) {
                    if (!pk.equals(c)) continue;
                    isPK = true;
                    break;
                }
                if (isPK) {
                    label.setForeground(Color.RED);
                }
                columnPanel.add((Component)label, "West");
                label = new JLabel();
                label.setText(" " + c.toSQL(null).substring(c.name.length()) + " ");
                label.setForeground(Color.GRAY);
                label.setFont(filter == null || this.selectedTable == null ? this.nonBoldFont : this.boldFont);
                columnPanel.add((Component)label, "East");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 17;
                this.filterPane.add((Component)columnPanel, gridBagConstraints);
                label = new JLabel();
                label.setText(" :=  ");
                label.setFont(this.nonBoldFont);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 17;
                this.filterPane.add((Component)label, gridBagConstraints);
                final JTextField textField = new JTextField();
                textField.setText(filter == null ? "" : ConditionEditor.toSingleLine(filter));
                this.filterTextfieldsPerColumn.put(c, textField);
                label = new JLabel();
                label.setText(null);
                label.setIcon(this.conditionEditorIcon);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(1, 0, 0, 2);
                this.filterPane.add((Component)label, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = y++;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(1, 0, 0, 0);
                this.filterPane.add((Component)textField, gridBagConstraints);
                final JLabel theLabel = label;
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        FilterEditorDialog.this.conditionEditor.setTitle(columnName.trim());
                        String cond = FilterEditorDialog.this.conditionEditor.edit(textField.getText(), "Table", "T", table, null, null, null, false);
                        if (cond != null) {
                            if (!textField.getText().equals(ConditionEditor.toSingleLine(cond))) {
                                textField.setText(ConditionEditor.toSingleLine(cond));
                            }
                            theLabel.setIcon(FilterEditorDialog.this.conditionEditorIcon);
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent evt) {
                        theLabel.setIcon(FilterEditorDialog.this.conditionEditorSelectedIcon);
                    }

                    @Override
                    public void mouseExited(MouseEvent evt) {
                        theLabel.setIcon(FilterEditorDialog.this.conditionEditorIcon);
                    }
                });
            }
        }
        JLabel label = new JLabel();
        label.setText(y == 0 ? " no filter defined" : " ");
        label.setFont(this.nonBoldFont);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.filterPane.add((Component)label, gridBagConstraints);
        this.validate();
        this.repaint();
    }

    private void storeFilterExpressions() {
        for (Column c : this.filterTextfieldsPerColumn.keySet()) {
            String newFilter = ConditionEditor.toMultiLine(this.filterTextfieldsPerColumn.get(c).getText()).trim();
            if (newFilter.length() == 0) {
                newFilter = null;
            }
            c.setFilterExpression(newFilter);
        }
        ++this.getDataModel().version;
        this.parent.extractionModelEditor.refresh(false, false, true, true);
        this.parent.extractionModelEditor.markDirty();
    }

    private boolean needsSave() {
        for (Column c : this.filterTextfieldsPerColumn.keySet()) {
            String newFilter = ConditionEditor.toMultiLine(this.filterTextfieldsPerColumn.get(c).getText()).trim();
            if (newFilter.length() == 0) {
                newFilter = null;
            }
            if (c.getFilterExpression() == null && newFilter != null) {
                return true;
            }
            if (c.getFilterExpression() == null || c.getFilterExpression().equals(newFilter)) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.filterScrollPane = new JScrollPane();
        this.filterPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.tableBox = new JComboBox();
        this.jPanel2 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Filter Editor");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Filters"));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.filterScrollPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.filterPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.filterPane.setLayout(new GridBagLayout());
        this.filterScrollPane.setViewportView(this.filterPane);
        this.jPanel1.add(this.filterScrollPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText(" Table ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.tableBox.setMaximumRowCount(20);
        this.tableBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.tableBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterEditorDialog.this.tableBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 2);
        this.getContentPane().add((Component)this.tableBox, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.okButton.setText("  OK  ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterEditorDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterEditorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 20;
        this.jPanel2.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 13;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel2.setForeground(Color.gray);
        this.jLabel2.setText("as T ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.needsSave()) {
            this.storeFilterExpressions();
        }
        this.setVisible(false);
    }

    private void tableBoxItemStateChanged(ItemEvent evt) {
        if (this.tableBox.getSelectedItem() instanceof String) {
            Table table = this.getDataModel().getTableByDisplayName((String)this.tableBox.getSelectedItem());
            if (this.needsSave() && 0 == JOptionPane.showConfirmDialog(this, "Keep filter changes?", "", 0)) {
                this.storeFilterExpressions();
            }
            this.selectedTable = table;
            this.refreshFilterPane();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

