/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.PrintUtil;

public class FileView
extends JDialog {
    private JTextArea jTextPane = null;
    private JScrollPane jScrollPane = null;
    private static final long serialVersionUID = -8991473715127153931L;

    public FileView(Dialog owner) {
        super(owner);
        this.initialize();
        this.setModal(true);
        UIUtil.initPeer();
    }

    public FileView(Dialog owner, String file) throws FileNotFoundException, IOException {
        super(owner);
        this.setModal(true);
        try {
            this.initialize();
            this.setTitle(file);
            this.getJTextPane().setText(PrintUtil.loadFile(file));
            UIUtil.initPeer();
            this.setVisible(true);
        }
        catch (Throwable t) {
            UIUtil.showException(owner, "Error", t);
        }
    }

    private void initialize() {
        this.setSize(new Dimension(700, 600));
        this.setContentPane(this.getJScrollPane());
        this.setTitle("Jailer");
        this.setLocation(100, 100);
        this.getJTextPane().setFont(new Font("Monospaced", 0, 12));
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextPane());
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextPane() {
        if (this.jTextPane == null) {
            this.jTextPane = new JTextArea();
            this.jTextPane.setLineWrap(false);
        }
        return this.jTextPane;
    }
}

