/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import jsyntaxpane.DefaultSyntaxKit;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.DDLCreator;
import net.sf.jailer.Jailer;
import net.sf.jailer.ScriptFormat;
import net.sf.jailer.database.DMLTransformer;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.TemporaryTableScope;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.extractionmodel.ExtractionModel;
import net.sf.jailer.modelbuilder.ModelBuilder;
import net.sf.jailer.render.HtmlDataModelRenderer;
import net.sf.jailer.ui.About;
import net.sf.jailer.ui.AnalyseOptionsDialog;
import net.sf.jailer.ui.BrowserLauncher;
import net.sf.jailer.ui.ClosureBorderDialog;
import net.sf.jailer.ui.ClosureView;
import net.sf.jailer.ui.CyclesView;
import net.sf.jailer.ui.DataModelEditor;
import net.sf.jailer.ui.DataModelManager;
import net.sf.jailer.ui.DataModelManagerDialog;
import net.sf.jailer.ui.DbConnectionDialog;
import net.sf.jailer.ui.ExportDialog;
import net.sf.jailer.ui.ExtractionModelEditor;
import net.sf.jailer.ui.FilterEditorDialog;
import net.sf.jailer.ui.ParameterSelector;
import net.sf.jailer.ui.ProgressPanel;
import net.sf.jailer.ui.ProgressTable;
import net.sf.jailer.ui.RestrictedDependenciesListDialog;
import net.sf.jailer.ui.UIProgressListener;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.ui.databrowser.DataBrowser;
import net.sf.jailer.ui.graphical_view.LayoutStorage;

public class ExtractionModelFrame
extends JFrame {
    ExtractionModelEditor extractionModelEditor;
    private DbConnectionDialog dbConnectionDialog;
    private final FilterEditorDialog filterEditorDialog;
    final ClosureView closureView;
    final ClosureBorderDialog closureBorderView;
    final ClosureBorderDialog restrictedDependenciesView;
    final CyclesView cycleViewDialog;
    private static final String PLAFSETTING = ".plaf2.ui";
    private static final String ORIENTATIONSETTING = ".orientation.ui";
    public int animationStepTime = 0;
    boolean isHorizontalLayout = false;
    private JMenuItem closureBorderToolMenuItem;
    private JMenuItem closureMenuItem;
    private JMenuItem closureToolMenuItem;
    private JMenuItem collapseAll;
    private JCheckBoxMenuItem connectDb;
    private JMenuItem cycleView;
    private JMenuItem dataExport;
    private JMenuItem dataImport;
    private JMenuItem disconnectDb;
    private JMenu editMenu;
    private JPanel editorPanel;
    private JMenuItem exit;
    private JMenuItem expandAll;
    private JMenuItem expandAllVisible;
    private JMenuItem exportDisplay;
    private JMenu fileMenu;
    private JMenuItem helpContent;
    private JMenuItem helpForum;
    private JCheckBoxMenuItem horizontalLayoutMenuItem;
    private JMenuItem ignoreAll;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar2;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JMenuItem load;
    private JMenuItem newModel;
    private JMenuItem openDataBrowserItem;
    private JMenuItem openDataModelEditor;
    private JMenuItem queryBuilder;
    private JMenuItem refresh;
    private JMenuItem removeAllRestrictions;
    private JMenuItem renderHtml;
    private JMenuItem restrictedDependenciesToolMenuItem;
    private JMenuItem save;
    private JMenuItem saveAs;
    private JCheckBoxMenuItem showIgnored;
    private JMenuItem showReachability;
    private JCheckBoxMenuItem showTableDetails;
    private JRadioButtonMenuItem steptime0;
    private JRadioButtonMenuItem steptime10;
    private JRadioButtonMenuItem steptime100;
    private JRadioButtonMenuItem steptime20;
    private JRadioButtonMenuItem steptime200;
    private JRadioButtonMenuItem steptime30;
    private JRadioButtonMenuItem steptime50;
    private JRadioButtonMenuItem steptime500;
    private JRadioButtonMenuItem steptime75;
    private ButtonGroup steptimeGroup;
    private JMenuItem tutorial;
    private JMenuItem updateDataModel;
    private JMenu view;
    private JMenu viewMenu;
    private JMenuItem zoomToFit;
    private static final long serialVersionUID = -2252377308370736756L;

    public ExtractionModelFrame(String extractionModelFile, boolean isHorizonal) {
        this.initComponents();
        this.initAnimationSteptime();
        this.isHorizontalLayout = isHorizonal;
        this.horizontalLayoutMenuItem.setSelected(this.isHorizontalLayout);
        this.extractionModelEditor = new ExtractionModelEditor(extractionModelFile, this, this.isHorizontalLayout, this.getConnectivityState(), this.getConnectivityStateToolTip());
        this.editorPanel.add((Component)this.extractionModelEditor, "editor");
        this.extractionModelEditor.extractionModelFile = extractionModelFile;
        this.pack();
        this.updateTitle(this.extractionModelEditor.needsSave);
        this.dbConnectionDialog = new DbConnectionDialog((Frame)this, "Jailer", null);
        this.view.setVisible(false);
        try {
            for (final UIManager.LookAndFeelInfo lfInfo : UIManager.getInstalledLookAndFeels()) {
                JMenuItem mItem = new JMenuItem();
                mItem.setText(lfInfo.getName());
                this.view.add(mItem);
                mItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        ExtractionModelFrame.this.setPLAF(lfInfo.getClassName());
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateMenuItems();
        this.closureView = new ClosureView(this);
        this.closureBorderView = new ClosureBorderDialog(this, true){
            private static final long serialVersionUID = -7426280043553389753L;

            @Override
            protected Table getRoot() {
                return ExtractionModelFrame.this.extractionModelEditor == null ? null : ExtractionModelFrame.this.extractionModelEditor.root;
            }

            @Override
            protected DataModel getDataModel() {
                return ExtractionModelFrame.this.extractionModelEditor == null ? null : ExtractionModelFrame.this.extractionModelEditor.dataModel;
            }

            @Override
            protected void removeRestrictions(Collection<Association> associations) {
                if (ExtractionModelFrame.this.extractionModelEditor != null) {
                    ExtractionModelFrame.this.extractionModelEditor.removeRestrictions(associations);
                }
            }

            @Override
            protected void onSelect(Association association) {
                ExtractionModelFrame.this.extractionModelEditor.select(association);
            }
        };
        this.restrictedDependenciesView = new RestrictedDependenciesListDialog(this){
            private static final long serialVersionUID = -7426280043553389753L;

            @Override
            protected Table getRoot() {
                return ExtractionModelFrame.this.extractionModelEditor == null ? null : ExtractionModelFrame.this.extractionModelEditor.root;
            }

            @Override
            protected DataModel getDataModel() {
                return ExtractionModelFrame.this.extractionModelEditor == null ? null : ExtractionModelFrame.this.extractionModelEditor.dataModel;
            }

            @Override
            protected void removeRestrictions(Collection<Association> associations) {
                if (ExtractionModelFrame.this.extractionModelEditor != null) {
                    ExtractionModelFrame.this.extractionModelEditor.removeRestrictions(associations);
                }
            }

            @Override
            protected void onSelect(Association association) {
                ExtractionModelFrame.this.extractionModelEditor.select(association);
            }
        };
        this.cycleViewDialog = new CyclesView(this);
        this.filterEditorDialog = new FilterEditorDialog(this, new ParameterSelector.ParametersGetter(){

            @Override
            public Set<String> getParameters() {
                return ExtractionModelFrame.this.extractionModelEditor.dataModel.getParameters(ExtractionModelFrame.this.extractionModelEditor.condition.getText());
            }
        });
    }

    private void updateMenuItems() {
        this.connectDb.setSelected(this.dbConnectionDialog.isConnected);
        this.extractionModelEditor.connectivityState.setText(this.getConnectivityState());
        this.extractionModelEditor.connectivityState.setToolTipText(this.getConnectivityStateToolTip());
    }

    private String getConnectivityState() {
        if (this.dbConnectionDialog != null && this.dbConnectionDialog.isConnected) {
            return this.dbConnectionDialog.currentConnection.user + "@" + this.dbConnectionDialog.currentConnection.alias;
        }
        return "offline";
    }

    private String getConnectivityStateToolTip() {
        if (this.dbConnectionDialog != null && this.dbConnectionDialog.isConnected) {
            return this.dbConnectionDialog.currentConnection.url;
        }
        return "offline";
    }

    public void openFilterEditor(Table table) {
        this.filterEditorDialog.open(table);
    }

    private void initComponents() {
        this.steptimeGroup = new ButtonGroup();
        this.editorPanel = new JPanel();
        this.jMenuBar2 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newModel = new JMenuItem();
        this.load = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.save = new JMenuItem();
        this.saveAs = new JMenuItem();
        this.exportDisplay = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.connectDb = new JCheckBoxMenuItem();
        this.disconnectDb = new JMenuItem();
        this.jSeparator10 = new JSeparator();
        this.exit = new JMenuItem();
        this.editMenu = new JMenu();
        this.ignoreAll = new JMenuItem();
        this.removeAllRestrictions = new JMenuItem();
        this.jSeparator12 = new JSeparator();
        this.jMenuItem2 = new JMenuItem();
        this.viewMenu = new JMenu();
        this.collapseAll = new JMenuItem();
        this.expandAll = new JMenuItem();
        this.expandAllVisible = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.refresh = new JMenuItem();
        this.showReachability = new JMenuItem();
        this.zoomToFit = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.closureMenuItem = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.showIgnored = new JCheckBoxMenuItem();
        this.showTableDetails = new JCheckBoxMenuItem();
        this.jSeparator11 = new JSeparator();
        this.horizontalLayoutMenuItem = new JCheckBoxMenuItem();
        this.view = new JMenu();
        this.jMenu4 = new JMenu();
        this.steptime0 = new JRadioButtonMenuItem();
        this.steptime10 = new JRadioButtonMenuItem();
        this.steptime20 = new JRadioButtonMenuItem();
        this.steptime30 = new JRadioButtonMenuItem();
        this.steptime50 = new JRadioButtonMenuItem();
        this.steptime75 = new JRadioButtonMenuItem();
        this.steptime100 = new JRadioButtonMenuItem();
        this.steptime200 = new JRadioButtonMenuItem();
        this.steptime500 = new JRadioButtonMenuItem();
        this.jMenu1 = new JMenu();
        this.updateDataModel = new JMenuItem();
        this.openDataModelEditor = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.dataExport = new JMenuItem();
        this.dataImport = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.openDataBrowserItem = new JMenuItem();
        this.closureToolMenuItem = new JMenuItem();
        this.closureBorderToolMenuItem = new JMenuItem();
        this.queryBuilder = new JMenuItem();
        this.cycleView = new JMenuItem();
        this.restrictedDependenciesToolMenuItem = new JMenuItem();
        this.renderHtml = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.helpContent = new JMenuItem();
        this.tutorial = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.helpForum = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.jMenuItem1 = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("Extraction Model Editor");
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                ExtractionModelFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
                ExtractionModelFrame.this.formWindowLostFocus(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExtractionModelFrame.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.editorPanel.setLayout(new CardLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.editorPanel, gridBagConstraints);
        this.fileMenu.setText("File");
        this.fileMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.fileMenuActionPerformed(evt);
            }
        });
        this.newModel.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newModel.setText("New");
        this.newModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.newModelActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newModel);
        this.load.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.load.setText("Load");
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.loadActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.load);
        this.fileMenu.add(this.jSeparator1);
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.save.setText("Save");
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.saveActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.save);
        this.saveAs.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.saveAs.setText("Save as...");
        this.saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.saveAsActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAs);
        this.exportDisplay.setText("Export graph as image");
        this.exportDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.exportDisplayActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportDisplay);
        this.fileMenu.add(this.jSeparator2);
        this.connectDb.setText("Connect database");
        this.connectDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.connectDbActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.connectDb);
        this.disconnectDb.setText("Disconnect");
        this.disconnectDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.disconnectDbActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.disconnectDb);
        this.fileMenu.add(this.jSeparator10);
        this.exit.setText("Exit");
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.exitActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exit);
        this.jMenuBar2.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.ignoreAll.setActionCommand("Disable all associations");
        this.ignoreAll.setLabel("Disable all associations");
        this.ignoreAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.ignoreAllActionPerformed(evt);
            }
        });
        this.editMenu.add(this.ignoreAll);
        this.removeAllRestrictions.setLabel("Remove all restrictions");
        this.removeAllRestrictions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.removeAllRestrictionsActionPerformed(evt);
            }
        });
        this.editMenu.add(this.removeAllRestrictions);
        this.editMenu.add(this.jSeparator12);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.jMenuItem2.setText("Filter editor...");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem2);
        this.jMenuBar2.add(this.editMenu);
        this.viewMenu.setText("View");
        this.collapseAll.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.collapseAll.setText("Collapse all");
        this.collapseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.collapseAllActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.collapseAll);
        this.expandAll.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.expandAll.setLabel("Expand all");
        this.expandAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.expandAllActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.expandAll);
        this.expandAllVisible.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.expandAllVisible.setText("Expand all visible tables");
        this.expandAllVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.expandAllVisibleActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.expandAllVisible);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jMenuItem3.setText("Fix all");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.jMenuItem3);
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.jMenuItem4.setText("Unfix all");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.jMenuItem4);
        this.refresh.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.refresh.setText("Reset");
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.refreshActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.refresh);
        this.showReachability.setText("Show reachability of selected table");
        this.showReachability.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.showReachabilityActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.showReachability);
        this.zoomToFit.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.zoomToFit.setText("Zoom to fit");
        this.zoomToFit.setVerifyInputWhenFocusTarget(false);
        this.zoomToFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.zoomToFitActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.zoomToFit);
        this.viewMenu.add(this.jSeparator4);
        this.closureMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.closureMenuItem.setText("Open closure browser");
        this.closureMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.closureMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.closureMenuItem);
        this.viewMenu.add(this.jSeparator9);
        this.showIgnored.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.showIgnored.setText("Show disabled associations");
        this.showIgnored.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.showIgnoredActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.showIgnored);
        this.showTableDetails.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.showTableDetails.setText("Show table details");
        this.showTableDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.showTableDetailsActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.showTableDetails);
        this.viewMenu.add(this.jSeparator11);
        this.horizontalLayoutMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.horizontalLayoutMenuItem.setSelected(true);
        this.horizontalLayoutMenuItem.setText("Horizontal layout");
        this.horizontalLayoutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.horizontalLayoutMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.horizontalLayoutMenuItem);
        this.view.setLabel("Look&Feel");
        this.viewMenu.add(this.view);
        this.jMenu4.setText("Animation step time");
        this.steptimeGroup.add(this.steptime0);
        this.steptime0.setSelected(true);
        this.steptime0.setText("default");
        this.steptime0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime0ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime0);
        this.steptimeGroup.add(this.steptime10);
        this.steptime10.setText("10");
        this.steptime10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime10ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime10);
        this.steptimeGroup.add(this.steptime20);
        this.steptime20.setText("20");
        this.steptime20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime20ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime20);
        this.steptimeGroup.add(this.steptime30);
        this.steptime30.setText("30");
        this.steptime30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime30ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime30);
        this.steptimeGroup.add(this.steptime50);
        this.steptime50.setText("50");
        this.steptime50.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime50ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime50);
        this.steptimeGroup.add(this.steptime75);
        this.steptime75.setText("75");
        this.steptime75.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime75ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime75);
        this.steptimeGroup.add(this.steptime100);
        this.steptime100.setText("100");
        this.steptime100.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime100ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime100);
        this.steptimeGroup.add(this.steptime200);
        this.steptime200.setText("200");
        this.steptime200.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime200ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime200);
        this.steptimeGroup.add(this.steptime500);
        this.steptime500.setText("500");
        this.steptime500.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.steptime500ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.steptime500);
        this.viewMenu.add(this.jMenu4);
        this.jMenuBar2.add(this.viewMenu);
        this.jMenu1.setText("DataModel");
        this.updateDataModel.setText("Analyze Database");
        this.updateDataModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.updateDataModelActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.updateDataModel);
        this.openDataModelEditor.setLabel("Data Model Editor");
        this.openDataModelEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.openDataModelEditorActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.openDataModelEditor);
        this.jMenuBar2.add(this.jMenu1);
        this.jMenu3.setText("Tools");
        this.dataExport.setLabel("Export Data");
        this.dataExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.dataExportActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.dataExport);
        this.dataImport.setLabel("Import SQL Data");
        this.dataImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.dataImportActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.dataImport);
        this.jMenu3.add(this.jSeparator5);
        this.openDataBrowserItem.setText("Data Browser");
        this.openDataBrowserItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.openDataBrowserItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.openDataBrowserItem);
        this.closureToolMenuItem.setText("Closure Browser");
        this.closureToolMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.closureToolMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.closureToolMenuItem);
        this.closureBorderToolMenuItem.setText("Closure Border Browser");
        this.closureBorderToolMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.closureBorderToolMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.closureBorderToolMenuItem);
        this.queryBuilder.setText("Query Builder");
        this.queryBuilder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.queryBuilderActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.queryBuilder);
        this.cycleView.setText("Cycle View");
        this.cycleView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.cycleViewActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.cycleView);
        this.restrictedDependenciesToolMenuItem.setText("Restricted Dependencies View");
        this.restrictedDependenciesToolMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.restrictedDependenciesToolMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.restrictedDependenciesToolMenuItem);
        this.renderHtml.setText("HTML Rendering");
        this.renderHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.renderHtmlActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.renderHtml);
        this.jMenuBar2.add(this.jMenu3);
        this.jMenu2.setText("Help");
        this.helpContent.setText("Manual");
        this.helpContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.helpContentActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.helpContent);
        this.tutorial.setLabel("Tutorial");
        this.tutorial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.tutorialActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.tutorial);
        this.jMenu2.add(this.jSeparator7);
        this.helpForum.setLabel("Help Forum");
        this.helpForum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.helpForumActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.helpForum);
        this.jMenu2.add(this.jSeparator8);
        this.jMenuItem1.setText("About Jailer");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem1);
        this.jMenuBar2.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar2);
        this.pack();
    }

    private void formWindowLostFocus(WindowEvent evt) {
    }

    private void formWindowGainedFocus(WindowEvent evt) {
    }

    private void closureMenuItemActionPerformed(ActionEvent evt) {
        this.openClosureView(this.extractionModelEditor.root);
    }

    private void queryBuilderActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.graphView.openQueryBuilder(this.extractionModelEditor.root, true);
    }

    private void expandAllVisibleActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.expandAllVisibleTables();
    }

    private void showTableDetailsActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.graphView.updateTableDetailsMode();
    }

    private void helpForumActionPerformed(ActionEvent evt) {
        try {
            BrowserLauncher.openURL(new URI("https://sourceforge.net/forum/?group_id=197260"));
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void zoomToFitActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.zoomToFit();
    }

    private void tutorialActionPerformed(ActionEvent evt) {
        try {
            BrowserLauncher.openURL(new URI("http://jailer.sourceforge.net/doc/exporting-data.htm"));
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void helpContentActionPerformed(ActionEvent evt) {
        try {
            BrowserLauncher.openURL(new URI("http://jailer.sourceforge.net/doc/home.htm"));
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void removeAllRestrictionsActionPerformed(ActionEvent evt) {
        if (0 == JOptionPane.showConfirmDialog(this, "Remove all restrictions?", "Remove restrictions", 0, 3)) {
            this.extractionModelEditor.removeAllRestrictions(null);
        }
    }

    private void ignoreAllActionPerformed(ActionEvent evt) {
        if (0 == JOptionPane.showConfirmDialog(this, "Disable each association (except dependencies)?", "Add restrictions", 0, 3)) {
            this.extractionModelEditor.ignoreAll(null);
        }
    }

    private void dataImportActionPerformed(ActionEvent evt) {
        try {
            String sqlFile = UIUtil.choseFile(null, ".", "Data Import", ".sql", this, false, true);
            if (sqlFile != null) {
                this.disconnect();
                if (this.connectToDBIfNeeded("Data Import")) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("import");
                    args.add(sqlFile);
                    this.dbConnectionDialog.addDbArgs(args);
                    this.disconnect();
                    UIUtil.runJailer(this, args, false, true, false, false, null, this.dbConnectionDialog.getPassword(), null, null, false, true, false);
                }
            }
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    public boolean showDisabledAssociations() {
        return !this.hideIgnored();
    }

    public void openClosureView(Table tableToSelect) {
        this.closureView.refresh(tableToSelect);
        this.closureView.setVisible(true);
        this.closureView.toFront();
    }

    public void openDataBrowser(Table root, String condition) {
        if (this.dbConnectionDialog.isConnected || this.dbConnectionDialog.connect("Data Browser")) {
            this.updateMenuItems();
            try {
                DataBrowser dataBrowser = new DataBrowser(this.extractionModelEditor.dataModel, root, condition, this.dbConnectionDialog, true);
                dataBrowser.setDefaultCloseOperation(2);
                dataBrowser.setVisible(true);
            }
            catch (Exception e) {
                UIUtil.showException(this, "Error", e);
            }
        }
    }

    private void setPLAF(String plaf) {
        try {
            UIManager.setLookAndFeel(plaf);
            SwingUtilities.updateComponentTreeUI(this);
            try {
                File file = new File(PLAFSETTING);
                file.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                File plafSetting = new File(PLAFSETTING);
                PrintWriter out = new PrintWriter(plafSetting);
                out.println(plaf);
                out.close();
            }
            catch (Exception x) {}
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void storeOrientation() {
        try {
            try {
                File file = new File(ORIENTATIONSETTING);
                file.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                File setting = new File(ORIENTATIONSETTING);
                PrintWriter out = new PrintWriter(setting);
                out.println(this.isHorizontalLayout);
                out.close();
            }
            catch (Exception x) {}
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void openDataModelEditorActionPerformed(ActionEvent evt) {
        this.openDataModelEditor(null);
    }

    private void openDataModelEditor(Table toEdit) {
        try {
            if (this.saveIfNeeded("edit data model", true)) {
                String modelname = this.extractionModelEditor.dataModel == null ? "New Model" : this.extractionModelEditor.dataModel.getName();
                DataModelEditor dataModelEditor = new DataModelEditor(this, false, false, toEdit, null, null, modelname, null);
                dataModelEditor.setVisible(true);
                this.reload();
                ExtractionModelFrame.askForDataModel(this);
                this.closureBorderView.refresh();
                this.restrictedDependenciesView.refresh();
            }
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataModelActionPerformed(ActionEvent evt) {
        block14: {
            try {
                if (!this.saveIfNeeded("Analyze Database", true)) break block14;
                if (this.connectToDBIfNeeded("Analyze Database")) {
                    List<String> schemas;
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("build-model");
                    this.dbConnectionDialog.addDbArgs(args);
                    AnalyseOptionsDialog analyseOptionsDialog = new AnalyseOptionsDialog((Frame)this, this.extractionModelEditor.dataModel);
                    boolean[] isDefaultSchema = new boolean[1];
                    String[] defaultSchema = new String[1];
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        schemas = this.dbConnectionDialog.getDBSchemas(defaultSchema);
                    }
                    finally {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    if (analyseOptionsDialog.edit(schemas, defaultSchema[0], isDefaultSchema, this.dbConnectionDialog.currentConnection.user)) {
                        String schema = analyseOptionsDialog.getSelectedSchema();
                        if (schema != null) {
                            args.add("-schema");
                            args.add(schema);
                        }
                        if (!isDefaultSchema[0]) {
                            args.add("-qualifyNames");
                        }
                        ModelBuilder.assocFilter = analyseOptionsDialog.getAssociationLineFilter();
                        if (UIUtil.runJailer(this, args, false, true, false, true, null, this.dbConnectionDialog.getPassword(), null, null, false, true, false)) {
                            ModelBuilder.assocFilter = null;
                            String modelname = this.extractionModelEditor.dataModel == null ? "New Model" : this.extractionModelEditor.dataModel.getName();
                            DataModelEditor dataModelEditor = new DataModelEditor(this, true, analyseOptionsDialog.isRemoving(), null, analyseOptionsDialog.getTableLineFilter(), analyseOptionsDialog.getAssociationLineFilter(), modelname, schema == null ? this.dbConnectionDialog.getName() : schema);
                            if (dataModelEditor.dataModelHasChanged()) {
                                dataModelEditor.setVisible(true);
                            }
                            this.reload();
                            ExtractionModelFrame.askForDataModel(this);
                        }
                    }
                }
                ExtractionModelFrame.askForDataModel(this);
            }
            catch (Exception e) {
                UIUtil.showException(this, "Error", e);
            }
            finally {
                ModelBuilder.assocFilter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dataExportActionPerformed(ActionEvent evt) {
        block15: {
            try {
                Association restrictedDependency;
                if (this.extractionModelEditor.dataModel != null && !ScriptFormat.XML.equals((Object)this.extractionModelEditor.scriptFormat) && (restrictedDependency = this.findRestrictedDependency(this.extractionModelEditor.dataModel)) != null) {
                    switch (JOptionPane.showOptionDialog(this, "Dependency from '" + restrictedDependency.source.getName() + "' to '" + restrictedDependency.destination.getName() + "'\n" + "is restricted.\nReferential integrity is not guaranteed!", "Restricted Dependency", 0, 1, null, new Object[]{"Ok", "Cancel", "Show Dependency"}, "Cancel")) {
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.restrictedDependenciesView.setVisible(true);
                            this.restrictedDependenciesView.toFront();
                            return;
                        }
                    }
                }
                if (this.extractionModelEditor.subject == null) {
                    ExtractionModelFrame.askForDataModel(this);
                    return;
                }
                if (this.extractionModelEditor.dataModel != null) {
                    this.extractionModelEditor.dataModel.checkForPrimaryKey(this.extractionModelEditor.subject, false);
                }
                if (!this.saveIfNeeded("Export data", false) || this.extractionModelEditor.extractionModelFile == null && !this.extractionModelEditor.save(true, "Export data") || !this.connectToDBIfNeeded("Export data")) break block15;
                ArrayList<String> args = new ArrayList<String>();
                args.add("export");
                args.add(this.extractionModelEditor.extractionModelFile);
                this.dbConnectionDialog.addDbArgs(args);
                Session.closeTemporaryTableSession();
                Session session = new Session(this.dbConnectionDialog.currentConnection.driverClass, this.dbConnectionDialog.currentConnection.url, this.dbConnectionDialog.currentConnection.user, this.dbConnectionDialog.getPassword());
                ExportDialog exportDialog = new ExportDialog(this, this.extractionModelEditor.dataModel, this.extractionModelEditor.getSubject(), this.extractionModelEditor.getSubjectCondition(), session, args, this.dbConnectionDialog.getPassword());
                session.shutDown();
                Session.closeTemporaryTableSession();
                if (!exportDialog.isOk()) break block15;
                exportDialog.fillCLIArgs(args);
                ArrayList<String> ddlArgs = new ArrayList<String>();
                ddlArgs.add("create-ddl");
                this.dbConnectionDialog.addDbArgs(ddlArgs);
                DMLTransformer.numberOfExportedLOBs = 0L;
                String tableInConflict = DDLCreator.getTableInConflict((String)ddlArgs.get(1), (String)ddlArgs.get(2), (String)ddlArgs.get(3), (String)ddlArgs.get(4));
                if (tableInConflict != null && exportDialog.getTemporaryTableScope().equals((Object)TemporaryTableScope.GLOBAL)) {
                    JOptionPane.showMessageDialog(this, "Can't drop table '" + tableInConflict + "' as it is not created by Jailer.\nDrop or rename this table first.", "Error", 0);
                    break block15;
                }
                if (exportDialog.getTemporaryTableScope().equals((Object)TemporaryTableScope.GLOBAL) && !DDLCreator.isUptodate((String)ddlArgs.get(1), (String)ddlArgs.get(2), (String)ddlArgs.get(3), (String)ddlArgs.get(4)) && !UIUtil.runJailer(this, ddlArgs, true, true, false, true, "Automatic creation of working-tables failed!\nPlease execute the Jailer-DDL manually (jailer_ddl.sql)\n\nContinue Data Export?", this.dbConnectionDialog.getPassword(), null, null, false, false, true)) break block15;
                ProgressTable progressTable = new ProgressTable();
                ProgressPanel progressPanel = new ProgressPanel(progressTable);
                UIProgressListener progressListener = new UIProgressListener(progressTable, progressPanel, this.extractionModelEditor.dataModel);
                try {
                    UIUtil.runJailer(this, args, true, true, exportDialog.explain.isSelected(), false, null, this.dbConnectionDialog.getPassword(), progressListener, progressPanel, true, true, false);
                }
                finally {
                    progressListener.stop();
                }
            }
            catch (Exception e) {
                if (e instanceof DataModel.NoPrimaryKeyException) {
                    if (JOptionPane.showOptionDialog(this, e.getMessage(), "No Primary Key", 0, 0, null, new Object[]{"Edit Table", "Cancel"}, null) == 0) {
                        this.openDataModelEditor(((DataModel.NoPrimaryKeyException)e).table);
                    }
                }
                UIUtil.showException(this, "Error", e);
            }
        }
    }

    private Association findRestrictedDependency(DataModel dataModel) {
        for (Association association : dataModel.namedAssociations.values()) {
            if (!association.isInsertDestinationBeforeSource() || !association.isRestricted()) continue;
            return association;
        }
        return null;
    }

    private void disconnectDbActionPerformed(ActionEvent evt) {
        this.disconnect();
    }

    private void disconnect() {
        this.dbConnectionDialog.isConnected = false;
        this.updateMenuItems();
    }

    private void connectDbActionPerformed(ActionEvent evt) {
        this.disconnect();
        this.connectToDBIfNeeded(null);
    }

    private void renderHtmlActionPerformed(ActionEvent evt) {
        this.openHTMLRender(null);
    }

    public void openHTMLRender(Table table) {
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("render-datamodel");
            File file = this.saveRestrictions();
            args.add(file.getName());
            UIUtil.runJailer(this, args, false, true, false, true, null, null, null, null, false, true, false);
            BrowserLauncher.openURL(table == null ? "render/index.html" : "render/" + HtmlDataModelRenderer.toFileName(table));
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    public void showShortestPath(Table from, Table to) {
        if (from != null && to != null) {
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add("find-association");
                args.add(from.getName());
                args.add(to.getName());
                File file = this.saveRestrictions();
                args.add(file.getName());
                UIUtil.runJailer(this, args, false, false, false, false, null, this.dbConnectionDialog.getPassword(), null, null, false, true, false);
            }
            catch (Exception e) {
                UIUtil.showException(this, "Error", e);
            }
        }
    }

    private File saveRestrictions() throws Exception {
        String extractionModelFile = this.extractionModelEditor.extractionModelFile;
        File file = extractionModelFile == null ? new File("tmp_restrictions.csv") : ((extractionModelFile = new File(extractionModelFile).getName()).toLowerCase().endsWith(".csv") ? new File(extractionModelFile.substring(0, extractionModelFile.length() - 4) + "-restrictions.csv") : new File(extractionModelFile + "-restrictions.csv"));
        this.extractionModelEditor.saveRestrictions(file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToDBIfNeeded(String reason) {
        try {
            if (!this.dbConnectionDialog.isConnected) {
                boolean bl = this.dbConnectionDialog.connect(reason);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.updateMenuItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDbConnectionDialogClone(DbConnectionDialog dbConnectionDialog) {
        try {
            this.dbConnectionDialog = new DbConnectionDialog((Frame)this, dbConnectionDialog, "Jailer");
        }
        finally {
            this.updateMenuItems();
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        About about = new About((Frame)this, true);
        about.setTitle("Jailer 5.0.2");
        about.pack();
        about.setLocation(this.getLocation().x + (this.getSize().width - about.getPreferredSize().width) / 2, this.getLocation().y + (this.getSize().height - about.getPreferredSize().height) / 2);
        about.setVisible(true);
    }

    private void loadActionPerformed(ActionEvent evt) {
        String modelFile;
        if (this.saveIfNeeded("loading", true) && (modelFile = UIUtil.choseFile(null, "extractionmodel", "Load Extraction Model", ".csv", this, true, true)) != null) {
            this.load(modelFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String modelFile) {
        try {
            String dmf = ExtractionModel.loadDatamodelFolder(modelFile);
            if (dmf == null && DataModelManager.getCurrentModelSubfolder() != null || dmf != null && !dmf.equals(DataModelManager.getCurrentModelSubfolder())) {
                JOptionPane.showMessageDialog(this, "Unable to load \"" + new File(modelFile).getName() + "\"\nExtraction model is assigned to data model \"" + (String)DataModelManager.getModelDetails((String)dmf).a + "\"", "Wrong Data Model", 0);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.extractionModelEditor.extractionModelFrame = null;
            this.editorPanel.remove(this.extractionModelEditor);
            this.extractionModelEditor = null;
            this.extractionModelEditor = new ExtractionModelEditor(modelFile, this, this.isHorizontalLayout, this.getConnectivityState(), this.getConnectivityStateToolTip());
            this.editorPanel.add((Component)this.extractionModelEditor, "editor");
            ((CardLayout)this.editorPanel.getLayout()).show(this.editorPanel, "editor");
            this.validate();
            this.closureBorderView.refresh();
            this.restrictedDependenciesView.refresh();
            this.updateTitle(this.extractionModelEditor.needsSave);
        }
        catch (Throwable t) {
            UIUtil.showException(this, "Error", t);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newModelActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.saveIfNeeded("creating new model", true)) {
                this.extractionModelEditor.extractionModelFrame = null;
                this.editorPanel.remove(this.extractionModelEditor);
                this.extractionModelEditor = null;
                this.extractionModelEditor = new ExtractionModelEditor(null, this, this.isHorizontalLayout, this.getConnectivityState(), this.getConnectivityStateToolTip());
                this.editorPanel.add((Component)this.extractionModelEditor, "editor");
                ((CardLayout)this.editorPanel.getLayout()).show(this.editorPanel, "editor");
                this.validate();
                this.closureBorderView.refresh();
                this.restrictedDependenciesView.refresh();
                this.updateTitle(this.extractionModelEditor.needsSave);
            }
        }
        catch (Throwable t) {
            UIUtil.showException(this, "Error", t);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.extractionModelEditor.extractionModelFrame = null;
            this.editorPanel.remove(this.extractionModelEditor);
            this.extractionModelEditor = new ExtractionModelEditor(this.extractionModelEditor.extractionModelFile, this, this.isHorizontalLayout, this.getConnectivityState(), this.getConnectivityStateToolTip());
            this.editorPanel.add((Component)this.extractionModelEditor, "editor");
            ((CardLayout)this.editorPanel.getLayout()).show(this.editorPanel, "editor");
            this.validate();
            this.closureBorderView.refresh();
            this.restrictedDependenciesView.refresh();
            this.updateTitle(this.extractionModelEditor.needsSave);
        }
        catch (Throwable t) {
            UIUtil.showException(this, "Error", t);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void expandAllActionPerformed(ActionEvent evt) {
        this.expandAll();
    }

    public void expandAll() {
        this.extractionModelEditor.expand();
    }

    private void showIgnoredActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.resetGraphEditor(false, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collapseAllActionPerformed(ActionEvent evt) {
        try {
            LayoutStorage.enabled = false;
            this.extractionModelEditor.refresh(false, true, false, true);
            this.extractionModelEditor.resetGraphEditor(true, false, true, true);
        }
        finally {
            LayoutStorage.enabled = true;
        }
    }

    private void refreshActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.refresh(false, true, false, false);
    }

    private void saveAsActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.save(true, null);
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.save(false, null);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.onExit();
    }

    private void exitActionPerformed(ActionEvent evt) {
        this.onExit();
    }

    private boolean saveIfNeeded(String cause, boolean ask) {
        if (!this.extractionModelEditor.needsSave) {
            return true;
        }
        if (ask) {
            int option = JOptionPane.showConfirmDialog(this, "Save changes before " + cause + "?", "", 1, 3);
            if (option == 2) {
                return false;
            }
            if (option == 1) {
                return true;
            }
        }
        return this.extractionModelEditor.save(false, cause);
    }

    private void onExit() {
        if (this.extractionModelEditor.needsSave) {
            if (0 == JOptionPane.showConfirmDialog(this, "Exit without saving?", "", 0, 3)) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.graphView.setFix(true);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.extractionModelEditor.graphView.setFix(false);
    }

    private void initAnimationSteptime() {
        try {
            BufferedReader in = new BufferedReader(new FileReader(".steptime"));
            try {
                this.animationStepTime = Integer.parseInt(in.readLine());
            }
            catch (Exception exception) {
                // empty catch block
            }
            in.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        switch (this.animationStepTime) {
            case 0: {
                this.steptime0.setSelected(true);
                break;
            }
            case 10: {
                this.steptime10.setSelected(true);
                break;
            }
            case 20: {
                this.steptime20.setSelected(true);
                break;
            }
            case 30: {
                this.steptime30.setSelected(true);
                break;
            }
            case 50: {
                this.steptime50.setSelected(true);
                break;
            }
            case 75: {
                this.steptime75.setSelected(true);
                break;
            }
            case 100: {
                this.steptime100.setSelected(true);
                break;
            }
            case 200: {
                this.steptime200.setSelected(true);
                break;
            }
            case 500: {
                this.steptime500.setSelected(true);
            }
        }
    }

    private void setAnimationSteptime(int steptime) {
        this.animationStepTime = steptime;
        try {
            FileWriter out = new FileWriter(".steptime");
            out.write("" + this.animationStepTime);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.extractionModelEditor.refresh(false, true, true, true);
    }

    private void steptime0ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(0);
    }

    private void steptime10ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(10);
    }

    private void steptime20ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(20);
    }

    private void steptime30ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(30);
    }

    private void steptime50ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(50);
    }

    private void steptime75ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(75);
    }

    private void steptime100ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(100);
    }

    private void steptime200ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(200);
    }

    private void steptime500ActionPerformed(ActionEvent evt) {
        this.setAnimationSteptime(500);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.openFilterEditor(null);
    }

    private void exportDisplayActionPerformed(ActionEvent evt) {
        try {
            this.extractionModelEditor.graphView.exportDisplayToImage();
        }
        catch (Throwable e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void horizontalLayoutMenuItemActionPerformed(ActionEvent evt) {
        this.isHorizontalLayout = !this.isHorizontalLayout;
        this.extractionModelEditor.setOrientation(this.isHorizontalLayout);
        this.horizontalLayoutMenuItem.setSelected(this.isHorizontalLayout);
        this.storeOrientation();
        this.jMenuBar2.grabFocus();
    }

    private void showReachabilityActionPerformed(ActionEvent evt) {
        if (this.extractionModelEditor.currentAssociation != null) {
            this.extractionModelEditor.showReachability(this.extractionModelEditor.currentAssociation.destination);
        }
    }

    private void cycleViewActionPerformed(ActionEvent evt) {
        this.cycleViewDialog.refresh();
        this.cycleViewDialog.toFront();
        this.cycleViewDialog.findCycles();
    }

    private void openDataBrowserItemActionPerformed(ActionEvent evt) {
        this.openDataBrowser(this.extractionModelEditor.root, "");
    }

    private void closureToolMenuItemActionPerformed(ActionEvent evt) {
        this.openClosureView(this.extractionModelEditor.root);
    }

    private void closureBorderToolMenuItemActionPerformed(ActionEvent evt) {
        this.closureBorderView.setVisible(true);
        this.closureBorderView.toFront();
    }

    private void restrictedDependenciesToolMenuItemActionPerformed(ActionEvent evt) {
        this.restrictedDependenciesView.setVisible(true);
        this.restrictedDependenciesView.toFront();
    }

    public void updateTitle(boolean needsSave) {
        if (this.extractionModelEditor == null) {
            return;
        }
        String title = "Jailer 5.0.2 Extraction Model Editor";
        title = this.extractionModelEditor.extractionModelFile == null ? "New Model - " + title : new File(this.extractionModelEditor.extractionModelFile).getName() + " - " + title;
        if (needsSave) {
            title = "*" + title;
        }
        this.setTitle(title);
    }

    boolean hideIgnored() {
        return !this.showIgnored.isSelected();
    }

    public boolean showTableDetails() {
        return this.showTableDetails.isSelected();
    }

    public static void customizeNimbus() {
        try {
            ToolTipManager.sharedInstance().setInitialDelay(400);
            ToolTipManager.sharedInstance().setDismissDelay(20000);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String configFileName = "jailer.xml";
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            JOptionPane.showMessageDialog(null, "File '" + configFileName + "' not found!", "Missing configuration file", 0);
            return;
        }
        try {
            Logger.getLogger("prefuse").setLevel(Level.OFF);
            new Jailer(1);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            CommandLineParser.parse(args, true);
        }
        catch (Exception e) {
            UIUtil.showException(null, "Illegal arguments", e);
        }
        try {
            File file = new File(DataModel.getDatamodelFolder());
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String plaf = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
                    UIManager.setLookAndFeel(plaf);
                    ExtractionModelFrame.customizeNimbus();
                }
                catch (Exception x) {
                    // empty catch block
                }
                try {
                    DefaultSyntaxKit.initKit();
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                String file = null;
                try {
                    if (CommandLineParser.getInstance().arguments != null && CommandLineParser.getInstance().arguments.size() > 0) {
                        file = CommandLineParser.getInstance().arguments.get(0);
                    }
                    final String finalFile = file;
                    if (file != null && new File(file).exists()) {
                        DataModelManager.setCurrentModelSubfolder(ExtractionModel.loadDatamodelFolder(file));
                        ExtractionModelFrame.createFrame(finalFile, true);
                    } else {
                        DataModelManagerDialog dataModelManagerDialog = new DataModelManagerDialog("Jailer 5.0.2 - Database Subsetting Tool"){
                            private static final long serialVersionUID = 1L;

                            @Override
                            protected void onSelect() {
                                ExtractionModelFrame extractionModelFrame = null;
                                try {
                                    final ExtractionModelFrame finalExtractionModelFrame = extractionModelFrame = ExtractionModelFrame.createFrame(finalFile, true);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                ExtractionModelFrame.askForDataModel(finalExtractionModelFrame);
                                            }
                                            catch (Exception e) {
                                                UIUtil.showException(finalExtractionModelFrame, "Error", e);
                                            }
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    UIUtil.showException(extractionModelFrame, "Error", e);
                                }
                            }
                        };
                        dataModelManagerDialog.setVisible(true);
                    }
                }
                catch (Exception e) {
                    UIUtil.showException(null, "Error", e);
                }
            }
        });
    }

    private static void askForDataModel(ExtractionModelFrame extractionModelFrame) throws Exception {
        if (extractionModelFrame.extractionModelEditor == null || extractionModelFrame.extractionModelEditor.dataModel == null || extractionModelFrame.extractionModelEditor.dataModel.getTables().isEmpty()) {
            switch (JOptionPane.showOptionDialog(extractionModelFrame, "Data model \"" + (String)DataModelManager.getModelDetails((String)DataModelManager.getCurrentModelSubfolder()).a + "\" is empty.", "Jailer 5.0.2", 0, 1, null, new Object[]{"Analyze Database", "Data Model Editor"}, null)) {
                case 0: {
                    extractionModelFrame.updateDataModelActionPerformed(null);
                    break;
                }
                case 1: {
                    extractionModelFrame.openDataModelEditorActionPerformed(null);
                }
            }
        } else if (!new File(DataModel.getColumnsFile()).exists()) {
            switch (JOptionPane.showOptionDialog(extractionModelFrame, "No column definition found.", "Jailer 5.0.2", 0, 1, null, new Object[]{"Analyze Database", "Data Model Editor"}, null)) {
                case 0: {
                    extractionModelFrame.updateDataModelActionPerformed(null);
                    break;
                }
                case 1: {
                    extractionModelFrame.openDataModelEditorActionPerformed(null);
                }
            }
        }
        if (extractionModelFrame.closureBorderView != null) {
            extractionModelFrame.closureBorderView.refresh();
        }
        if (extractionModelFrame.restrictedDependenciesView != null) {
            extractionModelFrame.restrictedDependenciesView.refresh();
        }
    }

    public static ExtractionModelFrame createFrame(String file, boolean maximize) {
        boolean isHorizonal = false;
        try {
            File setting = new File(ORIENTATIONSETTING);
            BufferedReader in = new BufferedReader(new FileReader(setting));
            String or = in.readLine();
            in.close();
            isHorizonal = Boolean.valueOf(or);
        }
        catch (Exception x) {
            // empty catch block
        }
        ExtractionModelFrame extractionModelFrame = new ExtractionModelFrame(file, isHorizonal);
        try {
            extractionModelFrame.setIconImage(new ImageIcon(extractionModelFrame.getClass().getResource("/net/sf/jailer/resource/jailer.png")).getImage());
        }
        catch (Throwable t) {
            try {
                extractionModelFrame.setIconImage(new ImageIcon(extractionModelFrame.getClass().getResource("/net/sf/jailer/resource/jailer.gif")).getImage());
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        extractionModelFrame.setLocation(40, 40);
        extractionModelFrame.setSize(1100, 640);
        extractionModelFrame.setVisible(true);
        if (maximize) {
            extractionModelFrame.setExtendedState(6);
        }
        return extractionModelFrame;
    }

    public void markDirty() {
        this.extractionModelEditor.markDirty();
    }
}

