/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.ScriptFormat;
import net.sf.jailer.datamodel.AggregationSchema;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.ModelElement;
import net.sf.jailer.datamodel.ParameterHandler;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.extractionmodel.ExtractionModel;
import net.sf.jailer.ui.ColumnMapperDialog;
import net.sf.jailer.ui.ConditionEditor;
import net.sf.jailer.ui.ExtractionModelFrame;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.ParameterSelector;
import net.sf.jailer.ui.RestrictionDefinition;
import net.sf.jailer.ui.RestrictionEditor;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.ui.XmlSettingsDialog;
import net.sf.jailer.ui.XmlSketchBuilder;
import net.sf.jailer.ui.graphical_view.AssociationRenderer;
import net.sf.jailer.ui.graphical_view.GraphicalDataModelView;
import net.sf.jailer.ui.graphical_view.LayoutStorage;
import net.sf.jailer.ui.scrollmenu.JScrollPopupMenu;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.SqlUtil;

public class ExtractionModelEditor
extends JPanel {
    public RestrictionEditor restrictionEditor;
    private ExtractionModel extractionModel;
    DataModel dataModel;
    private Set<Table> currentSubjectClosure = null;
    private long closureVersion = -1L;
    Table subject;
    Table root;
    private Map<Association, Association> representant;
    private Map<ModelElement, DefaultMutableTreeNode> toNode;
    private DefaultTreeModel treeModel;
    private Collection<DefaultMutableTreeNode> treeNodes;
    private boolean suppressRestrictionSelection = false;
    boolean needsSave = false;
    public ExtractionModelFrame extractionModelFrame;
    private final ColumnMapperDialog columnMapperDialog;
    String extractionModelFile;
    GraphicalDataModelView graphView;
    public ScriptFormat scriptFormat = ScriptFormat.SQL;
    private boolean isHorizontalLayout = false;
    private ConditionEditor subjectConditionEditor;
    private ConditionEditor restrictionConditionEditor;
    private XmlSettingsDialog xmlSettingsDialog;
    private List<RestrictionDefinition> currentRestrictionDefinitions;
    Association currentAssociation;
    private DefaultMutableTreeNode currentNode;
    private String initialRestrictionCondition = null;
    private MouseAdapter maA;
    private MouseAdapter maB;
    private Set<Association> ambiguousNonames = null;
    private javax.swing.JComboBox aggregationCombobox;
    private JLabel associatedWith;
    JTextField condition;
    public JLabel connectivityState;
    private JLabel dependsOn;
    private JPanel editorPanel;
    public JButton exportButton;
    private javax.swing.JComboBox exportFormat;
    private JPanel graphContainer;
    private JLabel hasDependent;
    private JLabel ignored;
    private JPanel inspectorHolder;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JPanel legende;
    private JPanel legende1;
    private JPanel legende2;
    private JButton mapColumns;
    private JLabel modelName;
    private JLabel modelPath;
    private JButton openClosureView;
    private JButton openDataBrowser;
    private JLabel openSubjectConditionEditor;
    private JButton openXmlSettings;
    private JTable restrictionsTable;
    private javax.swing.JComboBox rootTable;
    private javax.swing.JComboBox subjectTable;
    private JTextField tagField;
    private JTree tree;
    private JPanel xmlMappingPanel;
    private JEditorPane xmlSketch;
    private JButton xmlTagApply;
    private Icon dropDownIcon;
    private Icon conditionEditorIcon;
    private Icon conditionEditorSelectedIcon;
    private static final long serialVersionUID = -5640822484296649670L;

    public ExtractionModelEditor(String extractionModelFile, ExtractionModelFrame extractionModelFrame, boolean horizontalLayout, String connectionState, String connectionStateToolTip) {
        String cond;
        String dir = "/net/sf/jailer/resource";
        try {
            this.dropDownIcon = new ImageIcon(this.getClass().getResource(dir + "/dropdown.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.conditionEditorIcon = new ImageIcon(this.getClass().getResource(dir + "/edit.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.conditionEditorSelectedIcon = new ImageIcon(this.getClass().getResource(dir + "/edit_s.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.extractionModelFrame = extractionModelFrame;
        this.extractionModelFile = extractionModelFile;
        ParameterSelector.ParametersGetter parametersGetter = new ParameterSelector.ParametersGetter(){

            @Override
            public Set<String> getParameters() {
                if (ExtractionModelEditor.this.dataModel == null) {
                    return new HashSet<String>();
                }
                return ExtractionModelEditor.this.dataModel.getParameters(ExtractionModelEditor.this.condition.getText());
            }
        };
        this.columnMapperDialog = new ColumnMapperDialog((Frame)extractionModelFrame, parametersGetter);
        try {
            this.dataModel = new DataModel();
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error in Data Model", e);
            return;
        }
        try {
            if (extractionModelFile == null || !new File(extractionModelFile).exists()) {
                this.needsSave = extractionModelFile != null;
                this.dataModel = new DataModel();
                this.extractionModel = new ExtractionModel(this.dataModel);
                LayoutStorage.removeAll();
            } else {
                this.extractionModel = new ExtractionModel(extractionModelFile, new HashMap<String, String>(), new HashMap<String, String>());
                LayoutStorage.restore(extractionModelFile);
            }
            this.subject = this.extractionModel.subject;
            this.dataModel = this.extractionModel.dataModel;
            if (this.subject == null && this.dataModel != null && !this.dataModel.getTables().isEmpty()) {
                this.subject = this.dataModel.getTables().iterator().next();
                this.needsSave = true;
            }
        }
        catch (Exception e) {
            UIUtil.showException(this, extractionModelFile == null ? "Error creating new Model" : "Error in " + new File(extractionModelFile).getName(), e);
            return;
        }
        boolean saveNeedsSave = this.needsSave;
        this.initComponents();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setExpandsSelectedPaths(true);
        this.restrictionEditor = new RestrictionEditor();
        this.graphView = this.isHorizontalLayout ? new GraphicalDataModelView(this.dataModel, this, this.subject, true, 948, 379) : new GraphicalDataModelView(this.dataModel, this, this.subject, true, 648, 579);
        this.graphContainer.add(this.graphView);
        AssociationRenderer.COLOR_ASSOCIATION = this.associatedWith.getForeground();
        AssociationRenderer.COLOR_DEPENDENCY = this.dependsOn.getForeground();
        AssociationRenderer.COLOR_IGNORED = this.ignored.getForeground();
        AssociationRenderer.COLOR_REVERSE_DEPENDENCY = this.hasDependent.getForeground();
        this.restrictionsTable.setSelectionMode(0);
        this.restrictionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ExtractionModelEditor.this.restrictionsTable.getSelectedRow() >= 0) {
                    ExtractionModelEditor.this.select((RestrictionDefinition)ExtractionModelEditor.this.currentRestrictionDefinitions.get(ExtractionModelEditor.this.restrictionsTable.getSelectedRow()));
                }
            }
        });
        final TableCellRenderer defaultTableCellRenderer = this.restrictionsTable.getDefaultRenderer(String.class);
        final Color BG1 = new Color(255, 255, 255);
        final Color BG2 = new Color(230, 255, 255);
        this.restrictionsTable.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component render = defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (render instanceof JLabel && !isSelected) {
                    ((JLabel)render).setBackground(row % 2 == 0 ? BG1 : BG2);
                }
                return render;
            }
        });
        this.restrictionsTable.setShowGrid(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.inspectorHolder.add((Component)this.restrictionEditor, gridBagConstraints);
        this.inspectorHolder.setMinimumSize(this.inspectorHolder.getPreferredSize());
        this.restrictionEditor.restriction.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExtractionModelEditor.this.restrictionEditor.apply.setEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExtractionModelEditor.this.restrictionEditor.apply.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExtractionModelEditor.this.restrictionEditor.apply.setEnabled(true);
            }
        });
        this.tagField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExtractionModelEditor.this.xmlTagApply.setEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExtractionModelEditor.this.xmlTagApply.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExtractionModelEditor.this.xmlTagApply.setEnabled(true);
            }
        });
        this.restrictionEditor.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractionModelEditor.this.onApply(true);
            }
        });
        this.restrictionEditor.ignore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractionModelEditor.this.onApply(false);
            }
        });
        this.initRestrictionEditor(null, null);
        if (this.extractionModel.subject != null) {
            this.subjectTable.setSelectedItem(this.dataModel.getDisplayName(this.extractionModel.subject));
        }
        if ((cond = this.extractionModel.condition).equals("1=1")) {
            cond = "";
        }
        this.condition.setText(ConditionEditor.toSingleLine(cond));
        this.condition.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                ExtractionModelEditor.this.needsSave = true;
                ExtractionModelEditor.this.extractionModelFrame.updateTitle(ExtractionModelEditor.this.needsSave);
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractionModelEditor.this.extractionModelFrame.dataExportActionPerformed(e);
            }
        });
        this.needsSave = saveNeedsSave;
        extractionModelFrame.updateTitle(this.needsSave);
        try {
            ScriptFormat f = ScriptFormat.valueOf(this.dataModel.getExportModus());
            if (f != null) {
                this.scriptFormat = f;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.exportFormat.setModel(new DefaultComboBoxModel<ScriptFormat>(ScriptFormat.values()));
        this.exportFormat.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 2393022320508863837L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((ScriptFormat)((Object)value)).getDisplayName(), index, isSelected, cellHasFocus);
            }
        });
        this.exportFormat.setSelectedItem((Object)this.scriptFormat);
        this.openXmlSettings.setVisible(ScriptFormat.XML.equals((Object)this.scriptFormat));
        this.onExportModusChanged(null);
        this.xmlSketch.setContentType("text/xml");
        this.setOrientation(horizontalLayout);
        this.connectivityState.setText(connectionState);
        this.connectivityState.setToolTipText(connectionStateToolTip);
        String modelname = "Data Model \"" + this.dataModel.getName() + "\"";
        String lastMod = this.dataModel.getLastModifiedAsString();
        if (lastMod.length() > 0) {
            lastMod = " (" + lastMod + ")";
        }
        this.modelName.setText(modelname);
        this.modelName.setToolTipText(modelname + lastMod);
        String modelpath = CommandLineParser.getInstance().getDataModelFolder();
        try {
            modelpath = CommandLineParser.getInstance().newFile(modelpath).getAbsolutePath();
        }
        catch (Throwable t) {
            // empty catch block
        }
        modelpath = modelpath + File.separator;
        this.modelPath.setToolTipText(modelpath);
        int MAX_LENGTH = 50;
        if (modelpath.length() > 54) {
            modelpath = modelpath.substring(0, 25) + "..." + modelpath.substring(modelpath.length() - 25);
        }
        this.modelPath.setText(modelpath);
        this.subjectConditionEditor = new ConditionEditor((Frame)extractionModelFrame, parametersGetter);
        this.subjectConditionEditor.setTitle("Subject condition");
        this.restrictionConditionEditor = new ConditionEditor((Frame)extractionModelFrame, parametersGetter);
        this.restrictionConditionEditor.setTitle("Restriction");
        this.openSubjectConditionEditor.setIcon(this.conditionEditorIcon);
        this.openSubjectConditionEditor.setText(null);
        this.restrictionEditor.openRestrictionConditionEditor.setIcon(this.conditionEditorIcon);
        this.restrictionEditor.openRestrictionConditionEditor.setText(null);
        this.restrictionEditor.openRestrictionConditionEditor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ExtractionModelEditor.this.currentAssociation != null && ExtractionModelEditor.this.restrictionEditor.restriction.isEditable()) {
                    String cond = ExtractionModelEditor.this.restrictionConditionEditor.edit(ExtractionModelEditor.this.restrictionEditor.restriction.getText(), "Table A", "A", ExtractionModelEditor.this.currentAssociation.source, "Table B", "B", ExtractionModelEditor.this.currentAssociation.destination, true);
                    if (cond != null && !ExtractionModelEditor.this.restrictionEditor.restriction.getText().equals(ConditionEditor.toSingleLine(cond))) {
                        ExtractionModelEditor.this.restrictionEditor.restriction.setText(ConditionEditor.toSingleLine(cond));
                        ExtractionModelEditor.this.onApply(true);
                    }
                    ExtractionModelEditor.this.restrictionEditor.openRestrictionConditionEditor.setIcon(ExtractionModelEditor.this.conditionEditorSelectedIcon);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (ExtractionModelEditor.this.currentAssociation != null) {
                    ExtractionModelEditor.this.restrictionEditor.openRestrictionConditionEditor.setIcon(ExtractionModelEditor.this.conditionEditorSelectedIcon);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ExtractionModelEditor.this.restrictionEditor.openRestrictionConditionEditor.setIcon(ExtractionModelEditor.this.conditionEditorIcon);
            }
        });
        this.openSubjectConditionEditor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                String cond = ExtractionModelEditor.this.subjectConditionEditor.edit(ExtractionModelEditor.this.condition.getText(), "Subject", "T", ExtractionModelEditor.this.subject, null, null, null, false);
                if (cond != null) {
                    if (!ExtractionModelEditor.this.condition.getText().equals(ConditionEditor.toSingleLine(cond))) {
                        ExtractionModelEditor.this.condition.setText(ConditionEditor.toSingleLine(cond));
                        ExtractionModelEditor.this.needsSave = true;
                        ExtractionModelEditor.this.extractionModelFrame.updateTitle(ExtractionModelEditor.this.needsSave);
                    }
                    ExtractionModelEditor.this.openSubjectConditionEditor.setIcon(ExtractionModelEditor.this.conditionEditorSelectedIcon);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ExtractionModelEditor.this.openSubjectConditionEditor.setIcon(ExtractionModelEditor.this.conditionEditorSelectedIcon);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ExtractionModelEditor.this.openSubjectConditionEditor.setIcon(ExtractionModelEditor.this.conditionEditorIcon);
            }
        });
    }

    void setOrientation(boolean horizontal) {
        this.isHorizontalLayout = horizontal;
        if (this.isHorizontalLayout) {
            this.jPanel1.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanel1.add((Component)this.editorPanel, gridBagConstraints);
            this.jSplitPane1.setOrientation(0);
            this.jSplitPane1.setLeftComponent(this.jPanel1);
            this.editorPanel.removeAll();
            this.editorPanel.add(this.jPanel3);
            this.editorPanel.add(this.jPanel4);
            this.editorPanel.add(this.inspectorHolder);
            ((GridLayout)this.editorPanel.getLayout()).setVgap(0);
            ((GridLayout)this.editorPanel.getLayout()).setRows(1);
            if (ScriptFormat.XML.equals((Object)this.scriptFormat)) {
                this.editorPanel.add(this.xmlMappingPanel);
                ((GridLayout)this.editorPanel.getLayout()).setColumns(4);
            } else {
                ((GridLayout)this.editorPanel.getLayout()).setColumns(3);
            }
        } else {
            this.jSplitPane1.setOrientation(1);
            final JScrollPane scrollPanel = new JScrollPane(){
                private static final long serialVersionUID = -947582621664272477L;

                @Override
                public Dimension getMinimumSize() {
                    return new Dimension(Math.max(((ExtractionModelEditor)ExtractionModelEditor.this).editorPanel.getMinimumSize().width, 380), ((ExtractionModelEditor)ExtractionModelEditor.this).editorPanel.getMinimumSize().height);
                }
            };
            scrollPanel.setHorizontalScrollBarPolicy(31);
            JPanel panel = new JPanel(){
                private static final long serialVersionUID = -5175513783835424396L;

                @Override
                public Dimension getMaximumSize() {
                    return new Dimension(scrollPanel.getWidth() - 20, Math.max((int)(650.0 * (ExtractionModelEditor.this.scriptFormat.equals((Object)ScriptFormat.XML) ? 1.33 : 1.0)), scrollPanel.getHeight() - 10));
                }

                @Override
                public Dimension getPreferredSize() {
                    return this.getMaximumSize();
                }
            };
            panel.setLayout(new GridLayout(1, 1, 0, 0));
            panel.add(this.editorPanel);
            scrollPanel.setViewportView(panel);
            this.jSplitPane1.setLeftComponent(scrollPanel);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            panel2.add((Component)this.jPanel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
            panel2.add((Component)this.jPanel4, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
            panel2.add((Component)this.inspectorHolder, gridBagConstraints);
            this.editorPanel.removeAll();
            this.editorPanel.add(panel2);
            ((GridLayout)this.editorPanel.getLayout()).setVgap(1);
            ((GridLayout)this.editorPanel.getLayout()).setColumns(1);
            if (ScriptFormat.XML.equals((Object)this.scriptFormat)) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(4, 0, 0, 0);
                panel2.add((Component)this.xmlMappingPanel, gridBagConstraints);
                ((GridLayout)this.editorPanel.getLayout()).setRows(1);
            } else {
                ((GridLayout)this.editorPanel.getLayout()).setRows(1);
            }
        }
    }

    public void resetGraphEditor(boolean full, boolean storeLayout, boolean removeLayout, boolean expandRoot) {
        if (full) {
            this.graphView.close(storeLayout, removeLayout);
            this.graphContainer.remove(this.graphView);
            this.graphView = new GraphicalDataModelView(this.dataModel, this, this.root, expandRoot, this.graphView.display.getWidth(), this.graphView.display.getHeight());
            this.graphContainer.add(this.graphView);
        } else {
            this.graphView.resetExpandedState();
        }
        this.validate();
    }

    public Table getSubject() {
        return this.subject;
    }

    public String getSubjectCondition() {
        return ConditionEditor.toMultiLine(this.condition.getText());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.graphContainer = new JPanel();
        this.jPanel1 = new JPanel();
        this.editorPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.restrictionsTable = new JTable();
        this.jLabel8 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel7 = new JPanel();
        this.condition = new JTextField();
        this.jPanel8 = new JPanel();
        this.jLabel7 = new JLabel();
        this.openSubjectConditionEditor = new JLabel();
        this.subjectTable = new JComboBox();
        this.jPanel10 = new JPanel();
        this.exportFormat = new JComboBox();
        this.exportButton = new JButton();
        this.openXmlSettings = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.jPanel6 = new JPanel();
        this.jLabel9 = new JLabel();
        this.rootTable = new JComboBox();
        this.jPanel9 = new JPanel();
        this.openDataBrowser = new JButton();
        this.openClosureView = new JButton();
        this.inspectorHolder = new JPanel();
        this.xmlMappingPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.aggregationCombobox = new JComboBox();
        this.tagField = new JTextField();
        this.jPanel5 = new JPanel();
        this.xmlTagApply = new JButton();
        this.mapColumns = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.xmlSketch = new JEditorPane();
        this.jPanel11 = new JPanel();
        this.legende1 = new JPanel();
        this.modelName = new JLabel();
        this.modelPath = new JLabel();
        this.legende = new JPanel();
        this.dependsOn = new JLabel();
        this.hasDependent = new JLabel();
        this.associatedWith = new JLabel();
        this.ignored = new JLabel();
        this.legende2 = new JPanel();
        this.connectivityState = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.graphContainer.setLayout(new BorderLayout());
        this.jSplitPane1.setBottomComponent(this.graphContainer);
        this.jPanel1.setLayout(new GridBagLayout());
        this.editorPanel.setLayout(new GridLayout(1, 4));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Subject ", 0, 0, new Font("Dialog", 1, 12), new Color(86, 82, 125)));
        this.jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jPanel3.setMinimumSize(new Dimension(158, 122));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel6.setText(" Export from ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.restrictionsTable.setModel(this.restrictionTableModel());
        this.jScrollPane4.setViewportView(this.restrictionsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jLabel8.setFont(new Font("Dialog", 2, 14));
        this.jLabel8.setText("Restrictions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel3.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel4.setText(" To");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(" as T ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel7.setLayout(new BorderLayout());
        this.condition.setText("jTextField1");
        this.jPanel7.add((Component)this.condition, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel3.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setLayout(new BorderLayout());
        this.jLabel7.setText(" Where ");
        this.jPanel8.add((Component)this.jLabel7, "West");
        this.openSubjectConditionEditor.setText("jLabel10");
        this.openSubjectConditionEditor.setToolTipText("open editor");
        this.jPanel8.add((Component)this.openSubjectConditionEditor, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel3.add((Component)this.jPanel8, gridBagConstraints);
        this.subjectTable.setMaximumRowCount(18);
        this.subjectTable.setModel(this.subjectListModel());
        this.subjectTable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExtractionModelEditor.this.subjectTableItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.subjectTable, gridBagConstraints);
        this.jPanel10.setLayout(new GridBagLayout());
        this.exportFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.exportFormat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExtractionModelEditor.this.onExportModusChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel10.add((Component)this.exportFormat, gridBagConstraints);
        this.exportButton.setText("Export");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel10.add((Component)this.exportButton, gridBagConstraints);
        this.openXmlSettings.setText("Setting");
        this.openXmlSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelEditor.this.openXmlSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel10.add((Component)this.openXmlSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jPanel10, gridBagConstraints);
        this.editorPanel.add(this.jPanel3);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Association ", 0, 0, new Font("Dialog", 1, 12), new Color(86, 82, 125)));
        this.jPanel4.setLayout(new BorderLayout(0, 4));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setAutoscrolls(true);
        this.tree.setModel(this.getModel());
        this.tree.setAutoscrolls(true);
        this.tree.setCellRenderer(this.getTreeCellRenderer(this.tree.getCellRenderer()));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                ExtractionModelEditor.this.treeValueChanged(evt);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExtractionModelEditor.this.treeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel9.setText(" Focus ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel6.add((Component)this.jLabel9, gridBagConstraints);
        this.rootTable.setMaximumRowCount(18);
        this.rootTable.setModel(this.getTableListModel());
        this.rootTable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExtractionModelEditor.this.rootTableItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.rootTable, gridBagConstraints);
        this.jPanel9.setLayout(new BorderLayout());
        this.openDataBrowser.setText("Data Browser");
        this.openDataBrowser.setToolTipText("Open Data Browser");
        this.openDataBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelEditor.this.openDataBrowserActionPerformed(evt);
            }
        });
        this.jPanel9.add((Component)this.openDataBrowser, "West");
        this.openClosureView.setText("Closure Browser");
        this.openClosureView.setToolTipText("Open Closure Browser");
        this.openClosureView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelEditor.this.openClosureViewActionPerformed(evt);
            }
        });
        this.jPanel9.add((Component)this.openClosureView, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel6.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel4.add((Component)this.jPanel6, "North");
        this.editorPanel.add(this.jPanel4);
        this.inspectorHolder.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Restriction ", 0, 0, new Font("Dialog", 1, 12), new Color(86, 82, 125)));
        this.inspectorHolder.setMinimumSize(new Dimension(100, 400));
        this.inspectorHolder.setLayout(new GridBagLayout());
        this.editorPanel.add(this.inspectorHolder);
        this.xmlMappingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "XML Mapping ", 0, 0, new Font("Dialog", 1, 12), new Color(86, 82, 125)));
        this.xmlMappingPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(" Aggregation ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.xmlMappingPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(" Tag ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.xmlMappingPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(" Sketch ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        this.xmlMappingPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.aggregationCombobox.setModel(this.getAggregationModel());
        this.aggregationCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelEditor.this.aggregationComboboxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.xmlMappingPanel.add((Component)this.aggregationCombobox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.xmlMappingPanel.add((Component)this.tagField, gridBagConstraints);
        this.xmlTagApply.setText("apply");
        this.xmlTagApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelEditor.this.xmlTagApplyActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.xmlTagApply);
        this.mapColumns.setText("map columns");
        this.mapColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionModelEditor.this.mapColumnsActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.mapColumns);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.xmlMappingPanel.add((Component)this.jPanel5, gridBagConstraints);
        this.xmlSketch.setEditable(false);
        this.jScrollPane2.setViewportView(this.xmlSketch);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 20, 0, 4);
        this.xmlMappingPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.editorPanel.add(this.xmlMappingPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.editorPanel, gridBagConstraints);
        this.jSplitPane1.setTopComponent(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        this.legende1.setBorder(new SoftBevelBorder(0));
        this.legende1.setLayout(new GridBagLayout());
        this.modelName.setFont(new Font("Dialog", 0, 12));
        this.modelName.setText("Data Model \"Demo\"");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 12);
        this.legende1.add((Component)this.modelName, gridBagConstraints);
        this.modelPath.setFont(new Font("Dialog", 0, 12));
        this.modelPath.setForeground(Color.gray);
        this.modelPath.setText("/home/jailer/datamodel/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.legende1.add((Component)this.modelPath, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel11.add((Component)this.legende1, gridBagConstraints);
        this.legende.setBorder(new SoftBevelBorder(0));
        this.legende.setLayout(new FlowLayout(1, 0, 0));
        this.dependsOn.setFont(new Font("Dialog", 0, 12));
        this.dependsOn.setForeground(new Color(170, 0, 0));
        this.dependsOn.setText(" depends on");
        this.legende.add(this.dependsOn);
        this.hasDependent.setFont(new Font("Dialog", 0, 12));
        this.hasDependent.setForeground(new Color(0, 112, 0));
        this.hasDependent.setText("   has dependent");
        this.legende.add(this.hasDependent);
        this.associatedWith.setFont(new Font("Dialog", 0, 12));
        this.associatedWith.setForeground(new Color(0, 100, 255));
        this.associatedWith.setText("   associated with");
        this.legende.add(this.associatedWith);
        this.ignored.setFont(new Font("Dialog", 0, 12));
        this.ignored.setForeground(new Color(153, 153, 153));
        this.ignored.setText("   disabled ");
        this.legende.add(this.ignored);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel11.add((Component)this.legende, gridBagConstraints);
        this.legende2.setBorder(new SoftBevelBorder(0));
        this.legende2.setLayout(new GridBagLayout());
        this.connectivityState.setFont(new Font("Dialog", 0, 12));
        this.connectivityState.setText("offline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.legende2.add((Component)this.connectivityState, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel11.add((Component)this.legende2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel11, gridBagConstraints);
    }

    private void openClosureViewActionPerformed(ActionEvent evt) {
        this.extractionModelFrame.openClosureView(this.root);
    }

    private void treeMouseClicked(MouseEvent evt) {
        Object sel;
        TreePath node;
        if (evt.getButton() == 3 && evt.getClickCount() == 1 && (node = this.tree.getPathForLocation(evt.getX(), evt.getY())) != null && (sel = node.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            Object selNode = ((DefaultMutableTreeNode)sel).getUserObject();
            Table table = null;
            if (selNode instanceof Table) {
                table = (Table)selNode;
            }
            if (selNode instanceof Association) {
                table = ((Association)selNode).destination;
            }
            JPopupMenu popup = this.graphView.createPopupMenu(table, false);
            popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void mapColumnsActionPerformed(ActionEvent evt) {
        this.applyXmlMapping();
        Table table = this.root;
        if (this.currentAssociation != null) {
            table = this.currentAssociation.source;
        }
        this.openColumnMapper(table);
    }

    private void xmlTagApplyActionPerformed(ActionEvent evt) {
        this.applyXmlMapping();
    }

    private void openXmlSettingsActionPerformed(ActionEvent evt) {
        if (this.xmlSettingsDialog == null) {
            this.xmlSettingsDialog = new XmlSettingsDialog(this.extractionModelFrame);
        }
        if (this.xmlSettingsDialog.edit(this.dataModel)) {
            this.needsSave = true;
            this.extractionModelFrame.updateTitle(this.needsSave);
        }
    }

    private void aggregationComboboxActionPerformed(ActionEvent evt) {
        this.tagField.setEnabled(AggregationSchema.NONE != this.aggregationCombobox.getSelectedItem() && AggregationSchema.FLAT != this.aggregationCombobox.getSelectedItem());
        this.tagField.setEditable(AggregationSchema.NONE != this.aggregationCombobox.getSelectedItem() && AggregationSchema.FLAT != this.aggregationCombobox.getSelectedItem());
        if (this.currentAssociation != null && this.currentAssociation.getAggregationSchema() != this.aggregationCombobox.getSelectedItem()) {
            this.currentAssociation.setAggregationSchema((AggregationSchema)((Object)this.aggregationCombobox.getSelectedItem()));
            this.needsSave = true;
            this.extractionModelFrame.updateTitle(this.needsSave);
            this.updateSketch();
        }
    }

    private void rootTableItemStateChanged(ItemEvent evt) {
        if (evt.getItem() != null && evt.getStateChange() == 1) {
            Table table = this.dataModel.getTableByDisplayName(evt.getItem().toString());
            this.setRoot(table);
        }
    }

    public void setRoot(Table table) {
        if (table != null) {
            this.root = table;
            this.tree.setModel(this.getModel());
            this.resetGraphEditor(true, true, false, true);
            if (this.extractionModelFrame != null && this.extractionModelFrame.closureBorderView != null) {
                this.extractionModelFrame.closureBorderView.refresh();
            }
            if (this.extractionModelFrame != null && this.extractionModelFrame.restrictedDependenciesView != null) {
                this.extractionModelFrame.restrictedDependenciesView.refresh();
            }
        }
    }

    public void setRootSelection(Table table) {
        if (table != null) {
            this.rootTable.setSelectedItem(this.dataModel.getDisplayName(table));
        }
    }

    private TableModel restrictionTableModel() {
        this.currentRestrictionDefinitions = RestrictionDefinition.fromRestrictionModel(this.extractionModel);
        Object[][] data = new Object[this.currentRestrictionDefinitions.size()][];
        int i = 0;
        for (RestrictionDefinition def : this.currentRestrictionDefinitions) {
            data[i++] = new Object[]{this.dataModel.getDisplayName(def.from), this.dataModel.getDisplayName(def.to), def.condition};
        }
        return new DefaultTableModel(data, new Object[]{"From", "To", "Condition"}){
            private static final long serialVersionUID = 7309234765268573389L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
    }

    private ComboBoxModel subjectListModel() {
        Vector<String> tableNames = new Vector<String>();
        for (Table table : this.dataModel.getTables()) {
            tableNames.add(this.dataModel.getDisplayName(table));
        }
        Collections.sort(tableNames);
        DefaultComboBoxModel model = new DefaultComboBoxModel(tableNames);
        return model;
    }

    private ComboBoxModel getTableListModel() {
        Vector<String> tableNames = new Vector<String>();
        for (Table table : this.dataModel.getTables()) {
            tableNames.add(this.dataModel.getDisplayName(table));
        }
        Collections.sort(tableNames);
        if (this.subject != null) {
            tableNames.add(0, this.dataModel.getDisplayName(this.subject));
            tableNames.add(1, "---");
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(tableNames);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void treeValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode n;
        Object node;
        this.suppressRestrictionSelection = true;
        try {
            if (evt.getNewLeadSelectionPath() != null) {
                node = (DefaultMutableTreeNode)evt.getNewLeadSelectionPath().getLastPathComponent();
                Object selection = ((DefaultMutableTreeNode)node).getUserObject();
                if (selection instanceof Association) {
                    this.initRestrictionEditor((Association)selection, (DefaultMutableTreeNode)node);
                }
                if (selection instanceof Table) {
                    this.initRestrictionEditor(null, null);
                }
            } else {
                this.initRestrictionEditor(null, null);
            }
        }
        finally {
            this.suppressRestrictionSelection = false;
        }
        if (evt.getPath() != null && evt.getPath().getLastPathComponent() != null && (node = evt.getPath().getLastPathComponent()) instanceof DefaultMutableTreeNode && (n = (DefaultMutableTreeNode)node).getChildCount() == 0 && n.getUserObject() instanceof Association) {
            for (Association a : ((Association)n.getUserObject()).destination.associations) {
                n.add(new DefaultMutableTreeNode(a));
            }
            this.sort(n);
        }
    }

    private void openColumnDropDownBox(JLabel label, String alias, Table table) {
        JScrollPopupMenu popup = new JScrollPopupMenu();
        ArrayList<String> columns = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            columns.add(alias + "." + column.name);
        }
        columns.add("");
        columns.add(alias + ".$IS_SUBJECT");
        columns.add(alias + ".$DISTANCE");
        for (final String string : columns) {
            if (string.equals("")) {
                popup.add(new JSeparator());
                continue;
            }
            JMenuItem m = new JMenuItem(string);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtractionModelEditor.this.restrictionEditor.restriction.isEnabled() && ExtractionModelEditor.this.restrictionEditor.restriction.isEditable()) {
                        ExtractionModelEditor.this.restrictionEditor.restriction.replaceSelection(string);
                    }
                }
            });
            popup.add(m);
        }
        UIUtil.fit(popup);
        ((JPopupMenu)popup).show(label, 0, label.getHeight());
    }

    private void initRestrictionEditor(final Association association, DefaultMutableTreeNode node) {
        this.currentAssociation = association;
        this.currentNode = node;
        this.initialRestrictionCondition = null;
        this.initXmlMappingEditor(association);
        this.initRestrictedDependencyWarningField();
        this.restrictionEditor.columnsA.setText(null);
        this.restrictionEditor.columnsB.setText(null);
        this.restrictionEditor.columnsA.setIcon(this.dropDownIcon);
        this.restrictionEditor.columnsB.setIcon(this.dropDownIcon);
        this.restrictionEditor.columnsA.setEnabled(true);
        this.restrictionEditor.columnsB.setEnabled(true);
        this.restrictionEditor.openRestrictionConditionEditor.setEnabled(true);
        if (this.maA != null) {
            this.restrictionEditor.columnsA.removeMouseListener(this.maA);
        }
        if (this.maB != null) {
            this.restrictionEditor.columnsB.removeMouseListener(this.maB);
        }
        this.maB = null;
        this.maA = null;
        if (association != null) {
            this.maB = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ExtractionModelEditor.this.openColumnDropDownBox(ExtractionModelEditor.this.restrictionEditor.columnsB, "B", association.destination);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    ExtractionModelEditor.this.restrictionEditor.columnsB.setEnabled(false);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    ExtractionModelEditor.this.restrictionEditor.columnsB.setEnabled(true);
                }
            };
            this.restrictionEditor.columnsB.addMouseListener(this.maB);
            this.maA = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ExtractionModelEditor.this.openColumnDropDownBox(ExtractionModelEditor.this.restrictionEditor.columnsA, "A", association.source);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    ExtractionModelEditor.this.restrictionEditor.columnsA.setEnabled(false);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    ExtractionModelEditor.this.restrictionEditor.columnsA.setEnabled(true);
                }
            };
            this.restrictionEditor.columnsA.addMouseListener(this.maA);
        }
        if (association == null) {
            int l;
            this.restrictionEditor.columnsA.setEnabled(false);
            this.restrictionEditor.columnsB.setEnabled(false);
            this.restrictionEditor.openRestrictionConditionEditor.setEnabled(false);
            int n = l = this.currentRestrictionDefinitions == null ? -1 : this.currentRestrictionDefinitions.size();
            if (l > 0) {
                this.restrictionsTable.removeRowSelectionInterval(0, l - 1);
            }
            String noVal = "n/a";
            this.restrictionEditor.apply.setEnabled(false);
            this.restrictionEditor.cardinality.setText("");
            this.restrictionEditor.destination.setText(noVal);
            this.restrictionEditor.ignore.getModel().setPressed(false);
            this.restrictionEditor.ignore.setEnabled(false);
            this.restrictionEditor.joinCondition.setText(noVal);
            this.restrictionEditor.joinCondition.setToolTipText(noVal);
            this.restrictionEditor.restriction.setText("");
            this.restrictionEditor.restriction.setEditable(false);
            this.restrictionEditor.source.setText(noVal);
            this.restrictionEditor.type.setText(noVal);
            this.restrictionEditor.aName.setText(noVal);
        } else {
            if (this.currentRestrictionDefinitions != null) {
                int row = 0;
                boolean found = false;
                for (RestrictionDefinition rd : this.currentRestrictionDefinitions) {
                    if (rd.from.equals(association.source) && rd.to.equals(association.destination) && (association.getName() == null || association.getName().equals("") || association.getName().equals(rd.name))) {
                        this.restrictionsTable.addRowSelectionInterval(row, row);
                        found = true;
                        break;
                    }
                    ++row;
                }
                if (!found && row > 0) {
                    this.restrictionsTable.removeRowSelectionInterval(0, row - 1);
                }
            }
            String type = "associated with  ";
            Color typeColor = this.associatedWith.getForeground();
            boolean editable = true;
            if (association.isInsertDestinationBeforeSource()) {
                type = "depends on  ";
                typeColor = this.dependsOn.getForeground();
            } else if (association.isInsertSourceBeforeDestination()) {
                type = "has dependent  ";
                typeColor = this.hasDependent.getForeground();
            }
            String shortendName = association.getName();
            if (shortendName != null && shortendName.length() > 30) {
                this.restrictionEditor.aName.setToolTipText(shortendName);
                shortendName = shortendName.substring(0, 30) + "...";
            } else {
                this.restrictionEditor.aName.setToolTipText(null);
            }
            this.restrictionEditor.aName.setText(shortendName);
            if (this.getAmbiguousNonames().contains(association)) {
                this.restrictionEditor.aName.setText("unnamed and ambiguous");
                editable = false;
            }
            this.restrictionEditor.restriction.setEditable(true);
            this.restrictionEditor.source.setText(this.dataModel.getDisplayName(association.source));
            this.restrictionEditor.destination.setText(this.dataModel.getDisplayName(association.destination));
            this.restrictionEditor.cardinality.setText(association.getCardinality() == null ? "" : "(" + association.getCardinality().toString() + ")");
            this.restrictionEditor.type.setText(type);
            this.restrictionEditor.type.setForeground(typeColor);
            this.restrictionEditor.joinCondition.setText(association.getUnrestrictedJoinCondition());
            String restrictionCondition = association.getRestrictionCondition();
            if (restrictionCondition != null && restrictionCondition.startsWith("(") && restrictionCondition.endsWith(")")) {
                restrictionCondition = restrictionCondition.substring(1, restrictionCondition.length() - 1);
            }
            this.initialRestrictionCondition = association.isIgnored() ? null : restrictionCondition;
            this.restrictionEditor.restriction.setText(restrictionCondition == null ? "" : ConditionEditor.toSingleLine(restrictionCondition));
            this.restrictionEditor.ignore.getModel().setSelected(association.isIgnored());
            this.restrictionEditor.restriction.setEditable(editable && !association.isIgnored());
            this.restrictionEditor.ignore.setEnabled(editable);
            String joinCondition = association.getUnrestrictedJoinCondition();
            if (association.reversed) {
                joinCondition = SqlUtil.reversRestrictionCondition(joinCondition);
            }
            boolean singleCondition = true;
            for (Association represented : this.representant.keySet()) {
                if (!association.equals(this.representant.get(represented))) continue;
                String jc = represented.getUnrestrictedJoinCondition();
                if (represented.reversed) {
                    jc = SqlUtil.reversRestrictionCondition(jc);
                }
                if (singleCondition) {
                    joinCondition = "(" + joinCondition + ")";
                }
                singleCondition = false;
                joinCondition = joinCondition + "\nor\n(" + jc + ")";
            }
            this.restrictionEditor.joinCondition.setText(joinCondition);
            this.restrictionEditor.joinCondition.setToolTipText(joinCondition);
        }
        this.graphView.setSelection(association);
        this.restrictionEditor.apply.setEnabled(false);
    }

    private void initRestrictedDependencyWarningField() {
        this.restrictionEditor.restrictedDependencyWarning.setVisible(this.currentAssociation != null && !ScriptFormat.XML.equals((Object)this.scriptFormat) && this.currentAssociation.isInsertDestinationBeforeSource() && this.currentAssociation.isRestricted());
    }

    private void initXmlMappingEditor(Association association) {
        if (association == null) {
            this.aggregationCombobox.setSelectedItem((Object)AggregationSchema.NONE);
            this.tagField.setText("");
            this.aggregationCombobox.setEnabled(false);
            this.tagField.setEnabled(false);
            this.tagField.setEditable(false);
            this.xmlTagApply.setEnabled(false);
        } else {
            this.aggregationCombobox.setEditable(false);
            this.aggregationCombobox.setEnabled(association.reversalAssociation.getAggregationSchema() == AggregationSchema.NONE);
            this.aggregationCombobox.setSelectedItem((Object)association.getAggregationSchema());
            this.tagField.setText(association.getAggregationTagName());
            this.tagField.setEnabled(AggregationSchema.NONE != association.getAggregationSchema() && AggregationSchema.FLAT != association.getAggregationSchema());
            this.tagField.setEditable(AggregationSchema.NONE != association.getAggregationSchema() && AggregationSchema.FLAT != association.getAggregationSchema());
            this.xmlTagApply.setEnabled(true);
        }
        this.updateSketch();
        this.xmlTagApply.setEnabled(false);
    }

    public void onApply(boolean applyButtonKlicked) {
        if (this.currentAssociation != null) {
            if (!this.needsSave) {
                this.needsSave = true;
                this.extractionModelFrame.updateTitle(this.needsSave);
            }
            String condition = this.restrictionEditor.ignore.getModel().isSelected() ? "ignore" : (!applyButtonKlicked ? (this.initialRestrictionCondition != null ? this.initialRestrictionCondition : "") : ConditionEditor.toMultiLine(this.restrictionEditor.restriction.getText()).trim());
            this.dataModel.getRestrictionModel().addRestriction(this.currentAssociation.source, this.currentAssociation, condition, "GUI", true, new HashMap<String, String>());
            this.tree.repaint();
            this.graphView.display.invalidate();
            this.restrictionsTable.setModel(this.restrictionTableModel());
            String saveInitialRestrictionCondition = this.initialRestrictionCondition;
            this.initRestrictionEditor(this.currentAssociation, this.currentNode);
            this.initialRestrictionCondition = saveInitialRestrictionCondition;
            this.extractionModelFrame.closureView.refresh();
            this.extractionModelFrame.closureBorderView.refresh();
            this.extractionModelFrame.restrictedDependenciesView.refresh();
            this.tree.grabFocus();
        }
    }

    public void removeRestrictions(Collection<Association> associations) {
        for (Association association : associations) {
            if (!this.needsSave) {
                this.needsSave = true;
                this.extractionModelFrame.updateTitle(this.needsSave);
            }
            String condition = "";
            this.dataModel.getRestrictionModel().addRestriction(association.source, association, condition, "GUI", true, new HashMap<String, String>());
            this.graphView.setSelection(association);
        }
        this.tree.repaint();
        this.graphView.display.invalidate();
        this.restrictionsTable.setModel(this.restrictionTableModel());
        this.extractionModelFrame.closureView.refresh();
        this.extractionModelFrame.closureBorderView.refresh();
        this.extractionModelFrame.restrictedDependenciesView.refresh();
    }

    private TreeModel getModel() {
        return this.getModel(null);
    }

    private TreeModel getModel(Association dontExclude) {
        this.representant = new HashMap<Association, Association>();
        this.toNode = new HashMap<ModelElement, DefaultMutableTreeNode>();
        this.treeNodes = new ArrayList<DefaultMutableTreeNode>();
        if (this.root == null) {
            this.root = this.subject;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.root);
        this.treeNodes.add(root);
        HashMap<Association, DefaultMutableTreeNode> parent = new HashMap<Association, DefaultMutableTreeNode>();
        LinkedList<Association> agenda = new LinkedList<Association>();
        this.toNode.put(this.root, root);
        if (this.root != null) {
            for (Association a : this.root.associations) {
                agenda.add(a);
                parent.put(a, root);
            }
        }
        while (!agenda.isEmpty()) {
            Association a = (Association)agenda.get(0);
            agenda.remove(0);
            if (this.toNode.get(a) != null) continue;
            Association rep = null;
            for (ModelElement cand : this.toNode.keySet()) {
                if (!(cand instanceof Association)) continue;
                Association candRep = (Association)cand;
                if (a.getName() != null && candRep.getName() != null || !a.source.equals(candRep.source) || !a.destination.equals(candRep.destination)) continue;
                rep = candRep;
                break;
            }
            if (rep != null) {
                this.representant.put(a, rep);
                continue;
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(a);
            this.treeNodes.add(node);
            ((DefaultMutableTreeNode)parent.get(a)).add(node);
            this.sort((DefaultMutableTreeNode)parent.get(a));
            this.toNode.put(a, node);
            for (Association nextA : a.destination.associations) {
                if (parent.containsKey(nextA)) continue;
                agenda.add(nextA);
                parent.put(nextA, node);
            }
        }
        if (this.treeModel != null) {
            this.treeModel.setRoot(root);
        } else {
            this.treeModel = new DefaultTreeModel(root);
        }
        return this.treeModel;
    }

    private void updateSketch() {
        try {
            this.xmlSketch.setText(XmlSketchBuilder.buildSketch(this.currentAssociation == null ? null : this.currentAssociation.source, 0));
            this.xmlSketch.setCaretPosition(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sort(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            children.add((DefaultMutableTreeNode)node.getChildAt(i));
        }
        Collections.sort(children, new Comparator<DefaultMutableTreeNode>(){

            private int cat(Association a) {
                if (a.isIgnored()) {
                    return 4;
                }
                if (a.isInsertDestinationBeforeSource()) {
                    return 1;
                }
                if (a.isInsertSourceBeforeDestination()) {
                    return 2;
                }
                return 3;
            }

            @Override
            public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
                int cat2;
                Association a1 = (Association)o1.getUserObject();
                Association a2 = (Association)o2.getUserObject();
                int cat1 = this.cat(a1);
                if (cat1 == (cat2 = this.cat(a2))) {
                    return ExtractionModelEditor.this.dataModel.getDisplayName(a1.destination).compareTo(ExtractionModelEditor.this.dataModel.getDisplayName(a2.destination));
                }
                return cat1 - cat2;
            }
        });
        node.removeAllChildren();
        for (MutableTreeNode mutableTreeNode : children) {
            node.add(mutableTreeNode);
        }
    }

    private void applyXmlMapping() {
        if (this.currentAssociation != null) {
            String tag = this.tagField.getText().trim();
            if (tag.length() == 0) {
                tag = null;
            }
            if (!this.currentAssociation.getAggregationTagName().equals(tag)) {
                this.currentAssociation.setAggregationTagName(tag);
                this.tagField.setText(this.currentAssociation.getAggregationTagName());
                this.needsSave = true;
                this.extractionModelFrame.updateTitle(this.needsSave);
            }
            this.updateSketch();
            this.xmlTagApply.setEnabled(false);
        }
    }

    private void onExportModusChanged(ItemEvent evt) {
        ScriptFormat f = (ScriptFormat)((Object)this.exportFormat.getSelectedItem());
        if (f != null) {
            this.scriptFormat = f;
            this.dataModel.setExportModus(this.scriptFormat.toString());
        }
        this.setOrientation(this.isHorizontalLayout);
        this.openXmlSettings.setVisible(ScriptFormat.XML.equals((Object)this.scriptFormat));
        this.validate();
    }

    private void openDataBrowserActionPerformed(ActionEvent evt) {
        String cond = "";
        if (this.root != null && this.root.equals(this.subject)) {
            cond = ConditionEditor.toMultiLine(this.condition.getText());
            if (cond.equals("1=1")) {
                cond = "";
            }
            HashSet<String> parameters = new HashSet<String>();
            ParameterHandler.collectParameter(cond, parameters);
            if (!parameters.isEmpty()) {
                cond = "";
            }
            cond = SqlUtil.replaceAlias(cond, "A");
        }
        this.extractionModelFrame.openDataBrowser(this.root, cond);
    }

    private void subjectTableItemStateChanged(ItemEvent evt) {
        Object selectedItem = this.subjectTable.getSelectedItem();
        if (selectedItem instanceof String && this.dataModel.getTableByDisplayName(selectedItem.toString()) != null) {
            this.currentSubjectClosure = null;
            this.subject = this.dataModel.getTableByDisplayName(selectedItem.toString());
        }
        this.rootTable.setModel(this.getTableListModel());
        this.rootTable.setSelectedItem(null);
        this.rootTable.setSelectedItem(selectedItem);
        if (!this.needsSave) {
            this.needsSave = true;
            this.extractionModelFrame.updateTitle(this.needsSave);
        }
    }

    private TreeCellRenderer getTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        DefaultTreeCellRenderer r = new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 2657584557290860355L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String text = "";
                if (value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    if (node.getUserObject() instanceof Table) {
                        text = ExtractionModelEditor.this.dataModel.getDisplayName((Table)node.getUserObject());
                        this.setTextNonSelectionColor(Color.BLACK);
                    } else if (node.getUserObject() instanceof Association) {
                        Association association = (Association)node.getUserObject();
                        text = ExtractionModelEditor.this.dataModel.getDisplayName(association.destination);
                        text = !association.isIgnored() && association.isRestricted() ? text + "*" : text + "  ";
                        if (association.isIgnored()) {
                            this.setTextNonSelectionColor(ExtractionModelEditor.this.ignored.getForeground());
                        } else if (association.isInsertDestinationBeforeSource()) {
                            this.setTextNonSelectionColor(ExtractionModelEditor.this.dependsOn.getForeground());
                        } else if (association.isInsertSourceBeforeDestination()) {
                            this.setTextNonSelectionColor(ExtractionModelEditor.this.hasDependent.getForeground());
                        } else {
                            this.setTextNonSelectionColor(ExtractionModelEditor.this.associatedWith.getForeground());
                        }
                        return ExtractionModelEditor.this.wrapTreeNode(super.getTreeCellRendererComponent(tree, text, selected, expanded, leaf, row, hasFocus), selected, association);
                    }
                }
                return super.getTreeCellRendererComponent(tree, text, selected, expanded, leaf, row, hasFocus);
            }
        };
        r.setOpenIcon(null);
        r.setLeafIcon(null);
        r.setClosedIcon(null);
        return r;
    }

    private Component wrapTreeNode(Component component, boolean selected, final Association association) {
        if (!(component instanceof JLabel)) {
            return component;
        }
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        final JLabel reversal = new JLabel();
        reversal.setText("re");
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        panel.add(component, gridBagConstraints);
        reversal.setFont(((JLabel)component).getFont());
        reversal.setBackground(((JLabel)component).getBackground());
        JPanel revArrow = new JPanel(){
            private static final long serialVersionUID = -8515778652672162975L;

            @Override
            public void paintComponent(Graphics g) {
                if (association.reversalAssociation.isIgnored()) {
                    return;
                }
                Color color = association.reversalAssociation.isIgnored() ? ExtractionModelEditor.this.ignored.getForeground() : (association.reversalAssociation.isInsertDestinationBeforeSource() ? ExtractionModelEditor.this.dependsOn.getForeground() : (association.reversalAssociation.isInsertSourceBeforeDestination() ? ExtractionModelEditor.this.hasDependent.getForeground() : ExtractionModelEditor.this.associatedWith.getForeground()));
                int width = this.getWidth();
                int height = this.getHeight();
                if (g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
                    g2d.setColor(color);
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setStroke(new BasicStroke(2.0f));
                    int a = height / 4;
                    g2d.drawLine(0, height / 2, width, height / 2);
                    g2d.drawLine(1, height / 2 - 1, a, height / 2 - a);
                    g2d.drawLine(1, height / 2 + 1, a, height / 2 + a);
                } else {
                    g.setColor(color);
                    int a = height / 4;
                    g.drawLine(0, height / 2, width, height / 2);
                    g.drawLine(0, height / 2, a, height / 2 - a);
                    g.drawLine(0, height / 2, a, height / 2 + a);
                }
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return reversal.getPreferredSize();
            }
        };
        revArrow.setOpaque(false);
        panel.add((Component)revArrow, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        return panel;
    }

    public boolean select(Table table) {
        Object r;
        if (this.root != null && this.root.equals(table) && (r = this.tree.getModel().getRoot()) != null && r instanceof DefaultMutableTreeNode) {
            TreePath treePath = new TreePath(((DefaultMutableTreeNode)r).getPath());
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
            return true;
        }
        for (DefaultMutableTreeNode node : this.treeNodes) {
            if (node.getChildCount() <= 0) continue;
            Table t = null;
            Association a = null;
            if (node.getUserObject() instanceof Association) {
                a = (Association)node.getUserObject();
                t = a.destination;
            }
            if (t == null || a == null || !table.equals(t)) continue;
            this.select(a);
            TreePath treePath = new TreePath(node.getPath());
            this.tree.expandPath(treePath);
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode c = (DefaultMutableTreeNode)node.getChildAt(i);
                this.tree.collapsePath(new TreePath(c.getPath()));
            }
            this.tree.scrollPathToVisible(treePath);
            return true;
        }
        Association first = null;
        for (Association a : table.associations) {
            if (first != null && this.dataModel.getDisplayName(first.destination).compareTo(this.dataModel.getDisplayName(a.destination)) >= 0) continue;
            first = a;
        }
        if (first != null) {
            return this.select(first);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void select(RestrictionDefinition restrictionDefinition) {
        if (!this.suppressRestrictionSelection) {
            this.suppressRestrictionSelection = true;
            try {
                DefaultMutableTreeNode toSelect = null;
                for (int i = 0; i < 3; ++i) {
                    for (DefaultMutableTreeNode node : this.treeNodes) {
                        if (!(node.getUserObject() instanceof Association)) continue;
                        Association a = (Association)node.getUserObject();
                        if (!a.destination.equals(restrictionDefinition.to) || !a.source.equals(restrictionDefinition.from) || restrictionDefinition.name != null && restrictionDefinition.name.length() != 0 && !restrictionDefinition.name.equals(a.getName()) || toSelect != null && !toSelect.isLeaf()) continue;
                        toSelect = node;
                    }
                    if (toSelect != null) {
                        TreePath treePath = new TreePath(toSelect.getPath());
                        this.tree.setSelectionPath(treePath);
                        this.tree.scrollPathToVisible(treePath);
                        break;
                    }
                    if (i == 2) {
                        this.setRoot(restrictionDefinition.from);
                        break;
                    }
                    block5: for (Table t : this.dataModel.getTables()) {
                        for (Association a : t.associations) {
                            if (!a.destination.equals(restrictionDefinition.to) || !a.source.equals(restrictionDefinition.from) || restrictionDefinition.name != null && restrictionDefinition.name.length() != 0 && !restrictionDefinition.name.equals(a.getName())) continue;
                            this.tree.setModel(this.getModel(a));
                            continue block5;
                        }
                    }
                }
            }
            finally {
                this.suppressRestrictionSelection = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean select(Association association) {
        if (!this.suppressRestrictionSelection) {
            this.suppressRestrictionSelection = true;
            try {
                DefaultMutableTreeNode toSelect = null;
                for (int i = 0; i < 2; ++i) {
                    for (DefaultMutableTreeNode node : this.treeNodes) {
                        Association a;
                        if (!(node.getUserObject() instanceof Association) || !(a = (Association)node.getUserObject()).equals(association) || toSelect != null && !toSelect.isLeaf()) continue;
                        toSelect = node;
                    }
                    if (toSelect != null) {
                        TreePath treePath = new TreePath(toSelect.getPath());
                        this.tree.setSelectionPath(treePath);
                        this.tree.scrollPathToVisible(treePath);
                        boolean bl = true;
                        return bl;
                    }
                    this.tree.setModel(this.getModel(association));
                }
            }
            finally {
                this.suppressRestrictionSelection = false;
            }
        }
        return false;
    }

    public List<Association> getPathToRoot(Association association) {
        ArrayList<Association> path = new ArrayList<Association>();
        for (DefaultMutableTreeNode node : this.treeNodes) {
            Association a;
            if (!(node.getUserObject() instanceof Association) || !(a = (Association)node.getUserObject()).equals(association)) continue;
            for (TreeNode n : node.getPath()) {
                if (!(((DefaultMutableTreeNode)n).getUserObject() instanceof Association)) continue;
                path.add((Association)((DefaultMutableTreeNode)n).getUserObject());
            }
        }
        return path;
    }

    public boolean save(boolean selectNewFile, String reason) {
        if (this.currentRestrictionDefinitions == null) {
            return false;
        }
        if (selectNewFile || this.extractionModelFile == null) {
            String newFile;
            String startDir = "extractionmodel";
            if (this.extractionModelFile != null && (startDir = new File(this.extractionModelFile).getParent()) == null) {
                startDir = "extractionmodel";
            }
            if ((newFile = UIUtil.choseFile(this.extractionModelFile == null ? null : new File(this.extractionModelFile), startDir, (reason == null ? "" : reason + " - ") + "Save Extraction Model", ".csv", this, true, false)) == null) {
                return false;
            }
            this.extractionModelFile = newFile;
        }
        try {
            this.graphView.storeLayout();
            Table stable = this.dataModel.getTableByDisplayName((String)this.subjectTable.getSelectedItem());
            if (stable == null) {
                return true;
            }
            this.dataModel.save(this.extractionModelFile, stable, ConditionEditor.toMultiLine(this.condition.getText()), this.scriptFormat, this.currentRestrictionDefinitions, null);
            this.needsSave = false;
            this.extractionModelFrame.updateTitle(this.needsSave);
        }
        catch (Exception e) {
            UIUtil.showException(this, "Could not save " + new File(this.extractionModelFile).getName(), e);
            return false;
        }
        return true;
    }

    private void saveRestrictions(PrintWriter out) {
        out.println();
        out.println("# from A (or association name); to B; restriction-condition");
        for (RestrictionDefinition rd : this.currentRestrictionDefinitions) {
            String condition;
            String string = condition = rd.isIgnored ? "ignore" : rd.condition;
            if (rd.name == null || rd.name.trim().length() == 0) {
                out.println(CsvFile.encodeCell(rd.from.getName()) + "; " + CsvFile.encodeCell(rd.to.getName()) + "; " + CsvFile.encodeCell(condition));
                continue;
            }
            out.println(CsvFile.encodeCell(rd.name) + "; ; " + CsvFile.encodeCell(condition));
        }
    }

    public void saveRestrictions(File file) throws Exception {
        PrintWriter out = new PrintWriter(file);
        this.saveRestrictions(out);
        out.close();
    }

    private Set<Association> getAmbiguousNonames() {
        if (this.ambiguousNonames == null) {
            this.ambiguousNonames = new HashSet<Association>();
            for (Table table : this.dataModel.getTables()) {
                block1: for (Association a : table.associations) {
                    if (a.getName() != null) continue;
                    for (Association b : table.associations) {
                        if (a.equals(b) || !a.destination.equals(b.destination)) continue;
                        this.ambiguousNonames.add(a);
                        continue block1;
                    }
                }
            }
        }
        return this.ambiguousNonames;
    }

    public void refresh(boolean restoreSelection, boolean fullGraphModelReset, boolean storeLayout, boolean removeLayout) {
        Association association = this.currentAssociation;
        this.tree.setModel(this.getModel());
        this.resetGraphEditor(fullGraphModelReset, storeLayout, removeLayout, true);
        if (restoreSelection) {
            this.select(association);
        }
    }

    public void expand() {
        this.graphView.expandAll(false, null);
        this.expandPathsToVisibleTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showReachability(Table table) {
        try {
            LayoutStorage.enabled = false;
            this.refresh(false, true, false, true);
            this.resetGraphEditor(true, false, true, false);
        }
        finally {
            LayoutStorage.enabled = true;
        }
        this.graphView.expandAll(false, table);
        this.expandPathsToVisibleTables();
        if (this.graphView.isTableVisible(table)) {
            this.graphView.selectTable(table);
        }
    }

    public void expandAllVisibleTables() {
        this.graphView.expandAll(true, null);
        this.expandPathsToVisibleTables();
    }

    private void expandPathsToVisibleTables() {
        Set<Table> visibleTables = this.graphView.getVisibleTables();
        for (DefaultMutableTreeNode node : this.treeNodes) {
            if (node.getUserObject() instanceof Association && !visibleTables.contains(((Association)node.getUserObject()).destination)) continue;
            TreePath treePath = new TreePath(node.getPath());
            this.tree.expandPath(treePath);
        }
    }

    public void removeAllRestrictions(Table context) {
        for (Table table : this.dataModel.getTables()) {
            for (Association association : table.associations) {
                if (context != null && !association.source.equals(context) && !association.destination.equals(context)) continue;
                this.dataModel.getRestrictionModel().addRestriction(table, association, "", "GUI", true, new HashMap<String, String>());
            }
        }
        if (!this.needsSave) {
            this.needsSave = true;
            this.extractionModelFrame.updateTitle(this.needsSave);
        }
        this.tree.repaint();
        this.restrictionsTable.setModel(this.restrictionTableModel());
        this.initRestrictionEditor(this.currentAssociation, this.currentNode);
        this.graphView.resetExpandedState();
        this.extractionModelFrame.closureView.refresh();
        this.extractionModelFrame.closureBorderView.refresh();
        this.extractionModelFrame.restrictedDependenciesView.refresh();
    }

    public boolean isRemovalOfAllRestrictionsApplicable(Table context) {
        for (Table table : this.dataModel.getTables()) {
            for (Association association : table.associations) {
                if (association.isInsertDestinationBeforeSource() || context != null && !association.source.equals(context) && !association.destination.equals(context) || !association.isRestricted()) continue;
                return true;
            }
        }
        return false;
    }

    public void ignoreAll(Table context) {
        for (Table table : this.dataModel.getTables()) {
            for (Association association : table.associations) {
                if (association.isInsertDestinationBeforeSource() || association.getName() == null || "".equals(association.getName().trim()) || context != null && !association.source.equals(context) && !association.destination.equals(context)) continue;
                this.dataModel.getRestrictionModel().addRestriction(table, association, "false", "GUI", true, new HashMap<String, String>());
            }
        }
        if (!this.needsSave) {
            this.needsSave = true;
            this.extractionModelFrame.updateTitle(this.needsSave);
        }
        this.tree.repaint();
        this.restrictionsTable.setModel(this.restrictionTableModel());
        this.initRestrictionEditor(this.currentAssociation, this.currentNode);
        this.graphView.resetExpandedState();
        this.extractionModelFrame.closureView.refresh();
        this.extractionModelFrame.closureBorderView.refresh();
        this.extractionModelFrame.restrictedDependenciesView.refresh();
    }

    public boolean isIgnoreAllApplicable(Table context) {
        for (Table table : this.dataModel.getTables()) {
            for (Association association : table.associations) {
                if (association.isInsertDestinationBeforeSource() || association.getName() == null || "".equals(association.getName().trim()) || context != null && !association.source.equals(context) && !association.destination.equals(context) || association.isIgnored()) continue;
                return true;
            }
        }
        return false;
    }

    public void zoomToFit() {
        this.graphView.zoomToFit();
    }

    private ComboBoxModel getAggregationModel() {
        DefaultComboBoxModel<AggregationSchema> model = new DefaultComboBoxModel<AggregationSchema>();
        for (AggregationSchema aggregation : AggregationSchema.values()) {
            model.addElement(aggregation);
        }
        return model;
    }

    public void openColumnMapper(Table table) {
        if (this.columnMapperDialog.edit(this.dataModel, table)) {
            this.updateSketch();
            this.markDirty();
        }
    }

    public void markDirty() {
        if (!this.needsSave) {
            this.needsSave = true;
            this.extractionModelFrame.updateTitle(this.needsSave);
        }
    }

    public Set<Table> getCurrentSubjectClosure() {
        if (this.dataModel == null || this.subject == null) {
            return Collections.emptySet();
        }
        if (this.currentSubjectClosure == null || this.dataModel.getVersion() != this.closureVersion) {
            this.currentSubjectClosure = this.subject.closure(true);
            this.closureVersion = this.dataModel.getVersion();
        }
        return this.currentSubjectClosure;
    }
}

