/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jailer.Configuration;
import net.sf.jailer.DDLCreator;
import net.sf.jailer.ScriptFormat;
import net.sf.jailer.database.Session;
import net.sf.jailer.database.TemporaryTableScope;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.ParameterEditor;
import net.sf.jailer.ui.Settings;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.CsvFile;

public class ExportDialog
extends JDialog {
    boolean isOk = false;
    private ScriptFormat scriptFormat;
    private final DataModel dataModel;
    private static String previousSubjectCondition;
    private static String previousInitialSubjectCondition;
    private static String DEFAULT_SCHEMA;
    private Map<String, JTextField> schemaMappingFields = new HashMap<String, JTextField>();
    private Map<String, JTextField> sourceSchemaMappingFields = new HashMap<String, JTextField>();
    private Settings theSettings;
    private final Table subject;
    private ParameterEditor parameterEditor;
    private final List<String> initialArgs;
    private final String password;
    private Thread initScopeButtonThread;
    private ButtonGroup buttonGroup1;
    private JTextArea cliArea;
    private JButton copyButton;
    private JTextField delete;
    public JCheckBox explain;
    private JLabel exportLabel;
    private JTextField insert;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel parameterPanel;
    private JLabel placeholder;
    private JLabel placeholder1;
    private JTextField rowsPerThread;
    private JPanel schemaMappingPanel;
    private JRadioButton scopeGlobal;
    private JRadioButton scopeLocal;
    private JRadioButton scopeSession;
    private JLabel selectDeleteFile;
    private JLabel selectInsertFile;
    private JCheckBox sortedCheckBox;
    public JPanel sourceSchemaMappingPanel;
    private JLabel subjectTable;
    private JTextField threads;
    public JCheckBox unicode;
    private JCheckBox upsertCheckbox;
    private JTextField where;
    private Icon loadIcon;
    private static final long serialVersionUID = 952553009821662964L;

    public ExportDialog(Frame parent, DataModel dataModel, Table subject, String subjectCondition, Session session, List<String> initialArgs, String password) {
        super(parent, true);
        String dir = "/net/sf/jailer/resource";
        try {
            this.loadIcon = new ImageIcon(this.getClass().getResource(dir + "/load.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dataModel = dataModel;
        this.subject = subject;
        this.initialArgs = new ArrayList<String>(initialArgs);
        this.password = password;
        this.initComponents();
        this.parameterEditor = new ParameterEditor(parent);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.parameterPanel.add((Component)this.parameterEditor.createPane(dataModel.getParameters(subjectCondition)), gridBagConstraints);
        this.setModal(true);
        this.setLocation(100, 150);
        HashMap<String, JComponent> fields = new HashMap<String, JComponent>();
        fields.put("insert", this.insert);
        fields.put("delete", this.delete);
        fields.put("threads", this.threads);
        fields.put("rowsPerThread", this.rowsPerThread);
        fields.put("unicode", this.unicode);
        for (Map.Entry<String, JTextField> e : this.parameterEditor.textfieldsPerParameter.entrySet()) {
            fields.put("$" + e.getKey(), e.getValue());
        }
        this.scriptFormat = ScriptFormat.SQL;
        try {
            this.scriptFormat = ScriptFormat.valueOf(dataModel.getExportModus());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sortedCheckBox.setEnabled(ScriptFormat.SQL.equals((Object)this.scriptFormat) || ScriptFormat.DBUNIT_FLAT_XML.equals((Object)this.scriptFormat) || ScriptFormat.LIQUIBASE_XML.equals((Object)this.scriptFormat));
        this.sortedCheckBox.setSelected(true);
        this.upsertCheckbox.setEnabled(ScriptFormat.SQL.equals((Object)this.scriptFormat));
        this.rowsPerThread.setEnabled(ScriptFormat.SQL.equals((Object)this.scriptFormat));
        HashMap<JTextField, String> defaults = new HashMap<JTextField, String>();
        if (!(ScriptFormat.SQL.equals((Object)this.scriptFormat) || ScriptFormat.DBUNIT_FLAT_XML.equals((Object)this.scriptFormat) || ScriptFormat.LIQUIBASE_XML.equals((Object)this.scriptFormat))) {
            this.schemaMappingPanel.setVisible(false);
        } else {
            this.schemaMappingPanel.setVisible(true);
            this.initSchemaMapping(dataModel, fields, defaults);
        }
        this.initSourceSchemaMapping(dataModel, fields, defaults);
        this.theSettings = new Settings(".exportdata.ui", fields);
        this.theSettings.restore("default");
        for (JTextField field : defaults.keySet()) {
            if (field.getText().length() != 0) continue;
            field.setText((String)defaults.get(field));
        }
        if (this.threads.getText().length() == 0) {
            this.threads.setText("1");
        }
        if (this.rowsPerThread.getText().length() == 0) {
            this.rowsPerThread.setText("50");
        }
        this.subjectTable.setText(subject.getName());
        if (subjectCondition.equals(previousInitialSubjectCondition)) {
            this.where.setText(previousSubjectCondition);
        } else {
            this.where.setText(subjectCondition);
        }
        this.initScopeButtons(session);
        this.selectInsertFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ExportDialog.this.selectInsertFile.setEnabled(false);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ExportDialog.this.selectInsertFile.setEnabled(true);
            }
        });
        this.selectDeleteFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ExportDialog.this.selectDeleteFile.setEnabled(false);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ExportDialog.this.selectDeleteFile.setEnabled(true);
            }
        });
        this.selectInsertFile.setText("");
        this.selectInsertFile.setIcon(this.loadIcon);
        this.selectDeleteFile.setText("");
        this.selectDeleteFile.setIcon(this.loadIcon);
        if (this.parameterEditor.firstTextField != null) {
            this.parameterEditor.firstTextField.grabFocus();
        }
        DocumentListener dl = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportDialog.this.updateCLIArea();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportDialog.this.updateCLIArea();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportDialog.this.updateCLIArea();
            }
        };
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExportDialog.this.updateCLIArea();
            }
        };
        this.where.getDocument().addDocumentListener(dl);
        this.insert.getDocument().addDocumentListener(dl);
        this.delete.getDocument().addDocumentListener(dl);
        this.threads.getDocument().addDocumentListener(dl);
        this.rowsPerThread.getDocument().addDocumentListener(dl);
        this.upsertCheckbox.addActionListener(al);
        this.explain.addActionListener(al);
        this.unicode.addActionListener(al);
        this.sortedCheckBox.addActionListener(al);
        this.scopeGlobal.addActionListener(al);
        this.scopeSession.addActionListener(al);
        this.scopeLocal.addActionListener(al);
        for (JTextField field : this.parameterEditor.textfieldsPerParameter.values()) {
            field.getDocument().addDocumentListener(dl);
        }
        this.updateCLIArea();
        this.pack();
        this.setSize(Math.max(Math.min(this.getSize().width, 900), 580), this.getSize().height);
        this.placeholder.setVisible(false);
        this.placeholder1.setVisible(false);
        UIUtil.initPeer();
        UIUtil.fit(this);
        this.setVisible(true);
        try {
            if (this.initScopeButtonThread != null) {
                this.initScopeButtonThread.join();
            }
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        this.initScopeButtonThread = null;
        if (this.isOk) {
            previousInitialSubjectCondition = subjectCondition;
            previousSubjectCondition = this.where.getText();
        }
    }

    private void updateCLIArea() {
        this.explain.setEnabled(!this.scopeLocal.isSelected());
        if (this.scopeLocal.isSelected()) {
            this.explain.setSelected(false);
        }
        ArrayList<String> args = new ArrayList<String>(this.initialArgs);
        this.fillCLIArgs(args);
        String cmd = "sh jailer.sh";
        if (System.getProperty("os.name", "").toLowerCase().startsWith("windows")) {
            cmd = "jailer.bat";
        }
        this.cliArea.setText(cmd + UIUtil.createCLIArgumentString(this.password, args));
        this.cliArea.setCaretPosition(0);
        this.jScrollPane1.getViewport().setViewPosition(new Point(0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initScopeButtons(final Session session) {
        ExportDialog exportDialog = this;
        synchronized (exportDialog) {
            this.scopeGlobal.setSelected(false);
            this.scopeGlobal.setEnabled(false);
            this.scopeSession.setSelected(false);
            this.scopeSession.setEnabled(false);
            this.scopeLocal.setSelected(true);
            this.jButton1.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.updateCLIArea();
        }
        CancellationHandler.reset(null);
        this.initScopeButtonThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Configuration configuration = Configuration.forDbms(session);
                boolean ok = false;
                if (configuration.sessionTemporaryTableManager != null) {
                    try {
                        session.reconnect();
                        DDLCreator.createDDL(ExportDialog.this.dataModel, session, TemporaryTableScope.SESSION_LOCAL);
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                ExportDialog exportDialog = ExportDialog.this;
                                synchronized (exportDialog) {
                                    ExportDialog.this.scopeSession.setEnabled(true);
                                    ExportDialog.this.scopeGlobal.setEnabled(true);
                                    ExportDialog.this.scopeLocal.setSelected(false);
                                    ExportDialog.this.scopeGlobal.setSelected(false);
                                    ExportDialog.this.scopeSession.setSelected(true);
                                    ExportDialog.this.updateCLIArea();
                                }
                            }
                        });
                        ok = true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!ok) {
                    try {
                        DDLCreator.createDDL(ExportDialog.this.dataModel, session, TemporaryTableScope.GLOBAL);
                        ok = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (ok) {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                ExportDialog exportDialog = ExportDialog.this;
                                synchronized (exportDialog) {
                                    ExportDialog.this.scopeGlobal.setEnabled(true);
                                    ExportDialog.this.scopeLocal.setSelected(false);
                                    ExportDialog.this.scopeSession.setSelected(false);
                                    ExportDialog.this.scopeGlobal.setSelected(true);
                                    ExportDialog.this.updateCLIArea();
                                }
                            }
                        });
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ExportDialog exportDialog = ExportDialog.this;
                        synchronized (exportDialog) {
                            ExportDialog.this.jButton1.setEnabled(true);
                            ExportDialog.this.setCursor(Cursor.getDefaultCursor());
                            ExportDialog.this.updateCLIArea();
                        }
                    }
                });
            }
        });
        this.initScopeButtonThread.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ExportDialog exportDialog = ExportDialog.this;
                        synchronized (exportDialog) {
                            ExportDialog.this.jButton1.setEnabled(true);
                            ExportDialog.this.setCursor(Cursor.getDefaultCursor());
                            ExportDialog.this.updateCLIArea();
                        }
                    }
                });
            }
        }).start();
    }

    private void initSchemaMapping(DataModel dataModel, Map<String, JComponent> fields, Map<JTextField, String> defaults) {
        HashSet<String> distinctSchemas = new HashSet<String>();
        for (Table table : dataModel.getTables()) {
            String schema = table.getOriginalSchema(DEFAULT_SCHEMA);
            distinctSchemas.add(schema);
        }
        ArrayList sortedSchemaList = new ArrayList(distinctSchemas);
        Collections.sort(sortedSchemaList);
        Set<String> relevantSchemas = this.getRelevantSchemas(true);
        int y = 0;
        for (String schema : sortedSchemaList) {
            boolean add = relevantSchemas.contains(schema.equals(DEFAULT_SCHEMA) ? "" : schema);
            JLabel a = new JLabel(schema);
            a.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.anchor = 13;
            if (add) {
                this.schemaMappingPanel.add((Component)a, gridBagConstraints);
            }
            JLabel b = new JLabel(" into schema ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = y;
            if (add) {
                this.schemaMappingPanel.add((Component)b, gridBagConstraints);
            }
            JTextField c = new JTextField(schema);
            c.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ExportDialog.this.updateCLIArea();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ExportDialog.this.updateCLIArea();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ExportDialog.this.updateCLIArea();
                }
            });
            fields.put("schema-" + schema, c);
            defaults.put(c, schema);
            this.schemaMappingFields.put(schema, c);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            if (add) {
                this.schemaMappingPanel.add((Component)c, gridBagConstraints);
            }
            if (!add) continue;
            ++y;
        }
    }

    private void initSourceSchemaMapping(DataModel dataModel, Map<String, JComponent> fields, Map<JTextField, String> defaults) {
        HashSet<String> distinctSchemas = new HashSet<String>();
        for (Table table : dataModel.getTables()) {
            String schema = table.getOriginalSchema(DEFAULT_SCHEMA);
            distinctSchemas.add(schema);
        }
        ArrayList sortedSchemaList = new ArrayList(distinctSchemas);
        Collections.sort(sortedSchemaList);
        Set<String> relevantSchemas = this.getRelevantSchemas(true);
        int y = 0;
        for (String schema : sortedSchemaList) {
            boolean add = relevantSchemas.contains(schema.equals(DEFAULT_SCHEMA) ? "" : schema);
            JLabel b = new JLabel(" instead of ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = y;
            if (add) {
                this.sourceSchemaMappingPanel.add((Component)b, gridBagConstraints);
            }
            JTextField c = new JTextField(schema);
            c.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ExportDialog.this.updateCLIArea();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ExportDialog.this.updateCLIArea();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ExportDialog.this.updateCLIArea();
                }
            });
            fields.put("srcschema-" + schema, c);
            defaults.put(c, schema);
            this.sourceSchemaMappingFields.put(schema, c);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            if (add) {
                this.sourceSchemaMappingPanel.add((Component)c, gridBagConstraints);
            }
            JLabel a = new JLabel(schema);
            a.setFont(new Font("Dialog", 0, 12));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = y;
            gridBagConstraints.anchor = 17;
            if (add) {
                this.sourceSchemaMappingPanel.add((Component)a, gridBagConstraints);
            }
            if (!add) continue;
            ++y;
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.sourceSchemaMappingPanel = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.schemaMappingPanel = new JPanel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.where = new JTextField();
        this.exportLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.insert = new JTextField();
        this.delete = new JTextField();
        this.jPanel3 = new JPanel();
        this.threads = new JTextField();
        this.jLabel10 = new JLabel();
        this.rowsPerThread = new JTextField();
        this.jLabel17 = new JLabel();
        this.upsertCheckbox = new JCheckBox();
        this.explain = new JCheckBox();
        this.placeholder = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jPanel4 = new JPanel();
        this.subjectTable = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jPanel8 = new JPanel();
        this.scopeSession = new JRadioButton();
        this.scopeGlobal = new JRadioButton();
        this.scopeLocal = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel9 = new JLabel();
        this.selectInsertFile = new JLabel();
        this.selectDeleteFile = new JLabel();
        this.jLabel21 = new JLabel();
        this.parameterPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel22 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.cliArea = new JTextArea();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.copyButton = new JButton();
        this.placeholder1 = new JLabel();
        this.sortedCheckBox = new JCheckBox();
        this.unicode = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Export");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel1.setLayout(new GridBagLayout());
        this.sourceSchemaMappingPanel.setLayout(new GridBagLayout());
        this.jLabel18.setText(" Read from schema ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.sourceSchemaMappingPanel.add((Component)this.jLabel18, gridBagConstraints);
        this.jLabel19.setFont(new Font("Dialog", 0, 12));
        this.jLabel19.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.sourceSchemaMappingPanel.add((Component)this.jLabel19, gridBagConstraints);
        this.jLabel20.setText("                          ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 200;
        gridBagConstraints.fill = 2;
        this.sourceSchemaMappingPanel.add((Component)this.jLabel20, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 78;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.sourceSchemaMappingPanel, gridBagConstraints);
        this.schemaMappingPanel.setLayout(new GridBagLayout());
        this.jLabel13.setText(" Import rows from schema ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.schemaMappingPanel.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel14.setFont(new Font("Dialog", 0, 12));
        this.jLabel14.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.schemaMappingPanel.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel15.setText("                          ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 200;
        gridBagConstraints.fill = 2;
        this.schemaMappingPanel.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 80;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.schemaMappingPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.jPanel1.add((Component)this.where, gridBagConstraints);
        this.exportLabel.setText(" Into*");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.exportLabel, gridBagConstraints);
        this.jLabel3.setText(" Generate delete-script* ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel5.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 45;
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(" Threads ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.jPanel1.add((Component)this.insert, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.jPanel1.add((Component)this.delete, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.threads.setMinimumSize(new Dimension(44, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.threads, gridBagConstraints);
        this.jLabel10.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.jPanel3.add((Component)this.rowsPerThread, gridBagConstraints);
        this.jLabel17.setText("           ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel3.add((Component)this.jLabel17, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.upsertCheckbox.setText("upsert-statements (overwrite) for all rows");
        this.upsertCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 44;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.jPanel1.add((Component)this.upsertCheckbox, gridBagConstraints);
        this.explain.setText("explain");
        this.explain.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 45;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 4, 0);
        this.jPanel1.add((Component)this.explain, gridBagConstraints);
        this.placeholder.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.placeholder, gridBagConstraints);
        this.jLabel4.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel8.setText(" Working table scope");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 55;
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel7.setText(" Export from");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel11.setText(" Where");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jLabel11, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.subjectTable.setFont(new Font("Dialog", 0, 12));
        this.subjectTable.setText("jLabel11");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel4.add((Component)this.subjectTable, gridBagConstraints);
        this.jLabel12.setText("  as T");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel4.add((Component)this.jLabel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jLabel16.setText(" Rows per statement");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 51;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel16, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.scopeSession);
        this.scopeSession.setText("temporary tables    ");
        this.scopeSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.scopeSessionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 58;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.scopeSession, gridBagConstraints);
        this.buttonGroup1.add(this.scopeGlobal);
        this.scopeGlobal.setText("global tables");
        this.scopeGlobal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.scopeGlobalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 56;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.scopeGlobal, gridBagConstraints);
        this.buttonGroup1.add(this.scopeLocal);
        this.scopeLocal.setText("local database");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 55;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.scopeLocal, gridBagConstraints);
        this.jLabel1.setForeground(new Color(128, 128, 128));
        this.jLabel1.setText("  (fastest)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 58;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel8.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel26.setForeground(new Color(128, 128, 128));
        this.jLabel26.setText("  (fast)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 56;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel8.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setForeground(new Color(128, 128, 128));
        this.jLabel27.setText("  (slow)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 55;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel8.add((Component)this.jLabel27, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 55;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jPanel8, gridBagConstraints);
        this.jLabel9.setText("           ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 58;
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.selectInsertFile.setText("jLabel21");
        this.selectInsertFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExportDialog.this.selectInsertFileMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel1.add((Component)this.selectInsertFile, gridBagConstraints);
        this.selectDeleteFile.setText("jLabel21");
        this.selectDeleteFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExportDialog.this.selectDeleteFileMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel1.add((Component)this.selectDeleteFile, gridBagConstraints);
        this.jLabel21.setText(" With");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.jPanel1.add((Component)this.jLabel21, gridBagConstraints);
        this.parameterPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.parameterPanel, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel22.setText(" Command line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.jLabel22, gridBagConstraints);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.cliArea.setColumns(20);
        this.cliArea.setEditable(false);
        this.cliArea.setLineWrap(true);
        this.cliArea.setRows(5);
        this.cliArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.cliArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel5.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel23.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel5.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel5.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel25.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel5.add((Component)this.jLabel25, gridBagConstraints);
        this.copyButton.setText("Copy");
        this.copyButton.setToolTipText("Copy to Clipboard");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.copyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel5.add((Component)this.copyButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 85;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.placeholder1.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.placeholder1, gridBagConstraints);
        this.sortedCheckBox.setText("sort topologically");
        this.sortedCheckBox.setToolTipText("sort exported rows according to dependencies");
        this.sortedCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sortedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.sortedCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 42;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.jPanel1.add((Component)this.sortedCheckBox, gridBagConstraints);
        this.unicode.setText("UTF-8 encoding");
        this.unicode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.unicode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.unicodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 46;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 4, 0);
        this.jPanel1.add((Component)this.unicode, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.jPanel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel7.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButton1.setText("Export Data");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 6);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        this.jLabel2.setText(" *  add '.zip' suffix for compressed files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel7, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        for (JTextField f : this.schemaMappingFields.values()) {
            if (f.getText().trim().length() != 0) continue;
            f.setText(DEFAULT_SCHEMA);
        }
        for (JTextField f : this.sourceSchemaMappingFields.values()) {
            if (f.getText().trim().length() != 0) continue;
            f.setText(DEFAULT_SCHEMA);
        }
        this.theSettings.save("default");
        if (this.insert.getText().trim().length() == 0) {
            this.exportLabel.setForeground(Color.RED);
        } else {
            this.isOk = true;
            this.setVisible(false);
        }
    }

    private void scopeGlobalActionPerformed(ActionEvent evt) {
    }

    private void selectInsertFileMouseClicked(MouseEvent evt) {
        String fn = UIUtil.choseFile(null, ".", this.scriptFormat.getFileChooserTitle(), this.scriptFormat.getFileExtension(), this, true, false);
        if (fn != null) {
            this.insert.setText(fn);
        }
    }

    private void selectDeleteFileMouseClicked(MouseEvent evt) {
        String fn = UIUtil.choseFile(null, ".", "SQL Delete Script", ".sql", this, true, true);
        if (fn != null) {
            this.delete.setText(fn);
        }
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        this.cliArea.selectAll();
        this.cliArea.copy();
        this.updateCLIArea();
    }

    private void sortedCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void scopeSessionActionPerformed(ActionEvent evt) {
    }

    private void unicodeActionPerformed(ActionEvent evt) {
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void fillCLIArgs(List<String> args) {
        File excludeFromDeletion;
        int nt;
        boolean withDelete = false;
        args.add("-e");
        args.add(this.insert.getText());
        if (this.delete.getText().trim().length() > 0) {
            withDelete = true;
            args.add("-d");
            args.add(this.delete.getText().trim());
        }
        if (this.explain.isSelected()) {
            args.add("-explain");
        }
        if (this.unicode.isSelected()) {
            args.add("-UTF8");
        }
        if (this.upsertCheckbox.isSelected()) {
            args.add("-upsert-only");
        }
        if (!this.sortedCheckBox.isSelected()) {
            args.add("-no-sorting");
        }
        try {
            nt = Integer.parseInt(this.threads.getText().trim());
            if (nt > 0 && nt <= 100) {
                args.add("-threads");
                args.add("" + nt);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            nt = Integer.parseInt(this.rowsPerThread.getText().trim());
            if (nt > 0) {
                args.add("-entities");
                args.add("" + nt);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        args.add("-where");
        args.add(this.where.getText());
        args.add("-format");
        args.add(this.scriptFormat.toString());
        if (ScriptFormat.XML.equals((Object)this.scriptFormat)) {
            args.add("-xml");
            args.add("-xml-root");
            args.add(this.dataModel.getXmlSettings().rootTag);
            args.add("-xml-date");
            args.add(this.dataModel.getXmlSettings().datePattern);
            args.add("-xml-timestamp");
            args.add(this.dataModel.getXmlSettings().timestampPattern);
        }
        StringBuilder schemaMapping = new StringBuilder();
        for (String schema : this.schemaMappingFields.keySet()) {
            String to = this.schemaMappingFields.get(schema).getText().trim();
            if (to.equals(DEFAULT_SCHEMA)) {
                to = "";
            }
            if (schemaMapping.length() > 0) {
                schemaMapping.append(",");
            }
            schemaMapping.append((schema.equals(DEFAULT_SCHEMA) ? "" : schema) + "=" + to);
        }
        if (schemaMapping.length() > 0) {
            args.add("-schemamapping");
            args.add(schemaMapping.toString());
        }
        StringBuilder parameter = new StringBuilder();
        for (String p : this.parameterEditor.textfieldsPerParameter.keySet()) {
            String v = this.parameterEditor.textfieldsPerParameter.get(p).getText().trim();
            if (parameter.length() > 0) {
                parameter.append(";");
            }
            parameter.append(p + "=" + CsvFile.encodeCell(v));
        }
        if (parameter.length() > 0) {
            args.add("-parameters");
            args.add(parameter.toString());
        }
        Set<String> relevantSchemas = this.getRelevantSchemas(withDelete);
        StringBuilder sourceSchemaMapping = new StringBuilder();
        for (String schema : this.sourceSchemaMappingFields.keySet()) {
            String to = this.sourceSchemaMappingFields.get(schema).getText().trim();
            if (to.equals(DEFAULT_SCHEMA)) {
                to = "";
            }
            if (sourceSchemaMapping.length() > 0) {
                sourceSchemaMapping.append(",");
            }
            if (!relevantSchemas.contains(schema.equals(DEFAULT_SCHEMA) ? "" : schema)) {
                to = "I/" + schema;
            }
            sourceSchemaMapping.append((schema.equals(DEFAULT_SCHEMA) ? "" : schema) + "=" + to);
        }
        if (sourceSchemaMapping.length() > 0) {
            args.add("-source-schemamapping");
            args.add(sourceSchemaMapping.toString());
        }
        if ((excludeFromDeletion = new File(DataModel.getExcludeFromDeletionFile())).exists()) {
            args.add("-t");
            args.add(DataModel.getExcludeFromDeletionFile());
        }
        args.add("-scope");
        args.add(this.getTemporaryTableScope().toString());
    }

    private Set<String> getRelevantSchemas(boolean withDelete) {
        Set<Table> closure = this.subject.closure(true);
        if (withDelete) {
            HashSet<Table> border = new HashSet<Table>();
            for (Table table : closure) {
                for (Association a : table.associations) {
                    if (a.reversalAssociation.isIgnored()) continue;
                    border.add(a.destination);
                }
            }
            closure.addAll(border);
        }
        HashSet<String> relevantSchemas = new HashSet<String>();
        for (Table table : closure) {
            relevantSchemas.add(table.getOriginalSchema(""));
        }
        return relevantSchemas;
    }

    public TemporaryTableScope getTemporaryTableScope() {
        if (this.scopeLocal.isSelected()) {
            return TemporaryTableScope.LOCAL_DATABASE;
        }
        if (this.scopeSession.isSelected()) {
            return TemporaryTableScope.SESSION_LOCAL;
        }
        return TemporaryTableScope.GLOBAL;
    }

    static {
        DEFAULT_SCHEMA = "<default>";
    }
}

