/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.jailer.database.Session;
import net.sf.jailer.modelbuilder.JDBCMetaDataBasedModelElementFinder;
import net.sf.jailer.ui.DataModelManager;
import net.sf.jailer.ui.DbConnectionDetailsEditor;
import net.sf.jailer.ui.InfoBar;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.ClasspathUtil;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.Pair;

public class DbConnectionDialog
extends JDialog {
    public boolean isConnected = false;
    private List<ConnectionInfo> connectionList;
    public ConnectionInfo currentConnection;
    private final Frame parent;
    private final InfoBar infoBar;
    private boolean inRefresh = false;
    private String jdbcHelpURL = "http://jailer.sourceforge.net/doc/jdbc.html?src=app";
    private static String CONNECTIONS_FILE = ".connections";
    private JTable connectionsTable;
    private JButton copy;
    private JButton deleteButton;
    private JButton downButton;
    private JButton editButton;
    private JLabel infoBarLabel;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JButton newButton;
    private JButton upButton;
    private static final long serialVersionUID = -3983034803834547687L;

    public boolean connect(String reason) {
        this.setTitle((reason == null ? "" : reason + " - ") + "Connect.");
        this.refresh();
        this.setVisible(true);
        return this.isConnected;
    }

    public DbConnectionDialog(Frame parent, DbConnectionDialog other, String applicationName) {
        this(parent, applicationName, other.infoBar == null ? null : new InfoBar(other.infoBar));
        this.isConnected = other.isConnected;
        this.connectionList = other.connectionList;
        if (other.currentConnection != null) {
            try {
                this.currentConnection = (ConnectionInfo)other.currentConnection.clone();
            }
            catch (CloneNotSupportedException e) {
                this.currentConnection = other.currentConnection;
            }
        }
    }

    public DbConnectionDialog(Frame parent, String applicationName, InfoBar infoBar) {
        super(parent, true);
        int i;
        this.parent = parent;
        this.infoBar = infoBar;
        this.loadConnectionList();
        this.initComponents();
        if (infoBar == null) {
            infoBar = new InfoBar("Connect with Database", "Select a connection to the database, or create a new connection.\nNew connections will be assigned to the datamodel \"" + (String)DataModelManager.getModelDetails((String)DataModelManager.getCurrentModelSubfolder()).a + "\".");
        }
        UIUtil.replace(this.infoBarLabel, infoBar);
        this.initTableModel();
        final TableCellRenderer defaultTableCellRenderer = this.connectionsTable.getDefaultRenderer(String.class);
        this.connectionsTable.setShowGrid(false);
        this.connectionsTable.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component render = defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (render instanceof JLabel) {
                    if (!isSelected) {
                        Color BG1 = new Color(255, 255, 255);
                        Color BG2 = new Color(230, 255, 255);
                        ((JLabel)render).setBackground(row % 2 == 0 ? BG1 : BG2);
                    } else {
                        ((JLabel)render).setBackground(new Color(160, 160, 255));
                    }
                    boolean inContext = DbConnectionDialog.this.isAssignedToDataModel(row);
                    if (inContext) {
                        ((JLabel)render).setForeground(Color.black);
                    } else {
                        ((JLabel)render).setForeground(Color.gray);
                    }
                }
                return render;
            }
        });
        this.connectionsTable.setSelectionMode(0);
        this.connectionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DbConnectionDialog.this.refresh();
            }
        });
        if (this.currentConnection != null && (i = this.connectionList.indexOf(this.currentConnection)) >= 0) {
            this.connectionsTable.getSelectionModel().setSelectionInterval(i, i);
        }
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (DbConnectionDialog.this.connectionList != null && DbConnectionDialog.this.connectionList.isEmpty()) {
                    DbConnectionDialog.this.newButtonActionPerformed(null);
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
        this.setLocation(100, 150);
        this.pack();
        this.setSize(Math.max(710, this.getWidth()), 450);
        this.refresh();
        UIUtil.initPeer();
    }

    private Object[][] initTableModel() {
        Object[][] data = new Object[this.connectionList.size()][];
        int i = 0;
        for (ConnectionInfo ci : this.connectionList) {
            Pair<String, Long> modelDetails = DataModelManager.getModelDetails(ci.dataModelFolder);
            data[i++] = new Object[]{ci.alias, ci.user, ci.url, modelDetails == null ? "" : (String)modelDetails.a};
        }
        DefaultTableModel tableModel = new DefaultTableModel(data, new String[]{"Alias", "User", "URL", "Data Model"}){
            private static final long serialVersionUID = 1535384744352159695L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.connectionsTable.setModel(tableModel);
        return data;
    }

    public synchronized void setJdbcHelpURL(String jdbcHelpURL) {
        this.jdbcHelpURL = jdbcHelpURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (this.inRefresh) {
            return;
        }
        this.inRefresh = true;
        try {
            int selectedRow = this.connectionsTable.getSelectedRow();
            Object[][] data = this.initTableModel();
            if (selectedRow >= 0) {
                this.connectionsTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                this.currentConnection = this.connectionList.get(selectedRow);
            } else {
                this.currentConnection = null;
            }
            for (int i = 0; i < this.connectionsTable.getColumnCount(); ++i) {
                TableColumn column = this.connectionsTable.getColumnModel().getColumn(i);
                int width = 1;
                Component comp = this.connectionsTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.connectionsTable, column.getHeaderValue(), false, false, 0, i);
                width = Math.max(width, comp.getPreferredSize().width);
                for (int line = 0; line < data.length; ++line) {
                    comp = this.connectionsTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.connectionsTable, data[line][i], false, false, line, i);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
                column.setPreferredWidth(width);
            }
            this.editButton.setEnabled(this.currentConnection != null);
            this.deleteButton.setEnabled(this.currentConnection != null);
            this.copy.setEnabled(this.currentConnection != null);
            this.upButton.setEnabled(this.currentConnection != null && selectedRow > 0);
            this.downButton.setEnabled(this.currentConnection != null && selectedRow < this.connectionList.size() - 1);
            this.jButton1.setEnabled(this.currentConnection != null && selectedRow >= 0 && selectedRow < this.connectionList.size() && this.isAssignedToDataModel(selectedRow));
        }
        finally {
            this.inRefresh = false;
        }
    }

    private void store() {
        try {
            File file = new File(CONNECTIONS_FILE);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(this.connectionList);
            out.writeInt(this.connectionList.indexOf(this.currentConnection));
            ArrayList<String> dataModels = new ArrayList<String>();
            for (ConnectionInfo ci : this.connectionList) {
                dataModels.add(ci.dataModelFolder);
            }
            out.writeObject(dataModels);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadConnectionList() {
        ConnectionInfo ci;
        ObjectInputStream in;
        boolean preV4;
        boolean ok;
        block14: {
            this.connectionList = new ArrayList<ConnectionInfo>();
            this.currentConnection = null;
            ok = false;
            preV4 = true;
            try {
                File file = new File(CONNECTIONS_FILE);
                if (!file.exists()) break block14;
                in = new ObjectInputStream(new FileInputStream(CONNECTIONS_FILE));
                List cis = (List)in.readObject();
                int i = in.readInt();
                try {
                    List dma = (List)in.readObject();
                    for (int n = 0; n < dma.size(); ++n) {
                        ((ConnectionInfo)cis.get((int)n)).dataModelFolder = (String)dma.get(n);
                    }
                    preV4 = false;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                in.close();
                this.connectionList = cis;
                if (i < 0 || i < this.connectionList.size()) {
                    // empty if block
                }
                ok = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!ok) {
            try {
                File settingsFile = new File(".connect.ui");
                if (settingsFile.exists()) {
                    in = new ObjectInputStream(new FileInputStream(settingsFile));
                    Map settings = (Map)in.readObject();
                    in.close();
                    for (String name : settings.keySet()) {
                        if (((String)((Map)settings.get(name)).get("dbUser")).trim().length() <= 0) continue;
                        ConnectionInfo ci2 = new ConnectionInfo();
                        ci2.alias = name;
                        ci2.driverClass = (String)((Map)settings.get(name)).get("driver");
                        ci2.user = (String)((Map)settings.get(name)).get("dbUser");
                        ci2.url = (String)((Map)settings.get(name)).get("dbUrl");
                        ci2.password = (String)((Map)settings.get(name)).get("password");
                        ci2.jar1 = (String)((Map)settings.get(name)).get("jar1");
                        ci2.jar2 = (String)((Map)settings.get(name)).get("jar2");
                        this.connectionList.add(ci2);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.connectionList.size() == 0) {
            ci = new ConnectionInfo();
            ci.alias = "Demo Scott";
            ci.driverClass = "org.h2.Driver";
            ci.jar1 = "lib" + File.separator + "h2-1.3.160.jar";
            ci.url = "jdbc:h2:demo-scott";
            ci.user = "sa";
            ci.password = "";
            ci.dataModelFolder = "Demo-Scott";
            this.connectionList.add(ci);
            this.store();
        }
        if (preV4) {
            ci = new ConnectionInfo();
            ci.alias = "Demo Sakila";
            ci.driverClass = "org.h2.Driver";
            ci.jar1 = "lib" + File.separator + "h2-1.3.160.jar";
            ci.url = "jdbc:h2:demo-sakila";
            ci.user = "sa";
            ci.password = "";
            ci.dataModelFolder = "Demo-Sakila";
            this.connectionList.add(ci);
            this.store();
        }
        if (this.connectionList.size() == 1) {
            this.currentConnection = this.connectionList.get(0);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.jPanel3 = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.copy = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.infoBarLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.connectionsTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("Connect with DB");
        this.getContentPane().setLayout(new CardLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButton2.setText(" Cancel ");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDialog.this.jButton2ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel2.add((Component)this.jButton2, gridBagConstraints);
        this.jButton1.setText(" Connect ");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.newButton.setText(" New ");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDialog.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(16, 4, 2, 0);
        this.jPanel3.add((Component)this.newButton, gridBagConstraints);
        this.editButton.setText(" Edit ");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDialog.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.jPanel3.add((Component)this.editButton, gridBagConstraints);
        this.copy.setText(" Copy ");
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDialog.this.copyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.jPanel3.add((Component)this.copy, gridBagConstraints);
        this.deleteButton.setText(" Delete ");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.jPanel3.add((Component)this.deleteButton, gridBagConstraints);
        this.upButton.setText(" Up ");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDialog.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 2, 0);
        this.jPanel3.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(" Down ");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDialog.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.downButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = 11;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.infoBarLabel.setText("info bar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.infoBarLabel, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Connections"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.connectionsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.connectionsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "card2");
        this.pack();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int i;
        if (this.currentConnection != null && (i = this.connectionList.indexOf(this.currentConnection)) > 0) {
            this.connectionList.set(i, this.connectionList.get(i - 1));
            this.connectionList.set(i - 1, this.currentConnection);
            this.connectionsTable.getSelectionModel().setSelectionInterval(i - 1, i - 1);
            this.refresh();
            this.store();
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int i;
        if (this.currentConnection != null && (i = this.connectionList.indexOf(this.currentConnection)) < this.connectionList.size() - 1) {
            this.connectionList.set(i, this.connectionList.get(i + 1));
            this.connectionList.set(i + 1, this.currentConnection);
            this.connectionsTable.getSelectionModel().setSelectionInterval(i + 1, i + 1);
            this.refresh();
            this.store();
        }
    }

    private void copyActionPerformed(ActionEvent evt) {
        int i;
        if (this.currentConnection != null && (i = this.connectionList.indexOf(this.currentConnection)) >= 0) {
            int nr = 1;
            while (true) {
                String newAlias = "Copy of " + this.currentConnection.alias + (nr > 1 ? " (" + nr + ")" : "");
                boolean found = false;
                for (ConnectionInfo ci : this.connectionList) {
                    if (!ci.alias.equals(newAlias)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ConnectionInfo ci = new ConnectionInfo();
                    ci.alias = newAlias;
                    ci.driverClass = this.currentConnection.driverClass;
                    ci.jar1 = this.currentConnection.jar1;
                    ci.jar2 = this.currentConnection.jar2;
                    ci.password = this.currentConnection.password;
                    ci.url = this.currentConnection.url;
                    ci.user = this.currentConnection.user;
                    this.connectionList.add(i + 1, ci);
                    this.connectionsTable.getSelectionModel().setSelectionInterval(i + 1, i + 1);
                    this.refresh();
                    this.store();
                    break;
                }
                ++nr;
            }
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int i;
        if (this.currentConnection != null && (i = this.connectionList.indexOf(this.currentConnection)) >= 0 && JOptionPane.showConfirmDialog(this, "Delete '" + this.currentConnection.alias + "'?", "Delete", 0, 3) == 0) {
            this.connectionList.remove(i);
            this.connectionsTable.getSelectionModel().clearSelection();
            this.refresh();
            this.store();
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        ConnectionInfo ci = new ConnectionInfo();
        try {
            CsvFile drivers = new CsvFile(new File("driverlist.csv"));
            ArrayList<CsvFile.Line> lines = new ArrayList<CsvFile.Line>(drivers.getLines());
            Collections.sort(lines, new Comparator<CsvFile.Line>(){

                @Override
                public int compare(CsvFile.Line o1, CsvFile.Line o2) {
                    return o1.cells.get(0).compareTo(o2.cells.get(0));
                }
            });
            ArrayList<String> dbmsNames = new ArrayList<String>();
            for (CsvFile.Line line : lines) {
                if (line.cells.get(0).length() <= 0) continue;
                dbmsNames.add(line.cells.get(0));
            }
            String s = (String)JOptionPane.showInputDialog(this, "Select DBMS", "Select DBMS", 3, null, dbmsNames.toArray(), dbmsNames.get(0));
            if (s == null) {
                return;
            }
            for (CsvFile.Line line : lines) {
                if (!line.cells.get(0).equals(s)) continue;
                ci.url = line.cells.get(1);
                ci.driverClass = line.cells.get(2);
                String[] jars = line.cells.get(3).replace("/", File.separator).split(" ");
                if (jars.length > 0) {
                    ci.jar1 = jars[0];
                }
                if (jars.length > 1) {
                    ci.jar2 = jars[1];
                }
                ci.alias = s;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.edit(ci, true)) {
            int nr = 1;
            while (true) {
                String newAlias = ci.alias + (nr > 1 ? " (" + nr + ")" : "");
                boolean found = false;
                for (ConnectionInfo ci2 : this.connectionList) {
                    if (!newAlias.equals(ci2.alias)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ci.alias = newAlias;
                    this.connectionList.add(ci);
                    int i = this.connectionList.size() - 1;
                    this.connectionsTable.getSelectionModel().setSelectionInterval(i, i);
                    this.refresh();
                    this.store();
                    break;
                }
                ++nr;
            }
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        if (this.currentConnection == null) {
            return;
        }
        if (this.edit(this.currentConnection, false)) {
            this.refresh();
            this.store();
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.isConnected = false;
        this.setVisible(false);
    }

    private boolean edit(ConnectionInfo ci, boolean forNew) {
        return new DbConnectionDetailsEditor(this.parent, this.jdbcHelpURL, forNew).edit(ci);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.currentConnection == null) {
            return;
        }
        this.isConnected = false;
        if (DbConnectionDialog.testConnection(this, this.currentConnection)) {
            this.isConnected = true;
            this.setVisible(false);
        }
    }

    public static boolean testConnection(Component parent, ConnectionInfo ci) {
        String d1 = ci.jar1.trim();
        String d2 = ci.jar2.trim();
        if (d1.length() == 0) {
            d1 = null;
        }
        if (d2.length() == 0) {
            d2 = null;
        }
        try {
            Session.setClassLoaderForJdbcDriver(ClasspathUtil.addJarToClasspath(d1, d2));
        }
        catch (Exception e) {
            UIUtil.showException(parent, "Error loading driver jars", e);
            return false;
        }
        try {
            if (Session.classLoaderForJdbcDriver != null) {
                Driver d = (Driver)Class.forName(ci.driverClass, true, Session.classLoaderForJdbcDriver).newInstance();
                DriverManager.registerDriver(new Session.DriverShim(d));
            } else {
                Class.forName(ci.driverClass);
            }
            Connection con = DriverManager.getConnection(ci.url, ci.user, ci.password);
            con.close();
            return true;
        }
        catch (ClassNotFoundException e) {
            UIUtil.showException(parent, "Could not connect to DB", new ClassNotFoundException("JDBC driver class not found: '" + e.getMessage() + "'", e));
            return false;
        }
        catch (Exception e) {
            UIUtil.showException(parent, "Could not connect to DB", e);
            return false;
        }
    }

    public List<String> getDBSchemas(String[] defaultSchema) throws Exception {
        Session session = new Session(this.currentConnection.driverClass, this.currentConnection.url, this.currentConnection.user, this.currentConnection.password);
        List<String> schemas = JDBCMetaDataBasedModelElementFinder.getSchemas(session, this.currentConnection.user);
        defaultSchema[0] = JDBCMetaDataBasedModelElementFinder.getDefaultSchema(session, this.currentConnection.user);
        session.shutDown();
        return schemas;
    }

    public String selectDBSchema(Component parent, boolean[] isDefaultSchema) throws Exception {
        Session session = new Session(this.currentConnection.driverClass, this.currentConnection.url, this.currentConnection.user, this.currentConnection.password);
        List<String> schemas = JDBCMetaDataBasedModelElementFinder.getSchemas(session, this.currentConnection.user);
        String defaultSchema = JDBCMetaDataBasedModelElementFinder.getDefaultSchema(session, this.currentConnection.user);
        session.shutDown();
        isDefaultSchema[0] = false;
        if (schemas.size() == 1) {
            if (schemas.get(0).equalsIgnoreCase(this.currentConnection.user)) {
                isDefaultSchema[0] = true;
            }
            return schemas.get(0);
        }
        if (schemas.isEmpty()) {
            isDefaultSchema[0] = true;
            return null;
        }
        String s = (String)JOptionPane.showInputDialog(parent, "Select schema to analyze", "Schema", 3, null, schemas.toArray(), defaultSchema);
        if (s == null) {
            isDefaultSchema[0] = true;
            return "";
        }
        if (s.equalsIgnoreCase(defaultSchema)) {
            isDefaultSchema[0] = true;
        }
        return s;
    }

    public void addDbArgs(List<String> args) {
        args.add(this.currentConnection.driverClass);
        args.add(this.currentConnection.url);
        args.add(this.currentConnection.user);
        args.add(this.currentConnection.password);
        if (this.currentConnection.jar1.trim().length() > 0) {
            args.add("-jdbcjar");
            args.add(this.currentConnection.jar1.trim());
        }
        if (this.currentConnection.jar2.trim().length() > 0) {
            args.add("-jdbcjar2");
            args.add(this.currentConnection.jar2.trim());
        }
    }

    public String getPassword() {
        return this.currentConnection.password;
    }

    private boolean isAssignedToDataModel(int row) {
        String rowFN = this.connectionList.get((int)row).dataModelFolder;
        String fn = DataModelManager.getCurrentModelSubfolder();
        return fn == null && rowFN == null || fn != null && fn.equals(rowFN);
    }

    public static class ConnectionInfo
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -8034755966212631808L;
        public String alias = "";
        public String driverClass = "";
        public String url = "";
        public String user = "";
        public String password = "";
        public String jar1 = "";
        public String jar2 = "";
        public transient String dataModelFolder = DataModelManager.getCurrentModelSubfolder();

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

