/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.sf.jailer.ui.BrowserLauncher;
import net.sf.jailer.ui.DbConnectionDialog;
import net.sf.jailer.ui.InfoBar;
import net.sf.jailer.ui.UIUtil;

public class DbConnectionDetailsEditor
extends JDialog {
    private boolean isOk = false;
    private DbConnectionDialog.ConnectionInfo ci;
    public JTextField alias;
    private JButton cancelButton;
    public JTextField dbUrl;
    public JTextField driverClass;
    private JLabel helpjdbc;
    private JLabel infoBarLabel;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jar1;
    private JTextField jar2;
    private JLabel load1;
    private JLabel load2;
    private JButton okButton;
    private JPasswordField password;
    private JButton testConnectionButton;
    public JTextField user;
    private Icon helpIcon;
    private Icon loadIcon;
    private static final long serialVersionUID = -492511696901313920L;

    public boolean edit(DbConnectionDialog.ConnectionInfo ci) {
        this.ci = ci;
        this.alias.setText(ci.alias);
        this.dbUrl.setText(ci.url);
        this.user.setText(ci.user);
        this.password.setText(ci.password);
        this.driverClass.setText(ci.driverClass);
        this.jar1.setText(ci.jar1);
        this.jar2.setText(ci.jar2);
        this.setVisible(true);
        return this.isOk;
    }

    public DbConnectionDetailsEditor(Frame parent, final String jdbcHelpURL, boolean forNew) {
        super(parent, true);
        String dir = "/net/sf/jailer/resource";
        try {
            this.helpIcon = new ImageIcon(this.getClass().getResource(dir + "/help.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.loadIcon = new ImageIcon(this.getClass().getResource(dir + "/load.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initComponents();
        if (forNew) {
            UIUtil.replace(this.infoBarLabel, new InfoBar("New Connection", "Enter connection credentials for the database.\nReplace placeholders (\"<...>\") with appropriate URL parameters."));
        } else {
            UIUtil.replace(this.infoBarLabel, new InfoBar("Edit Connection", "Edit connection credentials for the database."));
        }
        this.setLocation(120, 170);
        this.load1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                String fn = UIUtil.choseFile(null, ".", "Jdbc Driver", ".jar", DbConnectionDetailsEditor.this, true, true);
                if (fn != null) {
                    DbConnectionDetailsEditor.this.jar1.setText(fn);
                }
            }
        });
        this.load2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                String fn = UIUtil.choseFile(null, ".", "Jdbc Driver", ".jar", DbConnectionDetailsEditor.this, true, true);
                if (fn != null) {
                    DbConnectionDetailsEditor.this.jar2.setText(fn);
                }
            }
        });
        this.load1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DbConnectionDetailsEditor.this.load1.setEnabled(false);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DbConnectionDetailsEditor.this.load1.setEnabled(true);
            }
        });
        this.load2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DbConnectionDetailsEditor.this.load2.setEnabled(false);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DbConnectionDetailsEditor.this.load2.setEnabled(true);
            }
        });
        this.helpjdbc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DbConnectionDetailsEditor.this.helpjdbc.setEnabled(false);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DbConnectionDetailsEditor.this.helpjdbc.setEnabled(true);
            }
        });
        this.helpjdbc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    BrowserLauncher.openURL(new URI(jdbcHelpURL));
                }
                catch (Exception e) {
                    UIUtil.showException(DbConnectionDetailsEditor.this, "Error", e);
                }
            }
        });
        this.helpjdbc.setIcon(this.helpIcon);
        this.helpjdbc.setText(null);
        this.load1.setIcon(this.loadIcon);
        this.load1.setText(null);
        this.load2.setIcon(this.loadIcon);
        this.load2.setText(null);
        this.pack();
        this.setSize(Math.max(570, this.getWidth()), this.getHeight());
        UIUtil.initPeer();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jar1 = new JTextField();
        this.jar2 = new JTextField();
        this.driverClass = new JTextField();
        this.dbUrl = new JTextField();
        this.user = new JTextField();
        this.jPanel2 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.testConnectionButton = new JButton();
        this.jLabel11 = new JLabel();
        this.password = new JPasswordField();
        this.load1 = new JLabel();
        this.helpjdbc = new JLabel();
        this.load2 = new JLabel();
        this.alias = new JTextField();
        this.infoBarLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Database Connection");
        this.getContentPane().setLayout(new CardLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(" Alias ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(" JDBC Driver JAR ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(" secondary JAR ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 15;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 45;
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(" Driver-Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText(" DB-URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 60;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText(" User");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 70;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText(" Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 80;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jar1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jar2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 50;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.driverClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 60;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.dbUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 70;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.user, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.okButton.setText(" Ok ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDetailsEditor.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDetailsEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.cancelButton, gridBagConstraints);
        this.testConnectionButton.setText(" Test Connection ");
        this.testConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbConnectionDetailsEditor.this.testConnectionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 12);
        this.jPanel2.add((Component)this.testConnectionButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel11.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        this.jPanel1.add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 80;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.password, gridBagConstraints);
        this.load1.setText("load");
        this.load1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel1.add((Component)this.load1, gridBagConstraints);
        this.helpjdbc.setText("help");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.helpjdbc, gridBagConstraints);
        this.load2.setText("load");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel1.add((Component)this.load2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.alias, gridBagConstraints);
        this.infoBarLabel.setText("info bar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.jPanel1.add((Component)this.infoBarLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "card2");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.fillConnectionInfo()) {
            this.isOk = true;
            this.setVisible(false);
        }
    }

    private boolean fillConnectionInfo() {
        boolean ok = true;
        Color red = new Color(255, 200, 180);
        if (this.alias.getText().trim().length() == 0) {
            this.alias.setBackground(red);
            ok = false;
        }
        if (this.driverClass.getText().trim().length() == 0) {
            this.driverClass.setBackground(red);
            ok = false;
        }
        if (this.dbUrl.getText().trim().length() == 0) {
            this.dbUrl.setBackground(red);
            ok = false;
        }
        if (ok) {
            this.ci.alias = this.alias.getText().trim();
            this.ci.driverClass = this.driverClass.getText().trim();
            this.ci.jar1 = this.jar1.getText().trim();
            this.ci.jar2 = this.jar2.getText().trim();
            this.ci.url = this.dbUrl.getText().trim();
            this.ci.user = this.user.getText().trim();
            this.ci.password = this.password.getText().trim();
        }
        return ok;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void testConnectionButtonActionPerformed(ActionEvent evt) {
        if (this.fillConnectionInfo() && DbConnectionDialog.testConnection(this, this.ci)) {
            JOptionPane.showMessageDialog(this, "Successfully established connection.", "Connected", 1);
        }
    }
}

