/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.modelbuilder.ModelBuilder;
import net.sf.jailer.ui.AnalyseOptionsDialog;
import net.sf.jailer.ui.DataModelEditor;
import net.sf.jailer.ui.DataModelManager;
import net.sf.jailer.ui.DbConnectionDialog;
import net.sf.jailer.ui.InfoBar;
import net.sf.jailer.ui.NewDataModelDialog;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.Pair;

public abstract class DataModelManagerDialog
extends JFrame {
    public boolean hasSelectedModel = false;
    private List<String> modelList;
    private Map<String, Pair<String, Long>> modelDetails;
    private String currentModel;
    private boolean inRefresh = false;
    private final String applicationName;
    private static String MODEL_SELECTION_FILE = ".selecteddatamodel";
    private JButton analyzeButton;
    private JTable dataModelsTable;
    private JButton deleteButton;
    private JButton editButton;
    private JLabel infoBarLabel;
    private JButton jButton2;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JLabel locationLabel;
    private JButton newButton;
    private JButton okButton;
    private static final long serialVersionUID = -3983034803834547687L;

    public DataModelManagerDialog(String applicationName) {
        this.applicationName = applicationName;
        this.initComponents();
        InfoBar infoBar = new InfoBar("Data Model Configuration", "A data model is a set of interrelated tables. Acquire information about tables by analyzing\ndatabase schemas, or use the data model editor to manually define tables and associations.\nSelect a data model to work with.");
        UIUtil.replace(this.infoBarLabel, infoBar);
        String modelpath = CommandLineParser.getInstance().getDataModelFolder();
        try {
            modelpath = CommandLineParser.getInstance().newFile(modelpath).getAbsolutePath();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.locationLabel.setText(modelpath);
        this.locationLabel.setToolTipText(modelpath);
        try {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/net/sf/jailer/resource/jailer.png"));
            this.setIconImage(imageIcon.getImage());
            infoBar.setIcon(imageIcon);
        }
        catch (Throwable t) {
            try {
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/net/sf/jailer/resource/jailer.gif"));
                this.setIconImage(imageIcon.getImage());
                infoBar.setIcon(imageIcon);
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        this.loadModelList();
        this.initTableModel();
        final TableCellRenderer defaultTableCellRenderer = this.dataModelsTable.getDefaultRenderer(String.class);
        this.dataModelsTable.setShowGrid(false);
        this.dataModelsTable.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component render = defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (render instanceof JLabel && !isSelected) {
                    Color BG1 = new Color(255, 255, 255);
                    Color BG2 = new Color(230, 255, 255);
                    ((JLabel)render).setBackground(row % 2 == 0 ? BG1 : BG2);
                }
                return render;
            }
        });
        this.dataModelsTable.setSelectionMode(0);
        this.dataModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (DataModelManagerDialog.this.dataModelsTable.getSelectedRow() >= 0) {
                    DataModelManagerDialog.this.currentModel = (String)DataModelManagerDialog.this.modelList.get(DataModelManagerDialog.this.dataModelsTable.getSelectedRow());
                } else {
                    DataModelManagerDialog.this.currentModel = null;
                }
                DataModelManagerDialog.this.refresh();
            }
        });
        this.currentModel = this.restore();
        if (this.currentModel != null) {
            int i = this.modelList.indexOf(this.currentModel);
            if (i >= 0) {
                this.dataModelsTable.getSelectionModel().setSelectionInterval(i, i);
            } else {
                this.currentModel = null;
            }
        }
        this.setTitle(applicationName);
        this.setLocation(80, 130);
        this.pack();
        this.setSize(Math.max(740, this.getWidth()), 360);
        this.refresh();
        UIUtil.initPeer();
        this.okButton.grabFocus();
    }

    private void loadModelList() {
        DataModelManager.setCurrentModelSubfolder(null);
        this.modelList = new ArrayList<String>();
        this.modelDetails = new HashMap<String, Pair<String, Long>>();
        for (String mf : DataModelManager.getModelFolderNames()) {
            String modelFolder = mf == null ? "" : mf;
            this.modelList.add(modelFolder);
            this.modelDetails.put(modelFolder, DataModelManager.getModelDetails(mf));
        }
        Collections.sort(this.modelList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((String)((Pair)((DataModelManagerDialog)DataModelManagerDialog.this).modelDetails.get((Object)o1)).a).compareTo((String)((Pair)((DataModelManagerDialog)DataModelManagerDialog.this).modelDetails.get((Object)o2)).a);
            }
        });
    }

    private Object[][] initTableModel() {
        Object[][] data = new Object[this.modelList.size()][];
        int i = 0;
        for (String model : this.modelList) {
            Pair<String, Long> details = this.modelDetails.get(model);
            data[i++] = new Object[]{details == null ? "" : (String)details.a, model == null || model.length() == 0 ? "." : model, details == null ? "" : this.toDateAsString((Long)details.b)};
        }
        DefaultTableModel tableModel = new DefaultTableModel(data, new String[]{"Data Model", "Subfolder", "Last Modified"}){
            private static final long serialVersionUID = 1535384744352159695L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.dataModelsTable.setModel(tableModel);
        return data;
    }

    private String toDateAsString(Long time) {
        if (time == null) {
            return "";
        }
        return SimpleDateFormat.getDateTimeInstance(3, 3).format(new Date(time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (this.inRefresh) {
            return;
        }
        this.inRefresh = true;
        try {
            int i;
            String theModel = this.currentModel;
            Object[][] data = this.initTableModel();
            this.currentModel = theModel;
            if (this.currentModel != null) {
                i = this.modelList.indexOf(this.currentModel);
                if (i >= 0) {
                    this.dataModelsTable.getSelectionModel().setSelectionInterval(i, i);
                } else {
                    this.dataModelsTable.getSelectionModel().clearSelection();
                    this.currentModel = null;
                }
            } else {
                this.dataModelsTable.getSelectionModel().clearSelection();
            }
            for (i = 0; i < this.dataModelsTable.getColumnCount(); ++i) {
                TableColumn column = this.dataModelsTable.getColumnModel().getColumn(i);
                int width = 1;
                Component comp = this.dataModelsTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.dataModelsTable, column.getHeaderValue(), false, false, 0, i);
                width = Math.max(width, comp.getPreferredSize().width);
                for (int line = 0; line < data.length; ++line) {
                    comp = this.dataModelsTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.dataModelsTable, data[line][i], false, false, line, i);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
                column.setPreferredWidth(width);
            }
            this.editButton.setEnabled(this.currentModel != null);
            this.deleteButton.setEnabled(this.currentModel != null);
            this.okButton.setEnabled(this.currentModel != null);
            this.analyzeButton.setEnabled(this.currentModel != null);
        }
        finally {
            this.inRefresh = false;
        }
    }

    private void store() {
        if (this.currentModel != null) {
            try {
                File file = new File(MODEL_SELECTION_FILE);
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                out.write(this.currentModel + "\n");
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String restore() {
        String selection = null;
        try {
            File file = new File(MODEL_SELECTION_FILE);
            BufferedReader in = new BufferedReader(new FileReader(file));
            selection = in.readLine();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return selection;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.locationLabel = new JLabel();
        this.jButton2 = new JButton();
        this.okButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.dataModelsTable = new JTable();
        this.jPanel3 = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.analyzeButton = new JButton();
        this.deleteButton = new JButton();
        this.infoBarLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Connect with DB");
        this.getContentPane().setLayout(new CardLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel2.setText(" Base Folder:  ");
        this.jPanel4.add((Component)this.jLabel2, new GridBagConstraints());
        this.locationLabel.setText("jLabel3");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jButton2.setText(" Cancel ");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelManagerDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel2.add((Component)this.jButton2, gridBagConstraints);
        this.okButton.setText(" OK ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelManagerDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder("Data Models"));
        this.dataModelsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.dataModelsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.newButton.setText(" New ");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelManagerDialog.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(16, 4, 2, 0);
        this.jPanel3.add((Component)this.newButton, gridBagConstraints);
        this.editButton.setText(" Edit ");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelManagerDialog.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.jPanel3.add((Component)this.editButton, gridBagConstraints);
        this.analyzeButton.setText(" Analyze Database ");
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelManagerDialog.this.analyzeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.jPanel3.add((Component)this.analyzeButton, gridBagConstraints);
        this.deleteButton.setText(" Delete ");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelManagerDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 31;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 2, 0);
        this.jPanel3.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.anchor = 11;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.infoBarLabel.setText("info bar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.infoBarLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "card2");
        this.pack();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (this.currentModel != null && JOptionPane.showConfirmDialog(this, "Do you really want to delete Data Model \"" + (String)this.modelDetails.get((Object)this.currentModel).a + "\"?", "Delete", 0, 3) == 0) {
            this.modelList.remove(this.currentModel);
            DataModelManager.deleteModel(this.currentModel);
            this.dataModelsTable.getSelectionModel().clearSelection();
            this.refresh();
            this.store();
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        DataModelManager.setCurrentModelSubfolder(null);
        NewDataModelDialog newDataModelDialog = new NewDataModelDialog((Frame)this, this.modelList);
        String newName = newDataModelDialog.getNameEntered();
        if (newName != null) {
            try {
                DataModelManager.createNewModel(newName, newDataModelDialog.getFolderName());
                this.loadModelList();
                this.currentModel = newName;
                this.refresh();
                this.store();
            }
            catch (Exception e) {
                UIUtil.showException(this, "Error", e);
            }
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        if (this.currentModel == null) {
            return;
        }
        this.activateCurrentModel();
        this.edit(this.currentModel.length() == 0 ? null : this.currentModel);
        this.loadModelList();
        this.refresh();
        this.store();
    }

    private void activateCurrentModel() {
        DataModelManager.setCurrentModelSubfolder(this.currentModel.length() == 0 ? null : this.currentModel);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.hasSelectedModel = false;
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeButtonActionPerformed(ActionEvent evt) {
        block13: {
            this.activateCurrentModel();
            try {
                List<String> schemas;
                DbConnectionDialog dbConnectionDialog = new DbConnectionDialog((Frame)this, this.applicationName, new InfoBar("Connect with Database", "Select a connection to the database to be analyzed, or create a new connection.\nNew connections will be assigned to the datamodel \"" + (String)this.modelDetails.get((Object)this.currentModel).a + "\"."));
                if (!dbConnectionDialog.connect("Analyze Database")) break block13;
                ArrayList<String> args = new ArrayList<String>();
                args.add("build-model");
                dbConnectionDialog.addDbArgs(args);
                DataModel dataModel = new DataModel();
                AnalyseOptionsDialog analyseOptionsDialog = new AnalyseOptionsDialog((Frame)this, dataModel);
                boolean[] isDefaultSchema = new boolean[1];
                String[] defaultSchema = new String[1];
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    schemas = dbConnectionDialog.getDBSchemas(defaultSchema);
                }
                finally {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (analyseOptionsDialog.edit(schemas, defaultSchema[0], isDefaultSchema, dbConnectionDialog.currentConnection.user)) {
                    String schema = analyseOptionsDialog.getSelectedSchema();
                    if (schema != null) {
                        args.add("-schema");
                        args.add(schema);
                    }
                    if (!isDefaultSchema[0]) {
                        args.add("-qualifyNames");
                    }
                    ModelBuilder.assocFilter = analyseOptionsDialog.getAssociationLineFilter();
                    if (UIUtil.runJailer(this, args, false, true, false, true, null, dbConnectionDialog.getPassword(), null, null, false, true, false)) {
                        ModelBuilder.assocFilter = null;
                        String modelname = dataModel.getName();
                        DataModelEditor dataModelEditor = new DataModelEditor(this, true, analyseOptionsDialog.isRemoving(), null, analyseOptionsDialog.getTableLineFilter(), analyseOptionsDialog.getAssociationLineFilter(), modelname, schema == null ? dbConnectionDialog.getName() : schema);
                        if (dataModelEditor.dataModelHasChanged()) {
                            dataModelEditor.setVisible(true);
                        }
                    }
                    this.loadModelList();
                    this.refresh();
                    this.store();
                }
            }
            catch (Exception e) {
                UIUtil.showException(this, "Error", e);
            }
            finally {
                ModelBuilder.assocFilter = null;
            }
        }
    }

    private void edit(String modelFolder) {
        try {
            DataModelEditor dataModelEditor = new DataModelEditor(this, false, false, null, null, null, (String)this.modelDetails.get((Object)(modelFolder == null ? "" : modelFolder)).a, null);
            dataModelEditor.setVisible(true);
        }
        catch (Exception e) {
            UIUtil.showException(this, "Error", e);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.currentModel == null) {
            return;
        }
        this.activateCurrentModel();
        this.hasSelectedModel = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.store();
        this.onSelect();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setVisible(false);
        this.dispose();
    }

    protected abstract void onSelect();
}

