/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.ui.DataModelEditor;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.Pair;

public class DataModelManager {
    public static List<String> getModelFolderNames() {
        File[] files;
        File dmFolder = CommandLineParser.getInstance().newFile(DataModelManager.getBaseFolder());
        ArrayList<String> folders = new ArrayList<String>();
        if (new File(dmFolder, "table.csv").exists()) {
            folders.add(null);
        }
        if ((files = dmFolder.listFiles()) != null) {
            for (File f : files) {
                if (!f.isDirectory() || !new File(f, "table.csv").exists()) continue;
                folders.add(f.getName());
            }
        }
        return folders;
    }

    private static String getBaseFolder() {
        return CommandLineParser.getInstance().datamodelFolder;
    }

    public static boolean deleteModel(String modelFolder) {
        String dir = DataModelManager.getBaseFolder() + File.separator + (modelFolder != null ? modelFolder + File.separator : "");
        File nameFile = CommandLineParser.getInstance().newFile(dir + "table.csv");
        try {
            DataModelManager.copyFile(nameFile, CommandLineParser.getInstance().newFile(dir + "table.csv" + ".bak"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nameFile.delete();
    }

    public static Pair<String, Long> getModelDetails(String modelFolder) {
        File nameFile = CommandLineParser.getInstance().newFile(DataModelManager.getBaseFolder() + File.separator + (modelFolder != null ? modelFolder + File.separator : "") + "modelname.csv");
        String name = null;
        Long lastModified = null;
        try {
            ArrayList<CsvFile.Line> nameList;
            if (nameFile.exists() && (nameList = new ArrayList<CsvFile.Line>(new CsvFile(nameFile).getLines())).size() > 0) {
                CsvFile.Line line = (CsvFile.Line)nameList.get(0);
                name = line.cells.get(0);
                lastModified = Long.parseLong(line.cells.get(1));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (name == null) {
            name = modelFolder == null ? "Default" : modelFolder;
        }
        return new Pair<String, Object>(name, lastModified);
    }

    public static void main(String[] args) throws Exception {
        CommandLineParser.parse(args, true);
        for (String s : DataModelManager.getModelFolderNames()) {
            System.out.println(s + " -> " + DataModelManager.getModelDetails(s));
        }
    }

    public static void setCurrentModelSubfolder(String modelFolder) {
        CommandLineParser.getInstance().setCurrentModelSubfolder(modelFolder);
    }

    public static String getCurrentModelSubfolder() {
        return CommandLineParser.getInstance().getCurrentModelSubfolder();
    }

    public static void createNewModel(String newName, String folderName) throws IOException {
        DataModelManager.setCurrentModelSubfolder(null);
        File modelFolder = CommandLineParser.getInstance().newFile(DataModelManager.getBaseFolder() + File.separator + folderName);
        if (!modelFolder.mkdir()) {
            throw new IOException("Unable to create folder \"" + modelFolder.getAbsolutePath() + "\"");
        }
        DataModelManager.setCurrentModelSubfolder(folderName);
        for (String file : new String[]{DataModel.getTablesFile(), DataModel.getAssociationsFile(), DataModel.getColumnsFile()}) {
            File toCreate = CommandLineParser.getInstance().newFile(file);
            BufferedWriter out = new BufferedWriter(new FileWriter(toCreate));
            out.write(" ");
            out.close();
        }
        DataModelEditor.createNameFile(newName);
    }

    private static void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[16384];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }
}

