/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.modelbuilder.ModelBuilder;
import net.sf.jailer.ui.AssociationEditor;
import net.sf.jailer.ui.TableEditor;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.CsvFile;

public class DataModelEditor
extends JDialog {
    public static final String DATA_MODEL_EDITOR_AUTHOR = "Data Model Editor";
    private List<CsvFile.Line> tables;
    private Map<String, String> displayNames;
    private List<CsvFile.Line> associations;
    private List<CsvFile.Line> linesFromModelFinder = new ArrayList<CsvFile.Line>();
    private Set<String> modifiedColumnTables = new HashSet<String>();
    private Map<String, CsvFile.Line> columns = new TreeMap<String, CsvFile.Line>();
    private List<String> excludeFromDeletion = new ArrayList<String>();
    private List<String> initialDataTables = new ArrayList<String>();
    private boolean needsSave = false;
    public boolean saved = false;
    private JList associationsList;
    private JButton cancelButton;
    private JButton deleteAssociations;
    private JButton deleteTables;
    private JButton editAssociation;
    private JButton editTable;
    private JLabel info;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel locationLabel;
    private JTextField nameTextField;
    private JButton newAssociation;
    private JButton newTable;
    private JButton okButton;
    private JList tablesList;
    private static final long serialVersionUID = -1267039412732180237L;

    public DataModelEditor(Frame parent, boolean merge, boolean initiallyDirty, final Table toEdit, CsvFile.LineFilter tableFilter, CsvFile.LineFilter assocFilter, String modelname, String modelnameSuggestion) throws Exception {
        super(parent, true);
        this.tables = new CsvFile(new File(DataModel.getTablesFile()), tableFilter).getLines();
        this.displayNames = new TreeMap<String, String>();
        File dnFile = new File(DataModel.getDisplayNamesFile());
        if (dnFile.exists()) {
            for (CsvFile.Line dnl : new CsvFile(dnFile).getLines()) {
                this.displayNames.put(dnl.cells.get(0), dnl.cells.get(1));
            }
        }
        this.associations = new CsvFile(new File(DataModel.getAssociationsFile()), assocFilter).getLines();
        boolean isDemoModel = this.tables.size() > 0;
        for (CsvFile.Line dt : this.tables) {
            String lastV = null;
            for (String v : dt.cells) {
                if (v == null || v.trim().length() <= 0) continue;
                lastV = v.trim();
            }
            if (lastV == null || "Demo".equals(lastV)) continue;
            isDemoModel = false;
            break;
        }
        if (merge && isDemoModel) {
            this.tables.clear();
            this.associations.clear();
            initiallyDirty = true;
        } else {
            UIUtil.loadTableList(this.excludeFromDeletion, DataModel.getExcludeFromDeletionFile());
            UIUtil.loadTableList(this.initialDataTables, DataModel.getInitialDataTablesFile());
        }
        int newTables = 0;
        int newAssociations = 0;
        File file = new File(DataModel.getColumnsFile());
        if (file.exists()) {
            for (CsvFile.Line l : new CsvFile(file).getLines()) {
                this.columns.put(l.cells.get(0), l);
            }
        }
        File modelFinderTablesFile = new File(ModelBuilder.getModelBuilderTablesFilename());
        if (merge && modelFinderTablesFile.exists()) {
            CsvFile.Line t;
            List<CsvFile.Line> tablesFromModelFinder = new CsvFile(modelFinderTablesFile).getLines();
            Iterator<CsvFile.Line> i = tablesFromModelFinder.iterator();
            block6: while (i.hasNext()) {
                t = i.next();
                for (CsvFile.Line l : this.tables) {
                    boolean eq = true;
                    for (int n = 0; n < l.cells.size() && n < t.cells.size(); ++n) {
                        if (n != 1 && !l.cells.get(n).equals(t.cells.get(n))) {
                            eq = false;
                            break;
                        }
                        if (l.cells.get(n).length() == 0) break;
                    }
                    if (!eq) continue;
                    i.remove();
                    continue block6;
                }
            }
            this.linesFromModelFinder.addAll(tablesFromModelFinder);
            i = this.tables.iterator();
            block9: while (i.hasNext()) {
                t = i.next();
                for (CsvFile.Line l : this.linesFromModelFinder) {
                    if (!l.cells.get(0).equals(t.cells.get(0))) continue;
                    i.remove();
                    continue block9;
                }
            }
            this.tables.addAll(tablesFromModelFinder);
            newTables += tablesFromModelFinder.size();
        }
        this.sortLineList(this.tables, true);
        File modelFinderAssociationsFile = new File(ModelBuilder.getModelBuilderAssociationsFilename());
        if (merge && modelFinderAssociationsFile.exists()) {
            List<CsvFile.Line> associationsFromModelFinder = new CsvFile(modelFinderAssociationsFile).getLines();
            this.associations.addAll(associationsFromModelFinder);
            this.linesFromModelFinder.addAll(associationsFromModelFinder);
            newAssociations += associationsFromModelFinder.size();
        }
        this.sortLineList(this.associations, false);
        this.initComponents();
        String modelpath = CommandLineParser.getInstance().getDataModelFolder();
        try {
            modelpath = CommandLineParser.getInstance().newFile(modelpath).getAbsolutePath();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.locationLabel.setText(modelpath);
        this.locationLabel.setToolTipText(modelpath);
        if (modelnameSuggestion != null && (merge && isDemoModel || "New Model".equals(modelname) || "Demo".equals(modelname))) {
            modelname = modelnameSuggestion;
        }
        this.nameTextField.setText(modelname);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                DataModelEditor.this.markDirty();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                DataModelEditor.this.markDirty();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                DataModelEditor.this.markDirty();
            }
        });
        this.setSize(900, 700);
        this.setLocation(100, 32);
        File modelFinderColumnFile = new File(ModelBuilder.getModelBuilderColumnsFilename());
        if (merge && modelFinderColumnFile.exists()) {
            for (CsvFile.Line l : new CsvFile(modelFinderColumnFile).getLines()) {
                CsvFile.Line ol = this.columns.get(l.cells.get(0));
                if (ol == null || !ol.cells.equals(l.cells)) {
                    this.modifiedColumnTables.add(l.cells.get(0));
                    this.markDirty();
                }
                this.columns.put(l.cells.get(0), l);
            }
        }
        if (merge) {
            this.info.setText("Found " + newTables + " new tables and " + newAssociations + " new associations");
            if (!this.linesFromModelFinder.isEmpty()) {
                this.markDirty();
            }
        }
        this.info.setVisible(merge);
        this.updateButtons();
        final Color BG_COLOR = new Color(0.8f, 1.0f, 0.6f);
        final Color BG_SELCOLOR = new Color(0.4f, 1.0f, 0.1f);
        DefaultListCellRenderer tablesListItemRenderer = new DefaultListCellRenderer(){
            private static final long serialVersionUID = -8591324056536900244L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                boolean fromModelFinder = DataModelEditor.this.linesFromModelFinder.contains(value);
                CsvFile.Line line = (CsvFile.Line)value;
                String tableName = line.cells.get(0);
                String pk = "";
                for (int i = 2; i < line.length && line.cells.get(i).length() != 0; ++i) {
                    if (pk.length() > 0) {
                        pk = pk + ", ";
                    }
                    pk = pk + line.cells.get(i);
                }
                value = line.cells.get(0) + (pk.isEmpty() ? "" : " (" + pk + ")");
                Component render = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (pk.equals("")) {
                    render.setForeground(Color.RED);
                }
                if (fromModelFinder || DataModelEditor.this.modifiedColumnTables.contains(tableName)) {
                    render.setBackground(isSelected ? BG_SELCOLOR : BG_COLOR);
                }
                return render;
            }
        };
        DefaultListCellRenderer associationsListItemRenderer = new DefaultListCellRenderer(){
            private static final long serialVersionUID = -6057505075587930064L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                boolean fromModelFinder = DataModelEditor.this.linesFromModelFinder.contains(value);
                CsvFile.Line line = (CsvFile.Line)value;
                String type = "associates";
                if ("B".equalsIgnoreCase(line.cells.get(2))) {
                    type = "depends on";
                }
                if ("A".equalsIgnoreCase(line.cells.get(2))) {
                    type = "has dependent";
                }
                String name = "";
                if (line.cells.get(5).length() > 0) {
                    name = "(" + line.cells.get(5) + ") ";
                }
                value = line.cells.get(0) + " " + type + " " + line.cells.get(1) + " " + name + line.cells.get(3) + " on " + line.cells.get(4);
                Component render = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (fromModelFinder) {
                    render.setBackground(isSelected ? BG_SELCOLOR : BG_COLOR);
                }
                return render;
            }
        };
        this.tablesList.setCellRenderer(tablesListItemRenderer);
        this.associationsList.setCellRenderer(associationsListItemRenderer);
        this.invalidate();
        if (initiallyDirty) {
            this.markDirty();
        }
        UIUtil.initPeer();
        if (toEdit != null) {
            this.addWindowListener(new WindowListener(){

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    for (CsvFile.Line l : DataModelEditor.this.tables) {
                        if (!toEdit.getName().equals(l.cells.get(0))) continue;
                        if (!new TableEditor(DataModelEditor.this, DataModelEditor.this.displayNames, DataModelEditor.this.tables, DataModelEditor.this.associations, DataModelEditor.this.excludeFromDeletion, DataModelEditor.this.initialDataTables).edit(l, DataModelEditor.this.columns)) break;
                        DataModelEditor.this.markDirty();
                        DataModelEditor.this.repaint();
                        break;
                    }
                }
            });
        }
        if (merge) {
            ModelBuilder.cleanUp();
        }
    }

    private void markDirty() {
        if (!this.needsSave) {
            this.needsSave = true;
            this.setTitle("*" + this.getTitle());
        }
    }

    private void sortLineList(List<CsvFile.Line> list, final boolean sortTables) {
        Collections.sort(list, new Comparator<CsvFile.Line>(){

            @Override
            public int compare(CsvFile.Line o1, CsvFile.Line o2) {
                int c2;
                int c1 = DataModelEditor.this.linesFromModelFinder.contains(o1) ? 0 : 1;
                int n = c2 = DataModelEditor.this.linesFromModelFinder.contains(o2) ? 0 : 1;
                if (c1 != c2) {
                    return c1 - c2;
                }
                if (sortTables) {
                    String pk1 = o1.cells.get(2);
                    String pk2 = o2.cells.get(2);
                    if (pk1.length() == 0 && pk2.length() > 0) {
                        return -1;
                    }
                    if (pk1.length() > 0 && pk2.length() == 0) {
                        return 1;
                    }
                }
                for (int i = 0; i < 3; ++i) {
                    int r = o1.cells.get(i).compareTo(o2.cells.get(i));
                    if (r == 0) continue;
                    return r;
                }
                return 0;
            }
        });
    }

    private void initComponents() {
        this.jPanel6 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tablesList = new JList();
        this.jPanel4 = new JPanel();
        this.newTable = new JButton();
        this.editTable = new JButton();
        this.deleteTables = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.newAssociation = new JButton();
        this.editAssociation = new JButton();
        this.deleteAssociations = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.associationsList = new JList();
        this.info = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.locationLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.setDefaultCloseOperation(0);
        this.setTitle(DATA_MODEL_EDITOR_AUTHOR);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DataModelEditor.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Tables"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.tablesList.setModel(this.createTablesListModel());
        this.tablesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DataModelEditor.this.tablesListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tablesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel4.setLayout(new FlowLayout(1, 2, 2));
        this.newTable.setText("Add");
        this.newTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelEditor.this.newTableActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.newTable);
        this.editTable.setText("Edit");
        this.editTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelEditor.this.editTableActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.editTable);
        this.deleteTables.setText("Delete");
        this.deleteTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelEditor.this.deleteTablesActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.deleteTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel1.add(this.jPanel2);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Associations"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new FlowLayout(1, 2, 2));
        this.newAssociation.setText("Add");
        this.newAssociation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelEditor.this.newAssociationActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.newAssociation);
        this.editAssociation.setText("Edit");
        this.editAssociation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelEditor.this.editAssociationActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.editAssociation);
        this.deleteAssociations.setText("Delete");
        this.deleteAssociations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataModelEditor.this.deleteAssociationsActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.deleteAssociations);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.associationsList.setModel(this.createAssociationsListModel());
        this.associationsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DataModelEditor.this.associationsListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.associationsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel1.add(this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.info.setForeground(new Color(1, 111, 1));
        this.info.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.info, gridBagConstraints);
        this.jLabel1.setText(" Name  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(" Location  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.locationLabel.setText(" Location  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.locationLabel, gridBagConstraints);
        this.nameTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 22);
        this.getContentPane().add((Component)this.nameTextField, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.close();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void newAssociationActionPerformed(ActionEvent evt) {
        ArrayList<String> cells = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            cells.add("");
        }
        CsvFile.Line line = new CsvFile.Line("?", cells);
        if (new AssociationEditor((Dialog)this, this.tables, this.associations).edit(line)) {
            this.associations.add(0, line);
            this.associationsList.setModel(this.createAssociationsListModel());
            this.repaint();
            this.markDirty();
        }
    }

    private void editAssociationActionPerformed(ActionEvent evt) {
        CsvFile.Line line = null;
        for (int i = 0; i < this.associations.size(); ++i) {
            if (!this.associationsList.getSelectionModel().isSelectedIndex(i)) continue;
            line = this.associations.get(i);
            break;
        }
        if (line != null && new AssociationEditor((Dialog)this, this.tables, this.associations).edit(line)) {
            this.markDirty();
            this.repaint();
        }
    }

    private void newTableActionPerformed(ActionEvent evt) {
        ArrayList<String> cells = new ArrayList<String>();
        cells.add("");
        cells.add("N");
        cells.add("");
        cells.add(DATA_MODEL_EDITOR_AUTHOR);
        for (int i = 0; i < 100; ++i) {
            cells.add("");
        }
        CsvFile.Line line = new CsvFile.Line("?", cells);
        if (new TableEditor(this, this.displayNames, this.tables, this.associations, this.excludeFromDeletion, this.initialDataTables).edit(line, this.columns)) {
            this.tables.add(0, line);
            this.tablesList.setModel(this.createTablesListModel());
            this.markDirty();
            this.repaint();
        }
    }

    private void editTableActionPerformed(ActionEvent evt) {
        CsvFile.Line line = null;
        for (int i = 0; i < this.tables.size(); ++i) {
            if (!this.tablesList.getSelectionModel().isSelectedIndex(i)) continue;
            line = this.tables.get(i);
            break;
        }
        if (line != null && new TableEditor(this, this.displayNames, this.tables, this.associations, this.excludeFromDeletion, this.initialDataTables).edit(line, this.columns)) {
            this.markDirty();
            this.repaint();
        }
    }

    private void updateButtons() {
        this.editTable.setEnabled(!this.tablesList.isSelectionEmpty());
        this.deleteTables.setEnabled(!this.tablesList.isSelectionEmpty());
        this.editAssociation.setEnabled(!this.associationsList.isSelectionEmpty());
        this.deleteAssociations.setEnabled(!this.associationsList.isSelectionEmpty());
    }

    private void associationsListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void tablesListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void deleteTablesActionPerformed(ActionEvent evt) {
        ArrayList<CsvFile.Line> toDelete = new ArrayList<CsvFile.Line>();
        ArrayList<String> namesOfTablesToDelete = new ArrayList<String>();
        for (int i = 0; i < this.tables.size(); ++i) {
            CsvFile.Line table;
            if (!this.tablesList.getSelectionModel().isSelectedIndex(i) || (table = this.tables.get(i)) == null) continue;
            toDelete.add(table);
            namesOfTablesToDelete.add(table.cells.get(0));
        }
        HashSet<CsvFile.Line> assToDelete = new HashSet<CsvFile.Line>();
        for (CsvFile.Line t : toDelete) {
            for (CsvFile.Line a : this.associations) {
                if (!a.cells.get(0).equalsIgnoreCase(t.cells.get(0)) && !a.cells.get(1).equalsIgnoreCase(t.cells.get(0))) continue;
                assToDelete.add(a);
            }
        }
        if (0 == JOptionPane.showConfirmDialog(this, "Delete " + toDelete.size() + " tables with\n" + assToDelete.size() + " related associations?", "Delete Table", 0)) {
            this.tables.removeAll(toDelete);
            for (String k : namesOfTablesToDelete) {
                this.displayNames.remove(k);
            }
            this.excludeFromDeletion.removeAll(namesOfTablesToDelete);
            this.initialDataTables.removeAll(namesOfTablesToDelete);
            this.tablesList.setModel(this.createTablesListModel());
            this.associations.removeAll(assToDelete);
            this.associationsList.setModel(this.createAssociationsListModel());
            for (CsvFile.Line l : toDelete) {
                this.columns.remove(l.cells.get(0));
            }
            this.markDirty();
        }
    }

    private void deleteAssociationsActionPerformed(ActionEvent evt) {
        ArrayList<CsvFile.Line> toDelete = new ArrayList<CsvFile.Line>();
        for (int i = 0; i < this.associations.size(); ++i) {
            if (!this.associationsList.getSelectionModel().isSelectedIndex(i)) continue;
            toDelete.add(this.associations.get(i));
        }
        this.associations.removeAll(toDelete);
        this.associationsList.setModel(this.createAssociationsListModel());
        this.markDirty();
    }

    private ListModel createTablesListModel() {
        DefaultListModel<CsvFile.Line> tablesListModel = new DefaultListModel<CsvFile.Line>();
        for (CsvFile.Line line : this.tables) {
            tablesListModel.addElement(line);
        }
        return tablesListModel;
    }

    private ListModel createAssociationsListModel() {
        DefaultListModel<CsvFile.Line> associationsListModel = new DefaultListModel<CsvFile.Line>();
        for (CsvFile.Line line : this.associations) {
            associationsListModel.addElement(line);
        }
        return associationsListModel;
    }

    private void close() {
        if (this.needsSave && 0 != JOptionPane.showConfirmDialog(this, "Close without save?", "Close", 0, 3)) {
            return;
        }
        this.setVisible(false);
    }

    private void save() {
        try {
            if (this.needsSave) {
                this.save(this.tables, DataModel.getTablesFile(), "# Name; Upsert; Primary key; ; Author");
                this.save(this.associations, DataModel.getAssociationsFile(), "# Table A; Table B; First-insert; Cardinality; Join-condition; Name; Author");
                this.save(new ArrayList<CsvFile.Line>(this.columns.values()), DataModel.getColumnsFile(), "# Table; Columns");
                this.saveTableList(this.excludeFromDeletion, DataModel.getExcludeFromDeletionFile());
                this.saveTableList(this.initialDataTables, DataModel.getInitialDataTablesFile());
                this.saveTableList(Arrays.asList("5.0.2"), DataModel.getVersionFile());
                this.saveDisplayNames();
                this.saveName();
                this.saved = true;
            }
        }
        catch (Throwable t) {
            UIUtil.showException(this, "Error", t);
        }
        this.setVisible(false);
    }

    private void saveDisplayNames() throws FileNotFoundException {
        PrintWriter out = new PrintWriter(DataModel.getDisplayNamesFile());
        out.println("# table; display name");
        for (Map.Entry<String, String> e : this.displayNames.entrySet()) {
            out.println(CsvFile.encodeCell(e.getKey()) + "; " + CsvFile.encodeCell(e.getValue()));
        }
        out.close();
    }

    private void saveName() throws FileNotFoundException {
        DataModelEditor.createNameFile(this.nameTextField.getText());
    }

    public static void createNameFile(String name) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(DataModel.getModelNameFile());
        out.println("# name; last modification");
        out.println(CsvFile.encodeCell(name) + "; " + CsvFile.encodeCell(Long.toString(new Date().getTime())));
        out.close();
    }

    private void saveTableList(List<String> tableList, String fileName) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(fileName);
        for (String table : tableList) {
            out.println(table);
        }
        out.close();
    }

    private void save(List<CsvFile.Line> lines, String fileName, String title) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(fileName);
        out.println(title);
        for (CsvFile.Line line : lines) {
            out.println(line);
        }
        out.close();
    }

    public boolean dataModelHasChanged() throws Exception {
        String tmpFile = DataModel.getDatamodelFolder() + File.separator + "tempcsv.tmp";
        boolean result = false;
        this.save(this.tables, tmpFile, "#");
        boolean bl = result = !this.cvsFilesEquals(tmpFile, DataModel.getTablesFile());
        if (!result) {
            this.save(this.associations, tmpFile, "#");
            boolean bl2 = result = !this.cvsFilesEquals(tmpFile, DataModel.getAssociationsFile());
        }
        if (!result) {
            this.save(new ArrayList<CsvFile.Line>(this.columns.values()), tmpFile, "#");
            boolean bl3 = result = !this.cvsFilesEquals(tmpFile, DataModel.getColumnsFile());
        }
        if (!result) {
            JOptionPane.showMessageDialog(this, "No changes found.", "Analyze Database", 1);
        }
        new File(tmpFile).delete();
        return result;
    }

    private boolean cvsFilesEquals(String aFile, String bFile) throws Exception {
        TreeSet<String> a = new TreeSet<String>();
        StringBuilder sb = new StringBuilder();
        for (CsvFile.Line line : new CsvFile(new File(aFile)).getLines()) {
            sb.setLength(0);
            for (int i = 0; i < line.length; ++i) {
                sb.append(line.cells.get(i)).append(';');
            }
            a.add(sb.toString());
        }
        TreeSet<String> b = new TreeSet<String>();
        for (CsvFile.Line line : new CsvFile(new File(bFile)).getLines()) {
            sb.setLength(0);
            for (int i = 0; i < line.length; ++i) {
                sb.append(line.cells.get(i)).append(';');
            }
            b.add(sb.toString());
        }
        return a.equals(b);
    }
}

