/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.ExtractionModelFrame;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.CancellationException;
import net.sf.jailer.util.CancellationHandler;
import net.sf.jailer.util.CycleFinder;

public class CyclesView
extends JDialog {
    private static final int MAX_TABLES_PER_LINE = 4;
    private final ExtractionModelFrame extractionModelFrame;
    private String selectedTable;
    private final List<Color> bgColor = new ArrayList<Color>();
    private Set<CellInfo> cellInfo = new HashSet<CellInfo>();
    private JTable cyclesTable;
    private JLabel numLabel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private static final long serialVersionUID = 5485949274233292142L;

    public CyclesView(ExtractionModelFrame extractionModelFrame) {
        super((Frame)extractionModelFrame, false);
        this.extractionModelFrame = extractionModelFrame;
        this.initComponents();
        this.cyclesTable = new JTable(){
            private static final long serialVersionUID = 8960056200057023368L;

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (!(graphics instanceof Graphics2D)) {
                    return;
                }
                Graphics2D g2d = (Graphics2D)graphics;
                for (CellInfo posInfo : CyclesView.this.cellInfo) {
                    int y;
                    int x;
                    Rectangle r = CyclesView.this.cyclesTable.getCellRect(posInfo.row, posInfo.column, false);
                    Color color = new Color(255, 0, 0, 150);
                    g2d.setColor(color);
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setStroke(new BasicStroke(2.0f));
                    int a = r.height / 4;
                    int w = 3 * a;
                    if (posInfo.arrowLeft) {
                        x = r.x - w - a * 2;
                        y = r.y + r.height / 2;
                        g2d.drawLine(x, y, x + w, y);
                        g2d.drawLine(x + w - 1, y, x + w - a, y - a);
                        g2d.drawLine(x + w - 1, y, x + w - a, y + a);
                    }
                    if (!posInfo.arrowRight) continue;
                    x = r.x + r.width - w - a * 2;
                    y = r.y + r.height / 2;
                    g2d.drawLine(x, y, x + w, y);
                    g2d.drawLine(x + w - 1, y, x + w - a, y - a);
                    g2d.drawLine(x + w - 1, y, x + w - a, y + a);
                }
            }
        };
        this.cyclesTable.setShowGrid(false);
        this.cyclesTable.setSurrendersFocusOnKeystroke(true);
        this.jScrollPane1.setViewportView(this.cyclesTable);
        this.jScrollPane1.setColumnHeaderView(null);
        this.cyclesTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int row = CyclesView.this.cyclesTable.rowAtPoint(e.getPoint());
                    int column = CyclesView.this.cyclesTable.columnAtPoint(e.getPoint());
                    if (row < 0 || column < 0) {
                        return;
                    }
                    Object value = CyclesView.this.cyclesTable.getModel().getValueAt(row, column);
                    if (value == null || !(value instanceof String)) {
                        return;
                    }
                    Table table = CyclesView.this.getDataModel().getTableByDisplayName((String)value);
                    if (table != null) {
                        JPopupMenu popup = ((CyclesView)CyclesView.this).extractionModelFrame.extractionModelEditor.graphView.createPopupMenu(table, false);
                        UIUtil.fit(popup);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        final TableCellRenderer defaultTableCellRenderer = this.cyclesTable.getDefaultRenderer(String.class);
        this.cyclesTable.setDefaultRenderer(Object.class, new TableCellRenderer(){
            private Font font = new JLabel("normal").getFont();
            private Font normal = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
            private Font bold = new Font(this.font.getName(), this.font.getStyle() | 1, this.font.getSize());

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component render;
                boolean bl = isSelected = CyclesView.this.selectedTable != null && CyclesView.this.selectedTable.equals(value);
                if (value == null || column < 1 || "".equals(value)) {
                    hasFocus = false;
                }
                if ((render = defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JLabel && !isSelected) {
                    ((JLabel)render).setBackground((Color)CyclesView.this.bgColor.get(row));
                }
                if (render instanceof JLabel) {
                    ((JLabel)render).setForeground(Color.BLACK);
                    ((JLabel)render).setFont(this.normal);
                    ((JLabel)render).setToolTipText(((JLabel)render).getText());
                    if (CyclesView.this.selectedTable != null && CyclesView.this.selectedTable.equals(value)) {
                        ((JLabel)render).setFont(this.bold);
                    }
                }
                return render;
            }
        });
        this.cyclesTable.setSelectionMode(0);
        this.cyclesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                int col = CyclesView.this.cyclesTable.getSelectedColumn();
                int row = CyclesView.this.cyclesTable.getSelectedRow();
                if (col >= 1 && row >= 0) {
                    String displayName = (String)CyclesView.this.cyclesTable.getModel().getValueAt(row, col);
                    CyclesView.this.cyclesTable.getSelectionModel().clearSelection();
                    if (displayName != null && !"".equals(displayName)) {
                        CyclesView.this.selectedTable = displayName;
                        CyclesView.this.repaint();
                        Table table = CyclesView.this.getDataModel().getTableByDisplayName(CyclesView.this.selectedTable);
                        if (table != null && !((CyclesView)CyclesView.this).extractionModelFrame.extractionModelEditor.select(table)) {
                            ((CyclesView)CyclesView.this).extractionModelFrame.extractionModelEditor.setRootSelection(table);
                        }
                    }
                }
            }
        });
        this.setLocation(500, 150);
        this.setSize(600, 400);
    }

    public void findCycles() {
        final FindCyclesDialog findCyclesDialog = new FindCyclesDialog();
        findCyclesDialog.setLocation(this.getLocation().x + this.getSize().width / 2 - findCyclesDialog.getSize().width / 2, this.getLocation().y + this.getSize().height / 2 - findCyclesDialog.getSize().height / 2);
        CancellationHandler.reset(null);
        new Thread(){

            @Override
            public void run() {
                try {
                    final Collection<CycleFinder.Path> cycles = CycleFinder.findCycle(((CyclesView)CyclesView.this).extractionModelFrame.extractionModelEditor.dataModel, ((CyclesView)CyclesView.this).extractionModelFrame.extractionModelEditor.dataModel.getTables());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            findCyclesDialog.setVisible(false);
                            CyclesView.this.setVisible(true);
                            CyclesView.this.refreshTableModel(cycles);
                        }
                    });
                }
                catch (CancellationException ce) {
                    CancellationHandler.reset(null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CyclesView.this.setVisible(false);
                        }
                    });
                }
                catch (Throwable t) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIUtil.showException(CyclesView.this, "Error", t);
                            CyclesView.this.setVisible(false);
                        }
                    });
                }
            }
        }.start();
        findCyclesDialog.setVisible(true);
    }

    private DataModel getDataModel() {
        return this.extractionModelFrame.extractionModelEditor.dataModel;
    }

    public void refresh() {
    }

    private synchronized void refreshTableModel(Collection<CycleFinder.Path> cycles) {
        this.cellInfo.clear();
        this.numLabel.setText(" " + cycles.size() + " Cycles");
        Object[] columns = new Object[5];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = "";
        }
        columns[0] = "Distance";
        columns[1] = "Table";
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        int distance = 0;
        Color BG1 = new Color(255, 255, 255);
        Color BG2 = new Color(230, 255, 255);
        this.bgColor.clear();
        for (CycleFinder.Path cycle : cycles) {
            ArrayList<Table> currentLineT = new ArrayList<Table>();
            cycle.fillPath(currentLineT);
            ArrayList<String> currentLine = new ArrayList<String>();
            for (Table t : currentLineT) {
                currentLine.add(this.extractionModelFrame.extractionModelEditor.dataModel.getDisplayName(t));
            }
            Object[] lineAsObjects = new Object[5];
            Arrays.fill(lineAsObjects, "");
            int col = 0;
            lineAsObjects[col++] = "";
            CellInfo cellInfo = null;
            for (String t : currentLine) {
                cellInfo = new CellInfo();
                cellInfo.arrowLeft = false;
                cellInfo.arrowRight = true;
                this.cellInfo.add(cellInfo);
                if (col <= 4) {
                    cellInfo.column = col;
                    lineAsObjects[col++] = t;
                } else {
                    data.add(lineAsObjects);
                    this.bgColor.add(distance % 2 == 0 ? BG1 : BG2);
                    lineAsObjects = new Object[5];
                    Arrays.fill(lineAsObjects, "");
                    col = 1;
                    cellInfo.arrowLeft = true;
                    cellInfo.column = col;
                    lineAsObjects[col++] = t;
                }
                cellInfo.row = data.size();
            }
            if (cellInfo != null) {
                cellInfo.arrowRight = false;
            }
            if (col > 1) {
                data.add(lineAsObjects);
                this.bgColor.add(distance % 2 == 0 ? BG1 : BG2);
            }
            lineAsObjects = new Object[5];
            Arrays.fill(lineAsObjects, "");
            data.add(lineAsObjects);
            this.bgColor.add(distance % 2 == 0 ? BG1 : BG2);
            ++distance;
        }
        Object[][] dataArray = (Object[][])data.toArray((T[])new Object[data.size()][]);
        DefaultTableModel tableModel = new DefaultTableModel(dataArray, columns){
            private static final long serialVersionUID = -6639310191624899380L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.cyclesTable.setModel(tableModel);
        for (int i = 0; i < this.cyclesTable.getColumnCount(); ++i) {
            TableColumn column = this.cyclesTable.getColumnModel().getColumn(i);
            int width = 1;
            Component comp = this.cyclesTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.cyclesTable, column.getHeaderValue(), false, false, 0, i);
            width = Math.max(width, comp.getPreferredSize().width);
            for (int line = 0; line < dataArray.length; ++line) {
                comp = this.cyclesTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.cyclesTable, dataArray[line][i], false, false, line, i);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            if (i == 0) {
                width = 50;
                column.setMaxWidth(width);
            }
            column.setPreferredWidth(width);
        }
        this.cyclesTable.setIntercellSpacing(new Dimension(0, 0));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.numLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.cyclesTable = new JTable();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Cycle View");
        this.jPanel1.setLayout(new GridBagLayout());
        this.numLabel.setText(" ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.numLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 20;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 2);
        this.cyclesTable.setTableHeader(null);
        this.cyclesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Titel 1", "Titel 2", "Titel 3", "Titel 4"}));
        this.cyclesTable.setShowGrid(false);
        this.cyclesTable.setSurrendersFocusOnKeystroke(true);
        this.jScrollPane1.setViewportView(this.cyclesTable);
        this.jScrollPane1.setColumnHeaderView(null);
        this.jScrollPane1.setColumnHeader(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 30;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private class FindCyclesDialog
    extends JDialog {
        private JButton jButton1;
        private JLabel label;
        private static final long serialVersionUID = -6499791486275376059L;

        public FindCyclesDialog() {
            super((Frame)CyclesView.this.extractionModelFrame, false);
            this.initComponents();
            UIUtil.initPeer();
        }

        private void initComponents() {
            this.label = new JLabel();
            this.jButton1 = new JButton();
            this.setDefaultCloseOperation(0);
            this.getContentPane().setLayout(new GridBagLayout());
            this.label.setText("       Finding cycles...     ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 12, 12, 12);
            this.getContentPane().add((Component)this.label, gridBagConstraints);
            this.jButton1.setText(" Abort ");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FindCyclesDialog.this.jButton1ActionPerformed(evt);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(12, 0, 12, 0);
            this.getContentPane().add((Component)this.jButton1, gridBagConstraints);
            this.pack();
        }

        private void jButton1ActionPerformed(ActionEvent evt) {
            this.setVisible(false);
            CancellationHandler.cancel(null);
        }
    }

    private class CellInfo {
        public int row;
        public int column;
        boolean arrowLeft;
        boolean arrowRight;

        private CellInfo() {
        }
    }
}

