/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.sf.jailer.datamodel.Column;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.ParameterSelector;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.ui.scrollmenu.JScrollPopupMenu;

public class ConditionEditor
extends JDialog {
    private boolean ok;
    private ParameterSelector parameterSelector;
    private Table table1;
    private Table table2;
    private String table1alias;
    private String table2alias;
    private boolean addPseudoColumns;
    private JButton cancelButton;
    private JEditorPane editorPane;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JButton okButton;
    private JPanel paramsPanel;
    private JLabel table1dropDown;
    private JLabel table1label;
    private JLabel table1name;
    private JLabel table2dropDown;
    private JLabel table2label;
    private JLabel table2name;
    private Icon dropDownIcon;
    private static final long serialVersionUID = -5169934807182707970L;

    public ConditionEditor(Frame parent, ParameterSelector.ParametersGetter parametersGetter) {
        super(parent, true);
        String dir = "/net/sf/jailer/resource";
        try {
            this.dropDownIcon = new ImageIcon(this.getClass().getResource(dir + "/dropdown.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initComponents();
        this.setLocation(400, 150);
        this.setSize(600, 400);
        if (parametersGetter != null) {
            this.parameterSelector = new ParameterSelector(this, this.editorPane, parametersGetter);
            this.paramsPanel.add(this.parameterSelector);
        } else {
            this.paramsPanel.setVisible(false);
        }
        this.editorPane.setContentType("text/sql");
        this.table1dropDown.setText(null);
        this.table1dropDown.setIcon(this.dropDownIcon);
        this.table2dropDown.setText(null);
        this.table2dropDown.setIcon(this.dropDownIcon);
        this.table1dropDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ConditionEditor.this.openColumnDropDownBox(ConditionEditor.this.table1dropDown, ConditionEditor.this.table1alias, ConditionEditor.this.table1);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ConditionEditor.this.table1dropDown.setEnabled(false);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ConditionEditor.this.table1dropDown.setEnabled(true);
            }
        });
        this.table2dropDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ConditionEditor.this.openColumnDropDownBox(ConditionEditor.this.table2dropDown, ConditionEditor.this.table2alias, ConditionEditor.this.table2);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ConditionEditor.this.table2dropDown.setEnabled(false);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ConditionEditor.this.table2dropDown.setEnabled(true);
            }
        });
    }

    private void openColumnDropDownBox(JLabel label, String alias, Table table) {
        JScrollPopupMenu popup = new JScrollPopupMenu();
        ArrayList<String> columns = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            columns.add(alias + "." + column.name);
        }
        if (this.addPseudoColumns) {
            columns.add("");
            columns.add(alias + ".$IS_SUBJECT");
            columns.add(alias + ".$DISTANCE");
        }
        for (final String string : columns) {
            if (string.equals("")) {
                popup.add(new JSeparator());
                continue;
            }
            JMenuItem m = new JMenuItem(string);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConditionEditor.this.editorPane.isEnabled() && ConditionEditor.this.editorPane.isEditable()) {
                        ConditionEditor.this.editorPane.replaceSelection(string);
                    }
                }
            });
            popup.add(m);
        }
        UIUtil.fit(popup);
        ((JPopupMenu)popup).show(label, 0, label.getHeight());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.paramsPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.table1label = new JLabel();
        this.table1name = new JLabel();
        this.table1dropDown = new JLabel();
        this.jLabel1 = new JLabel();
        this.table2label = new JLabel();
        this.table2name = new JLabel();
        this.table2dropDown = new JLabel();
        this.jPanel3 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.editorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.paramsPanel.setMinimumSize(new Dimension(150, 0));
        this.paramsPanel.setLayout(new BoxLayout(this.paramsPanel, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 20;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.paramsPanel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.table1label.setText(" Table ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 3, 0);
        this.jPanel2.add((Component)this.table1label, gridBagConstraints);
        this.table1name.setFont(new Font("DejaVu Sans", 0, 12));
        this.table1name.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 3, 0);
        this.jPanel2.add((Component)this.table1name, gridBagConstraints);
        this.table1dropDown.setFont(new Font("DejaVu Sans", 0, 12));
        this.table1dropDown.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 3, 0);
        this.jPanel2.add((Component)this.table1dropDown, gridBagConstraints);
        this.jLabel1.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.table2label.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.table2label, gridBagConstraints);
        this.table2name.setFont(new Font("DejaVu Sans", 0, 12));
        this.table2name.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.table2name, gridBagConstraints);
        this.table2dropDown.setFont(new Font("DejaVu Sans", 0, 12));
        this.table2dropDown.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.table2dropDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.okButton.setText(" Ok ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.okButton);
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.editorPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.setVisible(false);
    }

    public String edit(String condition, String table1label, String table1alias, Table table1, String table2label, String table2alias, Table table2, boolean addPseudoColumns) {
        condition = ConditionEditor.toMultiLine(condition);
        this.table1 = table1;
        this.table2 = table2;
        this.table1alias = table1alias;
        this.table2alias = table2alias;
        this.addPseudoColumns = addPseudoColumns;
        if (table1 != null) {
            this.table1label.setText(" " + table1label + " ");
            this.table1name.setText("  " + table1.getName());
            this.table1label.setVisible(true);
            this.table1name.setVisible(true);
            this.table1dropDown.setVisible(true);
        } else {
            this.table1label.setVisible(false);
            this.table1name.setVisible(false);
            this.table1dropDown.setVisible(false);
        }
        if (table2 != null) {
            this.table2label.setText(" " + table2label + " ");
            this.table2name.setText("  " + table2.getName());
            this.table2label.setVisible(true);
            this.table2name.setVisible(true);
            this.table2dropDown.setVisible(true);
        } else {
            this.table2label.setVisible(false);
            this.table2name.setVisible(false);
            this.table2dropDown.setVisible(false);
        }
        this.ok = false;
        this.editorPane.setText(condition);
        if (this.parameterSelector != null) {
            this.parameterSelector.updateParameters();
        }
        this.setVisible(true);
        return this.ok ? this.editorPane.getText() : null;
    }

    public static String toSingleLine(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toMultiLine(String s) {
        StringBuilder sb = new StringBuilder();
        boolean esc = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (esc) {
                    esc = false;
                } else {
                    esc = true;
                    continue;
                }
            }
            if (esc && c == 'n') {
                c = '\n';
            } else if (esc && c == 'r') {
                c = '\r';
            }
            sb.append(c);
            esc = false;
        }
        return sb.toString();
    }
}

