/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.ParameterSelector;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.xml.XmlUtil;
import org.w3c.dom.Document;

public class ColumnMapperDialog
extends JDialog {
    private final Frame parent;
    private Table table;
    private DataModel dataModel;
    private boolean ok;
    private ParameterSelector parameterSelector;
    private JButton cancelButton;
    private JButton formatButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JEditorPane mappingField;
    private JButton okButton;
    private JPanel paramPanel;
    private JButton resetButton;
    private javax.swing.JComboBox tableCombobox;
    private static final long serialVersionUID = -5437578641818236294L;

    public ColumnMapperDialog(Frame parent, ParameterSelector.ParametersGetter parametersGetter) {
        super(parent, true);
        this.parent = parent;
        this.initComponents();
        this.parameterSelector = new ParameterSelector(this, this.mappingField, parametersGetter);
        this.paramPanel.add(this.parameterSelector);
        this.tableCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (ColumnMapperDialog.this.table != null) {
                        ColumnMapperDialog.this.table = ColumnMapperDialog.this.dataModel.getTableByDisplayName((String)ColumnMapperDialog.this.tableCombobox.getSelectedItem());
                        ColumnMapperDialog.this.mappingField.setText(XmlUtil.build(ColumnMapperDialog.this.table.getXmlTemplateAsDocument()));
                    }
                }
                catch (Exception ex) {
                    UIUtil.showException(ColumnMapperDialog.this.parent, "Error", ex);
                }
            }
        });
        this.mappingField.setContentType("text/xml");
        UIUtil.initPeer();
    }

    public boolean edit(DataModel dataModel, Table table) {
        this.parameterSelector.updateParameters();
        this.table = null;
        Vector<String> tableNames = new Vector<String>();
        for (Table t : dataModel.getTables()) {
            tableNames.add(dataModel.getDisplayName(t));
        }
        Collections.sort(tableNames);
        this.tableCombobox.setModel(new DefaultComboBoxModel(tableNames));
        this.tableCombobox.setMaximumRowCount(40);
        this.tableCombobox.setSelectedItem(dataModel.getDisplayName(table));
        int w = 600;
        int h = 600;
        this.setSize(w, h);
        this.setLocation(Math.max(0, this.parent.getX() + this.parent.getWidth() / 2 - w / 2), Math.max(0, this.parent.getY() + this.parent.getHeight() / 2 - h / 2));
        this.invalidate();
        try {
            this.mappingField.setText(XmlUtil.build(table.getXmlTemplateAsDocument()));
        }
        catch (Exception e) {
            try {
                this.mappingField.setText(XmlUtil.build(table.getDefaultXmlTemplate()));
            }
            catch (Exception e2) {
                UIUtil.showException(this.parent, "Error", e);
                return false;
            }
        }
        this.ok = false;
        this.table = table;
        this.dataModel = dataModel;
        this.setVisible(true);
        return this.ok;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tableCombobox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.formatButton = new JButton();
        this.resetButton = new JButton();
        this.jLabel3 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.paramPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.mappingField = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("XML Column Mapping");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(" Table ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.tableCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Eintrag 1", "Eintrag 2", "Eintrag 3", "Eintrag 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.tableCombobox, gridBagConstraints);
        this.jLabel2.setText(" Mapping  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.formatButton.setText("Format");
        this.formatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnMapperDialog.this.formatButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.formatButton);
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnMapperDialog.this.resetButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.resetButton);
        this.jLabel3.setText("  ");
        this.jPanel2.add(this.jLabel3);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnMapperDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnMapperDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.paramPanel.setMinimumSize(new Dimension(150, 0));
        this.paramPanel.setLayout(new BoxLayout(this.paramPanel, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.paramPanel, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.mappingField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        this.getContentPane().add(this.jPanel1);
        this.pack();
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        try {
            Document doc = this.table.getDefaultXmlTemplate();
            this.mappingField.setText(XmlUtil.build(doc));
        }
        catch (Exception e) {
            UIUtil.showException(this.parent, "Syntax Error", e);
        }
    }

    private void formatButtonActionPerformed(ActionEvent evt) {
        try {
            Document doc = XmlUtil.parse(this.mappingField.getText());
            this.mappingField.setText(XmlUtil.build(doc));
        }
        catch (Exception e) {
            UIUtil.showException(this.parent, "Syntax Error", e);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            Document doc = XmlUtil.parse(this.mappingField.getText());
            this.mappingField.setText(XmlUtil.build(doc));
            this.table.setXmlTemplate(this.mappingField.getText());
            this.ok = true;
            this.setVisible(false);
        }
        catch (Exception e) {
            UIUtil.showException(this.parent, "Syntax Error", e);
        }
    }
}

