/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.ExtractionModelFrame;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.util.SqlUtil;

public class ClosureView
extends JDialog {
    private static final int MAX_TABLES_PER_LINE = 4;
    private final ExtractionModelFrame extractionModelFrame;
    private String selectedTable;
    private final List<Color> bgColor = new ArrayList<Color>();
    private Map<String, CellInfo> cellInfo = new HashMap<String, CellInfo>();
    private boolean refreshing = false;
    private Set<String> editedAssociations = new TreeSet<String>();
    private List<List<String>> associationClosure = new ArrayList<List<String>>();
    private Collection<JComponent> associationClosureRender = new ArrayList<JComponent>();
    private String noAssocLimitTableName;
    private final int MAX_ASSOC_CLOSURE_SIZE_LIMIT = 200;
    private JPanel assocViewPanel;
    private JPanel associationPane;
    private JPanel associationPanel;
    private JTable closureTable;
    private JButton disableAssocButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JCheckBox showOnlyEnabledCheckBox;
    private JPanel tabAssAssPanel;
    private JPanel tabAssPanel;
    private JPanel tabAssTabPanel;
    private JTabbedPane tabbedPane;
    private JPanel tableAssociationPane;
    private JPanel tablePane;
    private JPanel tablePanel;
    private javax.swing.JComboBox tableSelection;
    private static final long serialVersionUID = 5485949274233292142L;
    private Font normalfont = new JLabel("normal").getFont();
    private Font nonbold = new Font(this.normalfont.getName(), this.normalfont.getStyle() & 0xFFFFFFFE, this.normalfont.getSize());

    public ClosureView(ExtractionModelFrame extractionModelFrame) {
        super((Frame)extractionModelFrame, false);
        this.extractionModelFrame = extractionModelFrame;
        this.initComponents();
        this.showOnlyEnabledCheckBox.setMnemonic(83);
        this.disableAssocButton.setMnemonic(68);
        this.disableAssocButton.setEnabled(false);
        this.tableSelection.setMaximumRowCount(22);
        this.closureTable = new JTable(){
            private static final long serialVersionUID = 8960056200057023368L;

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (!(graphics instanceof Graphics2D)) {
                    return;
                }
                Graphics2D g2d = (Graphics2D)graphics;
                CellInfo selectionInfo = (CellInfo)ClosureView.this.cellInfo.get(ClosureView.this.selectedTable);
                if (selectionInfo == null) {
                    return;
                }
                int[] x = new int[selectionInfo.pathToRoot.size() + 1];
                int[] y = new int[selectionInfo.pathToRoot.size() + 1];
                int pos = 0;
                for (String t : selectionInfo.pathToRoot) {
                    CellInfo posInfo = (CellInfo)ClosureView.this.cellInfo.get(t);
                    Rectangle r = ClosureView.this.closureTable.getCellRect(posInfo.row, posInfo.column, false);
                    x[pos] = (int)r.getCenterX();
                    y[pos] = (int)r.getCenterY();
                    ++pos;
                }
                CellInfo posInfo = selectionInfo;
                Rectangle r = ClosureView.this.closureTable.getCellRect(posInfo.row, posInfo.column, false);
                x[pos] = (int)r.getCenterX();
                y[pos] = (int)r.getCenterY();
                Color color = new Color(0, 120, 255, 60);
                g2d.setColor(color);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setStroke(new BasicStroke(5.0f));
                g2d.drawPolyline(x, y, ++pos);
            }
        };
        this.closureTable.setShowGrid(false);
        this.closureTable.setSurrendersFocusOnKeystroke(true);
        this.jScrollPane1.setViewportView(this.closureTable);
        this.closureTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int row = ClosureView.this.closureTable.rowAtPoint(e.getPoint());
                    int column = ClosureView.this.closureTable.columnAtPoint(e.getPoint());
                    if (row < 0 || column < 0) {
                        return;
                    }
                    Object value = ClosureView.this.closureTable.getModel().getValueAt(row, column);
                    if (value == null || !(value instanceof String)) {
                        return;
                    }
                    Table table = ClosureView.this.getDataModel().getTableByDisplayName((String)value);
                    if (table != null) {
                        JPopupMenu popup = ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.graphView.createPopupMenu(table, false);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        final TableCellRenderer defaultTableCellRenderer = this.closureTable.getDefaultRenderer(String.class);
        this.closureTable.setDefaultRenderer(Object.class, new TableCellRenderer(){
            private Font font = new JLabel("normal").getFont();
            private Font normal = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
            private Font bold = new Font(this.font.getName(), this.font.getStyle() | 1, this.font.getSize());

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component render;
                boolean bl = isSelected = ClosureView.this.selectedTable != null && ClosureView.this.selectedTable.equals(value);
                if (value == null || column < 1 || "".equals(value)) {
                    hasFocus = false;
                }
                if ((render = defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JLabel && !isSelected) {
                    ((JLabel)render).setBackground((Color)ClosureView.this.bgColor.get(row));
                }
                CellInfo cellInfo = (CellInfo)ClosureView.this.cellInfo.get(ClosureView.this.selectedTable);
                if (render instanceof JLabel) {
                    Table t;
                    ((JLabel)render).setForeground(Color.BLACK);
                    ((JLabel)render).setFont(this.normal);
                    ((JLabel)render).setToolTipText(((JLabel)render).getText());
                    if (cellInfo != null && ClosureView.this.selectedTable != null && (ClosureView.this.selectedTable.equals(value) || cellInfo.pathToRoot.contains(value))) {
                        ((JLabel)render).setFont(this.bold);
                    }
                    if ((t = ClosureView.this.getDataModel().getTableByDisplayName((String)value)) != null) {
                        boolean allDisabled = true;
                        boolean someRestricted = false;
                        for (Association association : t.associations) {
                            if (!association.isInsertDestinationBeforeSource() && !association.isIgnored()) {
                                allDisabled = false;
                            }
                            if (!association.isRestricted()) continue;
                            someRestricted = true;
                        }
                        if (allDisabled && someRestricted) {
                            ((JLabel)render).setForeground(new Color(160, 80, 0));
                        } else if (!allDisabled && someRestricted) {
                            ((JLabel)render).setForeground(new Color(0, 80, 160));
                        }
                    }
                }
                return render;
            }
        });
        this.closureTable.setSelectionMode(0);
        this.closureTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                int col = ClosureView.this.closureTable.getSelectedColumn();
                int row = ClosureView.this.closureTable.getSelectedRow();
                if (col >= 1 && row >= 0) {
                    String displayName = (String)ClosureView.this.closureTable.getModel().getValueAt(row, col);
                    ClosureView.this.closureTable.getSelectionModel().clearSelection();
                    if (displayName != null && !"".equals(displayName)) {
                        ClosureView.this.selectedTable = displayName;
                        ClosureView.this.disableAssocButton.setEnabled(true);
                        ClosureView.this.repaint();
                        Table table = ClosureView.this.getDataModel().getTableByDisplayName(ClosureView.this.selectedTable);
                        if (table != null) {
                            CellInfo selectionInfo = (CellInfo)ClosureView.this.cellInfo.get(ClosureView.this.selectedTable);
                            if (selectionInfo != null) {
                                Table pre;
                                Association association = null;
                                if (selectionInfo.pathToRoot != null && selectionInfo.pathToRoot.size() > 0 && (pre = ClosureView.this.getDataModel().getTableByDisplayName(selectionInfo.pathToRoot.get(selectionInfo.pathToRoot.size() - 1))) != null) {
                                    for (Association a : pre.associations) {
                                        if (a.isIgnored() || !a.destination.equals(table)) continue;
                                        association = a;
                                        break;
                                    }
                                }
                                if (association != null && ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.select(association)) {
                                    return;
                                }
                            }
                            if (!((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.select(table)) {
                                ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.setRootSelection(table);
                            }
                        }
                    }
                }
            }
        });
        this.tableSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Table table = ClosureView.this.getDataModel().getTableByDisplayName((String)ClosureView.this.tableSelection.getSelectedItem());
                ClosureView.this.refresh(table);
            }
        });
        this.initTabbedPane();
        this.setLocation(100, 100);
        this.setSize(500, 500);
        this.setAlwaysOnTop(true);
    }

    private DataModel getDataModel() {
        return this.extractionModelFrame.extractionModelEditor.dataModel;
    }

    public void refresh(Table tableToSelect) {
        Object currentSelection;
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        this.selectedTable = null;
        if (tableToSelect == null && (currentSelection = this.tableSelection.getSelectedItem()) instanceof String) {
            tableToSelect = this.getDataModel().getTableByDisplayName((String)currentSelection);
        }
        Vector<String> tableNames = new Vector<String>();
        for (Table table : this.getDataModel().getTables()) {
            tableNames.add(this.getDataModel().getDisplayName(table));
        }
        Collections.sort(tableNames);
        DefaultComboBoxModel model = new DefaultComboBoxModel(tableNames);
        this.tableSelection.setModel(model);
        if (tableToSelect != null) {
            this.tableSelection.setSelectedItem(this.getDataModel().getDisplayName(tableToSelect));
        } else {
            this.tableSelection.setSelectedItem(0);
        }
        this.refreshTableModel();
        this.refreshing = false;
    }

    public void refresh() {
        String prevSelection = this.selectedTable;
        this.refreshTableModel();
        this.selectedTable = this.cellInfo.containsKey(prevSelection) ? prevSelection : null;
        this.disableAssocButton.setEnabled(false);
        this.repaint();
    }

    private void refreshTableModel() {
        this.cellInfo.clear();
        Table selectedTable = this.getSelectedTable();
        this.refreshAssociationView(selectedTable);
        Object[] columns = new Object[5];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = "";
        }
        columns[0] = "Distance";
        columns[1] = "Table";
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        HashSet<String> visited = new HashSet<String>();
        ArrayList<String> currentLine = new ArrayList<String>();
        if (selectedTable != null) {
            String displayName = this.getDataModel().getDisplayName(selectedTable);
            currentLine.add(displayName);
            visited.add(displayName);
            CellInfo cellInfo = new CellInfo();
            cellInfo.column = 1;
            cellInfo.row = 0;
            this.cellInfo.put(displayName, cellInfo);
        }
        int distance = 0;
        Color BG1 = new Color(255, 255, 255);
        Color BG2 = new Color(230, 255, 255);
        this.bgColor.clear();
        this.bgColor.add(BG1);
        while (!currentLine.isEmpty()) {
            Collections.sort(currentLine);
            Object[] lineAsObjects = new Object[5];
            Arrays.fill(lineAsObjects, "");
            int col = 0;
            lineAsObjects[col++] = distance > 0 ? "" + distance : "";
            for (String t : currentLine) {
                CellInfo cellInfo = this.cellInfo.get(t);
                if (col <= 4) {
                    cellInfo.column = col;
                    lineAsObjects[col++] = t;
                } else {
                    data.add(lineAsObjects);
                    this.bgColor.add(distance % 2 == 0 ? BG1 : BG2);
                    lineAsObjects = new Object[5];
                    Arrays.fill(lineAsObjects, "");
                    cellInfo.column = col = 1;
                    lineAsObjects[col++] = t;
                }
                cellInfo.row = data.size();
            }
            if (col > 1) {
                data.add(lineAsObjects);
                this.bgColor.add(distance % 2 != 0 ? BG1 : BG2);
            }
            ArrayList<String> nextLine = new ArrayList<String>();
            for (String t : currentLine) {
                Table table = this.getDataModel().getTableByDisplayName(t);
                if (table == null) continue;
                CellInfo cellInfoT = this.cellInfo.get(t);
                for (Association association : table.associations) {
                    String displayName = this.getDataModel().getDisplayName(association.destination);
                    if (visited.contains(displayName) || association.isIgnored()) continue;
                    nextLine.add(displayName);
                    visited.add(displayName);
                    CellInfo cellInfo = new CellInfo();
                    cellInfo.pathToRoot.addAll(cellInfoT.pathToRoot);
                    cellInfo.pathToRoot.add(t);
                    this.cellInfo.put(displayName, cellInfo);
                }
            }
            currentLine = nextLine;
            ++distance;
        }
        Object[][] dataArray = (Object[][])data.toArray((T[])new Object[data.size()][]);
        DefaultTableModel tableModel = new DefaultTableModel(dataArray, columns){
            private static final long serialVersionUID = -6639310191624899380L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.closureTable.setModel(tableModel);
        for (int i = 0; i < this.closureTable.getColumnCount(); ++i) {
            TableColumn column = this.closureTable.getColumnModel().getColumn(i);
            int width = 1;
            Component comp = this.closureTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.closureTable, column.getHeaderValue(), false, false, 0, i);
            width = Math.max(width, comp.getPreferredSize().width);
            for (int line = 0; line < dataArray.length; ++line) {
                comp = this.closureTable.getDefaultRenderer(String.class).getTableCellRendererComponent(this.closureTable, dataArray[line][i], false, false, line, i);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(width);
        }
        this.closureTable.setIntercellSpacing(new Dimension(0, 0));
        this.disableAssocButton.setEnabled(false);
    }

    private Table getSelectedTable() {
        Table selectedTable = null;
        Object currentSelection = this.tableSelection.getSelectedItem();
        if (currentSelection instanceof String) {
            selectedTable = this.getDataModel().getTableByDisplayName((String)currentSelection);
        }
        return selectedTable;
    }

    private void refreshAssociationView(Table selectedTable) {
        JLabel l;
        GridBagConstraints gridBagConstraints;
        this.jLabel2.setFont(this.nonbold);
        this.jLabel3.setFont(this.nonbold);
        this.jLabel4.setFont(this.nonbold);
        this.jLabel5.setFont(this.nonbold);
        this.jLabel6.setFont(this.nonbold);
        for (JComponent c : this.associationClosureRender) {
            this.assocViewPanel.remove(c);
        }
        this.associationClosureRender.clear();
        this.createAssociationClosure(selectedTable);
        int y = 3;
        int surplus = 0;
        int distance = 0;
        boolean limitExceeded = false;
        final Table st = this.getSelectedTable();
        boolean unlimited = this.noAssocLimitTableName != null && st != null && this.noAssocLimitTableName.equals(st.getName());
        Color bgColor = Color.WHITE;
        for (List<String> assocList : this.associationClosure) {
            boolean firstTime = true;
            bgColor = distance % 2 == 0 ? new Color(240, 255, 255) : Color.WHITE;
            for (final String assocName : assocList) {
                Association association = this.getDataModel().namedAssociations.get(assocName);
                if (association == null || association.isInsertDestinationBeforeSource()) continue;
                if (y - 3 > 200 && !unlimited) {
                    limitExceeded = true;
                }
                if (limitExceeded) {
                    ++surplus;
                    continue;
                }
                Font font = this.nonbold;
                Color bgc = bgColor;
                if (this.extractionModelFrame.extractionModelEditor.graphView.selectedAssociation != null && assocName.equals(this.extractionModelFrame.extractionModelEditor.graphView.selectedAssociation.getName())) {
                    bgc = new Color(255, 230, 220);
                }
                JLabel l2 = this.createLabel(y, null, assocName, bgc, distance == 0 || !firstTime ? " " : " " + distance + " ", false);
                firstTime = false;
                l2.setOpaque(true);
                l2.setFont(font);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 1;
                this.assocViewPanel.add((Component)l2, gridBagConstraints);
                l2 = this.createLabel(y, association.source.getName(), assocName, bgc, " " + this.getDataModel().getDisplayName(association.source), false);
                l2.setOpaque(true);
                l2.setFont(font);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 1;
                this.assocViewPanel.add((Component)l2, gridBagConstraints);
                l2 = this.createLabel(y, association.destination.getName(), assocName, bgc, " " + this.getDataModel().getDisplayName(association.destination), false);
                l2.setOpaque(true);
                l2.setFont(font);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 1;
                this.assocViewPanel.add((Component)l2, gridBagConstraints);
                final JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(!association.isIgnored());
                checkBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        ClosureView.this.editedAssociations.add(assocName);
                        Association association = ((ClosureView)ClosureView.this).getDataModel().namedAssociations.get(assocName);
                        if (association != null) {
                            if (!((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.select(association)) {
                                ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.setRootSelection(association.destination);
                                ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.select(association);
                            }
                            ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.graphView.setRestriction(association, !checkBox.isSelected());
                        }
                    }
                });
                this.associationClosureRender.add(checkBox);
                checkBox.setBackground(bgc);
                checkBox.setOpaque(true);
                checkBox.setFont(this.nonbold);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 1;
                this.assocViewPanel.add((Component)checkBox, gridBagConstraints);
                String unrestrictedJoinCondition = association.getUnrestrictedJoinCondition();
                if (association.reversed) {
                    unrestrictedJoinCondition = SqlUtil.reversRestrictionCondition(unrestrictedJoinCondition);
                }
                l2 = this.createLabel(y, null, assocName, bgc, " " + unrestrictedJoinCondition, true);
                l2.setOpaque(true);
                l2.setFont(this.nonbold);
                l2.setForeground(Color.GRAY);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = y++;
                gridBagConstraints.fill = 1;
                this.assocViewPanel.add((Component)l2, gridBagConstraints);
            }
            if (firstTime && !limitExceeded) {
                JLabel l3 = this.createLabel(y, null, null, bgColor, distance == 0 || !firstTime ? " " : " " + distance + " ", false);
                firstTime = false;
                l3.setOpaque(true);
                l3.setFont(this.nonbold);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = y;
                gridBagConstraints.fill = 1;
                this.assocViewPanel.add((Component)l3, gridBagConstraints);
                l3 = this.createLabel(y, null, null, bgColor, " no non-dependency association", true);
                l3.setOpaque(true);
                l3.setFont(this.nonbold);
                l3.setForeground(Color.GRAY);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = y++;
                gridBagConstraints.gridwidth = 4;
                gridBagConstraints.fill = 1;
                this.assocViewPanel.add((Component)l3, gridBagConstraints);
            }
            ++distance;
        }
        if (limitExceeded) {
            l = this.createLabel(y, null, null, null, " " + surplus + " more...", false);
            l.setOpaque(true);
            l.setFont(this.nonbold);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 1;
            this.assocViewPanel.add((Component)l, gridBagConstraints);
            JButton showAll = new JButton("Show all");
            this.associationClosureRender.add(showAll);
            showAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClosureView.this.noAssocLimitTableName = st != null ? st.getName() : null;
                    ClosureView.this.refreshAssociationView(ClosureView.this.getSelectedTable());
                    ClosureView.this.repaint();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y + 1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            this.assocViewPanel.add((Component)showAll, gridBagConstraints);
            ++y;
        }
        l = new JLabel("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = y;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.assocViewPanel.add((Component)l, gridBagConstraints);
        this.associationClosureRender.add(l);
    }

    private JLabel createLabel(int y, final String tableName, final String assocName, Color bgColor, String text, boolean unbounded) {
        int MAX_TEXT_LENGTH = 22;
        JLabel label = new JLabel();
        if (text.length() > 22 && !unbounded) {
            label.setText(text.substring(0, 22) + "...");
            label.setToolTipText(text);
        } else {
            label.setText(text);
        }
        this.associationClosureRender.add(label);
        if (bgColor != null) {
            label.setBackground(bgColor);
        }
        if (assocName != null) {
            label.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    Association association;
                    if (SwingUtilities.isRightMouseButton(e)) {
                        Table table;
                        if (tableName != null && (table = ClosureView.this.getDataModel().getTable(tableName)) != null) {
                            JPopupMenu popup = ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.graphView.createPopupMenu(table, false);
                            popup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    } else if (SwingUtilities.isLeftMouseButton(e) && (association = ((ClosureView)ClosureView.this).getDataModel().namedAssociations.get(assocName)) != null) {
                        if (!((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.select(association)) {
                            ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.setRootSelection(association.destination);
                            ((ClosureView)ClosureView.this).extractionModelFrame.extractionModelEditor.select(association);
                        }
                        ClosureView.this.refreshAssociationView(ClosureView.this.getSelectedTable());
                        ClosureView.this.repaint();
                    }
                }
            });
        }
        return label;
    }

    private void createAssociationClosure(Table selectedTable) {
        this.associationClosure.clear();
        if (selectedTable != null) {
            HashSet seen = new HashSet();
            HashSet<Association> next = new HashSet<Association>();
            next.addAll(selectedTable.associations);
            for (Association a : selectedTable.associations) {
                next.add(a.reversalAssociation);
            }
            Set<Table> closure = selectedTable.closure(true);
            while (!next.isEmpty()) {
                HashSet<Association> neighbors = new HashSet<Association>();
                ArrayList<String> assocList = new ArrayList<String>();
                seen.addAll(next);
                for (Association a : next) {
                    if (!closure.contains(a.source) && !this.editedAssociations.contains(a.getName())) continue;
                    if (!a.isIgnored() || !this.showOnlyEnabledCheckBox.isSelected()) {
                        assocList.add(a.getName());
                    }
                    if (a.isIgnored()) continue;
                    for (Association n : a.destination.associations) {
                        if (!seen.contains(n)) {
                            neighbors.add(n);
                        }
                        if (seen.contains(n.reversalAssociation)) continue;
                        neighbors.add(n.reversalAssociation);
                    }
                    for (Association n : a.source.associations) {
                        if (!seen.contains(n)) {
                            neighbors.add(n);
                        }
                        if (seen.contains(n.reversalAssociation)) continue;
                        neighbors.add(n.reversalAssociation);
                    }
                }
                Collections.sort(assocList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        Association a1 = ((ClosureView)ClosureView.this).getDataModel().namedAssociations.get(o1);
                        Association a2 = ((ClosureView)ClosureView.this).getDataModel().namedAssociations.get(o2);
                        String n1 = "";
                        String n2 = "";
                        if (a1 != null) {
                            n1 = a1.source.getName() + "," + a1.destination.getName();
                        }
                        if (a2 != null) {
                            n2 = a2.source.getName() + "," + a2.destination.getName();
                        }
                        return n1.compareTo(n2);
                    }
                });
                if (!assocList.isEmpty()) {
                    this.associationClosure.add(assocList);
                }
                next = neighbors;
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tableSelection = new JComboBox();
        this.tabbedPane = new JTabbedPane();
        this.tablePane = new JPanel();
        this.tablePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.closureTable = new JTable();
        this.disableAssocButton = new JButton();
        this.associationPane = new JPanel();
        this.associationPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.assocViewPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.showOnlyEnabledCheckBox = new JCheckBox();
        this.tableAssociationPane = new JPanel();
        this.tabAssPanel = new JPanel();
        this.tabAssTabPanel = new JPanel();
        this.tabAssAssPanel = new JPanel();
        this.setTitle("Closure Browser");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(" Focus ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.tableSelection.setMaximumRowCount(32);
        this.tableSelection.setModel(new DefaultComboBoxModel<String>(new String[]{"Eintrag 1", "Eintrag 2", "Eintrag 3", "Eintrag 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 20;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 2);
        this.jPanel1.add((Component)this.tableSelection, gridBagConstraints);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ClosureView.this.tabbedPaneStateChanged(evt);
            }
        });
        this.tablePane.setLayout(new BoxLayout(this.tablePane, 2));
        this.tablePanel.setLayout(new GridBagLayout());
        this.closureTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.closureTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Titel 1", "Titel 2", "Titel 3", "Titel 4"}));
        this.closureTable.setSurrendersFocusOnKeystroke(true);
        this.jScrollPane1.setViewportView(this.closureTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 30;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.tablePanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.disableAssocButton.setText(" Disable associations ");
        this.disableAssocButton.setToolTipText("disables each association with the selected table\n(except dependencies), possibly removing the table from the closure.");
        this.disableAssocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClosureView.this.disableAssocButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.gridwidth = 30;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.tablePanel.add((Component)this.disableAssocButton, gridBagConstraints);
        this.tablePane.add(this.tablePanel);
        this.tabbedPane.addTab("Table", this.tablePane);
        this.associationPane.setLayout(new BoxLayout(this.associationPane, 2));
        this.associationPanel.setLayout(new GridBagLayout());
        this.jScrollPane2.setBorder(BorderFactory.createEtchedBorder());
        this.assocViewPanel.setBorder(null);
        this.assocViewPanel.setLayout(new GridBagLayout());
        this.jLabel2.setText(" Distance  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.assocViewPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(" to ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.assocViewPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("         ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.assocViewPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(" on");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.assocViewPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(" from ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.assocViewPanel.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.assocViewPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.assocViewPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.associationPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.showOnlyEnabledCheckBox.setText("Show only enabled associations");
        this.showOnlyEnabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ClosureView.this.showOnlyEnabledCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 4, 4, 4);
        this.associationPanel.add((Component)this.showOnlyEnabledCheckBox, gridBagConstraints);
        this.associationPane.add(this.associationPanel);
        this.tabbedPane.addTab("Association", this.associationPane);
        this.tableAssociationPane.setLayout(new BoxLayout(this.tableAssociationPane, 2));
        this.tabAssPanel.setLayout(new GridBagLayout());
        this.tabAssTabPanel.setLayout(new BoxLayout(this.tabAssTabPanel, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.tabAssPanel.add((Component)this.tabAssTabPanel, gridBagConstraints);
        this.tabAssAssPanel.setLayout(new BoxLayout(this.tabAssAssPanel, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tabAssPanel.add((Component)this.tabAssAssPanel, gridBagConstraints);
        this.tableAssociationPane.add(this.tabAssPanel);
        this.tabbedPane.addTab("Table + Association", this.tableAssociationPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.tabbedPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void disableAssocButtonActionPerformed(ActionEvent evt) {
        Table table = this.getDataModel().getTableByDisplayName(this.selectedTable);
        if (table != null) {
            this.extractionModelFrame.extractionModelEditor.ignoreAll(table);
        }
    }

    private void showOnlyEnabledCheckBoxItemStateChanged(ItemEvent evt) {
        this.clearView();
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        this.initTabbedPane();
    }

    private void initTabbedPane() {
        if (this.tabbedPane.getSelectedIndex() == 2) {
            this.tabAssTabPanel.removeAll();
            this.tabAssTabPanel.add(this.tablePanel);
            this.tabAssAssPanel.removeAll();
            this.tabAssAssPanel.add(this.associationPanel);
        } else {
            this.tablePane.removeAll();
            this.tablePane.add(this.tablePanel);
            this.associationPane.removeAll();
            this.associationPane.add(this.associationPanel);
        }
    }

    private void clearView() {
        this.editedAssociations.clear();
        this.refreshAssociationView(this.getSelectedTable());
        this.repaint();
    }

    private class CellInfo {
        public int row;
        public int column;
        List<String> pathToRoot = new ArrayList<String>();

        private CellInfo() {
        }
    }
}

