/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.AssociationListUI;

public abstract class ClosureBorderDialog
extends JDialog {
    private static final long serialVersionUID = -7151994890007647782L;
    protected AssociationListUI associationListUI;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel rootNameLabel;

    public ClosureBorderDialog(Frame parent, boolean withInfoLine) {
        super(parent, false);
        this.initComponents();
        if (!withInfoLine) {
            this.rootNameLabel.setVisible(false);
            this.jLabel1.setVisible(false);
        }
        this.associationListUI = new AssociationListUI("Remove Restrictions", "Remove Restrictions from selected Associations", false){
            private static final long serialVersionUID = 1129925600909956307L;

            @Override
            protected void applyAction(Collection<AssociationListUI.AssociationModel> selection) {
                ArrayList<Association> associations = new ArrayList<Association>();
                for (AssociationListUI.AssociationModel associationModel : selection) {
                    associations.add(((AssociationListUI.DefaultAssociationModel)associationModel).association);
                }
                ClosureBorderDialog.this.removeRestrictions(associations);
            }

            @Override
            protected void onSelect(AssociationListUI.AssociationModel association) {
                ClosureBorderDialog.this.onSelect(((AssociationListUI.DefaultAssociationModel)association).association);
            }
        };
        this.rootNameLabel.setFont(new Font(this.rootNameLabel.getFont().getName(), this.rootNameLabel.getFont().getStyle() | 1, this.rootNameLabel.getFont().getSize()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.associationListUI, gridBagConstraints);
        this.setLocation(30, 80);
        this.setSize(500, 500);
        this.setAlwaysOnTop(true);
        this.refresh();
    }

    protected abstract void removeRestrictions(Collection<Association> var1);

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.rootNameLabel = new JLabel();
        this.setTitle("Closure Border");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Closure-Border of ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.rootNameLabel.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.rootNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 0, 2);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    public void refresh() {
        Table root = this.getRoot();
        DataModel datamodel = this.getDataModel();
        if (root != null && datamodel != null) {
            this.rootNameLabel.setText(datamodel.getDisplayName(root));
            HashSet<Association> border = new HashSet<Association>();
            Set<Table> closure = root.closure(new HashSet<Table>(), true);
            for (Table table : closure) {
                for (Association association : table.associations) {
                    if (!association.isIgnored() || closure.contains(association.destination)) continue;
                    border.add(association);
                }
            }
            ArrayList<AssociationListUI.AssociationModel> model = new ArrayList<AssociationListUI.AssociationModel>();
            for (Association association : border) {
                model.add(new AssociationListUI.DefaultAssociationModel(association));
            }
            this.associationListUI.setModel(model);
        }
    }

    protected abstract Table getRoot();

    protected abstract DataModel getDataModel();

    protected abstract void onSelect(Association var1);
}

