/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.Cardinality;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.util.SqlUtil;

public abstract class AssociationListUI
extends JPanel {
    private List<AssociationModel> model = new ArrayList<AssociationModel>();
    private Set<AssociationModel> selection = new HashSet<AssociationModel>();
    private Set<AssociationModel> hidden = new HashSet<AssociationModel>();
    private Set<AssociationModel> hiddenAll = new HashSet<AssociationModel>();
    private final boolean stableSourceOrder;
    private Double pixelPerTableNameChar = null;
    private static final Color GREEN = new Color(0, 130, 0);
    private static final Color RED = Color.red;
    private static ColumnContentGetter TYPE_CG = new TypeGetter();
    private static ColumnContentGetter SOURCE_CG = new SourceGetter();
    private static ColumnContentGetter DESTINATION_CG = new DestinationGetter();
    private static ColumnContentGetter ASSOCIATION_NAME_CG = new AssociationNameGetter();
    private List<MouseListener> allMouseListener = new ArrayList<MouseListener>();
    private Map<Node, List<MouseListener>> mouseListenerPerNode = new HashMap<Node, List<MouseListener>>();
    private List<Node> roots;
    private final Color BGCOLOR_OF_SELECTED_ROW = Color.CYAN;
    private Font font = new JLabel("normal").getFont();
    private Font bold = new Font(this.font.getName(), this.font.getStyle() | 1, this.font.getSize());
    private Font nonbold = new Font(this.font.getName(), this.font.getStyle() & 0xFFFFFFFE, this.font.getSize());
    private Map<String, String> shortForms = new HashMap<String, String>();
    private JButton doItButton;
    private javax.swing.JComboBox groupByComboBox;
    private JButton hideButton;
    private JLabel infoLabel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JPanel listPanel;
    private JButton unhideButton;
    private static final long serialVersionUID = -5302225732569622137L;

    public AssociationListUI(String actionButtonText, String actionButtonToolTip, boolean stableSourceOrder) {
        this.stableSourceOrder = stableSourceOrder;
        this.initComponents();
        this.doItButton.setText(actionButtonText);
        this.doItButton.setToolTipText(actionButtonToolTip);
        this.groupByComboBox.setModel(new DefaultComboBoxModel<GroupByDefinition>(GroupByDefinition.values()));
        this.groupByComboBox.setSelectedIndex(0);
        this.groupByComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AssociationListUI.this.updateModel();
                AssociationListUI.this.revalidate();
            }
        });
        if (this.jScrollPane1.getVerticalScrollBar() != null) {
            this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        }
        if (this.jScrollPane1.getHorizontalScrollBar() != null) {
            this.jScrollPane1.getHorizontalScrollBar().setUnitIncrement(16);
        }
    }

    public void setModel(Collection<AssociationModel> model) {
        Iterator<AssociationModel> firstAssociationI;
        this.model = new ArrayList<AssociationModel>(model);
        this.selection.retainAll(model);
        this.hidden.clear();
        this.hidden.addAll(this.hiddenAll);
        this.hidden.retainAll(model);
        if (this.pixelPerTableNameChar == null && (firstAssociationI = model.iterator()).hasNext()) {
            AssociationModel firstAssociation = firstAssociationI.next();
            double size = 0.0;
            int l = 0;
            for (Table t : firstAssociation.getDataModel().getTables()) {
                String tName = firstAssociation.getDataModel().getDisplayName(t);
                size += (double)new JLabel((String)tName).getMinimumSize().width;
                l += tName.length();
            }
            this.pixelPerTableNameChar = 8.0;
            if (l > 0) {
                this.pixelPerTableNameChar = size / (double)l;
            }
            if (this.pixelPerTableNameChar < 5.0) {
                this.pixelPerTableNameChar = 5.0;
            }
        }
        this.updateModel();
    }

    private void hideSelection() {
        this.hidden.addAll(this.selection);
        this.hiddenAll.addAll(this.selection);
        this.selection.clear();
        this.updateModel();
    }

    private void unhideHidden() {
        this.hidden.clear();
        this.hiddenAll.clear();
        this.updateModel();
    }

    protected abstract void applyAction(Collection<AssociationModel> var1);

    private void updateModel() {
        this.listPanel.removeAll();
        this.allMouseListener.clear();
        this.mouseListenerPerNode.clear();
        ColumnContentGetter[] columnContentGetter = ((GroupByDefinition)((Object)this.groupByComboBox.getSelectedItem())).columnContentGetter;
        ArrayList<AssociationModel> unhidden = new ArrayList<AssociationModel>(this.model);
        unhidden.removeAll(this.hidden);
        this.roots = this.createHierarchy(columnContentGetter, 0, unhidden);
        if (!unhidden.isEmpty()) {
            int x = 0;
            while (x <= columnContentGetter.length) {
                String text = x == 0 ? " " : columnContentGetter[x - 1].getDisplayName();
                JLabel title = new JLabel(text + "  ");
                title.setBackground(Color.WHITE);
                title.setOpaque(true);
                title.setFont(this.bold);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = x++;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 1;
                this.listPanel.add((Component)title, gridBagConstraints);
            }
        }
        int[] y = new int[]{2};
        this.updateUI(this.roots, 0, y, new boolean[]{false}, new HashMap<Integer, Integer>(), new Node[5]);
        JLabel l = new JLabel(" ");
        l.setBackground(Color.WHITE);
        l.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y[0];
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.listPanel.add((Component)l, gridBagConstraints);
        this.infoLabel.setText(this.selection.size() + " selected association" + (this.selection.size() == 1 ? "" : "s") + ", " + this.hidden.size() + " hidden ");
        this.hideButton.setEnabled(!this.selection.isEmpty());
        this.doItButton.setEnabled(!this.selection.isEmpty());
        this.unhideButton.setEnabled(!this.hidden.isEmpty());
        this.revalidate();
    }

    private void updateUI(List<Node> nodes, int level, int[] y, boolean[] groupStart, Map<Integer, Integer> minLevelPerY, Node[] lastRowContent) {
        boolean firstNode = true;
        Node pred = null;
        for (Node node : nodes) {
            GridBagConstraints gridBagConstraints;
            Color bgColor = y[0] % 2 == 0 ? new Color(240, 255, 255) : Color.WHITE;
            if (!minLevelPerY.containsKey(y[0])) {
                minLevelPerY.put(y[0], level);
            }
            if (!firstNode) {
                for (int x = 0; x < level; ++x) {
                    String lastText = " ";
                    Color lastFgColor = null;
                    if (lastRowContent[x] != null) {
                        lastText = lastRowContent[x].group;
                        lastFgColor = lastRowContent[x].fgColor;
                        lastFgColor = lastFgColor != null ? new Color(lastFgColor.getRed() + 2 * (255 - lastFgColor.getRed()) / 3, lastFgColor.getGreen() + 2 * (255 - lastFgColor.getGreen()) / 3, lastFgColor.getBlue() + 2 * (255 - lastFgColor.getBlue()) / 3) : Color.lightGray;
                    }
                    JComponent l = this.createLabel(node, y[0], this.shorten(lastText), null, false, false, bgColor, lastFgColor, false, false);
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = x + 1;
                    gridBagConstraints.gridy = y[0];
                    gridBagConstraints.fill = 1;
                    this.listPanel.add((Component)l, gridBagConstraints);
                }
            }
            groupStart[0] = groupStart[0] || y[0] > 0 && (!node.isLinear() || pred != null && !pred.isLinear());
            AssociationModel a = node.associations.iterator().next();
            String joinCondition = a.getJoinCondition();
            if (a.isReversed()) {
                joinCondition = SqlUtil.reversRestrictionCondition(joinCondition);
            }
            JComponent l = this.createLabel(node, y[0], node.group, level >= 3 ? joinCondition : null, level < 3, groupStart[0], bgColor, level >= 3 ? Color.gray : node.fgColor, node.isSelected(), true);
            lastRowContent[level] = node;
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = level + 1;
            gridBagConstraints.gridy = y[0];
            gridBagConstraints.fill = 1;
            if (level == 3) {
                gridBagConstraints.weightx = 1.0;
            }
            this.listPanel.add((Component)l, gridBagConstraints);
            if (level >= 3) {
                y[0] = y[0] + 1;
                groupStart[0] = false;
                JPanel p = new JPanel();
                p.setLayout(new GridBagLayout());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = y[0] - 1;
                gridBagConstraints.fill = 1;
                this.listPanel.add((Component)p, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(2, 0, 2, 0);
                final JCheckBox checkbox = new JCheckBox("  ");
                p.add((Component)checkbox, gridBagConstraints);
                p.setBackground(bgColor);
                checkbox.setBackground(bgColor);
                if (node.associations.size() != 1) {
                    System.err.println("node.associations.size() != 1, " + node.associations.size());
                } else {
                    final AssociationModel association = a;
                    checkbox.setSelected(this.selection.contains(association));
                    checkbox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (checkbox.isSelected()) {
                                AssociationListUI.this.selection.add(association);
                                AssociationListUI.this.onSelect(association);
                            } else {
                                AssociationListUI.this.selection.remove(association);
                            }
                            AssociationListUI.this.updateModel();
                        }
                    });
                }
            } else {
                this.updateUI(node.children, level + 1, y, groupStart, minLevelPerY, lastRowContent);
            }
            firstNode = false;
            pred = node;
        }
    }

    private JComponent createLabel(final Node node, int y, String text, String tooltip, boolean shorten, final boolean firstOfGroup, Color bgColor, Color fgColor, boolean selected, boolean addListener) {
        final JPanel panel = new JPanel(){
            private static final long serialVersionUID = 5285941807747744395L;

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (firstOfGroup) {
                    if (!(graphics instanceof Graphics2D)) {
                        return;
                    }
                    Graphics2D g2d = (Graphics2D)graphics;
                    Color color = Color.gray;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setColor(color);
                    g2d.setStroke(new BasicStroke());
                    g2d.drawLine(0, 1, this.getSize().width - 1, 1);
                }
            }
        };
        if (selected) {
            bgColor = new Color(220, 225, 255);
        }
        panel.setLayout(new GridBagLayout());
        final JLabel label = new JLabel();
        label.setOpaque(true);
        label.setFont(this.nonbold);
        if (fgColor != null) {
            label.setForeground(fgColor);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        panel.add((Component)label, gridBagConstraints);
        if (text.trim().length() > 0) {
            label.setToolTipText(text);
        }
        if (tooltip != null) {
            label.setToolTipText(tooltip);
        }
        if (shorten) {
            text = this.shorten(text);
        }
        label.setText(text + "  ");
        label.setBackground(bgColor);
        panel.setBackground(bgColor);
        if (!addListener) {
            return panel;
        }
        MouseListener l = new MouseListener(){
            Color bgColorL;
            Color bgColorP;

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e != null) {
                    for (Node subNode : node.getSubNodes()) {
                        for (MouseListener l : (List)AssociationListUI.this.mouseListenerPerNode.get(subNode)) {
                            if (l == this) continue;
                            l.mouseExited(null);
                        }
                    }
                }
                if (this.bgColorL != null) {
                    label.setBackground(this.bgColorL);
                }
                if (this.bgColorP != null) {
                    panel.setBackground(this.bgColorP);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e != null) {
                    for (MouseListener l : AssociationListUI.this.allMouseListener) {
                        if (l == this) continue;
                        l.mouseExited(null);
                    }
                    for (Node subNode : node.getSubNodes()) {
                        for (MouseListener l : (List)AssociationListUI.this.mouseListenerPerNode.get(subNode)) {
                            if (l == this) continue;
                            l.mouseEntered(null);
                        }
                    }
                }
                if (this.bgColorL == null) {
                    this.bgColorL = label.getBackground();
                }
                if (this.bgColorP == null) {
                    this.bgColorP = panel.getBackground();
                }
                panel.setBackground(AssociationListUI.this.BGCOLOR_OF_SELECTED_ROW);
                label.setBackground(AssociationListUI.this.BGCOLOR_OF_SELECTED_ROW);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (node.isSelected()) {
                        AssociationListUI.this.selection.removeAll(node.associations);
                    } else {
                        AssociationListUI.this.selection.addAll(node.associations);
                        Node leaf = node;
                        while (leaf.children != null && leaf.children.size() > 0) {
                            leaf = leaf.children.get(0);
                        }
                        if (leaf.associations.size() > 0) {
                            AssociationListUI.this.onSelect(leaf.associations.iterator().next());
                        }
                    }
                    AssociationListUI.this.updateModel();
                }
            }
        };
        label.addMouseListener(l);
        this.allMouseListener.add(l);
        if (this.mouseListenerPerNode.get(node) == null) {
            this.mouseListenerPerNode.put(node, new ArrayList());
        }
        this.mouseListenerPerNode.get(node).add(l);
        return panel;
    }

    protected void onSelect(AssociationModel association) {
    }

    private String shorten(String text) {
        if (this.shortForms.containsKey(text)) {
            return this.shortForms.get(text);
        }
        Pattern p = Pattern.compile("^(.*) (\\([0-9]*\\))$");
        Matcher matcher = p.matcher(text);
        String pre = text;
        String suf = "";
        if (matcher.matches()) {
            pre = matcher.group(1);
            suf = matcher.group(2);
        }
        String shortText = text;
        int maxWidth = (int)((this.pixelPerTableNameChar == null ? 8.0 : this.pixelPerTableNameChar) * 30.0);
        for (int i = pre.length() - 2; i > 3 && new JLabel((String)shortText).getMinimumSize().width > maxWidth; --i) {
            shortText = pre.substring(0, i) + "..." + suf;
        }
        this.shortForms.put(text, shortText);
        return shortText;
    }

    private List<Node> createHierarchy(ColumnContentGetter[] columnContentGetter, int i, Collection<AssociationModel> associations) {
        TreeMap groups = new TreeMap();
        ArrayList<String> groupKeys = new ArrayList<String>();
        for (AssociationModel association : associations) {
            String key = columnContentGetter[i].getContent(association);
            if (!groups.containsKey(key)) {
                groups.put(key, new ArrayList());
                groupKeys.add(key);
            }
            ((Collection)groups.get(key)).add(association);
        }
        ArrayList<Node> result = new ArrayList<Node>();
        Collection<Object> gk = groups.keySet();
        if (this.stableSourceOrder && columnContentGetter[i] instanceof SourceGetter) {
            gk = groupKeys;
        }
        for (String groupKey : gk) {
            Collection group = (Collection)groups.get(groupKey);
            String gName = groupKey;
            if (columnContentGetter[i] instanceof TypeGetter) {
                gName = gName.substring(1);
            }
            Node node = new Node(gName, group, columnContentGetter[i].getFgColor(group));
            result.add(node);
            if (i + 1 >= columnContentGetter.length) continue;
            node.children.addAll(this.createHierarchy(columnContentGetter, i + 1, group));
        }
        return result;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.groupByComboBox = new JComboBox();
        this.infoLabel = new JLabel();
        this.jPanel4 = new JPanel();
        this.hideButton = new JButton();
        this.unhideButton = new JButton();
        this.doItButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.listPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.listPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText(" Sorted by ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.groupByComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.groupByComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.infoLabel.setText(" 12 selected, 0 hidden");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.infoLabel, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.hideButton.setText("Hide");
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationListUI.this.hideButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel4.add((Component)this.hideButton, gridBagConstraints);
        this.unhideButton.setText("Unhide");
        this.unhideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationListUI.this.unhideButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel4.add((Component)this.unhideButton, gridBagConstraints);
        this.doItButton.setText("doIt");
        this.doItButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationListUI.this.doItButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.doItButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
    }

    private void hideButtonActionPerformed(ActionEvent evt) {
        this.hideSelection();
    }

    private void unhideButtonActionPerformed(ActionEvent evt) {
        this.unhideHidden();
    }

    private void doItButtonActionPerformed(ActionEvent evt) {
        if (this.selection.size() < 50 || 0 == JOptionPane.showConfirmDialog(this, "Resolve " + this.selection.size() + " associations?", "Resolve", 0, 3)) {
            this.applyAction(new ArrayList<AssociationModel>(this.selection));
        }
    }

    static /* synthetic */ Color access$000() {
        return GREEN;
    }

    static /* synthetic */ Color access$100() {
        return RED;
    }

    static /* synthetic */ ColumnContentGetter access$900() {
        return TYPE_CG;
    }

    static /* synthetic */ ColumnContentGetter access$1000() {
        return SOURCE_CG;
    }

    static /* synthetic */ ColumnContentGetter access$1100() {
        return DESTINATION_CG;
    }

    static /* synthetic */ ColumnContentGetter access$1200() {
        return ASSOCIATION_NAME_CG;
    }

    private static enum GroupByDefinition {
        TSD("Type, From, To", new ColumnContentGetter[]{AssociationListUI.access$900(), AssociationListUI.access$1000(), AssociationListUI.access$1100(), AssociationListUI.access$1200()}),
        TDS("Type, To, From", new ColumnContentGetter[]{AssociationListUI.access$900(), AssociationListUI.access$1100(), AssociationListUI.access$1000(), AssociationListUI.access$1200()}),
        STD("From, Type, To", new ColumnContentGetter[]{AssociationListUI.access$1000(), AssociationListUI.access$900(), AssociationListUI.access$1100(), AssociationListUI.access$1200()}),
        DTS("To, Type, From", new ColumnContentGetter[]{AssociationListUI.access$1100(), AssociationListUI.access$900(), AssociationListUI.access$1000(), AssociationListUI.access$1200()}),
        SDT("From, To, Type", new ColumnContentGetter[]{AssociationListUI.access$1000(), AssociationListUI.access$1100(), AssociationListUI.access$900(), AssociationListUI.access$1200()}),
        DST("To, From, Type", new ColumnContentGetter[]{AssociationListUI.access$1100(), AssociationListUI.access$1000(), AssociationListUI.access$900(), AssociationListUI.access$1200()});

        public final ColumnContentGetter[] columnContentGetter;
        public final String displayName;

        private GroupByDefinition(String displayName, ColumnContentGetter[] columnContentGetter) {
            this.displayName = displayName;
            this.columnContentGetter = columnContentGetter;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private class Node {
        public final Collection<AssociationModel> associations;
        public final List<Node> children = new ArrayList<Node>();
        public final String group;
        public final Color fgColor;

        public Node(String group, Collection<AssociationModel> associations, Color fgColor) {
            this.group = group;
            this.associations = associations;
            this.fgColor = fgColor;
        }

        public boolean isLinear() {
            return this.children.size() == 0 || this.children.size() == 1 && this.children.get(0).isLinear();
        }

        public boolean isSelected() {
            return AssociationListUI.this.selection.containsAll(this.associations);
        }

        public Collection<Node> getSubNodes() {
            ArrayList<Node> subNodes = new ArrayList<Node>();
            for (Node child : this.children) {
                subNodes.add(child);
                subNodes.addAll(child.getSubNodes());
            }
            return subNodes;
        }
    }

    private static class AssociationNameGetter
    extends ColumnContentGetter {
        private AssociationNameGetter() {
        }

        @Override
        public String getContent(AssociationModel association) {
            return association.getName();
        }

        @Override
        public String getDisplayName() {
            return "Association Name";
        }
    }

    private static class DestinationGetter
    extends ColumnContentGetter {
        private DestinationGetter() {
        }

        @Override
        public String getContent(AssociationModel association) {
            return association.getDestinationName();
        }

        @Override
        public String getDisplayName() {
            return "To";
        }
    }

    private static class SourceGetter
    extends ColumnContentGetter {
        private SourceGetter() {
        }

        @Override
        public String getContent(AssociationModel association) {
            return association.getSourceName();
        }

        @Override
        public String getDisplayName() {
            return "From";
        }

        @Override
        public Color getFgColor(Collection<AssociationModel> group) {
            return null;
        }
    }

    private static class TypeGetter
    extends ColumnContentGetter {
        private TypeGetter() {
        }

        @Override
        public String getContent(AssociationModel association) {
            return association.getType().name;
        }

        @Override
        public String getDisplayName() {
            return "Type";
        }
    }

    private static abstract class ColumnContentGetter {
        private ColumnContentGetter() {
        }

        public abstract String getContent(AssociationModel var1);

        public abstract String getDisplayName();

        public Color getFgColor(Collection<AssociationModel> group) {
            Color fg = null;
            for (AssociationModel associationModel : group) {
                Color c = associationModel.getType().color;
                if (fg == null || fg == c) {
                    fg = c;
                    continue;
                }
                fg = null;
                break;
            }
            return fg;
        }
    }

    public static class DefaultAssociationModel
    implements AssociationModel {
        protected final Association association;

        public DefaultAssociationModel(Association association) {
            this.association = association;
        }

        @Override
        public String getSourceName() {
            return this.association.getDataModel().getDisplayName(this.association.source);
        }

        @Override
        public String getDestinationName() {
            return this.association.getDataModel().getDisplayName(this.association.destination);
        }

        @Override
        public String getJoinCondition() {
            return this.association.getUnrestrictedJoinCondition();
        }

        @Override
        public Cardinality getCardinality() {
            return this.association.getCardinality();
        }

        @Override
        public boolean isReversed() {
            return this.association.reversed;
        }

        @Override
        public String getName() {
            return this.association.getName();
        }

        @Override
        public DataModel getDataModel() {
            return this.association.getDataModel();
        }

        @Override
        public AssociationType getType() {
            if (this.association.isInsertSourceBeforeDestination()) {
                return AssociationType.CHILD;
            }
            if (this.association.isInsertDestinationBeforeSource()) {
                return AssociationType.PARENT;
            }
            return AssociationType.ASSOC;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DefaultAssociationModel) {
                return this.association.equals(((DefaultAssociationModel)obj).association);
            }
            return false;
        }

        public int hashCode() {
            return this.association.hashCode();
        }
    }

    public static interface AssociationModel {
        public String getSourceName();

        public String getDestinationName();

        public String getJoinCondition();

        public Cardinality getCardinality();

        public AssociationType getType();

        public boolean isReversed();

        public String getName();

        public DataModel getDataModel();
    }

    private static enum AssociationType {
        CHILD("1Child", AssociationListUI.access$000()),
        ASSOC("2Association", new Color(0, 0, 150)),
        PARENT("3Parent", AssociationListUI.access$100());

        public final String name;
        public final Color color;

        private AssociationType(String name, Color color) {
            this.name = name;
            this.color = color;
        }
    }
}

