/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.CsvFile;

public class AssociationEditor
extends JDialog {
    private Collection<CsvFile.Line> tables;
    private Collection<CsvFile.Line> associations;
    private boolean isOk;
    private CsvFile.Line currentAssociation;
    private javax.swing.JComboBox cardinality;
    private javax.swing.JComboBox destination;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField joinCondition;
    private JTextField nameField;
    private javax.swing.JComboBox source;
    private javax.swing.JComboBox type;
    private static final long serialVersionUID = 603961628104674406L;

    public AssociationEditor(Dialog parent, Collection<CsvFile.Line> tables, List<CsvFile.Line> associations) {
        super(parent, true);
        this.tables = tables;
        this.associations = associations;
        this.initComponents();
        this.type.setRenderer(this.createTypeRenderer());
        this.pack();
        this.setLocation(parent.getLocation().x + parent.getSize().width / 2 - this.getPreferredSize().width / 2, parent.getLocation().y + parent.getSize().height / 2 - this.getPreferredSize().height / 2);
        UIUtil.initPeer();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.source = new JComboBox();
        this.type = new JComboBox();
        this.destination = new JComboBox();
        this.cardinality = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.joinCondition = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.nameField = new JTextField();
        this.jLabel9 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel3 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel10 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Association");
        this.setDefaultCloseOperation(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.source.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.source.setMaximumRowCount(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.getContentPane().add((Component)this.source, gridBagConstraints);
        this.type.setModel(this.createTypeModel());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.getContentPane().add((Component)this.type, gridBagConstraints);
        this.destination.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.destination.setMaximumRowCount(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.getContentPane().add((Component)this.destination, gridBagConstraints);
        this.cardinality.setModel(new DefaultComboBoxModel<String>(new String[]{"", "1:n", "n:1", "1:1", "n:m"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.getContentPane().add((Component)this.cardinality, gridBagConstraints);
        this.jLabel1.setText(" Name ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(" Join condition* ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.joinCondition.setText("jTextField2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.joinCondition, gridBagConstraints);
        this.jLabel5.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(" From ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText(" To");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText(" Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.nameField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.nameField, gridBagConstraints);
        this.jLabel9.setText(" Cardinality ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButton1.setText("Ok");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationEditor.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        this.jLabel3.setText(" *use 'A' as alias for From, use 'B' as alias for To.           ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssociationEditor.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton2.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                AssociationEditor.this.jButton2ComponentResized(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jLabel4.setFont(new Font("Dialog", 0, 12));
        this.jLabel4.setText("  Upper case, no space between A/B and dot!");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel10.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 20;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String msg = null;
        if (this.nameField.getText().trim().length() == 0) {
            msg = "No association name";
        } else {
            for (CsvFile.Line l : this.associations) {
                if (l == this.currentAssociation || !l.cells.get(5).equalsIgnoreCase(this.nameField.getText().trim())) continue;
                msg = "Association with same name exists";
                break;
            }
        }
        if (this.joinCondition.getText().trim().length() == 0) {
            msg = "No join condition";
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        } else {
            this.isOk = true;
            this.setVisible(false);
        }
    }

    private void jButton2ComponentResized(ComponentEvent evt) {
    }

    private ComboBoxModel createTypeModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        model.addElement("A");
        model.addElement("B");
        return model;
    }

    private ListCellRenderer createTypeRenderer() {
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1992399605806444015L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if ("".equals(value)) {
                    value = "associates";
                } else if ("A".equals(value)) {
                    value = "has dependent";
                } else if ("B".equals(value)) {
                    value = "depends on";
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        };
        return renderer;
    }

    public boolean edit(CsvFile.Line association) {
        this.currentAssociation = association;
        this.nameField.setText(association.cells.get(5));
        DefaultComboBoxModel<String> tablesModel1 = new DefaultComboBoxModel<String>();
        DefaultComboBoxModel<String> tablesModel2 = new DefaultComboBoxModel<String>();
        TreeSet<String> sortedTableNames = new TreeSet<String>();
        for (CsvFile.Line table : this.tables) {
            sortedTableNames.add(table.cells.get(0));
        }
        sortedTableNames.add(association.cells.get(0));
        sortedTableNames.add(association.cells.get(1));
        for (String tableName : sortedTableNames) {
            tablesModel1.addElement(tableName);
            tablesModel2.addElement(tableName);
        }
        this.source.setModel(tablesModel1);
        this.destination.setModel(tablesModel2);
        this.source.setSelectedItem(association.cells.get(0));
        this.destination.setSelectedItem(association.cells.get(1));
        this.type.setSelectedItem(association.cells.get(2));
        this.joinCondition.setText(association.cells.get(4));
        String cardinality = association.cells.get(3);
        this.cardinality.setSelectedItem(cardinality);
        this.nameField.setText(association.cells.get(5));
        Object origSource = this.source.getSelectedItem();
        Object origDestination = this.destination.getSelectedItem();
        Object origType = this.type.getSelectedItem();
        Object origCardinality = this.cardinality.getSelectedItem();
        String origJoinCondition = this.joinCondition.getText();
        String origName = this.nameField.getText();
        this.isOk = false;
        this.setVisible(true);
        if (!(!this.isOk || origName.equals(this.nameField.getText()) && origSource.equals(this.source.getSelectedItem()) && origDestination.equals(this.destination.getSelectedItem()) && origType.equals(this.type.getSelectedItem()) && origCardinality.equals(this.cardinality.getSelectedItem()) && origJoinCondition.equals(this.joinCondition.getText()))) {
            association.cells.set(0, (String)this.source.getSelectedItem());
            association.cells.set(1, (String)this.destination.getSelectedItem());
            association.cells.set(2, (String)this.type.getSelectedItem());
            association.cells.set(3, (String)this.cardinality.getSelectedItem());
            association.cells.set(4, this.joinCondition.getText());
            association.cells.set(5, this.nameField.getText());
            association.cells.set(6, "Data Model Editor");
            association.length = 6;
            return true;
        }
        return false;
    }
}

