/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.ui.JComboBox;
import net.sf.jailer.ui.UIUtil;
import net.sf.jailer.util.CsvFile;

public class AnalyseOptionsDialog
extends JDialog {
    private String selectedSchema;
    private int numTables = 0;
    private int numAssociations = 0;
    private int numManTables = 0;
    private int numManAssociations = 0;
    private boolean ok;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JCheckBox keepManAssociationsCheckBox;
    private JCheckBox keepManTablesCheckBox;
    private JButton okButton;
    private JCheckBox removeCurrentAssociationsCheckBox;
    private JCheckBox removeCurrentTablesCheckBox;
    private javax.swing.JComboBox schemaComboBox;
    private JLabel schemaLabel;
    private static final long serialVersionUID = 7293743969854047598L;

    public AnalyseOptionsDialog(Frame parent, DataModel dataModel) throws Exception {
        super(parent, true);
        this.initComponents();
        List<CsvFile.Line> tables = new CsvFile(new File(DataModel.getTablesFile())).getLines();
        for (CsvFile.Line table : tables) {
            ++this.numTables;
            if (!AnalyseOptionsDialog.isManuallyEditedTable(table)) continue;
            ++this.numManTables;
        }
        List<CsvFile.Line> assocs = new CsvFile(new File(DataModel.getAssociationsFile())).getLines();
        for (CsvFile.Line assoc : assocs) {
            ++this.numAssociations;
            if (!AnalyseOptionsDialog.isManuallyEditedAssoc(assoc)) continue;
            ++this.numManAssociations;
        }
        this.removeCurrentAssociationsCheckBox.setText(this.removeCurrentAssociationsCheckBox.getText().replace("0", Integer.toString(this.numAssociations)));
        this.removeCurrentTablesCheckBox.setText(this.removeCurrentTablesCheckBox.getText().replace("0", Integer.toString(this.numTables)));
        this.keepManAssociationsCheckBox.setText(this.keepManAssociationsCheckBox.getText().replace("0", Integer.toString(this.numManAssociations)));
        this.keepManTablesCheckBox.setText(this.keepManTablesCheckBox.getText().replace("0", Integer.toString(this.numManTables)));
        this.removeCurrentAssociationsCheckBox.setEnabled(this.numAssociations > 0);
        this.removeCurrentTablesCheckBox.setEnabled(this.numTables > 0);
        this.pack();
        this.setLocation(parent.getLocation().x + parent.getSize().width / 2 - this.getPreferredSize().width / 2, parent.getLocation().y + parent.getSize().height / 2 - this.getPreferredSize().height / 2);
        UIUtil.initPeer();
    }

    public boolean isRemoving() {
        return this.removeCurrentAssociationsCheckBox.isSelected() || this.removeCurrentTablesCheckBox.isSelected();
    }

    public CsvFile.LineFilter getAssociationLineFilter() {
        final boolean remove = this.removeCurrentAssociationsCheckBox.isSelected();
        final boolean keep = this.keepManAssociationsCheckBox.isSelected();
        return new CsvFile.LineFilter(){

            @Override
            public boolean accept(CsvFile.Line line) {
                if (!remove) {
                    return true;
                }
                return keep && AnalyseOptionsDialog.isManuallyEditedAssoc(line);
            }
        };
    }

    public CsvFile.LineFilter getTableLineFilter() {
        final boolean remove = this.removeCurrentTablesCheckBox.isSelected();
        final boolean keep = this.keepManTablesCheckBox.isSelected();
        return new CsvFile.LineFilter(){

            @Override
            public boolean accept(CsvFile.Line line) {
                if (!remove) {
                    return true;
                }
                return keep && AnalyseOptionsDialog.isManuallyEditedTable(line);
            }
        };
    }

    private static boolean isManuallyEditedAssoc(CsvFile.Line assoc) {
        return "Data Model Editor".equals(assoc.cells.get(6));
    }

    private static boolean isManuallyEditedTable(CsvFile.Line table) {
        int size = table.cells.size();
        for (int i = 0; i < size; ++i) {
            if (!"".equals(table.cells.get(i))) continue;
            return "Data Model Editor".equals(table.cells.get(i + 1));
        }
        return false;
    }

    public boolean edit(List<String> schemas, String defaultSchema, boolean[] isDefaultSchema, String currentUser) {
        isDefaultSchema[0] = false;
        if (schemas.size() == 1 && schemas.get(0).equalsIgnoreCase(currentUser)) {
            isDefaultSchema[0] = true;
        }
        if (schemas.isEmpty()) {
            isDefaultSchema[0] = true;
            this.schemaLabel.setVisible(false);
            this.schemaComboBox.setVisible(false);
        } else {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(schemas.toArray());
            this.schemaComboBox.setModel(model);
            if (defaultSchema != null) {
                this.schemaComboBox.setSelectedItem(defaultSchema);
            }
        }
        this.ok = false;
        this.okButton.grabFocus();
        this.setVisible(true);
        if (this.ok) {
            this.selectedSchema = null;
            if (!schemas.isEmpty() && this.schemaComboBox.getSelectedItem() instanceof String) {
                this.selectedSchema = (String)this.schemaComboBox.getSelectedItem();
            }
            if (this.selectedSchema != null && this.selectedSchema.equalsIgnoreCase(defaultSchema)) {
                isDefaultSchema[0] = true;
            }
        }
        return this.ok;
    }

    public String getSelectedSchema() {
        return this.selectedSchema;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.removeCurrentTablesCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.keepManTablesCheckBox = new JCheckBox();
        this.removeCurrentAssociationsCheckBox = new JCheckBox();
        this.keepManAssociationsCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.schemaLabel = new JLabel();
        this.schemaComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Analyze Database");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Preparation"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.removeCurrentTablesCheckBox.setText("Remove current tables (0)");
        this.removeCurrentTablesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyseOptionsDialog.this.removeCurrentTablesCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.jPanel2.add((Component)this.removeCurrentTablesCheckBox, gridBagConstraints);
        this.jLabel1.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.keepManTablesCheckBox.setSelected(true);
        this.keepManTablesCheckBox.setText("Keep manually entered tables (0)");
        this.keepManTablesCheckBox.setEnabled(false);
        this.keepManTablesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyseOptionsDialog.this.keepManTablesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 24, 0, 8);
        this.jPanel2.add((Component)this.keepManTablesCheckBox, gridBagConstraints);
        this.removeCurrentAssociationsCheckBox.setText("Remove current associations (0)");
        this.removeCurrentAssociationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyseOptionsDialog.this.removeCurrentAssociationsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.jPanel2.add((Component)this.removeCurrentAssociationsCheckBox, gridBagConstraints);
        this.keepManAssociationsCheckBox.setSelected(true);
        this.keepManAssociationsCheckBox.setText("Keep manually entered associations (0)");
        this.keepManAssociationsCheckBox.setEnabled(false);
        this.keepManAssociationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyseOptionsDialog.this.keepManAssociationsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 24, 0, 8);
        this.jPanel2.add((Component)this.keepManAssociationsCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.okButton.setText(" Ok ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyseOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyseOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 4, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.schemaLabel.setText(" Analyze schema ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        this.getContentPane().add((Component)this.schemaLabel, gridBagConstraints);
        this.schemaComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.schemaComboBox, gridBagConstraints);
        this.pack();
    }

    private void removeCurrentTablesCheckBoxActionPerformed(ActionEvent evt) {
        this.keepManTablesCheckBox.setEnabled(this.removeCurrentTablesCheckBox.isSelected());
    }

    private void keepManTablesCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void removeCurrentAssociationsCheckBoxActionPerformed(ActionEvent evt) {
        this.keepManAssociationsCheckBox.setEnabled(this.removeCurrentAssociationsCheckBox.isSelected());
    }

    private void keepManAssociationsCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.setVisible(false);
    }
}

