/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jailer.restrictionmodel;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jailer.CommandLineParser;
import net.sf.jailer.datamodel.Association;
import net.sf.jailer.datamodel.DataModel;
import net.sf.jailer.datamodel.ParameterHandler;
import net.sf.jailer.datamodel.Table;
import net.sf.jailer.util.CsvFile;
import net.sf.jailer.util.SqlUtil;
import org.apache.log4j.Logger;

public class RestrictionModel {
    private final DataModel dataModel;
    private final Map<Association, String> restriction = new HashMap<Association, String>();
    private List<String> filesRead = new ArrayList<String>();
    private boolean transposed = false;
    private static final Logger _log = Logger.getLogger(RestrictionModel.class);
    public static final String IGNORE = new String("ignore");
    public static final Object EMBEDDED = ".embedded";

    public RestrictionModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void transpose() {
        boolean bl = this.transposed = !this.transposed;
        if (this.dataModel != null) {
            ++this.dataModel.version;
        }
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public String getRestriction(Association association) {
        if (this.transposed) {
            association = association.reversalAssociation;
        }
        if (!this.restriction.containsKey(association)) {
            return null;
        }
        String rest = this.restriction.get(association);
        if (rest == null) {
            return IGNORE;
        }
        return rest;
    }

    public void addRestrictionDefinition(String fileName, String extractionModelFileName, Map<String, String> parameters) throws Exception {
        File file;
        if (this.dataModel != null) {
            ++this.dataModel.version;
        }
        boolean embedded = false;
        if (EMBEDDED.equals(fileName)) {
            file = CommandLineParser.getInstance().newFile(extractionModelFileName);
            embedded = true;
        } else {
            file = CommandLineParser.getInstance().newFile(fileName);
        }
        if (!file.exists()) {
            try {
                file = new File(CommandLineParser.getInstance().newFile(extractionModelFileName).getParent(), fileName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!file.exists()) {
            file = CommandLineParser.getInstance().newFile("restrictionmodel" + File.separator + fileName);
        }
        List<CsvFile.Line> lines = new CsvFile(file).getLines();
        int nr = 0;
        for (CsvFile.Line line : lines) {
            Table to;
            Table from;
            if (++nr == 1 && embedded) continue;
            String location = line.location;
            if ("".equals(line.cells.get(1))) {
                Association association = this.dataModel.namedAssociations.get(line.cells.get(0));
                if (association == null) {
                    _log.warn(location + ": unknown association '" + line.cells.get(0) + "'");
                    continue;
                }
                String condition = line.cells.get(2);
                if ("".equals(condition)) {
                    _log.warn(location + ": missing condition");
                    continue;
                }
                this.addRestriction(null, association, condition, location, parameters);
                continue;
            }
            boolean reversFrom = false;
            if ("*".equals(line.cells.get(0))) {
                from = null;
            } else {
                if (line.cells.get(0).startsWith("*-")) {
                    from = this.dataModel.getTable(line.cells.get(0).substring(2));
                    reversFrom = true;
                } else {
                    from = this.dataModel.getTable(line.cells.get(0));
                }
                if (from == null) {
                    _log.warn(location + ": unknown table '" + line.cells.get(0) + "'");
                    continue;
                }
            }
            ArrayList<Table> excludeTo = new ArrayList<Table>();
            if (from != null && "*".equals(line.cells.get(1))) {
                to = null;
            } else if (line.cells.get(1).startsWith("*-")) {
                to = null;
                for (String t : line.cells.get(1).substring(2).split(",")) {
                    Table excludeTable = this.dataModel.getTable(t = t.trim());
                    if (excludeTable == null) {
                        _log.warn(location + ": unknown table '" + t + "'");
                        continue;
                    }
                    excludeTo.add(excludeTable);
                }
            } else {
                to = this.dataModel.getTable(line.cells.get(1));
                if (to == null) {
                    _log.warn(location + ": unknown table '" + line.cells.get(1) + "'");
                    continue;
                }
            }
            String condition = line.cells.get(2);
            if ("".equals(condition)) {
                throw new RuntimeException(location + ": missing condition");
            }
            if (from == null || reversFrom) {
                for (Table table : this.dataModel.getTables()) {
                    if (from != null && table.equals(from)) continue;
                    for (Association a : table.associations) {
                        if (!a.destination.equals(to) || a.isInsertDestinationBeforeSource()) continue;
                        this.addRestriction(table, a, condition, location, parameters);
                    }
                }
                continue;
            }
            if (to == null) {
                for (Association a : from.associations) {
                    if (a.isInsertDestinationBeforeSource() || excludeTo != null && excludeTo.contains(a.destination)) continue;
                    this.addRestriction(from, a, condition, location, parameters);
                }
                continue;
            }
            for (Association a : from.associations) {
                if (!a.destination.equals(to)) continue;
                this.addRestriction(from, a, condition, location, parameters);
            }
        }
        this.filesRead.add(fileName);
    }

    public void addRestriction(Table source, Association association, String condition, String location, Map<String, String> parameters) {
        this.addRestriction(source, association, condition, location, false, parameters);
    }

    public void addRestriction(Table source, Association association, String condition, String location, boolean removePreviousRestriction, Map<String, String> parameters) {
        if (this.dataModel != null) {
            ++this.dataModel.version;
        }
        if ("ignore".equalsIgnoreCase(condition = ParameterHandler.assignParameterValues(condition, parameters)) || "false".equalsIgnoreCase(condition)) {
            condition = null;
        }
        if (condition != null && association.reversed) {
            condition = SqlUtil.reversRestrictionCondition(condition);
        }
        if (removePreviousRestriction && "".equals(condition)) {
            this.restriction.remove(association);
        } else if (removePreviousRestriction || !this.restriction.containsKey(association)) {
            this.restriction.put(association, condition == null ? null : "(" + condition + ")");
        } else {
            String oldCondition = this.restriction.get(association);
            condition = oldCondition == null || condition == null ? null : oldCondition + " and (" + condition + ")";
            this.restriction.put(association, condition);
        }
    }

    public String toString() {
        return this.filesRead.toString();
    }
}

